/*
 *
 * Copyright (C) 2002 Richard Moore <rich@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify 
 *   it under the terms of the GNU General Public License as published by 
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */

#include <qlayout.h>
#include <qpopupmenu.h>
#include <qtimer.h>
#include <qvbox.h>

#include <kdebug.h>
#include <kglobal.h>
#include <klibloader.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kstandarddirs.h>

#include "kdetv.h"
#include "kdetvpart.h"
#include "kdetvwidget.h"

#include "kdetvapplet.h"
#include "kdetvapplet.moc"

static const int KTV_APPLET_FLAGS = KPanelApplet::Preferences | KPanelApplet::Help
                                    | KPanelApplet::About | KPanelApplet::ReportBug;

// Factory function
extern "C" KPanelApplet *init( QWidget *parent, const QString& configFile )
{
    KGlobal::locale()->insertCatalogue("kdetvapplet");

    KLibLoader::self()->globalLibrary("libkdetv.so");
    return new KdetvApplet( configFile,
                            KPanelApplet::Normal, KTV_APPLET_FLAGS,
                            parent, "kdetvapplet" );
}


KdetvApplet::KdetvApplet( const QString &configFile,
                          Type t, int actions,
                          QWidget *parent, const char *name )
    : KPanelApplet( configFile, t, actions, parent, name )
{
    QVBoxLayout *box =  new QVBoxLayout( this );
    tv = new KdetvPart( parent, 0, 0, 0, QStringList() );
    box->addWidget( tv->widget() );
    
    updateGeometry();
}

KdetvApplet::~KdetvApplet()
{
}

int KdetvApplet::widthForHeight( int h ) const
{
//    return (4*h)/3;
    return h;
}

int KdetvApplet::heightForWidth( int w ) const
{
//    return (3*w)/4;
    return w;
}

void KdetvApplet::about()
{
    tv->about();
}

void KdetvApplet::help()
{
    tv->help();
}

void KdetvApplet::preferences()
{
    tv->preferences();
}

void KdetvApplet::reportBug()
{
    tv->reportBug();
}


