// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 Richard Moore <rich@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify 
 *   it under the terms of the GNU General Public License as published by 
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */

#ifndef KDETVAPPLET_H
#define KDETVAPPLET_H

#include <kpanelapplet.h>

class KdetvPart;
class KdetvWidget;

/**
 * A panel applet that displays a TV picture.
 *
 * @author Richard Moore, <rich@kde.org>
 */
class KdetvApplet : public KPanelApplet
{
    Q_OBJECT

public:
    KdetvApplet( const QString& configFile, Type t = Normal, int actions = 0,
                 QWidget *parent = 0, const char *name = 0 );
    ~KdetvApplet();

    int widthForHeight( int h ) const;
    int heightForWidth( int w ) const;

public slots:
    virtual void about();
    virtual void help();
    virtual void preferences();
    virtual void reportBug();

private:
    KdetvPart *tv;
    KdetvWidget *screen;
};


#endif
