/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkadetailview.h"
#include "kkaperson.h"
#include "kkacontactdata.h"
#include "kkapersonaldata.h"
#include "kkapersonwidget.h"
#include "kkaaddresswidget.h"
#include "kkahomeaddress.h"
#include "kkaofficeaddress.h"
#include "kkaprintstatuswidget.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qgrid.h>

#include <ktabwidget.h>
#include <klineedit.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kdebug.h>

using namespace KKAddressBook;

KKADetailView::KKADetailView( bool showPrintStatus, QWidget* parent, const char* name )
	: QWidget( parent, name )
	, m_data( NULL )
{
	setupWidgets( showPrintStatus );
}

KKADetailView::~KKADetailView()
{
}

void KKADetailView::setupWidgets( bool showPrintStatus )
{
	QLabel* label;
	QVBoxLayout* layout = new QVBoxLayout( this );
	int iRow = ( showPrintStatus ? 1 : 0 );
	
	m_person = new KKAPersonWidget( true, this );
	connect( m_person, SIGNAL( nameChanged( const QString& ) ), this, SIGNAL( nameChanged( const QString& ) ) );
	layout->addWidget( m_person );
	
	m_tab = new KTabWidget( this );
	m_tab->setSizePolicy( QSizePolicy::Preferred, QSizePolicy::Preferred );
	layout->addWidget( m_tab );

	// Home tab
	QWidget* home = new QWidget( m_tab );
	QGridLayout* home_layout = new QGridLayout( home, iRow + 1 + KKAHomeAddress::JointNameCount, 2 );
	m_tab->insertTab( home, SmallIcon( "kk_home" ), showPrintStatus ? i18n( "To home" ) : i18n( "From home" ) );

	if( showPrintStatus )
	{
		label = new QLabel( i18n( "Print" ), home );
		home_layout->addWidget( label, 0, 0 );

		m_homePrintStatus = new KKAPrintStatusWidget( home );
		home_layout->addWidget( m_homePrintStatus, 0, 1 );
	}
	else
	{
		m_homePrintStatus = NULL;
	}
	
	m_home = new KKAAddressWidget( home );
	home_layout->addMultiCellWidget( m_home, iRow, iRow, 0, 1 );
	
	label = new QLabel( i18n( "Joint name" ), home );
	home_layout->addMultiCellWidget( label, iRow + 1, iRow + 1 + KKAHomeAddress::JointNameCount, 0, 0 );
	
	for( uint i = 0; i != KKAHomeAddress::JointNameCount; i++ )
	{
		KKAPersonWidget* joint = new KKAPersonWidget( i == 0, home );
		home_layout->addWidget( joint, iRow + 2 + i, 1 );
		m_jointNames.push_back( joint );
	}

	// Office tab
	QWidget* office = new QWidget( m_tab );
	QGridLayout* office_layout = new QGridLayout( office, 5, 2 );
	m_tab->insertTab( office, SmallIcon( "kk_office" ), showPrintStatus ? i18n( "To office" ) : i18n( "From office" ) );

	if( showPrintStatus )
	{
		label = new QLabel( i18n( "Print" ), office );
		office_layout->addWidget( label, 0, 0 );
		
		m_officePrintStatus = new KKAPrintStatusWidget( office );
		office_layout->addWidget( m_officePrintStatus, 0, 1 );
	}
	else
	{
		m_officePrintStatus = NULL;
	}
	
	office_layout->addWidget( new QLabel( i18n( "Corporation" ), office ), iRow, 0 );
	m_corporation = new KLineEdit( office );
	office_layout->addWidget( m_corporation, iRow, 1 );
	
	office_layout->addWidget( new QLabel( i18n( "Section" ), office ), iRow + 1, 0 );
	m_section = new KLineEdit( office );
	office_layout->addWidget( m_section, iRow + 1, 1 );
	
	office_layout->addWidget( new QLabel( i18n( "Post" ), office ), iRow + 2, 0 );
	m_post = new KLineEdit( office );
	office_layout->addWidget( m_post, iRow + 2, 1 );
	
	m_office = new KKAAddressWidget( office );
	office_layout->addMultiCellWidget( m_office, iRow + 3, iRow + 3, 0, 1 );

	layout->addWidget( new QWidget( this ) );
	setSizePolicy( QSizePolicy::Preferred, QSizePolicy::Preferred );
}

void KKADetailView::setData( QListViewItem* data )
{
	setData( data ? ((KKAPerson*)data)->data() : (KKAContactData*)0 );
}

void KKADetailView::setData( KKAContactData* data )
{
	if( m_data )
	{
		if( m_homePrintStatus )
		{
			m_data->home()->setPrintStatus( m_homePrintStatus->status() );
			disconnect( m_homePrintStatus, SIGNAL( statusChanged( KKAAddressData::PrintStatus ) ), m_data->home(), SLOT( setPrintStatus( KKAAddressData::PrintStatus ) ) );
			disconnect( m_data->home(), SIGNAL( printStatusChanged( KKAAddressData::PrintStatus ) ), m_homePrintStatus, SLOT( setStatus( KKAAddressData::PrintStatus ) ) );
		}

		if( m_officePrintStatus )
		{
			m_data->office()->setPrintStatus( m_officePrintStatus->status() );
			disconnect( m_officePrintStatus, SIGNAL( statusChanged( KKAAddressData::PrintStatus ) ), m_data->office(), SLOT( setPrintStatus( KKAAddressData::PrintStatus ) ) );
			disconnect( m_data->office(), SIGNAL( printStatusChanged( KKAAddressData::PrintStatus ) ), m_officePrintStatus, SLOT( setStatus( KKAAddressData::PrintStatus ) ) );
		}
		
		m_data->office()->setCorporation( m_corporation->text() );
		m_data->office()->setSection( m_section->text() );
		m_data->office()->setPost( m_post->text() );
		disconnect( m_tab, SIGNAL( currentChanged ( QWidget* ) ), this, SLOT( setPreference() ) );
		disconnect( m_corporation, SIGNAL( textChanged( const QString& ) ), m_data->office(), SLOT( setCorporation( const QString& ) ) );
		disconnect( m_section, SIGNAL( textChanged( const QString& ) ), m_data->office(), SLOT( setSection( const QString& ) ) );
		disconnect( m_post, SIGNAL( textChanged( const QString& ) ), m_data->office(), SLOT( setPost( const QString& ) ) );
	}
	if( !data )
	{
		m_data = 0;
		m_person->setData( 0 );
		m_home->setData( 0 );
		m_office->setData( 0 );

		for( uint i = 0; i != m_jointNames.count(); i++ )
		{
			(*m_jointNames.at( i ))->setData( 0 );
		}
		m_corporation->setText( "" );
		m_section->setText( "" );
		m_post->setText( "" );
	}
	else
	{
		m_data = data;
		m_person->setData( m_data );
		m_home->setData( m_data->home() );
		m_office->setData( m_data->office() );

		for( uint i = 0; i != m_jointNames.count(); i++ )
		{
			(*m_jointNames.at( i ))->setData( m_data->home()->at(i) );
		}

		if( m_homePrintStatus )
		{
			m_homePrintStatus->setStatus( m_data->home()->printStatus() );
			connect( m_homePrintStatus, SIGNAL( statusChanged( KKAAddressData::PrintStatus ) ), m_data->home(), SLOT( setPrintStatus( KKAAddressData::PrintStatus ) ) );
			connect( m_data->home(), SIGNAL( printStatusChanged( KKAAddressData::PrintStatus ) ), m_homePrintStatus, SLOT( setStatus( KKAAddressData::PrintStatus ) ) );
		}

		if( m_officePrintStatus )
		{
			m_officePrintStatus->setStatus( m_data->office()->printStatus() );
			connect( m_officePrintStatus, SIGNAL( statusChanged( KKAAddressData::PrintStatus ) ), m_data->office(), SLOT( setPrintStatus( KKAAddressData::PrintStatus ) ) );
			connect( m_data->office(), SIGNAL( printStatusChanged( KKAAddressData::PrintStatus ) ), m_officePrintStatus, SLOT( setStatus( KKAAddressData::PrintStatus ) ) );
		}

		m_corporation->setText( m_data->office()->corporation() );
		m_section->setText( m_data->office()->section() );
		m_post->setText( m_data->office()->post() );
		m_tab->setCurrentPage( (int)m_data->current()->locationType() );
		connect( m_tab, SIGNAL( currentChanged ( QWidget* ) ), this, SLOT( setPreference() ) );
		connect( m_corporation, SIGNAL( textChanged( const QString& ) ), m_data->office(), SLOT( setCorporation( const QString& ) ) );
		connect( m_section, SIGNAL( textChanged( const QString& ) ), m_data->office(), SLOT( setSection( const QString& ) ) );
		connect( m_post, SIGNAL( textChanged( const QString& ) ), m_data->office(), SLOT( setPost( const QString& ) ) );
	}
	setEnabled( m_data );
}

void KKADetailView::setPreference()
{
	if( m_data )
	{
		m_data->setCurrent( (KKAAddressData::LocationType)m_tab->currentPageIndex() );
	}
}

QSize KKADetailView::sizeHint() const
{
	return QWidget::sizeHint() * 2 / 3;
}
