/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKDCMDS_H_
#define _KKDCMDS_H_

#include <qmap.h>
#include <qptrlist.h>
#include <qlistview.h>

#include <kcommand.h>
#include <klocale.h>
#include <kdebug.h>
#include <qimage.h>

#include "kkddoc.h"
#include "kkdpaper.h"

namespace KKDesigner
{
	//BEGIN KKDCmdBase
	class KKDCmdBase : public QObject, public KCommand
	{
		Q_OBJECT
	public:
		KKDCmdBase( KKDDoc* doc );
		virtual void execute();
		virtual void unexecute();
		QString name() const;
		bool valid() const{ return m_items.count() != 0; }
		void begin();
		void end();
		QPtrList<KKDItemBase>& items() { return m_items; }

	signals:
		void executed();
		void unexecuted();

	protected:
		KKDDoc* document() const{ return m_doc; }
		virtual QString propertyName() = 0;
		virtual void execute( KKDItemBase* item ) = 0;
		virtual void unexecute( KKDItemBase* item ) = 0;
		virtual bool begin( KKDItemBase* item ) = 0;
		virtual bool end( KKDItemBase* item ) = 0;

	private:
		KKDDoc* m_doc;
		KKDPaper* m_paper;
		void setName( const QString &name );
		QString m_name;
		QPtrList<KKDItemBase> m_items;
	};
	//END KKDCmdBase

	//BEGIN KKDCmdOrientation
	class KKDCmdOrientation : public KKDCmdBase
	{
	public:
		KKDCmdOrientation( KKDDoc* doc );

	protected:
		QString propertyName();
		void execute( KKDItemBase* item );
		void unexecute( KKDItemBase* item );
		bool begin( KKDItemBase* item );
		bool end( KKDItemBase* item );

	private:
		QMap<KKDItemBase*,Orientation> m_before;
		QMap<KKDItemBase*,Orientation> m_after;
	};
	//END KKDCmdOrientation

	//BEGIN KKDCmdDataType
	class KKDCmdDataType : public KKDCmdBase
	{
		public:
			KKDCmdDataType( KKDDoc* doc );

		protected:
			QString propertyName();
			void execute( KKDItemBase* item );
			void unexecute( KKDItemBase* item );
			bool begin( KKDItemBase* item );
			bool end( KKDItemBase* item );

		private:
			QMap<KKDItemBase*,KKDDataBase::DataType> m_before;
			QMap<KKDItemBase*,KKDDataBase::DataType> m_after;
	};
	//END KKDCmdDataType
	
	//BEGIN KKDCmdImage
	class KKDCmdImage : public KKDCmdBase
	{
	public:
		KKDCmdImage( KKDDoc* doc );

	protected:
		QString propertyName();
		void execute( KKDItemBase* item );
		void unexecute( KKDItemBase* item );
		bool begin( KKDItemBase* item );
		bool end( KKDItemBase* item );

	private:
		QMap<KKDItemBase*,QImage> m_before;
		QMap<KKDItemBase*,QImage> m_after;
	};
	//END KKDCmdImage

	//BEGIN KKDCmdImagePrint
	class KKDCmdImagePrint : public KKDCmdBase
	{
	public:
		KKDCmdImagePrint( KKDDoc* doc );

	protected:
		QString propertyName();
		void execute( KKDItemBase* item );
		void unexecute( KKDItemBase* item );
		bool begin( KKDItemBase* item );
		bool end( KKDItemBase* item );

	private:
		QMap<KKDItemBase*,bool> m_before;
		QMap<KKDItemBase*,bool> m_after;
	};
	//END KKDCmdImagePrint

	//BEGIN KKDCmdInsert
	class KKDCmdInsert : public KKDCmdBase
	{
	public:
		KKDCmdInsert( KKDDoc* doc );

	protected:
		QString propertyName();
		void execute( KKDItemBase* item );
		void unexecute( KKDItemBase* item );
		bool begin( KKDItemBase* item );
		bool end( KKDItemBase* item );

	private:
		QMap<KKDItemBase*,KKDPaper*> m_parent;
	};
	//END KKDCmdInsert

	//BEGIN KKDCmdRemove
	class KKDCmdRemove : public KKDCmdBase
	{
	public:
		KKDCmdRemove( KKDDoc* doc );

	protected:
		QString propertyName();
		void execute( KKDItemBase* item );
		void unexecute( KKDItemBase* item );
		bool begin( KKDItemBase* item );
		bool end( KKDItemBase* item );

	private:
		QMap<KKDItemBase*,KKDPaper*> m_parent;
		QMap<KKDItemBase*,uint> m_index;
	};
	//END KKDCmdRemove

	//BEGIN KKDCmdLocation
	class KKDCmdLocation : public KKDCmdBase
	{
	public:
		KKDCmdLocation( KKDDoc* doc );

	protected:
		QString propertyName();
		void execute( KKDItemBase* item );
		void unexecute( KKDItemBase* item );
		bool begin( KKDItemBase* item );
		bool end( KKDItemBase* item );

	private:
		QMap<KKDItemBase*,QPoint> m_before;
		QMap<KKDItemBase*,QPoint> m_after;
	};
	//END KKDCmdLocation

	//BEGIN KKDCmdLocked
	class KKDCmdLocked : public KKDCmdBase
	{
	public:
		KKDCmdLocked( KKDDoc* doc );

	protected:
		QString propertyName();
		void execute( KKDItemBase* item );
		void unexecute( KKDItemBase* item );
		bool begin( KKDItemBase* item );
		bool end( KKDItemBase* item );

	private:
		QMap<KKDItemBase*,bool> m_before;
		QMap<KKDItemBase*,bool> m_after;
	};
	//END KKDCmdLocked

	//BEGIN KKDCmdSize
	class KKDCmdSize : public KKDCmdBase
	{
	public:
		KKDCmdSize( KKDDoc* doc );

	protected:
		QString propertyName();
		void execute( KKDItemBase* item );
		void unexecute( KKDItemBase* item );
		bool begin( KKDItemBase* item );
		bool end( KKDItemBase* item );

	private:
		QMap<KKDItemBase*,QSize> m_before;
		QMap<KKDItemBase*,QSize> m_after;
	};
	//END KKDCmdSize

	//BEGIN KKDCmdText
	class KKDCmdText : public KKDCmdBase
	{
	public:
		KKDCmdText( KKDDoc* doc );

	protected:
		QString propertyName();
		void execute( KKDItemBase* item );
		void unexecute( KKDItemBase* item );
		bool begin( KKDItemBase* item );
		bool end( KKDItemBase* item );

	private:
		QMap<KKDItemBase*,QString> m_before;
		QMap<KKDItemBase*,QString> m_after;
	};
	//END KKDCmdText

	//BEGIN KKDCmdAlign
	class KKDCmdAlign : public KKDCmdBase
	{
	public:
		KKDCmdAlign( KKDDoc* doc );

	protected:
		QString propertyName();
		void execute( KKDItemBase* item );
		void unexecute( KKDItemBase* item );
		bool begin( KKDItemBase* item );
		bool end( KKDItemBase* item );

	private:
		QMap<KKDItemBase*,AlignmentFlags> m_before;
		QMap<KKDItemBase*,AlignmentFlags> m_after;
	};
	//END KKDCmdAlign

	//BEGIN KKDCmdColor
	class KKDCmdColor : public KKDCmdBase
	{
	public:
		KKDCmdColor( KKDDoc* doc );

	protected:
		QString propertyName();
		void execute( KKDItemBase* item );
		void unexecute( KKDItemBase* item );
		bool begin( KKDItemBase* item );
		bool end( KKDItemBase* item );

	private:
		QMap<KKDItemBase*,QColor> m_before;
		QMap<KKDItemBase*,QColor> m_after;
	};
	//END KKDCmdColor

	//BEGIN KKDCmdFontFamily
	class KKDCmdFontFamily : public KKDCmdBase
	{
	public:
		KKDCmdFontFamily( KKDDoc* doc );

	protected:
		QString propertyName();
		void execute( KKDItemBase* item );
		void unexecute( KKDItemBase* item );
		bool begin( KKDItemBase* item );
		bool end( KKDItemBase* item );

	private:
		QMap<KKDItemBase*,QString> m_before;
		QMap<KKDItemBase*,QString> m_after;
	};
	//END KKDCmdFontFamily

	//BEGIN KKDCmdFontSize
	class KKDCmdFontSize : public KKDCmdBase
	{
	public:
		KKDCmdFontSize( KKDDoc* doc );

	protected:
		QString propertyName();
		void execute( KKDItemBase* item );
		void unexecute( KKDItemBase* item );
		bool begin( KKDItemBase* item );
		bool end( KKDItemBase* item );

	private:
		QMap<KKDItemBase*,int> m_before;
		QMap<KKDItemBase*,int> m_after;
	};
	//END KKDCmdFontSize

	//BEGIN KKDCmdFontBold
	class KKDCmdFontBold : public KKDCmdBase
	{
	public:
		KKDCmdFontBold( KKDDoc* doc );

	protected:
		QString propertyName();
		void execute( KKDItemBase* item );
		void unexecute( KKDItemBase* item );
		bool begin( KKDItemBase* item );
		bool end( KKDItemBase* item );

	private:
		QMap<KKDItemBase*,bool> m_before;
		QMap<KKDItemBase*,bool> m_after;
	};
	//END KKDCmdFontBold

	//BEGIN KKDCmdFontItalic
	class KKDCmdFontItalic : public KKDCmdBase
	{
	public:
		KKDCmdFontItalic( KKDDoc* doc );

	protected:
		QString propertyName();
		void execute( KKDItemBase* item );
		void unexecute( KKDItemBase* item );
		bool begin( KKDItemBase* item );
		bool end( KKDItemBase* item );

	private:
		QMap<KKDItemBase*,bool> m_before;
		QMap<KKDItemBase*,bool> m_after;
	};
	//END KKDCmdFontItalic

	//BEGIN KKDCmdFontUnderline
	class KKDCmdFontUnderline : public KKDCmdBase
	{
	public:
		KKDCmdFontUnderline( KKDDoc* doc );

	protected:
		QString propertyName();
		void execute( KKDItemBase* item );
		void unexecute( KKDItemBase* item );
		bool begin( KKDItemBase* item );
		bool end( KKDItemBase* item );

	private:
		QMap<KKDItemBase*,bool> m_before;
		QMap<KKDItemBase*,bool> m_after;
	};
	//END KKDCmdFontUnderline

	//BEGIN KKDCmdFontStrikeOut
	class KKDCmdFontStrikeOut : public KKDCmdBase
	{
	public:
		KKDCmdFontStrikeOut( KKDDoc* doc );

	protected:
		QString propertyName();
		void execute( KKDItemBase* item );
		void unexecute( KKDItemBase* item );
		bool begin( KKDItemBase* item );
		bool end( KKDItemBase* item );

	private:
		QMap<KKDItemBase*,bool> m_before;
		QMap<KKDItemBase*,bool> m_after;
	};
	//END KKDCmdFontStrikeOut

	//BEGIN KKDCmdAutoSize
	class KKDCmdAutoSize : public KKDCmdBase
	{
	public:
		KKDCmdAutoSize( KKDDoc* doc );

	protected:
		QString propertyName();
		void execute( KKDItemBase* item );
		void unexecute( KKDItemBase* item );
		bool begin( KKDItemBase* item );
		bool end( KKDItemBase* item );

	private:
		QMap<KKDItemBase*,bool> m_before;
		QMap<KKDItemBase*,bool> m_after;
	};
	//END KKDCmdAutoSize

	//BEGIN KKDCmdRaise
	class KKDCmdRaise : public KKDCmdBase
	{
	public:
		KKDCmdRaise( KKDDoc* doc );

	protected:
		QString propertyName();
		void execute( KKDItemBase* item );
		void unexecute( KKDItemBase* item );
		bool begin( KKDItemBase* item );
		bool end( KKDItemBase* item );

	private:
		QMap<KKDItemBase*,KKDPaper*> m_parent;
		QMap<KKDItemBase*,uint> m_index;
	};
	//END KKDCmdRaise

	//BEGIN KKDCmdLower
	class KKDCmdLower : public KKDCmdBase
	{
	public:
		KKDCmdLower( KKDDoc* doc );

	protected:
		QString propertyName();
		void execute( KKDItemBase* item );
		void unexecute( KKDItemBase* item );
		bool begin( KKDItemBase* item );
		bool end( KKDItemBase* item );

	private:
		QMap<KKDItemBase*,KKDPaper*> m_parent;
		QMap<KKDItemBase*,uint> m_index;
	};
	//END KKDCmdLower
}

#endif /* _KKDCMDS_H_ */
