/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkdsizehandlerwidget.h"

#include <kcursor.h>

using namespace KKDesigner;

KKDSizeHandlerWidget::KKDSizeHandlerWidget( int x, int y, QWidget *parent, const char *name )
	: QWidget(parent, name)
{
	m_x = x;
	m_y = y;
	m_drag = false;
	resize( 5, 5 );
	setPaletteBackgroundColor( QColor( 68, 102, 255 ) );
	switch( y )
	{
		case 0:
			switch( x )
			{
				case 0:
					setCursor( KCursor::sizeFDiagCursor() );
					break;
				case 1:
					setCursor( KCursor::sizeVerCursor() );
					break;
				case 2:
					setCursor( KCursor::sizeBDiagCursor() );
					break;
			}
			break;
		case 1:
			switch( x )
			{
				case 0:
					setCursor( KCursor::sizeHorCursor() );
					break;
				case 1:
					// Nothing
					break;
				case 2:
					setCursor( KCursor::sizeHorCursor() );
					break;
			}
			break;
		case 2:
			switch( x )
			{
				case 0:
					setCursor( KCursor::sizeBDiagCursor() );
					break;
				case 1:
					setCursor( KCursor::sizeVerCursor() );
					break;
				case 2:
					setCursor( KCursor::sizeFDiagCursor() );
					break;
			}
			break;
	}
}

KKDSizeHandlerWidget::~KKDSizeHandlerWidget()
{
}

void KKDSizeHandlerWidget::mousePressEvent( QMouseEvent* e )
{
	if( ( e->button() & LeftButton ) != LeftButton ) return;
	m_drag = true;
	m_pos = e->pos();
	emit start();
	e->accept();
}

void KKDSizeHandlerWidget::mouseMoveEvent( QMouseEvent* e )
{
	if( !m_drag ) return;
	emit moving( m_x, m_y, e->pos() - m_pos );
	e->accept();
}

void KKDSizeHandlerWidget::mouseReleaseEvent( QMouseEvent* e )
{
	if( !m_drag ) return;
	m_drag = false;
	emit end();
	e->accept();
}
