/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "kkwidgetbase.h"
#include <kmainwindow.h>
#include <kaction.h>
#include <kactioncollection.h>
#include <kmessagebox.h>
#include <kdebug.h>
#include <kcommand.h>

KKWidgetBase::KKWidgetBase( KCommandHistory* cmdHistory, QWidget* parent, const char* name )
	: QSplitter( Qt::Horizontal, parent, name )
	, m_cmdHistory( cmdHistory )
{
}

KKWidgetBase::~ KKWidgetBase()
{
}

KActionCollection* KKWidgetBase::actionCollection()
{
	QPtrList< KMainWindow >* list = KMainWindow::memberList;
	return ((KMainWindow*)list->at(0))->actionCollection();
}

KAction* KKWidgetBase::action( const QString& name )
{
	KAction* act = actionCollection()->action( name );
	if( act == 0 )
	{
// 		KMessageBox::error( this, QString( "Unknown Action %1" ).arg( name ) );
		kdError() << QString( "Unknown Action %1" ).arg( name ) << endl;
		act = new KAction( this );
	}
	return act;
}

void KKWidgetBase::setActionEnabled( const QString& strName, bool blEnabled )
{
	action( strName )->setEnabled( blEnabled );
}

KCommandHistory* KKWidgetBase::commandHistory()
{
	return m_cmdHistory;
}
