/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.userdefined;

import org.pentaho.reporting.libraries.base.util.CSVQuoter;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Sequence;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class CsvTextFunction
implements Function {
    public String getCanonicalName() {
        return "CSVTEXT";
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        Object indexValue;
        Type indexType;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 1 || parameterCount > 4) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Sequence sequence = context.getTypeRegistry().convertToSequence(parameters.getType(0), parameters.getValue(0));
        if (sequence == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        String quote = "\"";
        String separator = ",";
        boolean doQuoting = false;
        if (parameterCount > 1) {
            indexType = parameters.getType(1);
            indexValue = parameters.getValue(1);
            Boolean indexNumber = context.getTypeRegistry().convertToLogical(indexType, indexValue);
            doQuoting = Boolean.TRUE.equals(indexNumber);
        }
        if (parameterCount > 2) {
            indexType = parameters.getType(2);
            indexValue = parameters.getValue(2);
            separator = context.getTypeRegistry().convertToText(indexType, indexValue);
        }
        if (parameterCount > 3) {
            indexType = parameters.getType(1);
            indexValue = parameters.getValue(1);
            quote = context.getTypeRegistry().convertToText(indexType, indexValue);
        }
        if (!doQuoting) {
            StringBuffer b = new StringBuffer();
            while (sequence.hasNext()) {
                Object o = sequence.next();
                if (o != null) {
                    b.append(o);
                }
                if (!sequence.hasNext()) continue;
                b.append(separator);
            }
            return new TypeValuePair(TextType.TYPE, b.toString());
        }
        CSVQuoter quoter = new CSVQuoter(quote.charAt(0), quote.charAt(0));
        StringBuffer b = new StringBuffer();
        while (sequence.hasNext()) {
            Object o = sequence.next();
            if (o != null) {
                b.append(quoter.doQuoting(String.valueOf(o)));
            }
            if (!sequence.hasNext()) continue;
            b.append(separator);
        }
        return new TypeValuePair(TextType.TYPE, b.toString());
    }
}

