/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.hpsf.CustomProperty;
import org.apache.poi.hpsf.MutableProperty;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CustomProperties
extends HashMap {
    private Map dictionaryIDToName;
    private Map dictionaryNameToID;
    private boolean isPure;

    public Object put(Object name, Object customProperty) throws ClassCastException {
        CustomProperty cp = (CustomProperty)customProperty;
        if (name == null) {
            this.isPure = false;
            return null;
        }
        if (!(name instanceof String)) {
            throw new ClassCastException("The name of a custom property must be a java.lang.String, but it is a " + name.getClass().getName());
        }
        if (!name.equals(cp.getName())) {
            throw new IllegalArgumentException("Parameter \"name\" (" + name + ") and custom property's name (" + cp.getName() + ") do not match.");
        }
        Long idKey = new Long(cp.getID());
        Object oldID = this.dictionaryNameToID.get(name);
        this.dictionaryIDToName.remove(oldID);
        this.dictionaryNameToID.put(name, idKey);
        this.dictionaryIDToName.put(idKey, name);
        Object oldCp = super.remove(oldID);
        super.put(idKey, cp);
        return oldCp;
    }

    private final Object put(CustomProperty customProperty) throws ClassCastException {
        String name = customProperty.getName();
        Long oldId = (Long)this.dictionaryNameToID.get(name);
        if (oldId != null) {
            customProperty.setID(oldId);
        } else {
            long max = 1L;
            Iterator i = this.dictionaryIDToName.keySet().iterator();
            while (i.hasNext()) {
                long id = (Long)i.next();
                if (id <= max) continue;
                max = id;
            }
            customProperty.setID(max + 1L);
        }
        return this.put((Object)name, customProperty);
    }

    public Object remove(String name) {
        Long id = (Long)this.dictionaryNameToID.get(name);
        if (id == null) {
            return null;
        }
        this.dictionaryIDToName.remove(id);
        this.dictionaryNameToID.remove(name);
        return super.remove(id);
    }

    public Object put(String name, String value) {
        MutableProperty p = new MutableProperty();
        p.setID(-1);
        p.setType(31L);
        p.setValue(value);
        CustomProperty cp = new CustomProperty(p, name);
        return this.put(cp);
    }

    public Object put(String name, Long value) {
        MutableProperty p = new MutableProperty();
        p.setID(-1);
        p.setType(20L);
        p.setValue(value);
        CustomProperty cp = new CustomProperty(p, name);
        return this.put(cp);
    }

    public Object put(String name, Double value) {
        MutableProperty p = new MutableProperty();
        p.setID(-1);
        p.setType(5);
        p.setValue(value);
        CustomProperty cp = new CustomProperty(p, name);
        return this.put(cp);
    }

    public Object put(String name, Integer value) {
        MutableProperty p = new MutableProperty();
        p.setID(-1);
        p.setType(3);
        p.setValue(value);
        CustomProperty cp = new CustomProperty(p, name);
        return this.put(cp);
    }

    public Object put(String name, Boolean value) {
        MutableProperty p = new MutableProperty();
        p.setID(-1);
        p.setType(11L);
        p.setValue(value);
        CustomProperty cp = new CustomProperty(p, name);
        return this.put(cp);
    }

    public Object get(String name) {
        Long id = (Long)this.dictionaryNameToID.get(name);
        CustomProperty cp = (CustomProperty)super.get(id);
        return cp != null ? cp.getValue() : null;
    }

    public Object put(String name, Date value) {
        MutableProperty p = new MutableProperty();
        p.setID(-1);
        p.setType(64L);
        p.setValue(value);
        CustomProperty cp = new CustomProperty(p, name);
        return this.put(cp);
    }

    public void setCodepage(int codepage) {
        MutableProperty p = new MutableProperty();
        p.setID(1L);
        p.setType(2);
        p.setValue(new Integer(codepage));
        this.put(new CustomProperty(p));
    }

    Map getDictionary() {
        return this.dictionaryIDToName;
    }

    public int getCodepage() {
        int codepage = -1;
        Iterator i = this.values().iterator();
        while (codepage == -1 && i.hasNext()) {
            CustomProperty cp = (CustomProperty)i.next();
            if (cp.getID() != 1L) continue;
            codepage = (Integer)cp.getValue();
        }
        return codepage;
    }

    public boolean isPure() {
        return this.isPure;
    }

    public void setPure(boolean isPure) {
        this.isPure = isPure;
    }

    private final /* synthetic */ void this() {
        this.dictionaryIDToName = new HashMap();
        this.dictionaryNameToID = new HashMap();
        this.isPure = true;
    }

    public CustomProperties() {
        this.this();
    }
}

