/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.util.LittleEndian;

public class NameXPtg
extends Ptg {
    public static final short sid = 57;
    private static final int SIZE = 7;
    private short field_1_ixals;
    private short field_2_ilbl;
    private short field_3_reserved;

    public void writeBytes(byte[] array, int offset) {
        array[offset] = (byte)(57 + this.ptgClass);
        LittleEndian.putShort(array, offset + 1, this.field_1_ixals);
        LittleEndian.putShort(array, offset + 3, this.field_2_ilbl);
        LittleEndian.putShort(array, offset + 5, this.field_3_reserved);
    }

    public int getSize() {
        return 7;
    }

    public String toFormulaString(Workbook book) {
        return "NO IDEA - NAME";
    }

    public byte getDefaultOperandClass() {
        return 32;
    }

    public Object clone() {
        NameXPtg ptg = new NameXPtg();
        ptg.field_1_ixals = this.field_1_ixals;
        ptg.field_3_reserved = this.field_3_reserved;
        ptg.field_2_ilbl = this.field_2_ilbl;
        ptg.setClass(this.ptgClass);
        return ptg;
    }

    private NameXPtg() {
    }

    public NameXPtg(String name) {
    }

    public NameXPtg(RecordInputStream in) {
        this.field_1_ixals = in.readShort();
        this.field_2_ilbl = in.readShort();
        this.field_3_reserved = in.readShort();
    }
}

