/**
 * @file libgalago-gtk/galago-gtk-entry-completion.h
 *       GtkEntryCompletion utility functions
 *
 * @Copyright (C) 2005-2006 Christian Hammond.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_GTK_COMPLETION_H_
#define _GALAGO_GTK_COMPLETION_H_

#include <gtk/gtk.h>

#include <libgalago/galago.h>

G_BEGIN_DECLS

GtkEntryCompletion *galago_gtk_entry_completion_new_with_accounts(
	const GalagoService *service, gboolean query);
GtkEntryCompletion *galago_gtk_entry_completion_new_with_contacts(
	const GalagoAccount *account, gboolean query);
GtkEntryCompletion *galago_gtk_entry_completion_new_with_services(
	gboolean query);

G_END_DECLS

#endif /* _GALAGO_GTK_COMPLETION_H_ */
