; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=x86-64 | FileCheck %s --check-prefix=CHECK --check-prefix=GENERIC
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=atom | FileCheck %s --check-prefix=CHECK --check-prefix=ATOM
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=slm | FileCheck %s --check-prefix=CHECK --check-prefix=SLM
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=sandybridge | FileCheck %s --check-prefix=CHECK --check-prefix=SANDY
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=ivybridge | FileCheck %s --check-prefix=CHECK --check-prefix=SANDY
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=haswell | FileCheck %s --check-prefix=CHECK --check-prefix=HASWELL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=broadwell | FileCheck %s --check-prefix=CHECK --check-prefix=BROADWELL
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=skylake | FileCheck %s --check-prefix=CHECK --check-prefix=SKYLAKE
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=skx | FileCheck %s --check-prefix=CHECK --check-prefix=SKX
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=btver2 | FileCheck %s --check-prefix=CHECK --check-prefix=BTVER2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -print-schedule -mcpu=znver1 | FileCheck %s --check-prefix=CHECK --check-prefix=ZNVER1

define void @test_cmov_16(i16 %a0, i16 %a1, i16 *%a2) optsize {
; GENERIC-LABEL: test_cmov_16:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    cmovow %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovnow %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovbw %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovbw %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovbw %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovaew %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovaew %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovaew %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovew %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovew %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovnew %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovnew %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovbew %si, %di # sched: [3:1.00]
; GENERIC-NEXT:    cmovbew %si, %di # sched: [3:1.00]
; GENERIC-NEXT:    cmovaw %si, %di # sched: [3:1.00]
; GENERIC-NEXT:    cmovaw %si, %di # sched: [3:1.00]
; GENERIC-NEXT:    cmovsw %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovnsw %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovpw %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovpw %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovnpw %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovnpw %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovlw %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovlw %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovgew %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovgew %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovlew %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovlew %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovgw %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovgw %si, %di # sched: [2:0.67]
; GENERIC-NEXT:    cmovow (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovnow (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovbw (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovbw (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovbw (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovaew (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovaew (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovaew (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovew (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovew (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovnew (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovnew (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovbew (%rdx), %di # sched: [8:1.00]
; GENERIC-NEXT:    cmovbew (%rdx), %di # sched: [8:1.00]
; GENERIC-NEXT:    cmovaw (%rdx), %di # sched: [8:1.00]
; GENERIC-NEXT:    cmovaw (%rdx), %di # sched: [8:1.00]
; GENERIC-NEXT:    cmovsw (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovnsw (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovpw (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovpw (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovnpw (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovnpw (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovlw (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovlw (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovgew (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovgew (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovlew (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovlew (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovgw (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    cmovgw (%rdx), %di # sched: [7:0.67]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cmov_16:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    cmovow %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovnow %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovbw %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovbw %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovbw %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovaew %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovaew %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovaew %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovew %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovew %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovnew %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovnew %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovbew %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovbew %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovaw %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovaw %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovsw %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovnsw %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovpw %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovpw %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovnpw %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovnpw %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovlw %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovlw %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovgew %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovgew %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovlew %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovlew %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovgw %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovgw %si, %di # sched: [1:0.50]
; ATOM-NEXT:    cmovow (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovnow (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovbw (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovbw (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovbw (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovaew (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovaew (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovaew (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovew (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovew (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovnew (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovnew (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovbew (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovbew (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovaw (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovaw (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovsw (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovnsw (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovpw (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovpw (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovnpw (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovnpw (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovlw (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovlw (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovgew (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovgew (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovlew (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovlew (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovgw (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    cmovgw (%rdx), %di # sched: [1:1.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cmov_16:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    cmovow %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovnow %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovbw %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovbw %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovbw %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovaew %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovaew %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovaew %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovew %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovew %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovnew %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovnew %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovbew %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovbew %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovaw %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovaw %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovsw %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovnsw %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovpw %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovpw %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovnpw %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovnpw %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovlw %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovlw %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovgew %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovgew %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovlew %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovlew %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovgw %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovgw %si, %di # sched: [1:0.50]
; SLM-NEXT:    cmovow (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovnow (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovbw (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovbw (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovbw (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovaew (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovaew (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovaew (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovew (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovew (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovnew (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovnew (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovbew (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovbew (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovaw (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovaw (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovsw (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovnsw (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovpw (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovpw (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovnpw (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovnpw (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovlw (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovlw (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovgew (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovgew (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovlew (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovlew (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovgw (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    cmovgw (%rdx), %di # sched: [4:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_cmov_16:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    cmovow %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovnow %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovbw %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovbw %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovbw %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovaew %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovaew %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovaew %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovew %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovew %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovnew %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovnew %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovbew %si, %di # sched: [3:1.00]
; SANDY-NEXT:    cmovbew %si, %di # sched: [3:1.00]
; SANDY-NEXT:    cmovaw %si, %di # sched: [3:1.00]
; SANDY-NEXT:    cmovaw %si, %di # sched: [3:1.00]
; SANDY-NEXT:    cmovsw %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovnsw %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovpw %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovpw %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovnpw %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovnpw %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovlw %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovlw %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovgew %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovgew %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovlew %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovlew %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovgw %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovgw %si, %di # sched: [2:0.67]
; SANDY-NEXT:    cmovow (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovnow (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovbw (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovbw (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovbw (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovaew (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovaew (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovaew (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovew (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovew (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovnew (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovnew (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovbew (%rdx), %di # sched: [8:1.00]
; SANDY-NEXT:    cmovbew (%rdx), %di # sched: [8:1.00]
; SANDY-NEXT:    cmovaw (%rdx), %di # sched: [8:1.00]
; SANDY-NEXT:    cmovaw (%rdx), %di # sched: [8:1.00]
; SANDY-NEXT:    cmovsw (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovnsw (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovpw (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovpw (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovnpw (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovnpw (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovlw (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovlw (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovgew (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovgew (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovlew (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovlew (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovgw (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    cmovgw (%rdx), %di # sched: [7:0.67]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cmov_16:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    cmovow %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovnow %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovbw %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovbw %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovbw %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovaew %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovaew %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovaew %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovew %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovew %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovnew %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovnew %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovbew %si, %di # sched: [3:0.75]
; HASWELL-NEXT:    cmovbew %si, %di # sched: [3:0.75]
; HASWELL-NEXT:    cmovaw %si, %di # sched: [3:0.75]
; HASWELL-NEXT:    cmovaw %si, %di # sched: [3:0.75]
; HASWELL-NEXT:    cmovsw %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovnsw %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovpw %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovpw %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovnpw %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovnpw %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovlw %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovlw %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovgew %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovgew %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovlew %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovlew %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovgw %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovgw %si, %di # sched: [2:0.50]
; HASWELL-NEXT:    cmovow (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovnow (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovbw (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovbw (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovbw (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovaew (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovaew (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovaew (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovew (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovew (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovnew (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovnew (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovbew (%rdx), %di # sched: [8:0.75]
; HASWELL-NEXT:    cmovbew (%rdx), %di # sched: [8:0.75]
; HASWELL-NEXT:    cmovaw (%rdx), %di # sched: [8:0.75]
; HASWELL-NEXT:    cmovaw (%rdx), %di # sched: [8:0.75]
; HASWELL-NEXT:    cmovsw (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovnsw (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovpw (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovpw (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovnpw (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovnpw (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovlw (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovlw (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovgew (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovgew (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovlew (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovlew (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovgw (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    cmovgw (%rdx), %di # sched: [7:0.50]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cmov_16:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    cmovow %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovnow %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovbw %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovbw %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovbw %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovaew %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovaew %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovaew %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovew %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovew %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovnew %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovnew %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovbew %si, %di # sched: [2:0.50]
; BROADWELL-NEXT:    cmovbew %si, %di # sched: [2:0.50]
; BROADWELL-NEXT:    cmovaw %si, %di # sched: [2:0.50]
; BROADWELL-NEXT:    cmovaw %si, %di # sched: [2:0.50]
; BROADWELL-NEXT:    cmovsw %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovnsw %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovpw %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovpw %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovnpw %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovnpw %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovlw %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovlw %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovgew %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovgew %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovlew %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovlew %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovgw %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovgw %si, %di # sched: [1:0.50]
; BROADWELL-NEXT:    cmovow (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovnow (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovbw (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovbw (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovbw (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovaew (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovaew (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovaew (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovew (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovew (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovnew (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovnew (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovbew (%rdx), %di # sched: [7:0.50]
; BROADWELL-NEXT:    cmovbew (%rdx), %di # sched: [7:0.50]
; BROADWELL-NEXT:    cmovaw (%rdx), %di # sched: [7:0.50]
; BROADWELL-NEXT:    cmovaw (%rdx), %di # sched: [7:0.50]
; BROADWELL-NEXT:    cmovsw (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovnsw (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovpw (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovpw (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovnpw (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovnpw (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovlw (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovlw (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovgew (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovgew (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovlew (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovlew (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovgw (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    cmovgw (%rdx), %di # sched: [6:0.50]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cmov_16:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    cmovow %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovnow %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovbw %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovbw %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovbw %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovaew %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovaew %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovaew %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovew %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovew %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovnew %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovnew %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovbew %si, %di # sched: [2:1.00]
; SKYLAKE-NEXT:    cmovbew %si, %di # sched: [2:1.00]
; SKYLAKE-NEXT:    cmovaw %si, %di # sched: [2:1.00]
; SKYLAKE-NEXT:    cmovaw %si, %di # sched: [2:1.00]
; SKYLAKE-NEXT:    cmovsw %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovnsw %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovpw %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovpw %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovnpw %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovnpw %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovlw %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovlw %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovgew %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovgew %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovlew %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovlew %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovgw %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovgw %si, %di # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovow (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovnow (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovbw (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovbw (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovbw (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovaew (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovaew (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovaew (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovew (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovew (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovnew (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovnew (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovbew (%rdx), %di # sched: [7:1.00]
; SKYLAKE-NEXT:    cmovbew (%rdx), %di # sched: [7:1.00]
; SKYLAKE-NEXT:    cmovaw (%rdx), %di # sched: [7:1.00]
; SKYLAKE-NEXT:    cmovaw (%rdx), %di # sched: [7:1.00]
; SKYLAKE-NEXT:    cmovsw (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovnsw (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovpw (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovpw (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovnpw (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovnpw (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovlw (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovlw (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovgew (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovgew (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovlew (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovlew (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovgw (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovgw (%rdx), %di # sched: [6:0.50]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cmov_16:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    cmovow %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovnow %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovbw %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovbw %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovbw %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovaew %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovaew %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovaew %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovew %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovew %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovnew %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovnew %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovbew %si, %di # sched: [2:1.00]
; SKX-NEXT:    cmovbew %si, %di # sched: [2:1.00]
; SKX-NEXT:    cmovaw %si, %di # sched: [2:1.00]
; SKX-NEXT:    cmovaw %si, %di # sched: [2:1.00]
; SKX-NEXT:    cmovsw %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovnsw %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovpw %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovpw %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovnpw %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovnpw %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovlw %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovlw %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovgew %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovgew %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovlew %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovlew %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovgw %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovgw %si, %di # sched: [1:0.50]
; SKX-NEXT:    cmovow (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovnow (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovbw (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovbw (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovbw (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovaew (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovaew (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovaew (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovew (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovew (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovnew (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovnew (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovbew (%rdx), %di # sched: [7:1.00]
; SKX-NEXT:    cmovbew (%rdx), %di # sched: [7:1.00]
; SKX-NEXT:    cmovaw (%rdx), %di # sched: [7:1.00]
; SKX-NEXT:    cmovaw (%rdx), %di # sched: [7:1.00]
; SKX-NEXT:    cmovsw (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovnsw (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovpw (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovpw (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovnpw (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovnpw (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovlw (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovlw (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovgew (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovgew (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovlew (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovlew (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovgw (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    cmovgw (%rdx), %di # sched: [6:0.50]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_cmov_16:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    cmovow %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovnow %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovbw %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovbw %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovbw %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovaew %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovaew %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovaew %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovew %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovew %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovnew %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovnew %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovbew %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovbew %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovaw %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovaw %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovsw %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovnsw %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovpw %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovpw %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovnpw %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovnpw %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovlw %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovlw %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovgew %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovgew %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovlew %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovlew %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovgw %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovgw %si, %di # sched: [1:0.50]
; BTVER2-NEXT:    cmovow (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovnow (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovbw (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovbw (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovbw (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovaew (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovaew (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovaew (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovew (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovew (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovnew (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovnew (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovbew (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovbew (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovaw (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovaw (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovsw (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovnsw (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovpw (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovpw (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovnpw (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovnpw (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovlw (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovlw (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovgew (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovgew (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovlew (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovlew (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovgw (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    cmovgw (%rdx), %di # sched: [4:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cmov_16:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    cmovow %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovnow %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovbw %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovbw %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovbw %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovaew %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovaew %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovaew %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovew %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovew %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovnew %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovnew %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovbew %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovbew %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovaw %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovaw %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovsw %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovnsw %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovpw %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovpw %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovnpw %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovnpw %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovlw %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovlw %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovgew %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovgew %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovlew %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovlew %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovgw %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovgw %si, %di # sched: [1:0.25]
; ZNVER1-NEXT:    cmovow (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovnow (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovbw (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovbw (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovbw (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovaew (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovaew (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovaew (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovew (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovew (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovnew (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovnew (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovbew (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovbew (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovaw (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovaw (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovsw (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovnsw (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovpw (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovpw (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovnpw (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovnpw (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovlw (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovlw (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovgew (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovgew (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovlew (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovlew (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovgw (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    cmovgw (%rdx), %di # sched: [5:0.50]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  call void asm sideeffect "cmovow $1, $0 \0A\09 cmovnow $1, $0 \0A\09 cmovbw $1, $0 \0A\09 cmovcw $1, $0 \0A\09 cmovnaew $1, $0 \0A\09 cmovnbw $1, $0 \0A\09 cmovncw $1, $0 \0A\09 cmovaew $1, $0 \0A\09 cmovzw $1, $0 \0A\09 cmovew $1, $0 \0A\09 cmovnzw $1, $0 \0A\09 cmovnew $1, $0 \0A\09 cmovbew $1, $0 \0A\09 cmovnaw $1, $0 \0A\09 cmovnbew $1, $0 \0A\09 cmovaw $1, $0 \0A\09 cmovsw $1, $0 \0A\09 cmovnsw $1, $0 \0A\09 cmovpw $1, $0 \0A\09 cmovpew $1, $0 \0A\09 cmovnpw $1, $0 \0A\09 cmovpow $1, $0 \0A\09 cmovlw $1, $0 \0A\09 cmovngew $1, $0 \0A\09 cmovnlw $1, $0 \0A\09 cmovgew $1, $0 \0A\09 cmovlew $1, $0 \0A\09 cmovngw $1, $0 \0A\09 cmovnlew $1, $0 \0A\09 cmovgw $1, $0 \0A\09 cmovow $2, $0 \0A\09 cmovnow $2, $0 \0A\09 cmovbw $2, $0 \0A\09 cmovcw $2, $0 \0A\09 cmovnaew $2, $0 \0A\09 cmovnbw $2, $0 \0A\09 cmovncw $2, $0 \0A\09 cmovaew $2, $0 \0A\09 cmovzw $2, $0 \0A\09 cmovew $2, $0 \0A\09 cmovnzw $2, $0 \0A\09 cmovnew $2, $0 \0A\09 cmovbew $2, $0 \0A\09 cmovnaw $2, $0 \0A\09 cmovnbew $2, $0 \0A\09 cmovaw $2, $0 \0A\09 cmovsw $2, $0 \0A\09 cmovnsw $2, $0 \0A\09 cmovpw $2, $0 \0A\09 cmovpew $2, $0 \0A\09 cmovnpw $2, $0 \0A\09 cmovpow $2, $0 \0A\09 cmovlw $2, $0 \0A\09 cmovngew $2, $0 \0A\09 cmovnlw $2, $0 \0A\09 cmovgew $2, $0 \0A\09 cmovlew $2, $0 \0A\09 cmovngw $2, $0 \0A\09 cmovnlew $2, $0 \0A\09 cmovgw $2, $0", "r,r,*m"(i16 %a0, i16 %a1, i16 *%a2)
  ret void
}

define void @test_cmov_32(i32 %a0, i32 %a1, i32 *%a2) optsize {
; GENERIC-LABEL: test_cmov_32:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    cmovol %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovnol %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovbl %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovbl %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovbl %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovael %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovael %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovael %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovel %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovel %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovnel %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovnel %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovbel %esi, %edi # sched: [3:1.00]
; GENERIC-NEXT:    cmovbel %esi, %edi # sched: [3:1.00]
; GENERIC-NEXT:    cmoval %esi, %edi # sched: [3:1.00]
; GENERIC-NEXT:    cmoval %esi, %edi # sched: [3:1.00]
; GENERIC-NEXT:    cmovsl %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovnsl %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovpl %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovpl %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovnpl %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovnpl %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovll %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovll %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovgel %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovgel %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovlel %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovlel %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovgl %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovgl %esi, %edi # sched: [2:0.67]
; GENERIC-NEXT:    cmovol (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovnol (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovbl (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovbl (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovbl (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovael (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovael (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovael (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovel (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovel (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovnel (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovnel (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovbel (%rdx), %edi # sched: [8:1.00]
; GENERIC-NEXT:    cmovbel (%rdx), %edi # sched: [8:1.00]
; GENERIC-NEXT:    cmoval (%rdx), %edi # sched: [8:1.00]
; GENERIC-NEXT:    cmoval (%rdx), %edi # sched: [8:1.00]
; GENERIC-NEXT:    cmovsl (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovnsl (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovpl (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovpl (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovnpl (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovnpl (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovll (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovll (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovgel (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovgel (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovlel (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovlel (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovgl (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    cmovgl (%rdx), %edi # sched: [7:0.67]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cmov_32:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    cmovol %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovnol %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovbl %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovbl %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovbl %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovael %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovael %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovael %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovel %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovel %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovnel %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovnel %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovbel %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovbel %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmoval %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmoval %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovsl %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovnsl %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovpl %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovpl %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovnpl %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovnpl %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovll %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovll %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovgel %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovgel %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovlel %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovlel %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovgl %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovgl %esi, %edi # sched: [1:0.50]
; ATOM-NEXT:    cmovol (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovnol (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovbl (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovbl (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovbl (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovael (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovael (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovael (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovel (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovel (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovnel (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovnel (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovbel (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovbel (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmoval (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmoval (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovsl (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovnsl (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovpl (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovpl (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovnpl (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovnpl (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovll (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovll (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovgel (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovgel (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovlel (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovlel (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovgl (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    cmovgl (%rdx), %edi # sched: [1:1.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cmov_32:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    cmovol %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovnol %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovbl %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovbl %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovbl %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovael %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovael %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovael %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovel %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovel %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovnel %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovnel %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovbel %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovbel %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmoval %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmoval %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovsl %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovnsl %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovpl %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovpl %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovnpl %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovnpl %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovll %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovll %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovgel %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovgel %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovlel %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovlel %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovgl %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovgl %esi, %edi # sched: [1:0.50]
; SLM-NEXT:    cmovol (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovnol (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovbl (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovbl (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovbl (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovael (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovael (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovael (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovel (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovel (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovnel (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovnel (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovbel (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovbel (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmoval (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmoval (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovsl (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovnsl (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovpl (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovpl (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovnpl (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovnpl (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovll (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovll (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovgel (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovgel (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovlel (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovlel (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovgl (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    cmovgl (%rdx), %edi # sched: [4:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_cmov_32:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    cmovol %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovnol %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovbl %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovbl %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovbl %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovael %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovael %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovael %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovel %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovel %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovnel %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovnel %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovbel %esi, %edi # sched: [3:1.00]
; SANDY-NEXT:    cmovbel %esi, %edi # sched: [3:1.00]
; SANDY-NEXT:    cmoval %esi, %edi # sched: [3:1.00]
; SANDY-NEXT:    cmoval %esi, %edi # sched: [3:1.00]
; SANDY-NEXT:    cmovsl %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovnsl %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovpl %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovpl %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovnpl %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovnpl %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovll %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovll %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovgel %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovgel %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovlel %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovlel %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovgl %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovgl %esi, %edi # sched: [2:0.67]
; SANDY-NEXT:    cmovol (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovnol (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovbl (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovbl (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovbl (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovael (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovael (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovael (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovel (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovel (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovnel (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovnel (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovbel (%rdx), %edi # sched: [8:1.00]
; SANDY-NEXT:    cmovbel (%rdx), %edi # sched: [8:1.00]
; SANDY-NEXT:    cmoval (%rdx), %edi # sched: [8:1.00]
; SANDY-NEXT:    cmoval (%rdx), %edi # sched: [8:1.00]
; SANDY-NEXT:    cmovsl (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovnsl (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovpl (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovpl (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovnpl (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovnpl (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovll (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovll (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovgel (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovgel (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovlel (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovlel (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovgl (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    cmovgl (%rdx), %edi # sched: [7:0.67]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cmov_32:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    cmovol %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovnol %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovbl %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovbl %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovbl %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovael %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovael %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovael %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovel %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovel %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovnel %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovnel %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovbel %esi, %edi # sched: [3:0.75]
; HASWELL-NEXT:    cmovbel %esi, %edi # sched: [3:0.75]
; HASWELL-NEXT:    cmoval %esi, %edi # sched: [3:0.75]
; HASWELL-NEXT:    cmoval %esi, %edi # sched: [3:0.75]
; HASWELL-NEXT:    cmovsl %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovnsl %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovpl %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovpl %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovnpl %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovnpl %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovll %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovll %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovgel %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovgel %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovlel %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovlel %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovgl %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovgl %esi, %edi # sched: [2:0.50]
; HASWELL-NEXT:    cmovol (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovnol (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovbl (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovbl (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovbl (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovael (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovael (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovael (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovel (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovel (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovnel (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovnel (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovbel (%rdx), %edi # sched: [8:0.75]
; HASWELL-NEXT:    cmovbel (%rdx), %edi # sched: [8:0.75]
; HASWELL-NEXT:    cmoval (%rdx), %edi # sched: [8:0.75]
; HASWELL-NEXT:    cmoval (%rdx), %edi # sched: [8:0.75]
; HASWELL-NEXT:    cmovsl (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovnsl (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovpl (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovpl (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovnpl (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovnpl (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovll (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovll (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovgel (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovgel (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovlel (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovlel (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovgl (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    cmovgl (%rdx), %edi # sched: [7:0.50]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cmov_32:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    cmovol %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovnol %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovbl %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovbl %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovbl %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovael %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovael %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovael %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovel %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovel %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovnel %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovnel %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovbel %esi, %edi # sched: [2:0.50]
; BROADWELL-NEXT:    cmovbel %esi, %edi # sched: [2:0.50]
; BROADWELL-NEXT:    cmoval %esi, %edi # sched: [2:0.50]
; BROADWELL-NEXT:    cmoval %esi, %edi # sched: [2:0.50]
; BROADWELL-NEXT:    cmovsl %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovnsl %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovpl %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovpl %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovnpl %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovnpl %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovll %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovll %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovgel %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovgel %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovlel %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovlel %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovgl %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovgl %esi, %edi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovol (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovnol (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovbl (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovbl (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovbl (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovael (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovael (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovael (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovel (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovel (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovnel (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovnel (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovbel (%rdx), %edi # sched: [7:0.50]
; BROADWELL-NEXT:    cmovbel (%rdx), %edi # sched: [7:0.50]
; BROADWELL-NEXT:    cmoval (%rdx), %edi # sched: [7:0.50]
; BROADWELL-NEXT:    cmoval (%rdx), %edi # sched: [7:0.50]
; BROADWELL-NEXT:    cmovsl (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovnsl (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovpl (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovpl (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovnpl (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovnpl (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovll (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovll (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovgel (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovgel (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovlel (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovlel (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovgl (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovgl (%rdx), %edi # sched: [6:0.50]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cmov_32:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    cmovol %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovnol %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovbl %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovbl %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovbl %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovael %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovael %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovael %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovel %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovel %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovnel %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovnel %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovbel %esi, %edi # sched: [2:1.00]
; SKYLAKE-NEXT:    cmovbel %esi, %edi # sched: [2:1.00]
; SKYLAKE-NEXT:    cmoval %esi, %edi # sched: [2:1.00]
; SKYLAKE-NEXT:    cmoval %esi, %edi # sched: [2:1.00]
; SKYLAKE-NEXT:    cmovsl %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovnsl %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovpl %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovpl %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovnpl %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovnpl %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovll %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovll %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovgel %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovgel %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovlel %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovlel %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovgl %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovgl %esi, %edi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovol (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovnol (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovbl (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovbl (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovbl (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovael (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovael (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovael (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovel (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovel (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovnel (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovnel (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovbel (%rdx), %edi # sched: [7:1.00]
; SKYLAKE-NEXT:    cmovbel (%rdx), %edi # sched: [7:1.00]
; SKYLAKE-NEXT:    cmoval (%rdx), %edi # sched: [7:1.00]
; SKYLAKE-NEXT:    cmoval (%rdx), %edi # sched: [7:1.00]
; SKYLAKE-NEXT:    cmovsl (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovnsl (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovpl (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovpl (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovnpl (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovnpl (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovll (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovll (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovgel (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovgel (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovlel (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovlel (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovgl (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovgl (%rdx), %edi # sched: [6:0.50]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cmov_32:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    cmovol %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovnol %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovbl %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovbl %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovbl %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovael %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovael %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovael %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovel %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovel %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovnel %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovnel %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovbel %esi, %edi # sched: [2:1.00]
; SKX-NEXT:    cmovbel %esi, %edi # sched: [2:1.00]
; SKX-NEXT:    cmoval %esi, %edi # sched: [2:1.00]
; SKX-NEXT:    cmoval %esi, %edi # sched: [2:1.00]
; SKX-NEXT:    cmovsl %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovnsl %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovpl %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovpl %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovnpl %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovnpl %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovll %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovll %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovgel %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovgel %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovlel %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovlel %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovgl %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovgl %esi, %edi # sched: [1:0.50]
; SKX-NEXT:    cmovol (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovnol (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovbl (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovbl (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovbl (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovael (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovael (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovael (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovel (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovel (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovnel (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovnel (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovbel (%rdx), %edi # sched: [7:1.00]
; SKX-NEXT:    cmovbel (%rdx), %edi # sched: [7:1.00]
; SKX-NEXT:    cmoval (%rdx), %edi # sched: [7:1.00]
; SKX-NEXT:    cmoval (%rdx), %edi # sched: [7:1.00]
; SKX-NEXT:    cmovsl (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovnsl (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovpl (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovpl (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovnpl (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovnpl (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovll (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovll (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovgel (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovgel (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovlel (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovlel (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovgl (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    cmovgl (%rdx), %edi # sched: [6:0.50]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_cmov_32:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    cmovol %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovnol %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovbl %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovbl %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovbl %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovael %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovael %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovael %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovel %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovel %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovnel %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovnel %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovbel %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovbel %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmoval %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmoval %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovsl %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovnsl %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovpl %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovpl %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovnpl %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovnpl %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovll %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovll %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovgel %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovgel %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovlel %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovlel %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovgl %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovgl %esi, %edi # sched: [1:0.50]
; BTVER2-NEXT:    cmovol (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovnol (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovbl (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovbl (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovbl (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovael (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovael (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovael (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovel (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovel (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovnel (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovnel (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovbel (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovbel (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmoval (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmoval (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovsl (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovnsl (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovpl (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovpl (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovnpl (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovnpl (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovll (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovll (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovgel (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovgel (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovlel (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovlel (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovgl (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    cmovgl (%rdx), %edi # sched: [4:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cmov_32:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    cmovol %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovnol %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovbl %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovbl %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovbl %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovael %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovael %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovael %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovel %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovel %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovnel %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovnel %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovbel %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovbel %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmoval %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmoval %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovsl %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovnsl %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovpl %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovpl %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovnpl %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovnpl %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovll %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovll %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovgel %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovgel %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovlel %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovlel %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovgl %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovgl %esi, %edi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovol (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovnol (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovbl (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovbl (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovbl (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovael (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovael (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovael (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovel (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovel (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovnel (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovnel (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovbel (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovbel (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmoval (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmoval (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovsl (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovnsl (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovpl (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovpl (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovnpl (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovnpl (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovll (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovll (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovgel (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovgel (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovlel (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovlel (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovgl (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovgl (%rdx), %edi # sched: [5:0.50]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  call void asm sideeffect "cmovol $1, $0 \0A\09 cmovnol $1, $0 \0A\09 cmovbl $1, $0 \0A\09 cmovcl $1, $0 \0A\09 cmovnael $1, $0 \0A\09 cmovnbl $1, $0 \0A\09 cmovncl $1, $0 \0A\09 cmovael $1, $0 \0A\09 cmovzl $1, $0 \0A\09 cmovel $1, $0 \0A\09 cmovnzl $1, $0 \0A\09 cmovnel $1, $0 \0A\09 cmovbel $1, $0 \0A\09 cmovnal $1, $0 \0A\09 cmovnbel $1, $0 \0A\09 cmoval $1, $0 \0A\09 cmovsl $1, $0 \0A\09 cmovnsl $1, $0 \0A\09 cmovpl $1, $0 \0A\09 cmovpel $1, $0 \0A\09 cmovnpl $1, $0 \0A\09 cmovpol $1, $0 \0A\09 cmovll $1, $0 \0A\09 cmovngel $1, $0 \0A\09 cmovnll $1, $0 \0A\09 cmovgel $1, $0 \0A\09 cmovlel $1, $0 \0A\09 cmovngl $1, $0 \0A\09 cmovnlel $1, $0 \0A\09 cmovgl $1, $0 \0A\09 cmovol $2, $0 \0A\09 cmovnol $2, $0 \0A\09 cmovbl $2, $0 \0A\09 cmovcl $2, $0 \0A\09 cmovnael $2, $0 \0A\09 cmovnbl $2, $0 \0A\09 cmovncl $2, $0 \0A\09 cmovael $2, $0 \0A\09 cmovzl $2, $0 \0A\09 cmovel $2, $0 \0A\09 cmovnzl $2, $0 \0A\09 cmovnel $2, $0 \0A\09 cmovbel $2, $0 \0A\09 cmovnal $2, $0 \0A\09 cmovnbel $2, $0 \0A\09 cmoval $2, $0 \0A\09 cmovsl $2, $0 \0A\09 cmovnsl $2, $0 \0A\09 cmovpl $2, $0 \0A\09 cmovpel $2, $0 \0A\09 cmovnpl $2, $0 \0A\09 cmovpol $2, $0 \0A\09 cmovll $2, $0 \0A\09 cmovngel $2, $0 \0A\09 cmovnll $2, $0 \0A\09 cmovgel $2, $0 \0A\09 cmovlel $2, $0 \0A\09 cmovngl $2, $0 \0A\09 cmovnlel $2, $0 \0A\09 cmovgl $2, $0", "r,r,*m"(i32 %a0, i32 %a1, i32 *%a2)
  ret void
}

define void @test_cmov_64(i64 %a0, i64 %a1, i64 *%a2) optsize {
; GENERIC-LABEL: test_cmov_64:
; GENERIC:       # %bb.0:
; GENERIC-NEXT:    #APP
; GENERIC-NEXT:    cmovoq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmovnoq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmovbq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmovbq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmovbq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmovaeq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmovaeq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmovaeq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmoveq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmoveq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmovneq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmovneq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmovbeq %rsi, %rdi # sched: [3:1.00]
; GENERIC-NEXT:    cmovbeq %rsi, %rdi # sched: [3:1.00]
; GENERIC-NEXT:    cmovaq %rsi, %rdi # sched: [3:1.00]
; GENERIC-NEXT:    cmovaq %rsi, %rdi # sched: [3:1.00]
; GENERIC-NEXT:    cmovsq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmovnsq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmovpq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmovpq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmovnpq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmovnpq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmovlq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmovlq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmovgeq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmovgeq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmovleq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmovleq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmovgq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmovgq %rsi, %rdi # sched: [2:0.67]
; GENERIC-NEXT:    cmovoq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmovnoq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmovbq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmovbq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmovbq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmovaeq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmovaeq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmovaeq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmoveq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmoveq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmovneq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmovneq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmovbeq (%rdx), %rdi # sched: [8:1.00]
; GENERIC-NEXT:    cmovbeq (%rdx), %rdi # sched: [8:1.00]
; GENERIC-NEXT:    cmovaq (%rdx), %rdi # sched: [8:1.00]
; GENERIC-NEXT:    cmovaq (%rdx), %rdi # sched: [8:1.00]
; GENERIC-NEXT:    cmovsq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmovnsq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmovpq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmovpq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmovnpq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmovnpq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmovlq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmovlq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmovgeq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmovgeq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmovleq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmovleq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmovgq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    cmovgq (%rdx), %rdi # sched: [7:0.67]
; GENERIC-NEXT:    #NO_APP
; GENERIC-NEXT:    retq # sched: [1:1.00]
;
; ATOM-LABEL: test_cmov_64:
; ATOM:       # %bb.0:
; ATOM-NEXT:    #APP
; ATOM-NEXT:    cmovoq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovnoq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovbq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovbq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovbq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovaeq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovaeq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovaeq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmoveq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmoveq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovneq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovneq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovbeq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovbeq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovaq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovaq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovsq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovnsq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovpq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovpq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovnpq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovnpq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovlq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovlq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovgeq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovgeq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovleq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovleq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovgq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovgq %rsi, %rdi # sched: [1:0.50]
; ATOM-NEXT:    cmovoq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovnoq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovbq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovbq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovbq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovaeq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovaeq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovaeq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmoveq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmoveq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovneq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovneq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovbeq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovbeq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovaq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovaq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovsq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovnsq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovpq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovpq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovnpq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovnpq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovlq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovlq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovgeq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovgeq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovleq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovleq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovgq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    cmovgq (%rdx), %rdi # sched: [1:1.00]
; ATOM-NEXT:    #NO_APP
; ATOM-NEXT:    retq # sched: [79:39.50]
;
; SLM-LABEL: test_cmov_64:
; SLM:       # %bb.0:
; SLM-NEXT:    #APP
; SLM-NEXT:    cmovoq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovnoq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovbq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovbq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovbq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovaeq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovaeq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovaeq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmoveq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmoveq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovneq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovneq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovbeq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovbeq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovaq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovaq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovsq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovnsq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovpq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovpq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovnpq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovnpq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovlq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovlq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovgeq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovgeq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovleq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovleq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovgq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovgq %rsi, %rdi # sched: [1:0.50]
; SLM-NEXT:    cmovoq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovnoq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovbq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovbq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovbq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovaeq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovaeq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovaeq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmoveq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmoveq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovneq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovneq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovbeq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovbeq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovaq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovaq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovsq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovnsq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovpq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovpq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovnpq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovnpq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovlq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovlq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovgeq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovgeq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovleq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovleq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovgq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    cmovgq (%rdx), %rdi # sched: [4:1.00]
; SLM-NEXT:    #NO_APP
; SLM-NEXT:    retq # sched: [4:1.00]
;
; SANDY-LABEL: test_cmov_64:
; SANDY:       # %bb.0:
; SANDY-NEXT:    #APP
; SANDY-NEXT:    cmovoq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmovnoq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmovbq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmovbq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmovbq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmovaeq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmovaeq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmovaeq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmoveq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmoveq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmovneq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmovneq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmovbeq %rsi, %rdi # sched: [3:1.00]
; SANDY-NEXT:    cmovbeq %rsi, %rdi # sched: [3:1.00]
; SANDY-NEXT:    cmovaq %rsi, %rdi # sched: [3:1.00]
; SANDY-NEXT:    cmovaq %rsi, %rdi # sched: [3:1.00]
; SANDY-NEXT:    cmovsq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmovnsq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmovpq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmovpq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmovnpq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmovnpq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmovlq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmovlq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmovgeq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmovgeq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmovleq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmovleq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmovgq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmovgq %rsi, %rdi # sched: [2:0.67]
; SANDY-NEXT:    cmovoq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmovnoq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmovbq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmovbq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmovbq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmovaeq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmovaeq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmovaeq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmoveq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmoveq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmovneq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmovneq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmovbeq (%rdx), %rdi # sched: [8:1.00]
; SANDY-NEXT:    cmovbeq (%rdx), %rdi # sched: [8:1.00]
; SANDY-NEXT:    cmovaq (%rdx), %rdi # sched: [8:1.00]
; SANDY-NEXT:    cmovaq (%rdx), %rdi # sched: [8:1.00]
; SANDY-NEXT:    cmovsq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmovnsq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmovpq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmovpq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmovnpq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmovnpq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmovlq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmovlq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmovgeq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmovgeq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmovleq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmovleq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmovgq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    cmovgq (%rdx), %rdi # sched: [7:0.67]
; SANDY-NEXT:    #NO_APP
; SANDY-NEXT:    retq # sched: [1:1.00]
;
; HASWELL-LABEL: test_cmov_64:
; HASWELL:       # %bb.0:
; HASWELL-NEXT:    #APP
; HASWELL-NEXT:    cmovoq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmovnoq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmovbq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmovbq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmovbq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmovaeq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmovaeq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmovaeq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmoveq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmoveq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmovneq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmovneq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmovbeq %rsi, %rdi # sched: [3:0.75]
; HASWELL-NEXT:    cmovbeq %rsi, %rdi # sched: [3:0.75]
; HASWELL-NEXT:    cmovaq %rsi, %rdi # sched: [3:0.75]
; HASWELL-NEXT:    cmovaq %rsi, %rdi # sched: [3:0.75]
; HASWELL-NEXT:    cmovsq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmovnsq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmovpq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmovpq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmovnpq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmovnpq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmovlq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmovlq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmovgeq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmovgeq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmovleq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmovleq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmovgq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmovgq %rsi, %rdi # sched: [2:0.50]
; HASWELL-NEXT:    cmovoq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmovnoq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmovbq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmovbq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmovbq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmovaeq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmovaeq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmovaeq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmoveq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmoveq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmovneq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmovneq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmovbeq (%rdx), %rdi # sched: [8:0.75]
; HASWELL-NEXT:    cmovbeq (%rdx), %rdi # sched: [8:0.75]
; HASWELL-NEXT:    cmovaq (%rdx), %rdi # sched: [8:0.75]
; HASWELL-NEXT:    cmovaq (%rdx), %rdi # sched: [8:0.75]
; HASWELL-NEXT:    cmovsq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmovnsq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmovpq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmovpq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmovnpq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmovnpq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmovlq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmovlq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmovgeq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmovgeq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmovleq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmovleq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmovgq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    cmovgq (%rdx), %rdi # sched: [7:0.50]
; HASWELL-NEXT:    #NO_APP
; HASWELL-NEXT:    retq # sched: [7:1.00]
;
; BROADWELL-LABEL: test_cmov_64:
; BROADWELL:       # %bb.0:
; BROADWELL-NEXT:    #APP
; BROADWELL-NEXT:    cmovoq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovnoq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovbq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovbq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovbq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovaeq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovaeq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovaeq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmoveq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmoveq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovneq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovneq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovbeq %rsi, %rdi # sched: [2:0.50]
; BROADWELL-NEXT:    cmovbeq %rsi, %rdi # sched: [2:0.50]
; BROADWELL-NEXT:    cmovaq %rsi, %rdi # sched: [2:0.50]
; BROADWELL-NEXT:    cmovaq %rsi, %rdi # sched: [2:0.50]
; BROADWELL-NEXT:    cmovsq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovnsq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovpq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovpq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovnpq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovnpq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovlq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovlq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovgeq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovgeq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovleq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovleq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovgq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovgq %rsi, %rdi # sched: [1:0.50]
; BROADWELL-NEXT:    cmovoq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovnoq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovbq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovbq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovbq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovaeq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovaeq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovaeq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmoveq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmoveq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovneq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovneq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovbeq (%rdx), %rdi # sched: [7:0.50]
; BROADWELL-NEXT:    cmovbeq (%rdx), %rdi # sched: [7:0.50]
; BROADWELL-NEXT:    cmovaq (%rdx), %rdi # sched: [7:0.50]
; BROADWELL-NEXT:    cmovaq (%rdx), %rdi # sched: [7:0.50]
; BROADWELL-NEXT:    cmovsq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovnsq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovpq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovpq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovnpq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovnpq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovlq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovlq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovgeq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovgeq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovleq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovleq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovgq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    cmovgq (%rdx), %rdi # sched: [6:0.50]
; BROADWELL-NEXT:    #NO_APP
; BROADWELL-NEXT:    retq # sched: [7:1.00]
;
; SKYLAKE-LABEL: test_cmov_64:
; SKYLAKE:       # %bb.0:
; SKYLAKE-NEXT:    #APP
; SKYLAKE-NEXT:    cmovoq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovnoq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovbq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovbq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovbq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovaeq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovaeq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovaeq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmoveq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmoveq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovneq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovneq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovbeq %rsi, %rdi # sched: [2:1.00]
; SKYLAKE-NEXT:    cmovbeq %rsi, %rdi # sched: [2:1.00]
; SKYLAKE-NEXT:    cmovaq %rsi, %rdi # sched: [2:1.00]
; SKYLAKE-NEXT:    cmovaq %rsi, %rdi # sched: [2:1.00]
; SKYLAKE-NEXT:    cmovsq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovnsq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovpq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovpq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovnpq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovnpq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovlq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovlq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovgeq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovgeq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovleq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovleq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovgq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovgq %rsi, %rdi # sched: [1:0.50]
; SKYLAKE-NEXT:    cmovoq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovnoq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovbq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovbq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovbq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovaeq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovaeq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovaeq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmoveq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmoveq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovneq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovneq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovbeq (%rdx), %rdi # sched: [7:1.00]
; SKYLAKE-NEXT:    cmovbeq (%rdx), %rdi # sched: [7:1.00]
; SKYLAKE-NEXT:    cmovaq (%rdx), %rdi # sched: [7:1.00]
; SKYLAKE-NEXT:    cmovaq (%rdx), %rdi # sched: [7:1.00]
; SKYLAKE-NEXT:    cmovsq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovnsq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovpq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovpq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovnpq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovnpq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovlq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovlq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovgeq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovgeq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovleq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovleq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovgq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    cmovgq (%rdx), %rdi # sched: [6:0.50]
; SKYLAKE-NEXT:    #NO_APP
; SKYLAKE-NEXT:    retq # sched: [7:1.00]
;
; SKX-LABEL: test_cmov_64:
; SKX:       # %bb.0:
; SKX-NEXT:    #APP
; SKX-NEXT:    cmovoq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmovnoq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmovbq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmovbq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmovbq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmovaeq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmovaeq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmovaeq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmoveq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmoveq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmovneq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmovneq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmovbeq %rsi, %rdi # sched: [2:1.00]
; SKX-NEXT:    cmovbeq %rsi, %rdi # sched: [2:1.00]
; SKX-NEXT:    cmovaq %rsi, %rdi # sched: [2:1.00]
; SKX-NEXT:    cmovaq %rsi, %rdi # sched: [2:1.00]
; SKX-NEXT:    cmovsq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmovnsq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmovpq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmovpq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmovnpq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmovnpq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmovlq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmovlq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmovgeq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmovgeq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmovleq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmovleq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmovgq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmovgq %rsi, %rdi # sched: [1:0.50]
; SKX-NEXT:    cmovoq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmovnoq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmovbq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmovbq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmovbq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmovaeq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmovaeq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmovaeq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmoveq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmoveq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmovneq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmovneq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmovbeq (%rdx), %rdi # sched: [7:1.00]
; SKX-NEXT:    cmovbeq (%rdx), %rdi # sched: [7:1.00]
; SKX-NEXT:    cmovaq (%rdx), %rdi # sched: [7:1.00]
; SKX-NEXT:    cmovaq (%rdx), %rdi # sched: [7:1.00]
; SKX-NEXT:    cmovsq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmovnsq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmovpq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmovpq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmovnpq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmovnpq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmovlq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmovlq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmovgeq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmovgeq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmovleq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmovleq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmovgq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    cmovgq (%rdx), %rdi # sched: [6:0.50]
; SKX-NEXT:    #NO_APP
; SKX-NEXT:    retq # sched: [7:1.00]
;
; BTVER2-LABEL: test_cmov_64:
; BTVER2:       # %bb.0:
; BTVER2-NEXT:    #APP
; BTVER2-NEXT:    cmovoq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovnoq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovbq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovbq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovbq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovaeq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovaeq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovaeq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmoveq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmoveq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovneq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovneq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovbeq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovbeq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovaq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovaq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovsq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovnsq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovpq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovpq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovnpq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovnpq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovlq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovlq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovgeq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovgeq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovleq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovleq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovgq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovgq %rsi, %rdi # sched: [1:0.50]
; BTVER2-NEXT:    cmovoq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovnoq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovbq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovbq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovbq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovaeq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovaeq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovaeq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmoveq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmoveq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovneq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovneq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovbeq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovbeq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovaq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovaq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovsq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovnsq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovpq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovpq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovnpq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovnpq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovlq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovlq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovgeq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovgeq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovleq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovleq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovgq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    cmovgq (%rdx), %rdi # sched: [4:1.00]
; BTVER2-NEXT:    #NO_APP
; BTVER2-NEXT:    retq # sched: [4:1.00]
;
; ZNVER1-LABEL: test_cmov_64:
; ZNVER1:       # %bb.0:
; ZNVER1-NEXT:    #APP
; ZNVER1-NEXT:    cmovoq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovnoq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovbq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovbq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovbq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovaeq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovaeq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovaeq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmoveq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmoveq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovneq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovneq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovbeq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovbeq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovaq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovaq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovsq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovnsq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovpq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovpq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovnpq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovnpq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovlq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovlq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovgeq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovgeq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovleq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovleq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovgq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovgq %rsi, %rdi # sched: [1:0.25]
; ZNVER1-NEXT:    cmovoq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovnoq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovbq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovbq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovbq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovaeq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovaeq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovaeq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmoveq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmoveq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovneq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovneq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovbeq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovbeq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovaq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovaq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovsq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovnsq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovpq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovpq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovnpq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovnpq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovlq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovlq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovgeq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovgeq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovleq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovleq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovgq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    cmovgq (%rdx), %rdi # sched: [5:0.50]
; ZNVER1-NEXT:    #NO_APP
; ZNVER1-NEXT:    retq # sched: [1:0.50]
  call void asm sideeffect "cmovoq $1, $0 \0A\09 cmovnoq $1, $0 \0A\09 cmovbq $1, $0 \0A\09 cmovcq $1, $0 \0A\09 cmovnaeq $1, $0 \0A\09 cmovnbq $1, $0 \0A\09 cmovncq $1, $0 \0A\09 cmovaeq $1, $0 \0A\09 cmovzq $1, $0 \0A\09 cmoveq $1, $0 \0A\09 cmovnzq $1, $0 \0A\09 cmovneq $1, $0 \0A\09 cmovbeq $1, $0 \0A\09 cmovnaq $1, $0 \0A\09 cmovnbeq $1, $0 \0A\09 cmovaq $1, $0 \0A\09 cmovsq $1, $0 \0A\09 cmovnsq $1, $0 \0A\09 cmovpq $1, $0 \0A\09 cmovpeq $1, $0 \0A\09 cmovnpq $1, $0 \0A\09 cmovpoq $1, $0 \0A\09 cmovlq $1, $0 \0A\09 cmovngeq $1, $0 \0A\09 cmovnlq $1, $0 \0A\09 cmovgeq $1, $0 \0A\09 cmovleq $1, $0 \0A\09 cmovngq $1, $0 \0A\09 cmovnleq $1, $0 \0A\09 cmovgq $1, $0 \0A\09 cmovoq $2, $0 \0A\09 cmovnoq $2, $0 \0A\09 cmovbq $2, $0 \0A\09 cmovcq $2, $0 \0A\09 cmovnaeq $2, $0 \0A\09 cmovnbq $2, $0 \0A\09 cmovncq $2, $0 \0A\09 cmovaeq $2, $0 \0A\09 cmovzq $2, $0 \0A\09 cmoveq $2, $0 \0A\09 cmovnzq $2, $0 \0A\09 cmovneq $2, $0 \0A\09 cmovbeq $2, $0 \0A\09 cmovnaq $2, $0 \0A\09 cmovnbeq $2, $0 \0A\09 cmovaq $2, $0 \0A\09 cmovsq $2, $0 \0A\09 cmovnsq $2, $0 \0A\09 cmovpq $2, $0 \0A\09 cmovpeq $2, $0 \0A\09 cmovnpq $2, $0 \0A\09 cmovpoq $2, $0 \0A\09 cmovlq $2, $0 \0A\09 cmovngeq $2, $0 \0A\09 cmovnlq $2, $0 \0A\09 cmovgeq $2, $0 \0A\09 cmovleq $2, $0 \0A\09 cmovngq $2, $0 \0A\09 cmovnleq $2, $0 \0A\09 cmovgq $2, $0", "r,r,*m"(i64 %a0, i64 %a1, i64 *%a2)
  ret void
}
