
/*
 * LaTeX Symbols Selector
 *
 * Copyright (C) 2006 Tomasz Mka <pasp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <limits.h>
#include <sys/stat.h>
#include <gtk/gtk.h>
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>

#include "prefs.h"

struct lss_prefs config;

/*------------------------------------------------------------------------------*/

gchar*
prefs_get_config_filename (void) {

static gchar filename[PATH_MAX];
gchar separator[2] = { G_DIR_SEPARATOR, '\0' };

    strncpy (filename, g_get_home_dir(), PATH_MAX-1);
    strcat (filename, separator);
    strcat (filename, CONFIG_FILENAME);

    return filename;
}

/*------------------------------------------------------------------------------*/

void
prefs_set_default_values (void) {

    config.window_x = 225;
    config.window_y = 100;
    config.window_size_x = 660;
    config.window_size_y = 390;
    config.current_group = 0;
    config.single_click = 0;
    config.display_symbol_name = 0;
    config.enable_ams_symbols = 0;
    config.send_to_gvim = 0;
    config.send_to_clipboard = 1;
    memset(config.latest_symbol_name, 0, SYMBOL_NAME_LEN);
}

/*------------------------------------------------------------------------------*/

void
prefs_read_config (void) {

gboolean cfg_file;
xmlDocPtr doc;
xmlNodePtr node;
xmlChar *key;

    cfg_file = g_file_test(prefs_get_config_filename(), G_FILE_TEST_IS_REGULAR);

    if (cfg_file == TRUE) {

        doc = xmlParseFile(prefs_get_config_filename());
        if (doc == NULL)
                return;

        node = xmlDocGetRootElement(doc);
        if (node == NULL) {
                xmlFreeDoc(doc);
                return;
        }

        if (xmlStrcmp(node->name, (const xmlChar *) CONFIG_NAME)) {
                xmlFreeDoc(doc);
                return;
        }

        prefs_set_default_values();

        node = node->xmlChildrenNode;

        while (node != NULL) {

                if ((!xmlStrcmp(node->name, (const xmlChar *) "window_x"))) {
                    key = xmlNodeListGetString(doc, node->xmlChildrenNode, 1);
                    if (key != NULL)
                            sscanf((gchar *) key, "%d", &config.window_x);
                    xmlFree(key);
                }

                if ((!xmlStrcmp(node->name, (const xmlChar *) "window_y"))) {
                    key = xmlNodeListGetString(doc, node->xmlChildrenNode, 1);
                    if (key != NULL)
                            sscanf((gchar *) key, "%d", &config.window_y);
                    xmlFree(key);
                }

                if ((!xmlStrcmp(node->name, (const xmlChar *) "window_size_x"))) {
                    key = xmlNodeListGetString(doc, node->xmlChildrenNode, 1);
                    if (key != NULL)
                            sscanf((gchar *) key, "%d", &config.window_size_x);
                    xmlFree(key);
                }

                if ((!xmlStrcmp(node->name, (const xmlChar *) "window_size_y"))) {
                    key = xmlNodeListGetString(doc, node->xmlChildrenNode, 1);
                    if (key != NULL)
                            sscanf((gchar *) key, "%d", &config.window_size_y);
                    xmlFree(key);
                }

                if ((!xmlStrcmp(node->name, (const xmlChar *) "current_group"))) {
                    key = xmlNodeListGetString(doc, node->xmlChildrenNode, 1);
                    if (key != NULL)
                            sscanf((gchar *) key, "%d", &config.current_group);
                    xmlFree(key);
                }

                if ((!xmlStrcmp(node->name, (const xmlChar *) "single_click"))) {
                    key = xmlNodeListGetString(doc, node->xmlChildrenNode, 1);
                    if (key != NULL)
                            sscanf((gchar *) key, "%d", &config.single_click);
                    xmlFree(key);
                }

                if ((!xmlStrcmp(node->name, (const xmlChar *) "display_symbol_name"))) {
                    key = xmlNodeListGetString(doc, node->xmlChildrenNode, 1);
                    if (key != NULL)
                            sscanf((gchar *) key, "%d", &config.display_symbol_name);
                    xmlFree(key);
                }

                if ((!xmlStrcmp(node->name, (const xmlChar *) "enable_ams_symbols"))) {
                    key = xmlNodeListGetString(doc, node->xmlChildrenNode, 1);
                    if (key != NULL)
                            sscanf((gchar *) key, "%d", &config.enable_ams_symbols);
                    xmlFree(key);
                }

                if ((!xmlStrcmp(node->name, (const xmlChar *) "send_to_gvim"))) {
                    key = xmlNodeListGetString(doc, node->xmlChildrenNode, 1);
                    if (key != NULL)
                            sscanf((gchar *) key, "%d", &config.send_to_gvim);
                    xmlFree(key);
                }

                if ((!xmlStrcmp(node->name, (const xmlChar *) "send_to_clipboard"))) {
                    key = xmlNodeListGetString(doc, node->xmlChildrenNode, 1);
                    if (key != NULL)
                            sscanf((gchar *) key, "%d", &config.send_to_clipboard);
                    xmlFree(key);
                }

                if ((!xmlStrcmp(node->name, (const xmlChar *) "latest_symbol_name"))) {
                    key = xmlNodeListGetString(doc, node->xmlChildrenNode, 1);
                    if (key != NULL)
                            strncpy(config.latest_symbol_name, (gchar *) key, SYMBOL_NAME_LEN-1);
                    xmlFree(key);
                }

            node = node->next;
        }

        xmlFreeDoc(doc);

    } else {

        prefs_set_default_values();
        prefs_write_config ();
    }

}

/*------------------------------------------------------------------------------*/

void prefs_write_config(void) {

xmlDocPtr doc;
xmlNodePtr node;
gchar temp[BUFFER_SIZE];

    doc = xmlNewDoc((const xmlChar *) "1.0");
    node = xmlNewNode(NULL, (const xmlChar *) CONFIG_NAME);
    xmlDocSetRootElement(doc, node);

    snprintf(temp, 32, "%d", config.window_x);
    xmlNewTextChild(node, NULL, (const xmlChar *) "window_x", (xmlChar *) temp);
    snprintf(temp, 32, "%d", config.window_y);
    xmlNewTextChild(node, NULL, (const xmlChar *) "window_y", (xmlChar *) temp);
    snprintf(temp, 32, "%d", config.window_size_x);
    xmlNewTextChild(node, NULL, (const xmlChar *) "window_size_x", (xmlChar *) temp);
    snprintf(temp, 32, "%d", config.window_size_y);
    xmlNewTextChild(node, NULL, (const xmlChar *) "window_size_y", (xmlChar *) temp);
    snprintf(temp, 32, "%d", config.current_group);
    xmlNewTextChild(node, NULL, (const xmlChar *) "current_group", (xmlChar *) temp);
    snprintf(temp, 32, "%d", config.single_click);
    xmlNewTextChild(node, NULL, (const xmlChar *) "single_click", (xmlChar *) temp);
    snprintf(temp, 32, "%d", config.display_symbol_name);
    xmlNewTextChild(node, NULL, (const xmlChar *) "display_symbol_name", (xmlChar *) temp);
    snprintf(temp, 32, "%d", config.enable_ams_symbols);
    xmlNewTextChild(node, NULL, (const xmlChar *) "enable_ams_symbols", (xmlChar *) temp);
    snprintf(temp, 32, "%d", config.send_to_gvim);
    xmlNewTextChild(node, NULL, (const xmlChar *) "send_to_gvim", (xmlChar *) temp);
    snprintf(temp, 32, "%d", config.send_to_clipboard);
    xmlNewTextChild(node, NULL, (const xmlChar *) "send_to_clipboard", (xmlChar *) temp);

    xmlNewTextChild(node, NULL, (const xmlChar *) "latest_symbol_name", (xmlChar *) config.latest_symbol_name);

    xmlSaveFormatFile(prefs_get_config_filename(), doc, 1);
    xmlFreeDoc(doc);
}

/*------------------------------------------------------------------------------*/

