
/*
 * LaTeX Symbols Selector
 *
 * Copyright (C) 2006 Tomasz Mąka <pasp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/wait.h>
#include <gtk/gtk.h>

#include "gui.h"
#include "prefs.h"
#include "send.h"


/*------------------------------------------------------------------------------*/

void
drag_data_get_cb (GtkWidget *widget, GdkDragContext *drag_context, 
                  GtkSelectionData *selection_data, guint info, guint time, gpointer user_data) {

    gchar *icon_name;
    GtkTreeIter iter;
    GtkTreePath *tree_path;
    GList *items_list, *current;

    GUI *appGUI = (GUI *)user_data;

    items_list = gtk_icon_view_get_selected_items (GTK_ICON_VIEW(appGUI->icons_view));

    current = g_list_nth (items_list, 0);

    if(current != NULL) {

        tree_path = current->data;

        gtk_tree_model_get_iter (GTK_TREE_MODEL (appGUI->icons_store), &iter, tree_path);
        gtk_tree_model_get (GTK_TREE_MODEL (appGUI->icons_store), &iter, COL_NAME, &icon_name, -1);

        gtk_selection_data_set (selection_data, selection_data->target,
                                8, (guchar *) icon_name, strlen(icon_name));
        g_free(icon_name);
    }
}

/*------------------------------------------------------------------------------*/

void
drag_and_drop_init (GtkWidget *widget, GUI *appGUI) {

GtkTargetEntry source_table[] = {
        { "STRING",        0, 0 },
        { "text/plain",    0, 0 }
};

    g_signal_connect (G_OBJECT (widget), "drag_data_get",
                      G_CALLBACK (drag_data_get_cb), appGUI);

    gtk_drag_source_set(widget, GDK_BUTTON1_MASK,
                        source_table, sizeof(source_table) / sizeof(GtkTargetEntry), GDK_ACTION_COPY);
}

/*------------------------------------------------------------------------------*/

gboolean
send_symbol_to_gvim (gchar *symbol) {

FILE *handle;
gchar server_name[BUFFER_SIZE];
gint i, flag, len;
gchar *cmdline[4], command[PATH_MAX];

    handle = popen(GVIM_SERVERS_LIST_CMD, "r");

    if (!handle)
        return FALSE;

    flag = FALSE;

    len = fread (server_name, 1, BUFFER_SIZE, handle);

    if (!len)
        return FALSE;

    for(i=0; i < BUFFER_SIZE; i++)
        if(server_name[i] == '\n') {
            server_name[i]='\0';
            flag = TRUE;
            break;
        }

    if(!WIFEXITED(pclose(handle)))
        return FALSE;

    if (flag) {
        snprintf(command, BUFFER_SIZE, GVIM_SERVER_SEND_TEXT_CMD, server_name, symbol);
        cmdline[0] = "sh";
        cmdline[1] = "-c";
        cmdline[2] = command;
        cmdline[3] = 0;
        g_spawn_async(NULL, (gchar **)cmdline, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_STDOUT_TO_DEV_NULL,
                      NULL, NULL, NULL, FALSE);
    }

    return TRUE;
}

/*------------------------------------------------------------------------------*/

gboolean
send_symbol_to_clipboard (gchar *symbol) {

GdkAtom clip_atom;

    clip_atom = gdk_atom_intern ("CLIPBOARD", FALSE);
    gtk_clipboard_set_text(gtk_clipboard_get(clip_atom), symbol, -1);

    clip_atom = gdk_atom_intern ("PRIMARY", FALSE);
    gtk_clipboard_set_text(gtk_clipboard_get(clip_atom), symbol, -1);

    return TRUE;
}

/*------------------------------------------------------------------------------*/

