/* Lyrics Plasmoid.
 * Copyright (C) 2010  Mauro E. Bender <maurobender@gmail.com>
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef LYRICS_SOURCES_H
#define LYRICS_SOURCES_H

#include <QMap>
#include <QList>
#include <QPair>
#include <QString>
#include <QStringList>
#include "lyrics_source.h"

class LyricsSources {
public:
	LyricsSources() {
		LyricSource *lyric_source = new LyricSource;
		QList< QPair <QString, QString> > extract_patterns;
		QList< QPair <QString, QString> > exlude_patterns;
		QList< QPair <QString, QString> > url_replacements;
		
		lyric_source->name = "lyrics.wikia.com";
		lyric_source->title = "{artist} - {title}";
		lyric_source->url = "http://lyrics.wikia.com/{artist}:{title}";
		
		extract_patterns.clear();
		extract_patterns.append(QPair< QString, QString> ("<div class='lyricbox'><div class='rtMatcher'>.*</div>", "<div class='rtMatcher'>.*</div></div>"));
		lyric_source->extract = extract_patterns;
		
		exlude_patterns.clear();
		exlude_patterns.append(QPair< QString, QString> ("<div class='rtMatcher'>", "</div>"));
		exlude_patterns.append(QPair< QString, QString> ("<!--", "-->"));
		exlude_patterns.append(QPair< QString, QString> ("<p>", "</p>"));
		exlude_patterns.append(QPair< QString, QString> ("<a.*>", "</a>"));
		exlude_patterns.append(QPair< QString, QString> ("<i>", "</i>"));
		lyric_source->exclude = exlude_patterns;
		
		url_replacements.clear();
		url_replacements.append(QPair< QString, QString> (" ", "_"));
		lyric_source->url_replace = url_replacements;
		
		lyric_source->start_case = true;
		
		m_sources.insert(lyric_source->name, lyric_source);
		
		/*lyric_source = new LyricSource;
		lyric_source->name = "lyricsplugin.com";
		lyric_source->title = "{artist} - {title}";
		lyric_source->url = "http://www.lyricsplugin.com/winamp03/plugin/?title={title}&artist={artist}";
		
		extract_patterns.clear();
		extract_patterns.append(QPair< QString, QString> ("<div id=\"lyrics\">", "</div>"));
		lyric_source->extract = extract_patterns;
		
		exlude_patterns.clear();
		exlude_patterns.append(QPair< QString, QString> ("<!--", "-->"));
		exlude_patterns.append(QPair< QString, QString> ("<p>", "</p>"));
		exlude_patterns.append(QPair< QString, QString> ("<a.*>", "</a>"));
		exlude_patterns.append(QPair< QString, QString> ("<i>", "</i>"));
		lyric_source->exclude = exlude_patterns;
		
		url_replacements.clear();
		url_replacements.append(QPair< QString, QString> (" ", "%20"));
		url_replacements.append(QPair< QString, QString> ("'", ""));
		lyric_source->url_replace = url_replacements;*/
		
		m_sources.insert(lyric_source->name, lyric_source);
		
		lyric_source = new LyricSource;
		lyric_source->name = "lyricstime.com";
		lyric_source->title = "{artist} - {title} Lyrics";
		lyric_source->url = "http://www.lyricstime.com/{artist}-{title}-lyrics.html";
		
		extract_patterns.clear();
		extract_patterns.append(QPair< QString, QString> ("<div.*id=\"songlyrics\".*>.*<p>", "</p>.*</div>"));
		lyric_source->extract = extract_patterns;
		
		exlude_patterns.clear();
		exlude_patterns.append(QPair< QString, QString> ("<!--", "-->"));
		exlude_patterns.append(QPair< QString, QString> ("<a.*>", "</a>"));
		exlude_patterns.append(QPair< QString, QString> ("<i>", "</i>"));
		lyric_source->exclude = exlude_patterns;
		
		url_replacements.clear();
		url_replacements.append(QPair< QString, QString> (" ", "-"));
		url_replacements.append(QPair< QString, QString> ("'", "-"));
		url_replacements.append(QPair< QString, QString> (".", ""));
		lyric_source->url_replace = url_replacements;
		
		m_sources.insert(lyric_source->name, lyric_source);
		
		/*lyric_source = new LyricSource;
		lyric_source->name = "seeklyrics.com";
		lyric_source->title = "{artist} - {title} Lyrics";
		lyric_source->url = "http://www.seeklyrics.com/lyrics/{artist}/{title}.html";
		
		extract_patterns.clear();
		extract_patterns.append(QPair< QString, QString> ("<div.*id=\"songlyrics\".*>", "</div>"));
		lyric_source->extract = extract_patterns;
		
		exlude_patterns.clear();
		lyric_source->exclude = exlude_patterns;
		
		url_replacements.clear();
		url_replacements.append(QPair< QString, QString> (" ", "-"));
		url_replacements.append(QPair< QString, QString> ("'", "-"));
		url_replacements.append(QPair< QString, QString> (".", ""));
		lyric_source->url_replace = url_replacements;
		
		lyric_source->start_case = true;
		
		m_sources.insert(lyric_source->name, lyric_source);*/
	}
	
	QMap<QString, LyricSource *> &sources() {
		return m_sources;
	}
	
	QStringList sources_names() {
		return m_sources.keys();
	}
	
private:
	QMap<QString, LyricSource *> m_sources;
};

#endif