/* Lyrics Plasmoid.
 * Copyright (C) 2010  Mauro E. Bender <maurobender@gmail.com>
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include "song.h"

Song::Song(const QString &a, const QString &t, const QString &l,
			  const QString &b, const QPixmap &c) {
	title = t;
	lyrics = l;
	artist = a;
	album = b;
	cover = c;
}

Song::Song(const Song &song) {
	*this = song;
}


Song::~Song() {
}

Song &Song::operator=(const Song &song) {
	this->artist = song.artist;
	this->title = song.title;
	this->album = song.album;
	this->lyrics = song.lyrics;
	this->cover = song.cover;
	
	return *this;
}


bool Song::operator==(const Song &song) const {
	return (artist == song.artist) && (title == song.title);
}

bool Song::operator!=(const Song &song) const {
	return !(*this == song);
}

QDebug operator<<(QDebug dbg, const Song &song) {
	dbg.nospace() << "Song(Artist: " << song.artist << ", Title: " << song.title << ")";

	return dbg.space();
}