/*
    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) 2011  <copyright holder> <maurobender@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#include "titlebar.h"

#include <QFrame>
#include <QLabel>
#include <KIcon>

TitleBar::TitleBar(QGraphicsItem *parent, Qt::WindowFlags wFlags): QGraphicsWidget(parent, wFlags) {
	m_title = new Plasma::Label;
	
	QFont title_font = QFont();
	title_font.setBold(true);
	title_font.setPointSize(11);
	
	m_title->setText(i18n("Lyrics"));
	m_title->nativeWidget()->setAlignment(Qt::AlignHCenter | Qt::AlignBottom);
	m_title->setFont(title_font);
	m_title->setPreferredHeight(20);
	
	m_layout = new QGraphicsGridLayout(this);
	
	Plasma::Label *line = new Plasma::Label;
	line->setMaximumHeight(5);
	line->nativeWidget()->setFrameShape(QFrame::HLine);
	
	Plasma::IconWidget *m_reload = new Plasma::IconWidget(KIcon("view-refresh"), QString());
	m_reload->setMaximumSize(14, 14);
	m_reload->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
	m_reload->setToolTip(i18n("Reload Lyrics"));
	
	Plasma::IconWidget *m_config = new Plasma::IconWidget(KIcon("preferences-other"), QString());
	m_config->setMaximumSize(14, 14);
	m_config->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
	m_config->setToolTip(i18n("Configuration"));
	
	connect(m_reload, SIGNAL(clicked()), this, SLOT(reloadLyricsButton_slot()));
	connect(m_config, SIGNAL(clicked()), this, SLOT(configurationButton_slot()));
	
	m_layout->addItem(m_title, 0, 2);
	m_layout->addItem(m_reload, 0, 3);
	m_layout->addItem(m_config, 0, 4);
	m_layout->addItem(line, 1, 0, 1, 5);
	
	m_layout->setAlignment(m_title, Qt::AlignHCenter | Qt::AlignBottom);
	m_layout->setAlignment(m_reload, Qt::AlignRight | Qt::AlignBottom);
	m_layout->setAlignment(m_config, Qt::AlignRight | Qt::AlignBottom);
	
	m_layout->setColumnFixedWidth(0, 14);
	m_layout->setColumnFixedWidth(1, 14);
	m_layout->setColumnFixedWidth(3, 14);
	m_layout->setColumnFixedWidth(4, 14);
	
	m_layout->setRowFixedHeight(0, 20);
	m_layout->setRowFixedHeight(1, 5);
	
	this->setLayout(m_layout);
}

TitleBar::~TitleBar() {
}

void TitleBar::configurationButton_slot() {
	emit configurationButtonClicked();
}

void TitleBar::reloadLyricsButton_slot() {
	emit reloadLyricsButtonClicked();
}