/*
    <one line to give the program's name and a brief idea of what it does.>
    Copyright (C) 2011  <copyright holder> <maurobender@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef TITLEBAR_H
#define TITLEBAR_H

#include <QGraphicsWidget>
#include <QGraphicsLinearLayout>
#include <QGraphicsGridLayout>
#include <Plasma/Label>
#include <Plasma/IconWidget>

class TitleBar : public QGraphicsWidget {
	Q_OBJECT
	
public:
	TitleBar(QGraphicsItem * = 0, Qt::WindowFlags = 0);
	virtual ~TitleBar();
	
signals:
	void reloadLyricsButtonClicked();
	void configurationButtonClicked();
	
private slots:
	void reloadLyricsButton_slot();
	void configurationButton_slot();
	
private:
	QGraphicsGridLayout *m_layout;
	
	Plasma::Label *m_title;
	Plasma::IconWidget *m_reload;
	Plasma::IconWidget *m_config;
};

#endif // TITLEBAR_H
