/*
 * Copyright 2011 Joakim Sindholt <opensource@zhasha.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE. */

/*** THIS FILE IS AUTOGENERATED. DO NOT MODIFY MANUALLY. ***/

#ifndef _D3D9_H_
#define _D3D9_H_

#include "d3d9types.h"
#include "d3d9caps.h"

typedef struct IDirect3D9 IDirect3D9, *PDIRECT3D9, *LPDIRECT3D9;
typedef struct IDirect3D9Ex IDirect3D9Ex, *PDIRECT3D9EX, *LPDIRECT3D9EX;
typedef struct IDirect3D9ExOverlayExtension IDirect3D9ExOverlayExtension, *PDIRECT3D9EXOVERLAYEXTENSION, *LPDIRECT3D9EXOVERLAYEXTENSION;
typedef struct IDirect3DAuthenticatedChannel9 IDirect3DAuthenticatedChannel9, *PDIRECT3DAUTHENTICATEDCHANNEL9, *LPDIRECT3DAUTHENTICATEDCHANNEL9;
typedef struct IDirect3DBaseTexture9 IDirect3DBaseTexture9, *PDIRECT3DBASETEXTURE9, *LPDIRECT3DBASETEXTURE9;
typedef struct IDirect3DCryptoSession9 IDirect3DCryptoSession9, *PDIRECT3DCRYPTOSESSION9, *LPDIRECT3DCRYPTOSESSION9;
typedef struct IDirect3DCubeTexture9 IDirect3DCubeTexture9, *PDIRECT3DCUBETEXTURE9, *LPDIRECT3DCUBETEXTURE9;
typedef struct IDirect3DDevice9 IDirect3DDevice9, *PDIRECT3DDEVICE9, *LPDIRECT3DDEVICE9;
typedef struct IDirect3DDevice9Ex IDirect3DDevice9Ex, *PDIRECT3DDEVICE9EX, *LPDIRECT3DDEVICE9EX;
typedef struct IDirect3DDevice9Video IDirect3DDevice9Video, *PDIRECT3DDEVICE9VIDEO, *LPDIRECT3DDEVICE9VIDEO;
typedef struct IDirect3DIndexBuffer9 IDirect3DIndexBuffer9, *PDIRECT3DINDEXBUFFER9, *LPDIRECT3DINDEXBUFFER9;
typedef struct IDirect3DPixelShader9 IDirect3DPixelShader9, *PDIRECT3DPIXELSHADER9, *LPDIRECT3DPIXELSHADER9;
typedef struct IDirect3DQuery9 IDirect3DQuery9, *PDIRECT3DQUERY9, *LPDIRECT3DQUERY9;
typedef struct IDirect3DResource9 IDirect3DResource9, *PDIRECT3DRESOURCE9, *LPDIRECT3DRESOURCE9;
typedef struct IDirect3DStateBlock9 IDirect3DStateBlock9, *PDIRECT3DSTATEBLOCK9, *LPDIRECT3DSTATEBLOCK9;
typedef struct IDirect3DSurface9 IDirect3DSurface9, *PDIRECT3DSURFACE9, *LPDIRECT3DSURFACE9;
typedef struct IDirect3DSwapChain9 IDirect3DSwapChain9, *PDIRECT3DSWAPCHAIN9, *LPDIRECT3DSWAPCHAIN9;
typedef struct IDirect3DSwapChain9Ex IDirect3DSwapChain9Ex, *PDIRECT3DSWAPCHAIN9EX, *LPDIRECT3DSWAPCHAIN9EX;
typedef struct IDirect3DTexture9 IDirect3DTexture9, *PDIRECT3DTEXTURE9, *LPDIRECT3DTEXTURE9;
typedef struct IDirect3DVertexBuffer9 IDirect3DVertexBuffer9, *PDIRECT3DVERTEXBUFFER9, *LPDIRECT3DVERTEXBUFFER9;
typedef struct IDirect3DVertexDeclaration9 IDirect3DVertexDeclaration9, *PDIRECT3DVERTEXDECLARATION9, *LPDIRECT3DVERTEXDECLARATION9;
typedef struct IDirect3DVertexShader9 IDirect3DVertexShader9, *PDIRECT3DVERTEXSHADER9, *LPDIRECT3DVERTEXSHADER9;
typedef struct IDirect3DVolume9 IDirect3DVolume9, *PDIRECT3DVOLUME9, *LPDIRECT3DVOLUME9;
typedef struct IDirect3DVolumeTexture9 IDirect3DVolumeTexture9, *PDIRECT3DVOLUMETEXTURE9, *LPDIRECT3DVOLUMETEXTURE9;

#ifdef __cplusplus

extern "C" const GUID IID_IDirect3D9;
extern "C" const GUID IID_IDirect3D9Ex;
extern "C" const GUID IID_IDirect3D9ExOverlayExtension;
extern "C" const GUID IID_IDirect3DAuthenticatedChannel9;
extern "C" const GUID IID_IDirect3DBaseTexture9;
extern "C" const GUID IID_IDirect3DCryptoSession9;
extern "C" const GUID IID_IDirect3DCubeTexture9;
extern "C" const GUID IID_IDirect3DDevice9;
extern "C" const GUID IID_IDirect3DDevice9Ex;
extern "C" const GUID IID_IDirect3DDevice9Video;
extern "C" const GUID IID_IDirect3DIndexBuffer9;
extern "C" const GUID IID_IDirect3DPixelShader9;
extern "C" const GUID IID_IDirect3DQuery9;
extern "C" const GUID IID_IDirect3DResource9;
extern "C" const GUID IID_IDirect3DStateBlock9;
extern "C" const GUID IID_IDirect3DSurface9;
extern "C" const GUID IID_IDirect3DSwapChain9;
extern "C" const GUID IID_IDirect3DSwapChain9Ex;
extern "C" const GUID IID_IDirect3DTexture9;
extern "C" const GUID IID_IDirect3DVertexBuffer9;
extern "C" const GUID IID_IDirect3DVertexDeclaration9;
extern "C" const GUID IID_IDirect3DVertexShader9;
extern "C" const GUID IID_IDirect3DVolume9;
extern "C" const GUID IID_IDirect3DVolumeTexture9;

struct IDirect3D9 : public IUnknown
{
	virtual HRESULT WINAPI RegisterSoftwareDevice(void *pInitializeFunction) = 0;
	virtual UINT WINAPI GetAdapterCount() = 0;
	virtual HRESULT WINAPI GetAdapterIdentifier(UINT Adapter, DWORD Flags, D3DADAPTER_IDENTIFIER9 *pIdentifier) = 0;
	virtual UINT WINAPI GetAdapterModeCount(UINT Adapter, D3DFORMAT Format) = 0;
	virtual HRESULT WINAPI EnumAdapterModes(UINT Adapter, D3DFORMAT Format, UINT Mode, D3DDISPLAYMODE *pMode) = 0;
	virtual HRESULT WINAPI GetAdapterDisplayMode(UINT Adapter, D3DDISPLAYMODE *pMode) = 0;
	virtual HRESULT WINAPI CheckDeviceType(UINT Adapter, D3DDEVTYPE DevType, D3DFORMAT AdapterFormat, D3DFORMAT BackBufferFormat, BOOL bWindowed) = 0;
	virtual HRESULT WINAPI CheckDeviceFormat(UINT Adapter, D3DDEVTYPE DeviceType, D3DFORMAT AdapterFormat, DWORD Usage, D3DRESOURCETYPE RType, D3DFORMAT CheckFormat) = 0;
	virtual HRESULT WINAPI CheckDeviceMultiSampleType(UINT Adapter, D3DDEVTYPE DeviceType, D3DFORMAT SurfaceFormat, BOOL Windowed, D3DMULTISAMPLE_TYPE MultiSampleType, DWORD *pQualityLevels) = 0;
	virtual HRESULT WINAPI CheckDepthStencilMatch(UINT Adapter, D3DDEVTYPE DeviceType, D3DFORMAT AdapterFormat, D3DFORMAT RenderTargetFormat, D3DFORMAT DepthStencilFormat) = 0;
	virtual HRESULT WINAPI CheckDeviceFormatConversion(UINT Adapter, D3DDEVTYPE DeviceType, D3DFORMAT SourceFormat, D3DFORMAT TargetFormat) = 0;
	virtual HRESULT WINAPI GetDeviceCaps(UINT Adapter, D3DDEVTYPE DeviceType, D3DCAPS9 *pCaps) = 0;
	virtual HMONITOR WINAPI GetAdapterMonitor(UINT Adapter) = 0;
	virtual HRESULT WINAPI CreateDevice(UINT Adapter, D3DDEVTYPE DeviceType, HWND hFocusWindow, DWORD BehaviorFlags, D3DPRESENT_PARAMETERS *pPresentationParameters, IDirect3DDevice9 **ppReturnedDeviceInterface) = 0;
};

struct IDirect3D9Ex : public IDirect3D9
{
	virtual UINT WINAPI GetAdapterModeCountEx(UINT Adapter, const D3DDISPLAYMODEFILTER *pFilter) = 0;
	virtual HRESULT WINAPI EnumAdapterModesEx(UINT Adapter, const D3DDISPLAYMODEFILTER *pFilter, UINT Mode, D3DDISPLAYMODEEX *pMode) = 0;
	virtual HRESULT WINAPI GetAdapterDisplayModeEx(UINT Adapter, D3DDISPLAYMODEEX *pMode, D3DDISPLAYROTATION *pRotation) = 0;
	virtual HRESULT WINAPI CreateDeviceEx(UINT Adapter, D3DDEVTYPE DeviceType, HWND hFocusWindow, DWORD BehaviorFlags, D3DPRESENT_PARAMETERS *pPresentationParameters, D3DDISPLAYMODEEX *pFullscreenDisplayMode, IDirect3DDevice9Ex **ppReturnedDeviceInterface) = 0;
	virtual HRESULT WINAPI GetAdapterLUID(UINT Adapter, LUID *pLUID) = 0;
};

struct IDirect3D9ExOverlayExtension : public IUnknown
{
	virtual HRESULT WINAPI CheckDeviceOverlayType(UINT Adapter, D3DDEVTYPE DevType, UINT OverlayWidth, UINT OverlayHeight, D3DFORMAT OverlayFormat, D3DDISPLAYMODEEX *pDisplayMode, D3DDISPLAYROTATION DisplayRotation, D3DOVERLAYCAPS *pOverlayCaps) = 0;
};

struct IDirect3DResource9 : public IUnknown
{
	virtual HRESULT WINAPI GetDevice(IDirect3DDevice9 **ppDevice) = 0;
	virtual HRESULT WINAPI SetPrivateData(REFGUID refguid, const void *pData, DWORD SizeOfData, DWORD Flags) = 0;
	virtual HRESULT WINAPI GetPrivateData(REFGUID refguid, void *pData, DWORD *pSizeOfData) = 0;
	virtual HRESULT WINAPI FreePrivateData(REFGUID refguid) = 0;
	virtual DWORD WINAPI SetPriority(DWORD PriorityNew) = 0;
	virtual DWORD WINAPI GetPriority() = 0;
	virtual void WINAPI PreLoad() = 0;
	virtual D3DRESOURCETYPE WINAPI GetType() = 0;
};

struct IDirect3DBaseTexture9 : public IDirect3DResource9
{
	virtual DWORD WINAPI SetLOD(DWORD LODNew) = 0;
	virtual DWORD WINAPI GetLOD() = 0;
	virtual DWORD WINAPI GetLevelCount() = 0;
	virtual HRESULT WINAPI SetAutoGenFilterType(D3DTEXTUREFILTERTYPE FilterType) = 0;
	virtual D3DTEXTUREFILTERTYPE WINAPI GetAutoGenFilterType() = 0;
	virtual void WINAPI GenerateMipSubLevels() = 0;
};

struct IDirect3DCryptoSession9 : public IUnknown
{
	virtual HRESULT WINAPI GetCertificateSize(UINT *pCertificateSize) = 0;
	virtual HRESULT WINAPI GetCertificate(UINT CertifacteSize, BYTE *ppCertificate) = 0;
	virtual HRESULT WINAPI NegotiateKeyExchange(UINT DataSize, void *pData) = 0;
	virtual HRESULT WINAPI EncryptionBlt(IDirect3DSurface9 *pSrcSurface, IDirect3DSurface9 *pDstSurface, UINT DstSurfaceSize, void *pIV) = 0;
	virtual HRESULT WINAPI DecryptionBlt(IDirect3DSurface9 *pSrcSurface, IDirect3DSurface9 *pDstSurface, UINT SrcSurfaceSize, D3DENCRYPTED_BLOCK_INFO *pEncryptedBlockInfo, void *pContentKey, void *pIV) = 0;
	virtual HRESULT WINAPI GetSurfacePitch(IDirect3DSurface9 *pSrcSurface, UINT *pSurfacePitch) = 0;
	virtual HRESULT WINAPI StartSessionKeyRefresh(void *pRandomNumber, UINT RandomNumberSize) = 0;
	virtual HRESULT WINAPI FinishSessionKeyRefresh() = 0;
	virtual HRESULT WINAPI GetEncryptionBltKey(void *pReadbackKey, UINT KeySize) = 0;
};

struct IDirect3DCubeTexture9 : public IDirect3DBaseTexture9
{
	virtual HRESULT WINAPI GetLevelDesc(UINT Level, D3DSURFACE_DESC *pDesc) = 0;
	virtual HRESULT WINAPI GetCubeMapSurface(D3DCUBEMAP_FACES FaceType, UINT Level, IDirect3DSurface9 **ppCubeMapSurface) = 0;
	virtual HRESULT WINAPI LockRect(D3DCUBEMAP_FACES FaceType, UINT Level, D3DLOCKED_RECT *pLockedRect, const RECT *pRect, DWORD Flags) = 0;
	virtual HRESULT WINAPI UnlockRect(D3DCUBEMAP_FACES FaceType, UINT Level) = 0;
	virtual HRESULT WINAPI AddDirtyRect(D3DCUBEMAP_FACES FaceType, const RECT *pDirtyRect) = 0;
};

struct IDirect3DDevice9 : public IUnknown
{
	virtual HRESULT WINAPI TestCooperativeLevel() = 0;
	virtual UINT WINAPI GetAvailableTextureMem() = 0;
	virtual HRESULT WINAPI EvictManagedResources() = 0;
	virtual HRESULT WINAPI GetDirect3D(IDirect3D9 **ppD3D9) = 0;
	virtual HRESULT WINAPI GetDeviceCaps(D3DCAPS9 *pCaps) = 0;
	virtual HRESULT WINAPI GetDisplayMode(UINT iSwapChain, D3DDISPLAYMODE *pMode) = 0;
	virtual HRESULT WINAPI GetCreationParameters(D3DDEVICE_CREATION_PARAMETERS *pParameters) = 0;
	virtual HRESULT WINAPI SetCursorProperties(UINT XHotSpot, UINT YHotSpot, IDirect3DSurface9 *pCursorBitmap) = 0;
	virtual void WINAPI SetCursorPosition(int X, int Y, DWORD Flags) = 0;
	virtual BOOL WINAPI ShowCursor(BOOL bShow) = 0;
	virtual HRESULT WINAPI CreateAdditionalSwapChain(D3DPRESENT_PARAMETERS *pPresentationParameters, IDirect3DSwapChain9 **pSwapChain) = 0;
	virtual HRESULT WINAPI GetSwapChain(UINT iSwapChain, IDirect3DSwapChain9 **pSwapChain) = 0;
	virtual UINT WINAPI GetNumberOfSwapChains() = 0;
	virtual HRESULT WINAPI Reset(D3DPRESENT_PARAMETERS *pPresentationParameters) = 0;
	virtual HRESULT WINAPI Present(const RECT *pSourceRect, const RECT *pDestRect, HWND hDestWindowOverride, const RGNDATA *pDirtyRegion) = 0;
	virtual HRESULT WINAPI GetBackBuffer(UINT iSwapChain, UINT iBackBuffer, D3DBACKBUFFER_TYPE Type, IDirect3DSurface9 **ppBackBuffer) = 0;
	virtual HRESULT WINAPI GetRasterStatus(UINT iSwapChain, D3DRASTER_STATUS *pRasterStatus) = 0;
	virtual HRESULT WINAPI SetDialogBoxMode(BOOL bEnableDialogs) = 0;
	virtual void WINAPI SetGammaRamp(UINT iSwapChain, DWORD Flags, const D3DGAMMARAMP *pRamp) = 0;
	virtual void WINAPI GetGammaRamp(UINT iSwapChain, D3DGAMMARAMP *pRamp) = 0;
	virtual HRESULT WINAPI CreateTexture(UINT Width, UINT Height, UINT Levels, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool, IDirect3DTexture9 **ppTexture, HANDLE *pSharedHandle) = 0;
	virtual HRESULT WINAPI CreateVolumeTexture(UINT Width, UINT Height, UINT Depth, UINT Levels, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool, IDirect3DVolumeTexture9 **ppVolumeTexture, HANDLE *pSharedHandle) = 0;
	virtual HRESULT WINAPI CreateCubeTexture(UINT EdgeLength, UINT Levels, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool, IDirect3DCubeTexture9 **ppCubeTexture, HANDLE *pSharedHandle) = 0;
	virtual HRESULT WINAPI CreateVertexBuffer(UINT Length, DWORD Usage, DWORD FVF, D3DPOOL Pool, IDirect3DVertexBuffer9 **ppVertexBuffer, HANDLE *pSharedHandle) = 0;
	virtual HRESULT WINAPI CreateIndexBuffer(UINT Length, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool, IDirect3DIndexBuffer9 **ppIndexBuffer, HANDLE *pSharedHandle) = 0;
	virtual HRESULT WINAPI CreateRenderTarget(UINT Width, UINT Height, D3DFORMAT Format, D3DMULTISAMPLE_TYPE MultiSample, DWORD MultisampleQuality, BOOL Lockable, IDirect3DSurface9 **ppSurface, HANDLE *pSharedHandle) = 0;
	virtual HRESULT WINAPI CreateDepthStencilSurface(UINT Width, UINT Height, D3DFORMAT Format, D3DMULTISAMPLE_TYPE MultiSample, DWORD MultisampleQuality, BOOL Discard, IDirect3DSurface9 **ppSurface, HANDLE *pSharedHandle) = 0;
	virtual HRESULT WINAPI UpdateSurface(IDirect3DSurface9 *pSourceSurface, const RECT *pSourceRect, IDirect3DSurface9 *pDestinationSurface, const POINT *pDestPoint) = 0;
	virtual HRESULT WINAPI UpdateTexture(IDirect3DBaseTexture9 *pSourceTexture, IDirect3DBaseTexture9 *pDestinationTexture) = 0;
	virtual HRESULT WINAPI GetRenderTargetData(IDirect3DSurface9 *pRenderTarget, IDirect3DSurface9 *pDestSurface) = 0;
	virtual HRESULT WINAPI GetFrontBufferData(UINT iSwapChain, IDirect3DSurface9 *pDestSurface) = 0;
	virtual HRESULT WINAPI StretchRect(IDirect3DSurface9 *pSourceSurface, const RECT *pSourceRect, IDirect3DSurface9 *pDestSurface, const RECT *pDestRect, D3DTEXTUREFILTERTYPE Filter) = 0;
	virtual HRESULT WINAPI ColorFill(IDirect3DSurface9 *pSurface, const RECT *pRect, D3DCOLOR color) = 0;
	virtual HRESULT WINAPI CreateOffscreenPlainSurface(UINT Width, UINT Height, D3DFORMAT Format, D3DPOOL Pool, IDirect3DSurface9 **ppSurface, HANDLE *pSharedHandle) = 0;
	virtual HRESULT WINAPI SetRenderTarget(DWORD RenderTargetIndex, IDirect3DSurface9 *pRenderTarget) = 0;
	virtual HRESULT WINAPI GetRenderTarget(DWORD RenderTargetIndex, IDirect3DSurface9 **ppRenderTarget) = 0;
	virtual HRESULT WINAPI SetDepthStencilSurface(IDirect3DSurface9 *pNewZStencil) = 0;
	virtual HRESULT WINAPI GetDepthStencilSurface(IDirect3DSurface9 **ppZStencilSurface) = 0;
	virtual HRESULT WINAPI BeginScene() = 0;
	virtual HRESULT WINAPI EndScene() = 0;
	virtual HRESULT WINAPI Clear(DWORD Count, const D3DRECT *pRects, DWORD Flags, D3DCOLOR Color, float Z, DWORD Stencil) = 0;
	virtual HRESULT WINAPI SetTransform(D3DTRANSFORMSTATETYPE State, const D3DMATRIX *pMatrix) = 0;
	virtual HRESULT WINAPI GetTransform(D3DTRANSFORMSTATETYPE State, D3DMATRIX *pMatrix) = 0;
	virtual HRESULT WINAPI MultiplyTransform(D3DTRANSFORMSTATETYPE State, const D3DMATRIX *pMatrix) = 0;
	virtual HRESULT WINAPI SetViewport(const D3DVIEWPORT9 *pViewport) = 0;
	virtual HRESULT WINAPI GetViewport(D3DVIEWPORT9 *pViewport) = 0;
	virtual HRESULT WINAPI SetMaterial(const D3DMATERIAL9 *pMaterial) = 0;
	virtual HRESULT WINAPI GetMaterial(D3DMATERIAL9 *pMaterial) = 0;
	virtual HRESULT WINAPI SetLight(DWORD Index, const D3DLIGHT9 *pLight) = 0;
	virtual HRESULT WINAPI GetLight(DWORD Index, D3DLIGHT9 *pLight) = 0;
	virtual HRESULT WINAPI LightEnable(DWORD Index, BOOL Enable) = 0;
	virtual HRESULT WINAPI GetLightEnable(DWORD Index, BOOL *pEnable) = 0;
	virtual HRESULT WINAPI SetClipPlane(DWORD Index, const float *pPlane) = 0;
	virtual HRESULT WINAPI GetClipPlane(DWORD Index, float *pPlane) = 0;
	virtual HRESULT WINAPI SetRenderState(D3DRENDERSTATETYPE State, DWORD Value) = 0;
	virtual HRESULT WINAPI GetRenderState(D3DRENDERSTATETYPE State, DWORD *pValue) = 0;
	virtual HRESULT WINAPI CreateStateBlock(D3DSTATEBLOCKTYPE Type, IDirect3DStateBlock9 **ppSB) = 0;
	virtual HRESULT WINAPI BeginStateBlock() = 0;
	virtual HRESULT WINAPI EndStateBlock(IDirect3DStateBlock9 **ppSB) = 0;
	virtual HRESULT WINAPI SetClipStatus(const D3DCLIPSTATUS9 *pClipStatus) = 0;
	virtual HRESULT WINAPI GetClipStatus(D3DCLIPSTATUS9 *pClipStatus) = 0;
	virtual HRESULT WINAPI GetTexture(DWORD Stage, IDirect3DBaseTexture9 **ppTexture) = 0;
	virtual HRESULT WINAPI SetTexture(DWORD Stage, IDirect3DBaseTexture9 *pTexture) = 0;
	virtual HRESULT WINAPI GetTextureStageState(DWORD Stage, D3DTEXTURESTAGESTATETYPE Type, DWORD *pValue) = 0;
	virtual HRESULT WINAPI SetTextureStageState(DWORD Stage, D3DTEXTURESTAGESTATETYPE Type, DWORD Value) = 0;
	virtual HRESULT WINAPI GetSamplerState(DWORD Sampler, D3DSAMPLERSTATETYPE Type, DWORD *pValue) = 0;
	virtual HRESULT WINAPI SetSamplerState(DWORD Sampler, D3DSAMPLERSTATETYPE Type, DWORD Value) = 0;
	virtual HRESULT WINAPI ValidateDevice(DWORD *pNumPasses) = 0;
	virtual HRESULT WINAPI SetPaletteEntries(UINT PaletteNumber, const PALETTEENTRY *pEntries) = 0;
	virtual HRESULT WINAPI GetPaletteEntries(UINT PaletteNumber, PALETTEENTRY *pEntries) = 0;
	virtual HRESULT WINAPI SetCurrentTexturePalette(UINT PaletteNumber) = 0;
	virtual HRESULT WINAPI GetCurrentTexturePalette(UINT *PaletteNumber) = 0;
	virtual HRESULT WINAPI SetScissorRect(const RECT *pRect) = 0;
	virtual HRESULT WINAPI GetScissorRect(RECT *pRect) = 0;
	virtual HRESULT WINAPI SetSoftwareVertexProcessing(BOOL bSoftware) = 0;
	virtual BOOL WINAPI GetSoftwareVertexProcessing() = 0;
	virtual HRESULT WINAPI SetNPatchMode(float nSegments) = 0;
	virtual float WINAPI GetNPatchMode() = 0;
	virtual HRESULT WINAPI DrawPrimitive(D3DPRIMITIVETYPE PrimitiveType, UINT StartVertex, UINT PrimitiveCount) = 0;
	virtual HRESULT WINAPI DrawIndexedPrimitive(D3DPRIMITIVETYPE PrimitiveType, INT BaseVertexIndex, UINT MinVertexIndex, UINT NumVertices, UINT startIndex, UINT primCount) = 0;
	virtual HRESULT WINAPI DrawPrimitiveUP(D3DPRIMITIVETYPE PrimitiveType, UINT PrimitiveCount, const void *pVertexStreamZeroData, UINT VertexStreamZeroStride) = 0;
	virtual HRESULT WINAPI DrawIndexedPrimitiveUP(D3DPRIMITIVETYPE PrimitiveType, UINT MinVertexIndex, UINT NumVertices, UINT PrimitiveCount, const void *pIndexData, D3DFORMAT IndexDataFormat, const void *pVertexStreamZeroData, UINT VertexStreamZeroStride) = 0;
	virtual HRESULT WINAPI ProcessVertices(UINT SrcStartIndex, UINT DestIndex, UINT VertexCount, IDirect3DVertexBuffer9 *pDestBuffer, IDirect3DVertexDeclaration9 *pVertexDecl, DWORD Flags) = 0;
	virtual HRESULT WINAPI CreateVertexDeclaration(const D3DVERTEXELEMENT9 *pVertexElements, IDirect3DVertexDeclaration9 **ppDecl) = 0;
	virtual HRESULT WINAPI SetVertexDeclaration(IDirect3DVertexDeclaration9 *pDecl) = 0;
	virtual HRESULT WINAPI GetVertexDeclaration(IDirect3DVertexDeclaration9 **ppDecl) = 0;
	virtual HRESULT WINAPI SetFVF(DWORD FVF) = 0;
	virtual HRESULT WINAPI GetFVF(DWORD *pFVF) = 0;
	virtual HRESULT WINAPI CreateVertexShader(const DWORD *pFunction, IDirect3DVertexShader9 **ppShader) = 0;
	virtual HRESULT WINAPI SetVertexShader(IDirect3DVertexShader9 *pShader) = 0;
	virtual HRESULT WINAPI GetVertexShader(IDirect3DVertexShader9 **ppShader) = 0;
	virtual HRESULT WINAPI SetVertexShaderConstantF(UINT StartRegister, const float *pConstantData, UINT Vector4fCount) = 0;
	virtual HRESULT WINAPI GetVertexShaderConstantF(UINT StartRegister, float *pConstantData, UINT Vector4fCount) = 0;
	virtual HRESULT WINAPI SetVertexShaderConstantI(UINT StartRegister, const int *pConstantData, UINT Vector4iCount) = 0;
	virtual HRESULT WINAPI GetVertexShaderConstantI(UINT StartRegister, int *pConstantData, UINT Vector4iCount) = 0;
	virtual HRESULT WINAPI SetVertexShaderConstantB(UINT StartRegister, const BOOL *pConstantData, UINT BoolCount) = 0;
	virtual HRESULT WINAPI GetVertexShaderConstantB(UINT StartRegister, BOOL *pConstantData, UINT BoolCount) = 0;
	virtual HRESULT WINAPI SetStreamSource(UINT StreamNumber, IDirect3DVertexBuffer9 *pStreamData, UINT OffsetInBytes, UINT Stride) = 0;
	virtual HRESULT WINAPI GetStreamSource(UINT StreamNumber, IDirect3DVertexBuffer9 **ppStreamData, UINT *pOffsetInBytes, UINT *pStride) = 0;
	virtual HRESULT WINAPI SetStreamSourceFreq(UINT StreamNumber, UINT Setting) = 0;
	virtual HRESULT WINAPI GetStreamSourceFreq(UINT StreamNumber, UINT *pSetting) = 0;
	virtual HRESULT WINAPI SetIndices(IDirect3DIndexBuffer9 *pIndexData) = 0;
	virtual HRESULT WINAPI GetIndices(IDirect3DIndexBuffer9 **ppIndexData) = 0;
	virtual HRESULT WINAPI CreatePixelShader(const DWORD *pFunction, IDirect3DPixelShader9 **ppShader) = 0;
	virtual HRESULT WINAPI SetPixelShader(IDirect3DPixelShader9 *pShader) = 0;
	virtual HRESULT WINAPI GetPixelShader(IDirect3DPixelShader9 **ppShader) = 0;
	virtual HRESULT WINAPI SetPixelShaderConstantF(UINT StartRegister, const float *pConstantData, UINT Vector4fCount) = 0;
	virtual HRESULT WINAPI GetPixelShaderConstantF(UINT StartRegister, float *pConstantData, UINT Vector4fCount) = 0;
	virtual HRESULT WINAPI SetPixelShaderConstantI(UINT StartRegister, const int *pConstantData, UINT Vector4iCount) = 0;
	virtual HRESULT WINAPI GetPixelShaderConstantI(UINT StartRegister, int *pConstantData, UINT Vector4iCount) = 0;
	virtual HRESULT WINAPI SetPixelShaderConstantB(UINT StartRegister, const BOOL *pConstantData, UINT BoolCount) = 0;
	virtual HRESULT WINAPI GetPixelShaderConstantB(UINT StartRegister, BOOL *pConstantData, UINT BoolCount) = 0;
	virtual HRESULT WINAPI DrawRectPatch(UINT Handle, const float *pNumSegs, const D3DRECTPATCH_INFO *pRectPatchInfo) = 0;
	virtual HRESULT WINAPI DrawTriPatch(UINT Handle, const float *pNumSegs, const D3DTRIPATCH_INFO *pTriPatchInfo) = 0;
	virtual HRESULT WINAPI DeletePatch(UINT Handle) = 0;
	virtual HRESULT WINAPI CreateQuery(D3DQUERYTYPE Type, IDirect3DQuery9 **ppQuery) = 0;
};

struct IDirect3DDevice9Ex : public IDirect3DDevice9
{
	virtual HRESULT WINAPI SetConvolutionMonoKernel(UINT width, UINT height, float *rows, float *columns) = 0;
	virtual HRESULT WINAPI ComposeRects(IDirect3DSurface9 *pSrc, IDirect3DSurface9 *pDst, IDirect3DVertexBuffer9 *pSrcRectDescs, UINT NumRects, IDirect3DVertexBuffer9 *pDstRectDescs, D3DCOMPOSERECTSOP Operation, int Xoffset, int Yoffset) = 0;
	virtual HRESULT WINAPI PresentEx(const RECT *pSourceRect, const RECT *pDestRect, HWND hDestWindowOverride, const RGNDATA *pDirtyRegion, DWORD dwFlags) = 0;
	virtual HRESULT WINAPI GetGPUThreadPriority(INT *pPriority) = 0;
	virtual HRESULT WINAPI SetGPUThreadPriority(INT Priority) = 0;
	virtual HRESULT WINAPI WaitForVBlank(UINT iSwapChain) = 0;
	virtual HRESULT WINAPI CheckResourceResidency(IDirect3DResource9 **pResourceArray, UINT32 NumResources) = 0;
	virtual HRESULT WINAPI SetMaximumFrameLatency(UINT MaxLatency) = 0;
	virtual HRESULT WINAPI GetMaximumFrameLatency(UINT *pMaxLatency) = 0;
	virtual HRESULT WINAPI CheckDeviceState(HWND hDestinationWindow) = 0;
	virtual HRESULT WINAPI CreateRenderTargetEx(UINT Width, UINT Height, D3DFORMAT Format, D3DMULTISAMPLE_TYPE MultiSample, DWORD MultisampleQuality, BOOL Lockable, IDirect3DSurface9 **ppSurface, HANDLE *pSharedHandle, DWORD Usage) = 0;
	virtual HRESULT WINAPI CreateOffscreenPlainSurfaceEx(UINT Width, UINT Height, D3DFORMAT Format, D3DPOOL Pool, IDirect3DSurface9 **ppSurface, HANDLE *pSharedHandle, DWORD Usage) = 0;
	virtual HRESULT WINAPI CreateDepthStencilSurfaceEx(UINT Width, UINT Height, D3DFORMAT Format, D3DMULTISAMPLE_TYPE MultiSample, DWORD MultisampleQuality, BOOL Discard, IDirect3DSurface9 **ppSurface, HANDLE *pSharedHandle, DWORD Usage) = 0;
	virtual HRESULT WINAPI ResetEx(D3DPRESENT_PARAMETERS *pPresentationParameters, D3DDISPLAYMODEEX *pFullscreenDisplayMode) = 0;
	virtual HRESULT WINAPI GetDisplayModeEx(UINT iSwapChain, D3DDISPLAYMODEEX *pMode, D3DDISPLAYROTATION *pRotation) = 0;
};

struct IDirect3DDevice9Video : public IUnknown
{
	virtual HRESULT WINAPI GetContentProtectionCaps(const GUID *pCryptoType, const GUID *pDecodeProfile, D3DCONTENTPROTECTIONCAPS *pCaps) = 0;
	virtual HRESULT WINAPI CreateAuthenticatedChannel(D3DAUTHENTICATEDCHANNELTYPE ChannelType, IDirect3DAuthenticatedChannel9 **ppAuthenticatedChannel, HANDLE *pChannelHandle) = 0;
	virtual HRESULT WINAPI CreateCryptoSession(const GUID *pCryptoType, const GUID *pDecodeProfile, IDirect3DCryptoSession9 **ppCryptoSession, HANDLE *pCryptoHandle) = 0;
};

struct IDirect3DIndexBuffer9 : public IDirect3DResource9
{
	virtual HRESULT WINAPI Lock(UINT OffsetToLock, UINT SizeToLock, void **ppbData, DWORD Flags) = 0;
	virtual HRESULT WINAPI Unlock() = 0;
	virtual HRESULT WINAPI GetDesc(D3DINDEXBUFFER_DESC *pDesc) = 0;
};

struct IDirect3DPixelShader9 : public IUnknown
{
	virtual HRESULT WINAPI GetDevice(IDirect3DDevice9 **ppDevice) = 0;
	virtual HRESULT WINAPI GetFunction(void *pData, UINT *pSizeOfData) = 0;
};

struct IDirect3DQuery9 : public IUnknown
{
	virtual HRESULT WINAPI GetDevice(IDirect3DDevice9 **ppDevice) = 0;
	virtual D3DQUERYTYPE WINAPI GetType() = 0;
	virtual DWORD WINAPI GetDataSize() = 0;
	virtual HRESULT WINAPI Issue(DWORD dwIssueFlags) = 0;
	virtual HRESULT WINAPI GetData(void *pData, DWORD dwSize, DWORD dwGetDataFlags) = 0;
};

struct IDirect3DStateBlock9 : public IUnknown
{
	virtual HRESULT WINAPI GetDevice(IDirect3DDevice9 **ppDevice) = 0;
	virtual HRESULT WINAPI Capture() = 0;
	virtual HRESULT WINAPI Apply() = 0;
};

struct IDirect3DSurface9 : public IDirect3DResource9
{
	virtual HRESULT WINAPI GetContainer(REFIID riid, void **ppContainer) = 0;
	virtual HRESULT WINAPI GetDesc(D3DSURFACE_DESC *pDesc) = 0;
	virtual HRESULT WINAPI LockRect(D3DLOCKED_RECT *pLockedRect, const RECT *pRect, DWORD Flags) = 0;
	virtual HRESULT WINAPI UnlockRect() = 0;
	virtual HRESULT WINAPI GetDC(HDC *phdc) = 0;
	virtual HRESULT WINAPI ReleaseDC(HDC hdc) = 0;
};

struct IDirect3DSwapChain9 : public IUnknown
{
	virtual HRESULT WINAPI Present(const RECT *pSourceRect, const RECT *pDestRect, HWND hDestWindowOverride, const RGNDATA *pDirtyRegion, DWORD dwFlags) = 0;
	virtual HRESULT WINAPI GetFrontBufferData(IDirect3DSurface9 *pDestSurface) = 0;
	virtual HRESULT WINAPI GetBackBuffer(UINT iBackBuffer, D3DBACKBUFFER_TYPE Type, IDirect3DSurface9 **ppBackBuffer) = 0;
	virtual HRESULT WINAPI GetRasterStatus(D3DRASTER_STATUS *pRasterStatus) = 0;
	virtual HRESULT WINAPI GetDisplayMode(D3DDISPLAYMODE *pMode) = 0;
	virtual HRESULT WINAPI GetDevice(IDirect3DDevice9 **ppDevice) = 0;
	virtual HRESULT WINAPI GetPresentParameters(D3DPRESENT_PARAMETERS *pPresentationParameters) = 0;
};

struct IDirect3DSwapChain9Ex : public IDirect3DSwapChain9
{
	virtual HRESULT WINAPI GetLastPresentCount(UINT *pLastPresentCount) = 0;
	virtual HRESULT WINAPI GetPresentStats(D3DPRESENTSTATS *pPresentationStatistics) = 0;
	virtual HRESULT WINAPI GetDisplayModeEx(D3DDISPLAYMODEEX *pMode, D3DDISPLAYROTATION *pRotation) = 0;
};

struct IDirect3DTexture9 : public IDirect3DBaseTexture9
{
	virtual HRESULT WINAPI GetLevelDesc(UINT Level, D3DSURFACE_DESC *pDesc) = 0;
	virtual HRESULT WINAPI GetSurfaceLevel(UINT Level, IDirect3DSurface9 **ppSurfaceLevel) = 0;
	virtual HRESULT WINAPI LockRect(UINT Level, D3DLOCKED_RECT *pLockedRect, const RECT *pRect, DWORD Flags) = 0;
	virtual HRESULT WINAPI UnlockRect(UINT Level) = 0;
	virtual HRESULT WINAPI AddDirtyRect(const RECT *pDirtyRect) = 0;
};

struct IDirect3DVertexBuffer9 : public IDirect3DResource9
{
	virtual HRESULT WINAPI Lock(UINT OffsetToLock, UINT SizeToLock, void **ppbData, DWORD Flags) = 0;
	virtual HRESULT WINAPI Unlock() = 0;
	virtual HRESULT WINAPI GetDesc(D3DVERTEXBUFFER_DESC *pDesc) = 0;
};

struct IDirect3DVertexDeclaration9 : public IUnknown
{
	virtual HRESULT WINAPI GetDevice(IDirect3DDevice9 **ppDevice) = 0;
	virtual HRESULT WINAPI GetDeclaration(D3DVERTEXELEMENT9 *pElement, UINT *pNumElements) = 0;
};

struct IDirect3DVertexShader9 : public IUnknown
{
	virtual HRESULT WINAPI GetDevice(IDirect3DDevice9 **ppDevice) = 0;
	virtual HRESULT WINAPI GetFunction(void *pData, UINT *pSizeOfData) = 0;
};

struct IDirect3DVolume9 : public IUnknown
{
	virtual HRESULT WINAPI GetDevice(IDirect3DDevice9 **ppDevice) = 0;
	virtual HRESULT WINAPI SetPrivateData(REFGUID refguid, const void *pData, DWORD SizeOfData, DWORD Flags) = 0;
	virtual HRESULT WINAPI GetPrivateData(REFGUID refguid, void *pData, DWORD *pSizeOfData) = 0;
	virtual HRESULT WINAPI FreePrivateData(REFGUID refguid) = 0;
	virtual HRESULT WINAPI GetContainer(REFIID riid, void **ppContainer) = 0;
	virtual HRESULT WINAPI GetDesc(D3DVOLUME_DESC *pDesc) = 0;
	virtual HRESULT WINAPI LockBox(D3DLOCKED_BOX *pLockedVolume, const D3DBOX *pBox, DWORD Flags) = 0;
	virtual HRESULT WINAPI UnlockBox() = 0;
};

struct IDirect3DVolumeTexture9 : public IDirect3DBaseTexture9
{
    virtual HRESULT WINAPI GetLevelDesc(UINT Level, D3DVOLUME_DESC *pDesc) = 0;
    virtual HRESULT WINAPI GetVolumeLevel(UINT Level, IDirect3DVolume9 **ppVolumeLevel) = 0;
    virtual HRESULT WINAPI LockBox(UINT Level, D3DLOCKED_BOX *pLockedVolume, const D3DBOX *pBox, DWORD Flags) = 0;
    virtual HRESULT WINAPI UnlockBox(UINT Level) = 0;
    virtual HRESULT WINAPI AddDirtyBox(const D3DBOX *pDirtyBox) = 0;
};


#else /* __cplusplus */

extern const GUID IID_IDirect3D9;
extern const GUID IID_IDirect3D9Ex;
extern const GUID IID_IDirect3D9ExOverlayExtension;
extern const GUID IID_IDirect3DAuthenticatedChannel9;
extern const GUID IID_IDirect3DBaseTexture9;
extern const GUID IID_IDirect3DCryptoSession9;
extern const GUID IID_IDirect3DCubeTexture9;
extern const GUID IID_IDirect3DDevice9;
extern const GUID IID_IDirect3DDevice9Ex;
extern const GUID IID_IDirect3DDevice9Video;
extern const GUID IID_IDirect3DIndexBuffer9;
extern const GUID IID_IDirect3DPixelShader9;
extern const GUID IID_IDirect3DQuery9;
extern const GUID IID_IDirect3DResource9;
extern const GUID IID_IDirect3DStateBlock9;
extern const GUID IID_IDirect3DSurface9;
extern const GUID IID_IDirect3DSwapChain9;
extern const GUID IID_IDirect3DSwapChain9Ex;
extern const GUID IID_IDirect3DTexture9;
extern const GUID IID_IDirect3DVertexBuffer9;
extern const GUID IID_IDirect3DVertexDeclaration9;
extern const GUID IID_IDirect3DVertexShader9;
extern const GUID IID_IDirect3DVolume9;
extern const GUID IID_IDirect3DVolumeTexture9;

typedef struct IDirect3D9Vtbl
{
	/* IUnknown */
	HRESULT (WINAPI *QueryInterface)(IDirect3D9 *This, REFIID riid, void **ppvObject);
	ULONG (WINAPI *AddRef)(IDirect3D9 *This);
	ULONG (WINAPI *Release)(IDirect3D9 *This);
	/* IDirect3D9 */
	HRESULT (WINAPI *RegisterSoftwareDevice)(IDirect3D9 *This, void *pInitializeFunction);
	UINT (WINAPI *GetAdapterCount)(IDirect3D9 *This);
	HRESULT (WINAPI *GetAdapterIdentifier)(IDirect3D9 *This, UINT Adapter, DWORD Flags, D3DADAPTER_IDENTIFIER9 *pIdentifier);
	UINT (WINAPI *GetAdapterModeCount)(IDirect3D9 *This, UINT Adapter, D3DFORMAT Format);
	HRESULT (WINAPI *EnumAdapterModes)(IDirect3D9 *This, UINT Adapter, D3DFORMAT Format, UINT Mode, D3DDISPLAYMODE *pMode);
	HRESULT (WINAPI *GetAdapterDisplayMode)(IDirect3D9 *This, UINT Adapter, D3DDISPLAYMODE *pMode);
	HRESULT (WINAPI *CheckDeviceType)(IDirect3D9 *This, UINT Adapter, D3DDEVTYPE DevType, D3DFORMAT AdapterFormat, D3DFORMAT BackBufferFormat, BOOL bWindowed);
	HRESULT (WINAPI *CheckDeviceFormat)(IDirect3D9 *This, UINT Adapter, D3DDEVTYPE DeviceType, D3DFORMAT AdapterFormat, DWORD Usage, D3DRESOURCETYPE RType, D3DFORMAT CheckFormat);
	HRESULT (WINAPI *CheckDeviceMultiSampleType)(IDirect3D9 *This, UINT Adapter, D3DDEVTYPE DeviceType, D3DFORMAT SurfaceFormat, BOOL Windowed, D3DMULTISAMPLE_TYPE MultiSampleType, DWORD *pQualityLevels);
	HRESULT (WINAPI *CheckDepthStencilMatch)(IDirect3D9 *This, UINT Adapter, D3DDEVTYPE DeviceType, D3DFORMAT AdapterFormat, D3DFORMAT RenderTargetFormat, D3DFORMAT DepthStencilFormat);
	HRESULT (WINAPI *CheckDeviceFormatConversion)(IDirect3D9 *This, UINT Adapter, D3DDEVTYPE DeviceType, D3DFORMAT SourceFormat, D3DFORMAT TargetFormat);
	HRESULT (WINAPI *GetDeviceCaps)(IDirect3D9 *This, UINT Adapter, D3DDEVTYPE DeviceType, D3DCAPS9 *pCaps);
	HMONITOR (WINAPI *GetAdapterMonitor)(IDirect3D9 *This, UINT Adapter);
	HRESULT (WINAPI *CreateDevice)(IDirect3D9 *This, UINT Adapter, D3DDEVTYPE DeviceType, HWND hFocusWindow, DWORD BehaviorFlags, D3DPRESENT_PARAMETERS *pPresentationParameters, IDirect3DDevice9 **ppReturnedDeviceInterface);
} IDirect3D9Vtbl;
struct IDirect3D9
{
	IDirect3D9Vtbl *lpVtbl;
};

/* IUnknown macros */
#define IDirect3D9_QueryInterface(p,a,b) (p)->lpVtbl->QueryInterface(p,a,b)
#define IDirect3D9_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirect3D9_Release(p) (p)->lpVtbl->Release(p)
/* IDirect3D9 macros */
#define IDirect3D9_RegisterSoftwareDevice(p,a) (p)->lpVtbl->RegisterSoftwareDevice(p,a)
#define IDirect3D9_GetAdapterCount(p) (p)->lpVtbl->GetAdapterCount(p)
#define IDirect3D9_GetAdapterIdentifier(p,a,b,c) (p)->lpVtbl->GetAdapterIdentifier(p,a,b,c)
#define IDirect3D9_GetAdapterModeCount(p,a,b) (p)->lpVtbl->GetAdapterModeCount(p,a,b)
#define IDirect3D9_EnumAdapterModes(p,a,b,c,d) (p)->lpVtbl->EnumAdapterModes(p,a,b,c,d)
#define IDirect3D9_GetAdapterDisplayMode(p,a,b) (p)->lpVtbl->GetAdapterDisplayMode(p,a,b)
#define IDirect3D9_CheckDeviceType(p,a,b,c,d,e) (p)->lpVtbl->CheckDeviceType(p,a,b,c,d,e)
#define IDirect3D9_CheckDeviceFormat(p,a,b,c,d,e,f) (p)->lpVtbl->CheckDeviceFormat(p,a,b,c,d,e,f)
#define IDirect3D9_CheckDeviceMultiSampleType(p,a,b,c,d,e,f) (p)->lpVtbl->CheckDeviceMultiSampleType(p,a,b,c,d,e,f)
#define IDirect3D9_CheckDepthStencilMatch(p,a,b,c,d,e) (p)->lpVtbl->CheckDepthStencilMatch(p,a,b,c,d,e)
#define IDirect3D9_CheckDeviceFormatConversion(p,a,b,c,d) (p)->lpVtbl->CheckDeviceFormatConversion(p,a,b,c,d)
#define IDirect3D9_GetDeviceCaps(p,a,b,c) (p)->lpVtbl->GetDeviceCaps(p,a,b,c)
#define IDirect3D9_GetAdapterMonitor(p,a) (p)->lpVtbl->GetAdapterMonitor(p,a)
#define IDirect3D9_CreateDevice(p,a,b,c,d,e,f) (p)->lpVtbl->CreateDevice(p,a,b,c,d,e,f)

typedef struct IDirect3D9ExVtbl
{
	/* IUnknown */
	HRESULT (WINAPI *QueryInterface)(IDirect3D9Ex *This, REFIID riid, void **ppvObject);
	ULONG (WINAPI *AddRef)(IDirect3D9Ex *This);
	ULONG (WINAPI *Release)(IDirect3D9Ex *This);
	/* IDirect3D9 */
	HRESULT (WINAPI *RegisterSoftwareDevice)(IDirect3D9Ex *This, void *pInitializeFunction);
	UINT (WINAPI *GetAdapterCount)(IDirect3D9Ex *This);
	HRESULT (WINAPI *GetAdapterIdentifier)(IDirect3D9Ex *This, UINT Adapter, DWORD Flags, D3DADAPTER_IDENTIFIER9 *pIdentifier);
	UINT (WINAPI *GetAdapterModeCount)(IDirect3D9Ex *This, UINT Adapter, D3DFORMAT Format);
	HRESULT (WINAPI *EnumAdapterModes)(IDirect3D9Ex *This, UINT Adapter, D3DFORMAT Format, UINT Mode, D3DDISPLAYMODE *pMode);
	HRESULT (WINAPI *GetAdapterDisplayMode)(IDirect3D9Ex *This, UINT Adapter, D3DDISPLAYMODE *pMode);
	HRESULT (WINAPI *CheckDeviceType)(IDirect3D9Ex *This, UINT Adapter, D3DDEVTYPE DevType, D3DFORMAT AdapterFormat, D3DFORMAT BackBufferFormat, BOOL bWindowed);
	HRESULT (WINAPI *CheckDeviceFormat)(IDirect3D9Ex *This, UINT Adapter, D3DDEVTYPE DeviceType, D3DFORMAT AdapterFormat, DWORD Usage, D3DRESOURCETYPE RType, D3DFORMAT CheckFormat);
	HRESULT (WINAPI *CheckDeviceMultiSampleType)(IDirect3D9Ex *This, UINT Adapter, D3DDEVTYPE DeviceType, D3DFORMAT SurfaceFormat, BOOL Windowed, D3DMULTISAMPLE_TYPE MultiSampleType, DWORD *pQualityLevels);
	HRESULT (WINAPI *CheckDepthStencilMatch)(IDirect3D9Ex *This, UINT Adapter, D3DDEVTYPE DeviceType, D3DFORMAT AdapterFormat, D3DFORMAT RenderTargetFormat, D3DFORMAT DepthStencilFormat);
	HRESULT (WINAPI *CheckDeviceFormatConversion)(IDirect3D9Ex *This, UINT Adapter, D3DDEVTYPE DeviceType, D3DFORMAT SourceFormat, D3DFORMAT TargetFormat);
	HRESULT (WINAPI *GetDeviceCaps)(IDirect3D9Ex *This, UINT Adapter, D3DDEVTYPE DeviceType, D3DCAPS9 *pCaps);
	HMONITOR (WINAPI *GetAdapterMonitor)(IDirect3D9Ex *This, UINT Adapter);
	HRESULT (WINAPI *CreateDevice)(IDirect3D9Ex *This, UINT Adapter, D3DDEVTYPE DeviceType, HWND hFocusWindow, DWORD BehaviorFlags, D3DPRESENT_PARAMETERS *pPresentationParameters, IDirect3DDevice9 **ppReturnedDeviceInterface);
	/* IDirect3D9Ex */
	UINT (WINAPI *GetAdapterModeCountEx)(IDirect3D9Ex *This, UINT Adapter, const D3DDISPLAYMODEFILTER *pFilter);
	HRESULT (WINAPI *EnumAdapterModesEx)(IDirect3D9Ex *This, UINT Adapter, const D3DDISPLAYMODEFILTER *pFilter, UINT Mode, D3DDISPLAYMODEEX *pMode);
	HRESULT (WINAPI *GetAdapterDisplayModeEx)(IDirect3D9Ex *This, UINT Adapter, D3DDISPLAYMODEEX *pMode, D3DDISPLAYROTATION *pRotation);
	HRESULT (WINAPI *CreateDeviceEx)(IDirect3D9Ex *This, UINT Adapter, D3DDEVTYPE DeviceType, HWND hFocusWindow, DWORD BehaviorFlags, D3DPRESENT_PARAMETERS *pPresentationParameters, D3DDISPLAYMODEEX *pFullscreenDisplayMode, IDirect3DDevice9Ex **ppReturnedDeviceInterface);
	HRESULT (WINAPI *GetAdapterLUID)(IDirect3D9Ex *This, UINT Adapter, LUID *pLUID);
} IDirect3D9ExVtbl;
struct IDirect3D9Ex
{
	IDirect3D9ExVtbl *lpVtbl;
};

/* IUnknown macros */
#define IDirect3D9Ex_QueryInterface(p,a,b) (p)->lpVtbl->QueryInterface(p,a,b)
#define IDirect3D9Ex_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirect3D9Ex_Release(p) (p)->lpVtbl->Release(p)
/* IDirect3D9 macros */
#define IDirect3D9Ex_RegisterSoftwareDevice(p,a) (p)->lpVtbl->RegisterSoftwareDevice(p,a)
#define IDirect3D9Ex_GetAdapterCount(p) (p)->lpVtbl->GetAdapterCount(p)
#define IDirect3D9Ex_GetAdapterIdentifier(p,a,b,c) (p)->lpVtbl->GetAdapterIdentifier(p,a,b,c)
#define IDirect3D9Ex_GetAdapterModeCount(p,a,b) (p)->lpVtbl->GetAdapterModeCount(p,a,b)
#define IDirect3D9Ex_EnumAdapterModes(p,a,b,c,d) (p)->lpVtbl->EnumAdapterModes(p,a,b,c,d)
#define IDirect3D9Ex_GetAdapterDisplayMode(p,a,b) (p)->lpVtbl->GetAdapterDisplayMode(p,a,b)
#define IDirect3D9Ex_CheckDeviceType(p,a,b,c,d,e) (p)->lpVtbl->CheckDeviceType(p,a,b,c,d,e)
#define IDirect3D9Ex_CheckDeviceFormat(p,a,b,c,d,e,f) (p)->lpVtbl->CheckDeviceFormat(p,a,b,c,d,e,f)
#define IDirect3D9Ex_CheckDeviceMultiSampleType(p,a,b,c,d,e,f) (p)->lpVtbl->CheckDeviceMultiSampleType(p,a,b,c,d,e,f)
#define IDirect3D9Ex_CheckDepthStencilMatch(p,a,b,c,d,e) (p)->lpVtbl->CheckDepthStencilMatch(p,a,b,c,d,e)
#define IDirect3D9Ex_CheckDeviceFormatConversion(p,a,b,c,d) (p)->lpVtbl->CheckDeviceFormatConversion(p,a,b,c,d)
#define IDirect3D9Ex_GetDeviceCaps(p,a,b,c) (p)->lpVtbl->GetDeviceCaps(p,a,b,c)
#define IDirect3D9Ex_GetAdapterMonitor(p,a) (p)->lpVtbl->GetAdapterMonitor(p,a)
#define IDirect3D9Ex_CreateDevice(p,a,b,c,d,e,f) (p)->lpVtbl->CreateDevice(p,a,b,c,d,e,f)
/* IDirect3D9Ex macros */
#define IDirect3D9Ex_GetAdapterModeCountEx(p,a,b) (p)->lpVtbl->GetAdapterModeCountEx(p,a,b)
#define IDirect3D9Ex_EnumAdapterModesEx(p,a,b,c,d) (p)->lpVtbl->EnumAdapterModesEx(p,a,b,c,d)
#define IDirect3D9Ex_GetAdapterDisplayModeEx(p,a,b,c) (p)->lpVtbl->GetAdapterDisplayModeEx(p,a,b,c)
#define IDirect3D9Ex_CreateDeviceEx(p,a,b,c,d,e,f,g) (p)->lpVtbl->CreateDeviceEx(p,a,b,c,d,e,f,g)
#define IDirect3D9Ex_GetAdapterLUID(p,a,b) (p)->lpVtbl->GetAdapterLUID(p,a,b)

typedef struct IDirect3D9ExOverlayExtensionVtbl
{
	/* IUnknown */
	HRESULT (WINAPI *QueryInterface)(IDirect3D9ExOverlayExtension *This, REFIID riid, void **ppvObject);
	ULONG (WINAPI *AddRef)(IDirect3D9ExOverlayExtension *This);
	ULONG (WINAPI *Release)(IDirect3D9ExOverlayExtension *This);
	/* IDirect3D9ExOverlayExtension */
	HRESULT (WINAPI *CheckDeviceOverlayType)(IDirect3D9ExOverlayExtension *This, UINT Adapter, D3DDEVTYPE DevType, UINT OverlayWidth, UINT OverlayHeight, D3DFORMAT OverlayFormat, D3DDISPLAYMODEEX *pDisplayMode, D3DDISPLAYROTATION DisplayRotation, D3DOVERLAYCAPS *pOverlayCaps);
} IDirect3D9ExOverlayExtensionVtbl;
struct IDirect3D9ExOverlayExtension
{
	IDirect3D9ExOverlayExtensionVtbl *lpVtbl;
};

/* IUnknown macros */
#define IDirect3D9ExOverlayExtension_QueryInterface(p,a,b) (p)->lpVtbl->QueryInterface(p,a,b)
#define IDirect3D9ExOverlayExtension_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirect3D9ExOverlayExtension_Release(p) (p)->lpVtbl->Release(p)
/* IDirect3D9ExOverlayExtension macros */
#define IDirect3D9ExOverlayExtension_CheckDeviceOverlayType(p,a,b,c,d,e,f,g,h) (p)->lpVtbl->CheckDeviceOverlayType(p,a,b,c,d,e,f,g,h)

typedef struct IDirect3DAuthenticatedChannel9Vtbl
{
	/* IUnknown */
	HRESULT (WINAPI *QueryInterface)(IDirect3DAuthenticatedChannel9 *This, REFIID riid, void **ppvObject);
	ULONG (WINAPI *AddRef)(IDirect3DAuthenticatedChannel9 *This);
	ULONG (WINAPI *Release)(IDirect3DAuthenticatedChannel9 *This);
	/* IDirect3DAuthenticatedChannel9 */
	HRESULT (WINAPI *GetCertificateSize)(IDirect3DAuthenticatedChannel9 *This, UINT *pCertificateSize);
	HRESULT (WINAPI *GetCertificate)(IDirect3DAuthenticatedChannel9 *This, UINT CertifacteSize, BYTE *ppCertificate);
	HRESULT (WINAPI *NegotiateKeyExchange)(IDirect3DAuthenticatedChannel9 *This, UINT DataSize, void *pData);
	HRESULT (WINAPI *Query)(IDirect3DAuthenticatedChannel9 *This, UINT InputSize, const void *pInput, UINT OutputSize, void *pOutput);
	HRESULT (WINAPI *Configure)(IDirect3DAuthenticatedChannel9 *This, UINT InputSize, const void *pInput, D3DAUTHENTICATEDCHANNEL_CONFIGURE_OUTPUT *pOutput);
} IDirect3DAuthenticatedChannel9Vtbl;
struct IDirect3DAuthenticatedChannel9
{
	IDirect3DAuthenticatedChannel9Vtbl *lpVtbl;
};

/* IUnknown macros */
#define IDirect3DAuthenticatedChannel9_QueryInterface(p,a,b) (p)->lpVtbl->QueryInterface(p,a,b)
#define IDirect3DAuthenticatedChannel9_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirect3DAuthenticatedChannel9_Release(p) (p)->lpVtbl->Release(p)
/* IDirect3DAuthenticatedChannel9 macros */
#define IDirect3DAuthenticatedChannel9_GetCertificateSize(p,a) (p)->lpVtbl->GetCertificateSize(p,a)
#define IDirect3DAuthenticatedChannel9_GetCertificate(p,a,b) (p)->lpVtbl->GetCertificate(p,a,b)
#define IDirect3DAuthenticatedChannel9_NegotiateKeyExchange(p,a,b) (p)->lpVtbl->NegotiateKeyExchange(p,a,b)
#define IDirect3DAuthenticatedChannel9_Query(p,a,b,c,d) (p)->lpVtbl->Query(p,a,b,c,d)
#define IDirect3DAuthenticatedChannel9_Configure(p,a,b,c) (p)->lpVtbl->Configure(p,a,b,c)

typedef struct IDirect3DBaseTexture9Vtbl
{
	/* IUnknown */
	HRESULT (WINAPI *QueryInterface)(IDirect3DBaseTexture9 *This, REFIID riid, void **ppvObject);
	ULONG (WINAPI *AddRef)(IDirect3DBaseTexture9 *This);
	ULONG (WINAPI *Release)(IDirect3DBaseTexture9 *This);
	/* IDirect3DResource9 */
	HRESULT (WINAPI *GetDevice)(IDirect3DBaseTexture9 *This, IDirect3DDevice9 **ppDevice);
	HRESULT (WINAPI *SetPrivateData)(IDirect3DBaseTexture9 *This, REFGUID refguid, const void *pData, DWORD SizeOfData, DWORD Flags);
	HRESULT (WINAPI *GetPrivateData)(IDirect3DBaseTexture9 *This, REFGUID refguid, void *pData, DWORD *pSizeOfData);
	HRESULT (WINAPI *FreePrivateData)(IDirect3DBaseTexture9 *This, REFGUID refguid);
	DWORD (WINAPI *SetPriority)(IDirect3DBaseTexture9 *This, DWORD PriorityNew);
	DWORD (WINAPI *GetPriority)(IDirect3DBaseTexture9 *This);
	void (WINAPI *PreLoad)(IDirect3DBaseTexture9 *This);
	D3DRESOURCETYPE (WINAPI *GetType)(IDirect3DBaseTexture9 *This);
	/* IDirect3DBaseTexture9 */
	DWORD (WINAPI *SetLOD)(IDirect3DBaseTexture9 *This, DWORD LODNew);
	DWORD (WINAPI *GetLOD)(IDirect3DBaseTexture9 *This);
	DWORD (WINAPI *GetLevelCount)(IDirect3DBaseTexture9 *This);
	HRESULT (WINAPI *SetAutoGenFilterType)(IDirect3DBaseTexture9 *This, D3DTEXTUREFILTERTYPE FilterType);
	D3DTEXTUREFILTERTYPE (WINAPI *GetAutoGenFilterType)(IDirect3DBaseTexture9 *This);
	void (WINAPI *GenerateMipSubLevels)(IDirect3DBaseTexture9 *This);
} IDirect3DBaseTexture9Vtbl;
struct IDirect3DBaseTexture9
{
	IDirect3DBaseTexture9Vtbl *lpVtbl;
};

/* IUnknown macros */
#define IDirect3DBaseTexture9_QueryInterface(p,a,b) (p)->lpVtbl->QueryInterface(p,a,b)
#define IDirect3DBaseTexture9_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirect3DBaseTexture9_Release(p) (p)->lpVtbl->Release(p)
/* IDirect3DResource9 macros */
#define IDirect3DBaseTexture9_GetDevice(p,a) (p)->lpVtbl->GetDevice(p,a)
#define IDirect3DBaseTexture9_SetPrivateData(p,a,b,c,d) (p)->lpVtbl->SetPrivateData(p,a,b,c,d)
#define IDirect3DBaseTexture9_GetPrivateData(p,a,b,c) (p)->lpVtbl->GetPrivateData(p,a,b,c)
#define IDirect3DBaseTexture9_FreePrivateData(p,a) (p)->lpVtbl->FreePrivateData(p,a)
#define IDirect3DBaseTexture9_SetPriority(p,a) (p)->lpVtbl->SetPriority(p,a)
#define IDirect3DBaseTexture9_GetPriority(p) (p)->lpVtbl->GetPriority(p)
#define IDirect3DBaseTexture9_PreLoad(p) (p)->lpVtbl->PreLoad(p)
#define IDirect3DBaseTexture9_GetType(p) (p)->lpVtbl->GetType(p)
/* IDirect3DBaseTexture9 macros */
#define IDirect3DBaseTexture9_SetLOD(p,a) (p)->lpVtbl->SetLOD(p,a)
#define IDirect3DBaseTexture9_GetLOD(p) (p)->lpVtbl->GetLOD(p)
#define IDirect3DBaseTexture9_GetLevelCount(p) (p)->lpVtbl->GetLevelCount(p)
#define IDirect3DBaseTexture9_SetAutoGenFilterType(p,a) (p)->lpVtbl->SetAutoGenFilterType(p,a)
#define IDirect3DBaseTexture9_GetAutoGenFilterType(p) (p)->lpVtbl->GetAutoGenFilterType(p)
#define IDirect3DBaseTexture9_GenerateMipSubLevels(p) (p)->lpVtbl->GenerateMipSubLevels(p)

typedef struct IDirect3DCryptoSession9Vtbl
{
	/* IUnknown */
	HRESULT (WINAPI *QueryInterface)(IDirect3DCryptoSession9 *This, REFIID riid, void **ppvObject);
	ULONG (WINAPI *AddRef)(IDirect3DCryptoSession9 *This);
	ULONG (WINAPI *Release)(IDirect3DCryptoSession9 *This);
	/* IDirect3DCryptoSession9 */
	HRESULT (WINAPI *GetCertificateSize)(IDirect3DCryptoSession9 *This, UINT *pCertificateSize);
	HRESULT (WINAPI *GetCertificate)(IDirect3DCryptoSession9 *This, UINT CertifacteSize, BYTE *ppCertificate);
	HRESULT (WINAPI *NegotiateKeyExchange)(IDirect3DCryptoSession9 *This, UINT DataSize, void *pData);
	HRESULT (WINAPI *EncryptionBlt)(IDirect3DCryptoSession9 *This, IDirect3DSurface9 *pSrcSurface, IDirect3DSurface9 *pDstSurface, UINT DstSurfaceSize, void *pIV);
	HRESULT (WINAPI *DecryptionBlt)(IDirect3DCryptoSession9 *This, IDirect3DSurface9 *pSrcSurface, IDirect3DSurface9 *pDstSurface, UINT SrcSurfaceSize, D3DENCRYPTED_BLOCK_INFO *pEncryptedBlockInfo, void *pContentKey, void *pIV);
	HRESULT (WINAPI *GetSurfacePitch)(IDirect3DCryptoSession9 *This, IDirect3DSurface9 *pSrcSurface, UINT *pSurfacePitch);
	HRESULT (WINAPI *StartSessionKeyRefresh)(IDirect3DCryptoSession9 *This, void *pRandomNumber, UINT RandomNumberSize);
	HRESULT (WINAPI *FinishSessionKeyRefresh)(IDirect3DCryptoSession9 *This);
	HRESULT (WINAPI *GetEncryptionBltKey)(IDirect3DCryptoSession9 *This, void *pReadbackKey, UINT KeySize);
} IDirect3DCryptoSession9Vtbl;
struct IDirect3DCryptoSession9
{
	IDirect3DCryptoSession9Vtbl *lpVtbl;
};

/* IUnknown macros */
#define IDirect3DCryptoSession9_QueryInterface(p,a,b) (p)->lpVtbl->QueryInterface(p,a,b)
#define IDirect3DCryptoSession9_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirect3DCryptoSession9_Release(p) (p)->lpVtbl->Release(p)
/* IDirect3DCryptoSession9 macros */
#define IDirect3DCryptoSession9_GetCertificateSize(p,a) (p)->lpVtbl->GetCertificateSize(p,a)
#define IDirect3DCryptoSession9_GetCertificate(p,a,b) (p)->lpVtbl->GetCertificate(p,a,b)
#define IDirect3DCryptoSession9_NegotiateKeyExchange(p,a,b) (p)->lpVtbl->NegotiateKeyExchange(p,a,b)
#define IDirect3DCryptoSession9_EncryptionBlt(p,a,b,c,d) (p)->lpVtbl->EncryptionBlt(p,a,b,c,d)
#define IDirect3DCryptoSession9_DecryptionBlt(p,a,b,c,d,e,f) (p)->lpVtbl->DecryptionBlt(p,a,b,c,d,e,f)
#define IDirect3DCryptoSession9_GetSurfacePitch(p,a,b) (p)->lpVtbl->GetSurfacePitch(p,a,b)
#define IDirect3DCryptoSession9_StartSessionKeyRefresh(p,a,b) (p)->lpVtbl->StartSessionKeyRefresh(p,a,b)
#define IDirect3DCryptoSession9_FinishSessionKeyRefresh(p) (p)->lpVtbl->FinishSessionKeyRefresh(p)
#define IDirect3DCryptoSession9_GetEncryptionBltKey(p,a,b) (p)->lpVtbl->GetEncryptionBltKey(p,a,b)

typedef struct IDirect3DCubeTexture9Vtbl
{
	/* IUnknown */
	HRESULT (WINAPI *QueryInterface)(IDirect3DCubeTexture9 *This, REFIID riid, void **ppvObject);
	ULONG (WINAPI *AddRef)(IDirect3DCubeTexture9 *This);
	ULONG (WINAPI *Release)(IDirect3DCubeTexture9 *This);
	/* IDirect3DResource9 */
	HRESULT (WINAPI *GetDevice)(IDirect3DCubeTexture9 *This, IDirect3DDevice9 **ppDevice);
	HRESULT (WINAPI *SetPrivateData)(IDirect3DCubeTexture9 *This, REFGUID refguid, const void *pData, DWORD SizeOfData, DWORD Flags);
	HRESULT (WINAPI *GetPrivateData)(IDirect3DCubeTexture9 *This, REFGUID refguid, void *pData, DWORD *pSizeOfData);
	HRESULT (WINAPI *FreePrivateData)(IDirect3DCubeTexture9 *This, REFGUID refguid);
	DWORD (WINAPI *SetPriority)(IDirect3DCubeTexture9 *This, DWORD PriorityNew);
	DWORD (WINAPI *GetPriority)(IDirect3DCubeTexture9 *This);
	void (WINAPI *PreLoad)(IDirect3DCubeTexture9 *This);
	D3DRESOURCETYPE (WINAPI *GetType)(IDirect3DCubeTexture9 *This);
	/* IDirect3DBaseTexture9 */
	DWORD (WINAPI *SetLOD)(IDirect3DCubeTexture9 *This, DWORD LODNew);
	DWORD (WINAPI *GetLOD)(IDirect3DCubeTexture9 *This);
	DWORD (WINAPI *GetLevelCount)(IDirect3DCubeTexture9 *This);
	HRESULT (WINAPI *SetAutoGenFilterType)(IDirect3DCubeTexture9 *This, D3DTEXTUREFILTERTYPE FilterType);
	D3DTEXTUREFILTERTYPE (WINAPI *GetAutoGenFilterType)(IDirect3DCubeTexture9 *This);
	void (WINAPI *GenerateMipSubLevels)(IDirect3DCubeTexture9 *This);
	/* IDirect3DCubeTexture9 */
	HRESULT (WINAPI *GetLevelDesc)(IDirect3DCubeTexture9 *This, UINT Level, D3DSURFACE_DESC *pDesc);
	HRESULT (WINAPI *GetCubeMapSurface)(IDirect3DCubeTexture9 *This, D3DCUBEMAP_FACES FaceType, UINT Level, IDirect3DSurface9 **ppCubeMapSurface);
	HRESULT (WINAPI *LockRect)(IDirect3DCubeTexture9 *This, D3DCUBEMAP_FACES FaceType, UINT Level, D3DLOCKED_RECT *pLockedRect, const RECT *pRect, DWORD Flags);
	HRESULT (WINAPI *UnlockRect)(IDirect3DCubeTexture9 *This, D3DCUBEMAP_FACES FaceType, UINT Level);
	HRESULT (WINAPI *AddDirtyRect)(IDirect3DCubeTexture9 *This, D3DCUBEMAP_FACES FaceType, const RECT *pDirtyRect);
} IDirect3DCubeTexture9Vtbl;
struct IDirect3DCubeTexture9
{
	IDirect3DCubeTexture9Vtbl *lpVtbl;
};

/* IUnknown macros */
#define IDirect3DCubeTexture9_QueryInterface(p,a,b) (p)->lpVtbl->QueryInterface(p,a,b)
#define IDirect3DCubeTexture9_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirect3DCubeTexture9_Release(p) (p)->lpVtbl->Release(p)
/* IDirect3DResource9 macros */
#define IDirect3DCubeTexture9_GetDevice(p,a) (p)->lpVtbl->GetDevice(p,a)
#define IDirect3DCubeTexture9_SetPrivateData(p,a,b,c,d) (p)->lpVtbl->SetPrivateData(p,a,b,c,d)
#define IDirect3DCubeTexture9_GetPrivateData(p,a,b,c) (p)->lpVtbl->GetPrivateData(p,a,b,c)
#define IDirect3DCubeTexture9_FreePrivateData(p,a) (p)->lpVtbl->FreePrivateData(p,a)
#define IDirect3DCubeTexture9_SetPriority(p,a) (p)->lpVtbl->SetPriority(p,a)
#define IDirect3DCubeTexture9_GetPriority(p) (p)->lpVtbl->GetPriority(p)
#define IDirect3DCubeTexture9_PreLoad(p) (p)->lpVtbl->PreLoad(p)
#define IDirect3DCubeTexture9_GetType(p) (p)->lpVtbl->GetType(p)
/* IDirect3DBaseTexture9 macros */
#define IDirect3DCubeTexture9_SetLOD(p,a) (p)->lpVtbl->SetLOD(p,a)
#define IDirect3DCubeTexture9_GetLOD(p) (p)->lpVtbl->GetLOD(p)
#define IDirect3DCubeTexture9_GetLevelCount(p) (p)->lpVtbl->GetLevelCount(p)
#define IDirect3DCubeTexture9_SetAutoGenFilterType(p,a) (p)->lpVtbl->SetAutoGenFilterType(p,a)
#define IDirect3DCubeTexture9_GetAutoGenFilterType(p) (p)->lpVtbl->GetAutoGenFilterType(p)
#define IDirect3DCubeTexture9_GenerateMipSubLevels(p) (p)->lpVtbl->GenerateMipSubLevels(p)
/* IDirect3DCubeTexture9 macros */
#define IDirect3DCubeTexture9_GetLevelDesc(p,a,b) (p)->lpVtbl->GetLevelDesc(p,a,b)
#define IDirect3DCubeTexture9_GetCubeMapSurface(p,a,b,c) (p)->lpVtbl->GetCubeMapSurface(p,a,b,c)
#define IDirect3DCubeTexture9_LockRect(p,a,b,c,d,e) (p)->lpVtbl->LockRect(p,a,b,c,d,e)
#define IDirect3DCubeTexture9_UnlockRect(p,a,b) (p)->lpVtbl->UnlockRect(p,a,b)
#define IDirect3DCubeTexture9_AddDirtyRect(p,a,b) (p)->lpVtbl->AddDirtyRect(p,a,b)

typedef struct IDirect3DDevice9Vtbl
{
	/* IUnknown */
	HRESULT (WINAPI *QueryInterface)(IDirect3DDevice9 *This, REFIID riid, void **ppvObject);
	ULONG (WINAPI *AddRef)(IDirect3DDevice9 *This);
	ULONG (WINAPI *Release)(IDirect3DDevice9 *This);
	/* IDirect3DDevice9 */
	HRESULT (WINAPI *TestCooperativeLevel)(IDirect3DDevice9 *This);
	UINT (WINAPI *GetAvailableTextureMem)(IDirect3DDevice9 *This);
	HRESULT (WINAPI *EvictManagedResources)(IDirect3DDevice9 *This);
	HRESULT (WINAPI *GetDirect3D)(IDirect3DDevice9 *This, IDirect3D9 **ppD3D9);
	HRESULT (WINAPI *GetDeviceCaps)(IDirect3DDevice9 *This, D3DCAPS9 *pCaps);
	HRESULT (WINAPI *GetDisplayMode)(IDirect3DDevice9 *This, UINT iSwapChain, D3DDISPLAYMODE *pMode);
	HRESULT (WINAPI *GetCreationParameters)(IDirect3DDevice9 *This, D3DDEVICE_CREATION_PARAMETERS *pParameters);
	HRESULT (WINAPI *SetCursorProperties)(IDirect3DDevice9 *This, UINT XHotSpot, UINT YHotSpot, IDirect3DSurface9 *pCursorBitmap);
	void (WINAPI *SetCursorPosition)(IDirect3DDevice9 *This, int X, int Y, DWORD Flags);
	BOOL (WINAPI *ShowCursor)(IDirect3DDevice9 *This, BOOL bShow);
	HRESULT (WINAPI *CreateAdditionalSwapChain)(IDirect3DDevice9 *This, D3DPRESENT_PARAMETERS *pPresentationParameters, IDirect3DSwapChain9 **pSwapChain);
	HRESULT (WINAPI *GetSwapChain)(IDirect3DDevice9 *This, UINT iSwapChain, IDirect3DSwapChain9 **pSwapChain);
	UINT (WINAPI *GetNumberOfSwapChains)(IDirect3DDevice9 *This);
	HRESULT (WINAPI *Reset)(IDirect3DDevice9 *This, D3DPRESENT_PARAMETERS *pPresentationParameters);
	HRESULT (WINAPI *Present)(IDirect3DDevice9 *This, const RECT *pSourceRect, const RECT *pDestRect, HWND hDestWindowOverride, const RGNDATA *pDirtyRegion);
	HRESULT (WINAPI *GetBackBuffer)(IDirect3DDevice9 *This, UINT iSwapChain, UINT iBackBuffer, D3DBACKBUFFER_TYPE Type, IDirect3DSurface9 **ppBackBuffer);
	HRESULT (WINAPI *GetRasterStatus)(IDirect3DDevice9 *This, UINT iSwapChain, D3DRASTER_STATUS *pRasterStatus);
	HRESULT (WINAPI *SetDialogBoxMode)(IDirect3DDevice9 *This, BOOL bEnableDialogs);
	void (WINAPI *SetGammaRamp)(IDirect3DDevice9 *This, UINT iSwapChain, DWORD Flags, const D3DGAMMARAMP *pRamp);
	void (WINAPI *GetGammaRamp)(IDirect3DDevice9 *This, UINT iSwapChain, D3DGAMMARAMP *pRamp);
	HRESULT (WINAPI *CreateTexture)(IDirect3DDevice9 *This, UINT Width, UINT Height, UINT Levels, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool, IDirect3DTexture9 **ppTexture, HANDLE *pSharedHandle);
	HRESULT (WINAPI *CreateVolumeTexture)(IDirect3DDevice9 *This, UINT Width, UINT Height, UINT Depth, UINT Levels, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool, IDirect3DVolumeTexture9 **ppVolumeTexture, HANDLE *pSharedHandle);
	HRESULT (WINAPI *CreateCubeTexture)(IDirect3DDevice9 *This, UINT EdgeLength, UINT Levels, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool, IDirect3DCubeTexture9 **ppCubeTexture, HANDLE *pSharedHandle);
	HRESULT (WINAPI *CreateVertexBuffer)(IDirect3DDevice9 *This, UINT Length, DWORD Usage, DWORD FVF, D3DPOOL Pool, IDirect3DVertexBuffer9 **ppVertexBuffer, HANDLE *pSharedHandle);
	HRESULT (WINAPI *CreateIndexBuffer)(IDirect3DDevice9 *This, UINT Length, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool, IDirect3DIndexBuffer9 **ppIndexBuffer, HANDLE *pSharedHandle);
	HRESULT (WINAPI *CreateRenderTarget)(IDirect3DDevice9 *This, UINT Width, UINT Height, D3DFORMAT Format, D3DMULTISAMPLE_TYPE MultiSample, DWORD MultisampleQuality, BOOL Lockable, IDirect3DSurface9 **ppSurface, HANDLE *pSharedHandle);
	HRESULT (WINAPI *CreateDepthStencilSurface)(IDirect3DDevice9 *This, UINT Width, UINT Height, D3DFORMAT Format, D3DMULTISAMPLE_TYPE MultiSample, DWORD MultisampleQuality, BOOL Discard, IDirect3DSurface9 **ppSurface, HANDLE *pSharedHandle);
	HRESULT (WINAPI *UpdateSurface)(IDirect3DDevice9 *This, IDirect3DSurface9 *pSourceSurface, const RECT *pSourceRect, IDirect3DSurface9 *pDestinationSurface, const POINT *pDestPoint);
	HRESULT (WINAPI *UpdateTexture)(IDirect3DDevice9 *This, IDirect3DBaseTexture9 *pSourceTexture, IDirect3DBaseTexture9 *pDestinationTexture);
	HRESULT (WINAPI *GetRenderTargetData)(IDirect3DDevice9 *This, IDirect3DSurface9 *pRenderTarget, IDirect3DSurface9 *pDestSurface);
	HRESULT (WINAPI *GetFrontBufferData)(IDirect3DDevice9 *This, UINT iSwapChain, IDirect3DSurface9 *pDestSurface);
	HRESULT (WINAPI *StretchRect)(IDirect3DDevice9 *This, IDirect3DSurface9 *pSourceSurface, const RECT *pSourceRect, IDirect3DSurface9 *pDestSurface, const RECT *pDestRect, D3DTEXTUREFILTERTYPE Filter);
	HRESULT (WINAPI *ColorFill)(IDirect3DDevice9 *This, IDirect3DSurface9 *pSurface, const RECT *pRect, D3DCOLOR color);
	HRESULT (WINAPI *CreateOffscreenPlainSurface)(IDirect3DDevice9 *This, UINT Width, UINT Height, D3DFORMAT Format, D3DPOOL Pool, IDirect3DSurface9 **ppSurface, HANDLE *pSharedHandle);
	HRESULT (WINAPI *SetRenderTarget)(IDirect3DDevice9 *This, DWORD RenderTargetIndex, IDirect3DSurface9 *pRenderTarget);
	HRESULT (WINAPI *GetRenderTarget)(IDirect3DDevice9 *This, DWORD RenderTargetIndex, IDirect3DSurface9 **ppRenderTarget);
	HRESULT (WINAPI *SetDepthStencilSurface)(IDirect3DDevice9 *This, IDirect3DSurface9 *pNewZStencil);
	HRESULT (WINAPI *GetDepthStencilSurface)(IDirect3DDevice9 *This, IDirect3DSurface9 **ppZStencilSurface);
	HRESULT (WINAPI *BeginScene)(IDirect3DDevice9 *This);
	HRESULT (WINAPI *EndScene)(IDirect3DDevice9 *This);
	HRESULT (WINAPI *Clear)(IDirect3DDevice9 *This, DWORD Count, const D3DRECT *pRects, DWORD Flags, D3DCOLOR Color, float Z, DWORD Stencil);
	HRESULT (WINAPI *SetTransform)(IDirect3DDevice9 *This, D3DTRANSFORMSTATETYPE State, const D3DMATRIX *pMatrix);
	HRESULT (WINAPI *GetTransform)(IDirect3DDevice9 *This, D3DTRANSFORMSTATETYPE State, D3DMATRIX *pMatrix);
	HRESULT (WINAPI *MultiplyTransform)(IDirect3DDevice9 *This, D3DTRANSFORMSTATETYPE State, const D3DMATRIX *pMatrix);
	HRESULT (WINAPI *SetViewport)(IDirect3DDevice9 *This, const D3DVIEWPORT9 *pViewport);
	HRESULT (WINAPI *GetViewport)(IDirect3DDevice9 *This, D3DVIEWPORT9 *pViewport);
	HRESULT (WINAPI *SetMaterial)(IDirect3DDevice9 *This, const D3DMATERIAL9 *pMaterial);
	HRESULT (WINAPI *GetMaterial)(IDirect3DDevice9 *This, D3DMATERIAL9 *pMaterial);
	HRESULT (WINAPI *SetLight)(IDirect3DDevice9 *This, DWORD Index, const D3DLIGHT9 *pLight);
	HRESULT (WINAPI *GetLight)(IDirect3DDevice9 *This, DWORD Index, D3DLIGHT9 *pLight);
	HRESULT (WINAPI *LightEnable)(IDirect3DDevice9 *This, DWORD Index, BOOL Enable);
	HRESULT (WINAPI *GetLightEnable)(IDirect3DDevice9 *This, DWORD Index, BOOL *pEnable);
	HRESULT (WINAPI *SetClipPlane)(IDirect3DDevice9 *This, DWORD Index, const float *pPlane);
	HRESULT (WINAPI *GetClipPlane)(IDirect3DDevice9 *This, DWORD Index, float *pPlane);
	HRESULT (WINAPI *SetRenderState)(IDirect3DDevice9 *This, D3DRENDERSTATETYPE State, DWORD Value);
	HRESULT (WINAPI *GetRenderState)(IDirect3DDevice9 *This, D3DRENDERSTATETYPE State, DWORD *pValue);
	HRESULT (WINAPI *CreateStateBlock)(IDirect3DDevice9 *This, D3DSTATEBLOCKTYPE Type, IDirect3DStateBlock9 **ppSB);
	HRESULT (WINAPI *BeginStateBlock)(IDirect3DDevice9 *This);
	HRESULT (WINAPI *EndStateBlock)(IDirect3DDevice9 *This, IDirect3DStateBlock9 **ppSB);
	HRESULT (WINAPI *SetClipStatus)(IDirect3DDevice9 *This, const D3DCLIPSTATUS9 *pClipStatus);
	HRESULT (WINAPI *GetClipStatus)(IDirect3DDevice9 *This, D3DCLIPSTATUS9 *pClipStatus);
	HRESULT (WINAPI *GetTexture)(IDirect3DDevice9 *This, DWORD Stage, IDirect3DBaseTexture9 **ppTexture);
	HRESULT (WINAPI *SetTexture)(IDirect3DDevice9 *This, DWORD Stage, IDirect3DBaseTexture9 *pTexture);
	HRESULT (WINAPI *GetTextureStageState)(IDirect3DDevice9 *This, DWORD Stage, D3DTEXTURESTAGESTATETYPE Type, DWORD *pValue);
	HRESULT (WINAPI *SetTextureStageState)(IDirect3DDevice9 *This, DWORD Stage, D3DTEXTURESTAGESTATETYPE Type, DWORD Value);
	HRESULT (WINAPI *GetSamplerState)(IDirect3DDevice9 *This, DWORD Sampler, D3DSAMPLERSTATETYPE Type, DWORD *pValue);
	HRESULT (WINAPI *SetSamplerState)(IDirect3DDevice9 *This, DWORD Sampler, D3DSAMPLERSTATETYPE Type, DWORD Value);
	HRESULT (WINAPI *ValidateDevice)(IDirect3DDevice9 *This, DWORD *pNumPasses);
	HRESULT (WINAPI *SetPaletteEntries)(IDirect3DDevice9 *This, UINT PaletteNumber, const PALETTEENTRY *pEntries);
	HRESULT (WINAPI *GetPaletteEntries)(IDirect3DDevice9 *This, UINT PaletteNumber, PALETTEENTRY *pEntries);
	HRESULT (WINAPI *SetCurrentTexturePalette)(IDirect3DDevice9 *This, UINT PaletteNumber);
	HRESULT (WINAPI *GetCurrentTexturePalette)(IDirect3DDevice9 *This, UINT *PaletteNumber);
	HRESULT (WINAPI *SetScissorRect)(IDirect3DDevice9 *This, const RECT *pRect);
	HRESULT (WINAPI *GetScissorRect)(IDirect3DDevice9 *This, RECT *pRect);
	HRESULT (WINAPI *SetSoftwareVertexProcessing)(IDirect3DDevice9 *This, BOOL bSoftware);
	BOOL (WINAPI *GetSoftwareVertexProcessing)(IDirect3DDevice9 *This);
	HRESULT (WINAPI *SetNPatchMode)(IDirect3DDevice9 *This, float nSegments);
	float (WINAPI *GetNPatchMode)(IDirect3DDevice9 *This);
	HRESULT (WINAPI *DrawPrimitive)(IDirect3DDevice9 *This, D3DPRIMITIVETYPE PrimitiveType, UINT StartVertex, UINT PrimitiveCount);
	HRESULT (WINAPI *DrawIndexedPrimitive)(IDirect3DDevice9 *This, D3DPRIMITIVETYPE PrimitiveType, INT BaseVertexIndex, UINT MinVertexIndex, UINT NumVertices, UINT startIndex, UINT primCount);
	HRESULT (WINAPI *DrawPrimitiveUP)(IDirect3DDevice9 *This, D3DPRIMITIVETYPE PrimitiveType, UINT PrimitiveCount, const void *pVertexStreamZeroData, UINT VertexStreamZeroStride);
	HRESULT (WINAPI *DrawIndexedPrimitiveUP)(IDirect3DDevice9 *This, D3DPRIMITIVETYPE PrimitiveType, UINT MinVertexIndex, UINT NumVertices, UINT PrimitiveCount, const void *pIndexData, D3DFORMAT IndexDataFormat, const void *pVertexStreamZeroData, UINT VertexStreamZeroStride);
	HRESULT (WINAPI *ProcessVertices)(IDirect3DDevice9 *This, UINT SrcStartIndex, UINT DestIndex, UINT VertexCount, IDirect3DVertexBuffer9 *pDestBuffer, IDirect3DVertexDeclaration9 *pVertexDecl, DWORD Flags);
	HRESULT (WINAPI *CreateVertexDeclaration)(IDirect3DDevice9 *This, const D3DVERTEXELEMENT9 *pVertexElements, IDirect3DVertexDeclaration9 **ppDecl);
	HRESULT (WINAPI *SetVertexDeclaration)(IDirect3DDevice9 *This, IDirect3DVertexDeclaration9 *pDecl);
	HRESULT (WINAPI *GetVertexDeclaration)(IDirect3DDevice9 *This, IDirect3DVertexDeclaration9 **ppDecl);
	HRESULT (WINAPI *SetFVF)(IDirect3DDevice9 *This, DWORD FVF);
	HRESULT (WINAPI *GetFVF)(IDirect3DDevice9 *This, DWORD *pFVF);
	HRESULT (WINAPI *CreateVertexShader)(IDirect3DDevice9 *This, const DWORD *pFunction, IDirect3DVertexShader9 **ppShader);
	HRESULT (WINAPI *SetVertexShader)(IDirect3DDevice9 *This, IDirect3DVertexShader9 *pShader);
	HRESULT (WINAPI *GetVertexShader)(IDirect3DDevice9 *This, IDirect3DVertexShader9 **ppShader);
	HRESULT (WINAPI *SetVertexShaderConstantF)(IDirect3DDevice9 *This, UINT StartRegister, const float *pConstantData, UINT Vector4fCount);
	HRESULT (WINAPI *GetVertexShaderConstantF)(IDirect3DDevice9 *This, UINT StartRegister, float *pConstantData, UINT Vector4fCount);
	HRESULT (WINAPI *SetVertexShaderConstantI)(IDirect3DDevice9 *This, UINT StartRegister, const int *pConstantData, UINT Vector4iCount);
	HRESULT (WINAPI *GetVertexShaderConstantI)(IDirect3DDevice9 *This, UINT StartRegister, int *pConstantData, UINT Vector4iCount);
	HRESULT (WINAPI *SetVertexShaderConstantB)(IDirect3DDevice9 *This, UINT StartRegister, const BOOL *pConstantData, UINT BoolCount);
	HRESULT (WINAPI *GetVertexShaderConstantB)(IDirect3DDevice9 *This, UINT StartRegister, BOOL *pConstantData, UINT BoolCount);
	HRESULT (WINAPI *SetStreamSource)(IDirect3DDevice9 *This, UINT StreamNumber, IDirect3DVertexBuffer9 *pStreamData, UINT OffsetInBytes, UINT Stride);
	HRESULT (WINAPI *GetStreamSource)(IDirect3DDevice9 *This, UINT StreamNumber, IDirect3DVertexBuffer9 **ppStreamData, UINT *pOffsetInBytes, UINT *pStride);
	HRESULT (WINAPI *SetStreamSourceFreq)(IDirect3DDevice9 *This, UINT StreamNumber, UINT Setting);
	HRESULT (WINAPI *GetStreamSourceFreq)(IDirect3DDevice9 *This, UINT StreamNumber, UINT *pSetting);
	HRESULT (WINAPI *SetIndices)(IDirect3DDevice9 *This, IDirect3DIndexBuffer9 *pIndexData);
	HRESULT (WINAPI *GetIndices)(IDirect3DDevice9 *This, IDirect3DIndexBuffer9 **ppIndexData);
	HRESULT (WINAPI *CreatePixelShader)(IDirect3DDevice9 *This, const DWORD *pFunction, IDirect3DPixelShader9 **ppShader);
	HRESULT (WINAPI *SetPixelShader)(IDirect3DDevice9 *This, IDirect3DPixelShader9 *pShader);
	HRESULT (WINAPI *GetPixelShader)(IDirect3DDevice9 *This, IDirect3DPixelShader9 **ppShader);
	HRESULT (WINAPI *SetPixelShaderConstantF)(IDirect3DDevice9 *This, UINT StartRegister, const float *pConstantData, UINT Vector4fCount);
	HRESULT (WINAPI *GetPixelShaderConstantF)(IDirect3DDevice9 *This, UINT StartRegister, float *pConstantData, UINT Vector4fCount);
	HRESULT (WINAPI *SetPixelShaderConstantI)(IDirect3DDevice9 *This, UINT StartRegister, const int *pConstantData, UINT Vector4iCount);
	HRESULT (WINAPI *GetPixelShaderConstantI)(IDirect3DDevice9 *This, UINT StartRegister, int *pConstantData, UINT Vector4iCount);
	HRESULT (WINAPI *SetPixelShaderConstantB)(IDirect3DDevice9 *This, UINT StartRegister, const BOOL *pConstantData, UINT BoolCount);
	HRESULT (WINAPI *GetPixelShaderConstantB)(IDirect3DDevice9 *This, UINT StartRegister, BOOL *pConstantData, UINT BoolCount);
	HRESULT (WINAPI *DrawRectPatch)(IDirect3DDevice9 *This, UINT Handle, const float *pNumSegs, const D3DRECTPATCH_INFO *pRectPatchInfo);
	HRESULT (WINAPI *DrawTriPatch)(IDirect3DDevice9 *This, UINT Handle, const float *pNumSegs, const D3DTRIPATCH_INFO *pTriPatchInfo);
	HRESULT (WINAPI *DeletePatch)(IDirect3DDevice9 *This, UINT Handle);
	HRESULT (WINAPI *CreateQuery)(IDirect3DDevice9 *This, D3DQUERYTYPE Type, IDirect3DQuery9 **ppQuery);
} IDirect3DDevice9Vtbl;
struct IDirect3DDevice9
{
	IDirect3DDevice9Vtbl *lpVtbl;
};

/* IUnknown macros */
#define IDirect3DDevice9_QueryInterface(p,a,b) (p)->lpVtbl->QueryInterface(p,a,b)
#define IDirect3DDevice9_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirect3DDevice9_Release(p) (p)->lpVtbl->Release(p)
/* IDirect3DDevice9 macros */
#define IDirect3DDevice9_TestCooperativeLevel(p) (p)->lpVtbl->TestCooperativeLevel(p)
#define IDirect3DDevice9_GetAvailableTextureMem(p) (p)->lpVtbl->GetAvailableTextureMem(p)
#define IDirect3DDevice9_EvictManagedResources(p) (p)->lpVtbl->EvictManagedResources(p)
#define IDirect3DDevice9_GetDirect3D(p,a) (p)->lpVtbl->GetDirect3D(p,a)
#define IDirect3DDevice9_GetDeviceCaps(p,a) (p)->lpVtbl->GetDeviceCaps(p,a)
#define IDirect3DDevice9_GetDisplayMode(p,a,b) (p)->lpVtbl->GetDisplayMode(p,a,b)
#define IDirect3DDevice9_GetCreationParameters(p,a) (p)->lpVtbl->GetCreationParameters(p,a)
#define IDirect3DDevice9_SetCursorProperties(p,a,b,c) (p)->lpVtbl->SetCursorProperties(p,a,b,c)
#define IDirect3DDevice9_SetCursorPosition(p,a,b,c) (p)->lpVtbl->SetCursorPosition(p,a,b,c)
#define IDirect3DDevice9_ShowCursor(p,a) (p)->lpVtbl->ShowCursor(p,a)
#define IDirect3DDevice9_CreateAdditionalSwapChain(p,a,b) (p)->lpVtbl->CreateAdditionalSwapChain(p,a,b)
#define IDirect3DDevice9_GetSwapChain(p,a,b) (p)->lpVtbl->GetSwapChain(p,a,b)
#define IDirect3DDevice9_GetNumberOfSwapChains(p) (p)->lpVtbl->GetNumberOfSwapChains(p)
#define IDirect3DDevice9_Reset(p,a) (p)->lpVtbl->Reset(p,a)
#define IDirect3DDevice9_Present(p,a,b,c,d) (p)->lpVtbl->Present(p,a,b,c,d)
#define IDirect3DDevice9_GetBackBuffer(p,a,b,c,d) (p)->lpVtbl->GetBackBuffer(p,a,b,c,d)
#define IDirect3DDevice9_GetRasterStatus(p,a,b) (p)->lpVtbl->GetRasterStatus(p,a,b)
#define IDirect3DDevice9_SetDialogBoxMode(p,a) (p)->lpVtbl->SetDialogBoxMode(p,a)
#define IDirect3DDevice9_SetGammaRamp(p,a,b,c) (p)->lpVtbl->SetGammaRamp(p,a,b,c)
#define IDirect3DDevice9_GetGammaRamp(p,a,b) (p)->lpVtbl->GetGammaRamp(p,a,b)
#define IDirect3DDevice9_CreateTexture(p,a,b,c,d,e,f,g,h) (p)->lpVtbl->CreateTexture(p,a,b,c,d,e,f,g,h)
#define IDirect3DDevice9_CreateVolumeTexture(p,a,b,c,d,e,f,g,h,i) (p)->lpVtbl->CreateVolumeTexture(p,a,b,c,d,e,f,g,h,i)
#define IDirect3DDevice9_CreateCubeTexture(p,a,b,c,d,e,f,g) (p)->lpVtbl->CreateCubeTexture(p,a,b,c,d,e,f,g)
#define IDirect3DDevice9_CreateVertexBuffer(p,a,b,c,d,e,f) (p)->lpVtbl->CreateVertexBuffer(p,a,b,c,d,e,f)
#define IDirect3DDevice9_CreateIndexBuffer(p,a,b,c,d,e,f) (p)->lpVtbl->CreateIndexBuffer(p,a,b,c,d,e,f)
#define IDirect3DDevice9_CreateRenderTarget(p,a,b,c,d,e,f,g,h) (p)->lpVtbl->CreateRenderTarget(p,a,b,c,d,e,f,g,h)
#define IDirect3DDevice9_CreateDepthStencilSurface(p,a,b,c,d,e,f,g,h) (p)->lpVtbl->CreateDepthStencilSurface(p,a,b,c,d,e,f,g,h)
#define IDirect3DDevice9_UpdateSurface(p,a,b,c,d) (p)->lpVtbl->UpdateSurface(p,a,b,c,d)
#define IDirect3DDevice9_UpdateTexture(p,a,b) (p)->lpVtbl->UpdateTexture(p,a,b)
#define IDirect3DDevice9_GetRenderTargetData(p,a,b) (p)->lpVtbl->GetRenderTargetData(p,a,b)
#define IDirect3DDevice9_GetFrontBufferData(p,a,b) (p)->lpVtbl->GetFrontBufferData(p,a,b)
#define IDirect3DDevice9_StretchRect(p,a,b,c,d,e) (p)->lpVtbl->StretchRect(p,a,b,c,d,e)
#define IDirect3DDevice9_ColorFill(p,a,b,c) (p)->lpVtbl->ColorFill(p,a,b,c)
#define IDirect3DDevice9_CreateOffscreenPlainSurface(p,a,b,c,d,e,f) (p)->lpVtbl->CreateOffscreenPlainSurface(p,a,b,c,d,e,f)
#define IDirect3DDevice9_SetRenderTarget(p,a,b) (p)->lpVtbl->SetRenderTarget(p,a,b)
#define IDirect3DDevice9_GetRenderTarget(p,a,b) (p)->lpVtbl->GetRenderTarget(p,a,b)
#define IDirect3DDevice9_SetDepthStencilSurface(p,a) (p)->lpVtbl->SetDepthStencilSurface(p,a)
#define IDirect3DDevice9_GetDepthStencilSurface(p,a) (p)->lpVtbl->GetDepthStencilSurface(p,a)
#define IDirect3DDevice9_BeginScene(p) (p)->lpVtbl->BeginScene(p)
#define IDirect3DDevice9_EndScene(p) (p)->lpVtbl->EndScene(p)
#define IDirect3DDevice9_Clear(p,a,b,c,d,e,f) (p)->lpVtbl->Clear(p,a,b,c,d,e,f)
#define IDirect3DDevice9_SetTransform(p,a,b) (p)->lpVtbl->SetTransform(p,a,b)
#define IDirect3DDevice9_GetTransform(p,a,b) (p)->lpVtbl->GetTransform(p,a,b)
#define IDirect3DDevice9_MultiplyTransform(p,a,b) (p)->lpVtbl->MultiplyTransform(p,a,b)
#define IDirect3DDevice9_SetViewport(p,a) (p)->lpVtbl->SetViewport(p,a)
#define IDirect3DDevice9_GetViewport(p,a) (p)->lpVtbl->GetViewport(p,a)
#define IDirect3DDevice9_SetMaterial(p,a) (p)->lpVtbl->SetMaterial(p,a)
#define IDirect3DDevice9_GetMaterial(p,a) (p)->lpVtbl->GetMaterial(p,a)
#define IDirect3DDevice9_SetLight(p,a,b) (p)->lpVtbl->SetLight(p,a,b)
#define IDirect3DDevice9_GetLight(p,a,b) (p)->lpVtbl->GetLight(p,a,b)
#define IDirect3DDevice9_LightEnable(p,a,b) (p)->lpVtbl->LightEnable(p,a,b)
#define IDirect3DDevice9_GetLightEnable(p,a,b) (p)->lpVtbl->GetLightEnable(p,a,b)
#define IDirect3DDevice9_SetClipPlane(p,a,b) (p)->lpVtbl->SetClipPlane(p,a,b)
#define IDirect3DDevice9_GetClipPlane(p,a,b) (p)->lpVtbl->GetClipPlane(p,a,b)
#define IDirect3DDevice9_SetRenderState(p,a,b) (p)->lpVtbl->SetRenderState(p,a,b)
#define IDirect3DDevice9_GetRenderState(p,a,b) (p)->lpVtbl->GetRenderState(p,a,b)
#define IDirect3DDevice9_CreateStateBlock(p,a,b) (p)->lpVtbl->CreateStateBlock(p,a,b)
#define IDirect3DDevice9_BeginStateBlock(p) (p)->lpVtbl->BeginStateBlock(p)
#define IDirect3DDevice9_EndStateBlock(p,a) (p)->lpVtbl->EndStateBlock(p,a)
#define IDirect3DDevice9_SetClipStatus(p,a) (p)->lpVtbl->SetClipStatus(p,a)
#define IDirect3DDevice9_GetClipStatus(p,a) (p)->lpVtbl->GetClipStatus(p,a)
#define IDirect3DDevice9_GetTexture(p,a,b) (p)->lpVtbl->GetTexture(p,a,b)
#define IDirect3DDevice9_SetTexture(p,a,b) (p)->lpVtbl->SetTexture(p,a,b)
#define IDirect3DDevice9_GetTextureStageState(p,a,b,c) (p)->lpVtbl->GetTextureStageState(p,a,b,c)
#define IDirect3DDevice9_SetTextureStageState(p,a,b,c) (p)->lpVtbl->SetTextureStageState(p,a,b,c)
#define IDirect3DDevice9_GetSamplerState(p,a,b,c) (p)->lpVtbl->GetSamplerState(p,a,b,c)
#define IDirect3DDevice9_SetSamplerState(p,a,b,c) (p)->lpVtbl->SetSamplerState(p,a,b,c)
#define IDirect3DDevice9_ValidateDevice(p,a) (p)->lpVtbl->ValidateDevice(p,a)
#define IDirect3DDevice9_SetPaletteEntries(p,a,b) (p)->lpVtbl->SetPaletteEntries(p,a,b)
#define IDirect3DDevice9_GetPaletteEntries(p,a,b) (p)->lpVtbl->GetPaletteEntries(p,a,b)
#define IDirect3DDevice9_SetCurrentTexturePalette(p,a) (p)->lpVtbl->SetCurrentTexturePalette(p,a)
#define IDirect3DDevice9_GetCurrentTexturePalette(p,a) (p)->lpVtbl->GetCurrentTexturePalette(p,a)
#define IDirect3DDevice9_SetScissorRect(p,a) (p)->lpVtbl->SetScissorRect(p,a)
#define IDirect3DDevice9_GetScissorRect(p,a) (p)->lpVtbl->GetScissorRect(p,a)
#define IDirect3DDevice9_SetSoftwareVertexProcessing(p,a) (p)->lpVtbl->SetSoftwareVertexProcessing(p,a)
#define IDirect3DDevice9_GetSoftwareVertexProcessing(p) (p)->lpVtbl->GetSoftwareVertexProcessing(p)
#define IDirect3DDevice9_SetNPatchMode(p,a) (p)->lpVtbl->SetNPatchMode(p,a)
#define IDirect3DDevice9_GetNPatchMode(p) (p)->lpVtbl->GetNPatchMode(p)
#define IDirect3DDevice9_DrawPrimitive(p,a,b,c) (p)->lpVtbl->DrawPrimitive(p,a,b,c)
#define IDirect3DDevice9_DrawIndexedPrimitive(p,a,b,c,d,e,f) (p)->lpVtbl->DrawIndexedPrimitive(p,a,b,c,d,e,f)
#define IDirect3DDevice9_DrawPrimitiveUP(p,a,b,c,d) (p)->lpVtbl->DrawPrimitiveUP(p,a,b,c,d)
#define IDirect3DDevice9_DrawIndexedPrimitiveUP(p,a,b,c,d,e,f,g,h) (p)->lpVtbl->DrawIndexedPrimitiveUP(p,a,b,c,d,e,f,g,h)
#define IDirect3DDevice9_ProcessVertices(p,a,b,c,d,e,f) (p)->lpVtbl->ProcessVertices(p,a,b,c,d,e,f)
#define IDirect3DDevice9_CreateVertexDeclaration(p,a,b) (p)->lpVtbl->CreateVertexDeclaration(p,a,b)
#define IDirect3DDevice9_SetVertexDeclaration(p,a) (p)->lpVtbl->SetVertexDeclaration(p,a)
#define IDirect3DDevice9_GetVertexDeclaration(p,a) (p)->lpVtbl->GetVertexDeclaration(p,a)
#define IDirect3DDevice9_SetFVF(p,a) (p)->lpVtbl->SetFVF(p,a)
#define IDirect3DDevice9_GetFVF(p,a) (p)->lpVtbl->GetFVF(p,a)
#define IDirect3DDevice9_CreateVertexShader(p,a,b) (p)->lpVtbl->CreateVertexShader(p,a,b)
#define IDirect3DDevice9_SetVertexShader(p,a) (p)->lpVtbl->SetVertexShader(p,a)
#define IDirect3DDevice9_GetVertexShader(p,a) (p)->lpVtbl->GetVertexShader(p,a)
#define IDirect3DDevice9_SetVertexShaderConstantF(p,a,b,c) (p)->lpVtbl->SetVertexShaderConstantF(p,a,b,c)
#define IDirect3DDevice9_GetVertexShaderConstantF(p,a,b,c) (p)->lpVtbl->GetVertexShaderConstantF(p,a,b,c)
#define IDirect3DDevice9_SetVertexShaderConstantI(p,a,b,c) (p)->lpVtbl->SetVertexShaderConstantI(p,a,b,c)
#define IDirect3DDevice9_GetVertexShaderConstantI(p,a,b,c) (p)->lpVtbl->GetVertexShaderConstantI(p,a,b,c)
#define IDirect3DDevice9_SetVertexShaderConstantB(p,a,b,c) (p)->lpVtbl->SetVertexShaderConstantB(p,a,b,c)
#define IDirect3DDevice9_GetVertexShaderConstantB(p,a,b,c) (p)->lpVtbl->GetVertexShaderConstantB(p,a,b,c)
#define IDirect3DDevice9_SetStreamSource(p,a,b,c,d) (p)->lpVtbl->SetStreamSource(p,a,b,c,d)
#define IDirect3DDevice9_GetStreamSource(p,a,b,c,d) (p)->lpVtbl->GetStreamSource(p,a,b,c,d)
#define IDirect3DDevice9_SetStreamSourceFreq(p,a,b) (p)->lpVtbl->SetStreamSourceFreq(p,a,b)
#define IDirect3DDevice9_GetStreamSourceFreq(p,a,b) (p)->lpVtbl->GetStreamSourceFreq(p,a,b)
#define IDirect3DDevice9_SetIndices(p,a) (p)->lpVtbl->SetIndices(p,a)
#define IDirect3DDevice9_GetIndices(p,a) (p)->lpVtbl->GetIndices(p,a)
#define IDirect3DDevice9_CreatePixelShader(p,a,b) (p)->lpVtbl->CreatePixelShader(p,a,b)
#define IDirect3DDevice9_SetPixelShader(p,a) (p)->lpVtbl->SetPixelShader(p,a)
#define IDirect3DDevice9_GetPixelShader(p,a) (p)->lpVtbl->GetPixelShader(p,a)
#define IDirect3DDevice9_SetPixelShaderConstantF(p,a,b,c) (p)->lpVtbl->SetPixelShaderConstantF(p,a,b,c)
#define IDirect3DDevice9_GetPixelShaderConstantF(p,a,b,c) (p)->lpVtbl->GetPixelShaderConstantF(p,a,b,c)
#define IDirect3DDevice9_SetPixelShaderConstantI(p,a,b,c) (p)->lpVtbl->SetPixelShaderConstantI(p,a,b,c)
#define IDirect3DDevice9_GetPixelShaderConstantI(p,a,b,c) (p)->lpVtbl->GetPixelShaderConstantI(p,a,b,c)
#define IDirect3DDevice9_SetPixelShaderConstantB(p,a,b,c) (p)->lpVtbl->SetPixelShaderConstantB(p,a,b,c)
#define IDirect3DDevice9_GetPixelShaderConstantB(p,a,b,c) (p)->lpVtbl->GetPixelShaderConstantB(p,a,b,c)
#define IDirect3DDevice9_DrawRectPatch(p,a,b,c) (p)->lpVtbl->DrawRectPatch(p,a,b,c)
#define IDirect3DDevice9_DrawTriPatch(p,a,b,c) (p)->lpVtbl->DrawTriPatch(p,a,b,c)
#define IDirect3DDevice9_DeletePatch(p,a) (p)->lpVtbl->DeletePatch(p,a)
#define IDirect3DDevice9_CreateQuery(p,a,b) (p)->lpVtbl->CreateQuery(p,a,b)

typedef struct IDirect3DDevice9ExVtbl
{
	/* IUnknown */
	HRESULT (WINAPI *QueryInterface)(IDirect3DDevice9Ex *This, REFIID riid, void **ppvObject);
	ULONG (WINAPI *AddRef)(IDirect3DDevice9Ex *This);
	ULONG (WINAPI *Release)(IDirect3DDevice9Ex *This);
	/* IDirect3DDevice9 */
	HRESULT (WINAPI *TestCooperativeLevel)(IDirect3DDevice9Ex *This);
	UINT (WINAPI *GetAvailableTextureMem)(IDirect3DDevice9Ex *This);
	HRESULT (WINAPI *EvictManagedResources)(IDirect3DDevice9Ex *This);
	HRESULT (WINAPI *GetDirect3D)(IDirect3DDevice9Ex *This, IDirect3D9 **ppD3D9);
	HRESULT (WINAPI *GetDeviceCaps)(IDirect3DDevice9Ex *This, D3DCAPS9 *pCaps);
	HRESULT (WINAPI *GetDisplayMode)(IDirect3DDevice9Ex *This, UINT iSwapChain, D3DDISPLAYMODE *pMode);
	HRESULT (WINAPI *GetCreationParameters)(IDirect3DDevice9Ex *This, D3DDEVICE_CREATION_PARAMETERS *pParameters);
	HRESULT (WINAPI *SetCursorProperties)(IDirect3DDevice9Ex *This, UINT XHotSpot, UINT YHotSpot, IDirect3DSurface9 *pCursorBitmap);
	void (WINAPI *SetCursorPosition)(IDirect3DDevice9Ex *This, int X, int Y, DWORD Flags);
	BOOL (WINAPI *ShowCursor)(IDirect3DDevice9Ex *This, BOOL bShow);
	HRESULT (WINAPI *CreateAdditionalSwapChain)(IDirect3DDevice9Ex *This, D3DPRESENT_PARAMETERS *pPresentationParameters, IDirect3DSwapChain9 **pSwapChain);
	HRESULT (WINAPI *GetSwapChain)(IDirect3DDevice9Ex *This, UINT iSwapChain, IDirect3DSwapChain9 **pSwapChain);
	UINT (WINAPI *GetNumberOfSwapChains)(IDirect3DDevice9Ex *This);
	HRESULT (WINAPI *Reset)(IDirect3DDevice9Ex *This, D3DPRESENT_PARAMETERS *pPresentationParameters);
	HRESULT (WINAPI *Present)(IDirect3DDevice9Ex *This, const RECT *pSourceRect, const RECT *pDestRect, HWND hDestWindowOverride, const RGNDATA *pDirtyRegion);
	HRESULT (WINAPI *GetBackBuffer)(IDirect3DDevice9Ex *This, UINT iSwapChain, UINT iBackBuffer, D3DBACKBUFFER_TYPE Type, IDirect3DSurface9 **ppBackBuffer);
	HRESULT (WINAPI *GetRasterStatus)(IDirect3DDevice9Ex *This, UINT iSwapChain, D3DRASTER_STATUS *pRasterStatus);
	HRESULT (WINAPI *SetDialogBoxMode)(IDirect3DDevice9Ex *This, BOOL bEnableDialogs);
	void (WINAPI *SetGammaRamp)(IDirect3DDevice9Ex *This, UINT iSwapChain, DWORD Flags, const D3DGAMMARAMP *pRamp);
	void (WINAPI *GetGammaRamp)(IDirect3DDevice9Ex *This, UINT iSwapChain, D3DGAMMARAMP *pRamp);
	HRESULT (WINAPI *CreateTexture)(IDirect3DDevice9Ex *This, UINT Width, UINT Height, UINT Levels, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool, IDirect3DTexture9 **ppTexture, HANDLE *pSharedHandle);
	HRESULT (WINAPI *CreateVolumeTexture)(IDirect3DDevice9Ex *This, UINT Width, UINT Height, UINT Depth, UINT Levels, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool, IDirect3DVolumeTexture9 **ppVolumeTexture, HANDLE *pSharedHandle);
	HRESULT (WINAPI *CreateCubeTexture)(IDirect3DDevice9Ex *This, UINT EdgeLength, UINT Levels, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool, IDirect3DCubeTexture9 **ppCubeTexture, HANDLE *pSharedHandle);
	HRESULT (WINAPI *CreateVertexBuffer)(IDirect3DDevice9Ex *This, UINT Length, DWORD Usage, DWORD FVF, D3DPOOL Pool, IDirect3DVertexBuffer9 **ppVertexBuffer, HANDLE *pSharedHandle);
	HRESULT (WINAPI *CreateIndexBuffer)(IDirect3DDevice9Ex *This, UINT Length, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool, IDirect3DIndexBuffer9 **ppIndexBuffer, HANDLE *pSharedHandle);
	HRESULT (WINAPI *CreateRenderTarget)(IDirect3DDevice9Ex *This, UINT Width, UINT Height, D3DFORMAT Format, D3DMULTISAMPLE_TYPE MultiSample, DWORD MultisampleQuality, BOOL Lockable, IDirect3DSurface9 **ppSurface, HANDLE *pSharedHandle);
	HRESULT (WINAPI *CreateDepthStencilSurface)(IDirect3DDevice9Ex *This, UINT Width, UINT Height, D3DFORMAT Format, D3DMULTISAMPLE_TYPE MultiSample, DWORD MultisampleQuality, BOOL Discard, IDirect3DSurface9 **ppSurface, HANDLE *pSharedHandle);
	HRESULT (WINAPI *UpdateSurface)(IDirect3DDevice9Ex *This, IDirect3DSurface9 *pSourceSurface, const RECT *pSourceRect, IDirect3DSurface9 *pDestinationSurface, const POINT *pDestPoint);
	HRESULT (WINAPI *UpdateTexture)(IDirect3DDevice9Ex *This, IDirect3DBaseTexture9 *pSourceTexture, IDirect3DBaseTexture9 *pDestinationTexture);
	HRESULT (WINAPI *GetRenderTargetData)(IDirect3DDevice9Ex *This, IDirect3DSurface9 *pRenderTarget, IDirect3DSurface9 *pDestSurface);
	HRESULT (WINAPI *GetFrontBufferData)(IDirect3DDevice9Ex *This, UINT iSwapChain, IDirect3DSurface9 *pDestSurface);
	HRESULT (WINAPI *StretchRect)(IDirect3DDevice9Ex *This, IDirect3DSurface9 *pSourceSurface, const RECT *pSourceRect, IDirect3DSurface9 *pDestSurface, const RECT *pDestRect, D3DTEXTUREFILTERTYPE Filter);
	HRESULT (WINAPI *ColorFill)(IDirect3DDevice9Ex *This, IDirect3DSurface9 *pSurface, const RECT *pRect, D3DCOLOR color);
	HRESULT (WINAPI *CreateOffscreenPlainSurface)(IDirect3DDevice9Ex *This, UINT Width, UINT Height, D3DFORMAT Format, D3DPOOL Pool, IDirect3DSurface9 **ppSurface, HANDLE *pSharedHandle);
	HRESULT (WINAPI *SetRenderTarget)(IDirect3DDevice9Ex *This, DWORD RenderTargetIndex, IDirect3DSurface9 *pRenderTarget);
	HRESULT (WINAPI *GetRenderTarget)(IDirect3DDevice9Ex *This, DWORD RenderTargetIndex, IDirect3DSurface9 **ppRenderTarget);
	HRESULT (WINAPI *SetDepthStencilSurface)(IDirect3DDevice9Ex *This, IDirect3DSurface9 *pNewZStencil);
	HRESULT (WINAPI *GetDepthStencilSurface)(IDirect3DDevice9Ex *This, IDirect3DSurface9 **ppZStencilSurface);
	HRESULT (WINAPI *BeginScene)(IDirect3DDevice9Ex *This);
	HRESULT (WINAPI *EndScene)(IDirect3DDevice9Ex *This);
	HRESULT (WINAPI *Clear)(IDirect3DDevice9Ex *This, DWORD Count, const D3DRECT *pRects, DWORD Flags, D3DCOLOR Color, float Z, DWORD Stencil);
	HRESULT (WINAPI *SetTransform)(IDirect3DDevice9Ex *This, D3DTRANSFORMSTATETYPE State, const D3DMATRIX *pMatrix);
	HRESULT (WINAPI *GetTransform)(IDirect3DDevice9Ex *This, D3DTRANSFORMSTATETYPE State, D3DMATRIX *pMatrix);
	HRESULT (WINAPI *MultiplyTransform)(IDirect3DDevice9Ex *This, D3DTRANSFORMSTATETYPE State, const D3DMATRIX *pMatrix);
	HRESULT (WINAPI *SetViewport)(IDirect3DDevice9Ex *This, const D3DVIEWPORT9 *pViewport);
	HRESULT (WINAPI *GetViewport)(IDirect3DDevice9Ex *This, D3DVIEWPORT9 *pViewport);
	HRESULT (WINAPI *SetMaterial)(IDirect3DDevice9Ex *This, const D3DMATERIAL9 *pMaterial);
	HRESULT (WINAPI *GetMaterial)(IDirect3DDevice9Ex *This, D3DMATERIAL9 *pMaterial);
	HRESULT (WINAPI *SetLight)(IDirect3DDevice9Ex *This, DWORD Index, const D3DLIGHT9 *pLight);
	HRESULT (WINAPI *GetLight)(IDirect3DDevice9Ex *This, DWORD Index, D3DLIGHT9 *pLight);
	HRESULT (WINAPI *LightEnable)(IDirect3DDevice9Ex *This, DWORD Index, BOOL Enable);
	HRESULT (WINAPI *GetLightEnable)(IDirect3DDevice9Ex *This, DWORD Index, BOOL *pEnable);
	HRESULT (WINAPI *SetClipPlane)(IDirect3DDevice9Ex *This, DWORD Index, const float *pPlane);
	HRESULT (WINAPI *GetClipPlane)(IDirect3DDevice9Ex *This, DWORD Index, float *pPlane);
	HRESULT (WINAPI *SetRenderState)(IDirect3DDevice9Ex *This, D3DRENDERSTATETYPE State, DWORD Value);
	HRESULT (WINAPI *GetRenderState)(IDirect3DDevice9Ex *This, D3DRENDERSTATETYPE State, DWORD *pValue);
	HRESULT (WINAPI *CreateStateBlock)(IDirect3DDevice9Ex *This, D3DSTATEBLOCKTYPE Type, IDirect3DStateBlock9 **ppSB);
	HRESULT (WINAPI *BeginStateBlock)(IDirect3DDevice9Ex *This);
	HRESULT (WINAPI *EndStateBlock)(IDirect3DDevice9Ex *This, IDirect3DStateBlock9 **ppSB);
	HRESULT (WINAPI *SetClipStatus)(IDirect3DDevice9Ex *This, const D3DCLIPSTATUS9 *pClipStatus);
	HRESULT (WINAPI *GetClipStatus)(IDirect3DDevice9Ex *This, D3DCLIPSTATUS9 *pClipStatus);
	HRESULT (WINAPI *GetTexture)(IDirect3DDevice9Ex *This, DWORD Stage, IDirect3DBaseTexture9 **ppTexture);
	HRESULT (WINAPI *SetTexture)(IDirect3DDevice9Ex *This, DWORD Stage, IDirect3DBaseTexture9 *pTexture);
	HRESULT (WINAPI *GetTextureStageState)(IDirect3DDevice9Ex *This, DWORD Stage, D3DTEXTURESTAGESTATETYPE Type, DWORD *pValue);
	HRESULT (WINAPI *SetTextureStageState)(IDirect3DDevice9Ex *This, DWORD Stage, D3DTEXTURESTAGESTATETYPE Type, DWORD Value);
	HRESULT (WINAPI *GetSamplerState)(IDirect3DDevice9Ex *This, DWORD Sampler, D3DSAMPLERSTATETYPE Type, DWORD *pValue);
	HRESULT (WINAPI *SetSamplerState)(IDirect3DDevice9Ex *This, DWORD Sampler, D3DSAMPLERSTATETYPE Type, DWORD Value);
	HRESULT (WINAPI *ValidateDevice)(IDirect3DDevice9Ex *This, DWORD *pNumPasses);
	HRESULT (WINAPI *SetPaletteEntries)(IDirect3DDevice9Ex *This, UINT PaletteNumber, const PALETTEENTRY *pEntries);
	HRESULT (WINAPI *GetPaletteEntries)(IDirect3DDevice9Ex *This, UINT PaletteNumber, PALETTEENTRY *pEntries);
	HRESULT (WINAPI *SetCurrentTexturePalette)(IDirect3DDevice9Ex *This, UINT PaletteNumber);
	HRESULT (WINAPI *GetCurrentTexturePalette)(IDirect3DDevice9Ex *This, UINT *PaletteNumber);
	HRESULT (WINAPI *SetScissorRect)(IDirect3DDevice9Ex *This, const RECT *pRect);
	HRESULT (WINAPI *GetScissorRect)(IDirect3DDevice9Ex *This, RECT *pRect);
	HRESULT (WINAPI *SetSoftwareVertexProcessing)(IDirect3DDevice9Ex *This, BOOL bSoftware);
	BOOL (WINAPI *GetSoftwareVertexProcessing)(IDirect3DDevice9Ex *This);
	HRESULT (WINAPI *SetNPatchMode)(IDirect3DDevice9Ex *This, float nSegments);
	float (WINAPI *GetNPatchMode)(IDirect3DDevice9Ex *This);
	HRESULT (WINAPI *DrawPrimitive)(IDirect3DDevice9Ex *This, D3DPRIMITIVETYPE PrimitiveType, UINT StartVertex, UINT PrimitiveCount);
	HRESULT (WINAPI *DrawIndexedPrimitive)(IDirect3DDevice9Ex *This, D3DPRIMITIVETYPE PrimitiveType, INT BaseVertexIndex, UINT MinVertexIndex, UINT NumVertices, UINT startIndex, UINT primCount);
	HRESULT (WINAPI *DrawPrimitiveUP)(IDirect3DDevice9Ex *This, D3DPRIMITIVETYPE PrimitiveType, UINT PrimitiveCount, const void *pVertexStreamZeroData, UINT VertexStreamZeroStride);
	HRESULT (WINAPI *DrawIndexedPrimitiveUP)(IDirect3DDevice9Ex *This, D3DPRIMITIVETYPE PrimitiveType, UINT MinVertexIndex, UINT NumVertices, UINT PrimitiveCount, const void *pIndexData, D3DFORMAT IndexDataFormat, const void *pVertexStreamZeroData, UINT VertexStreamZeroStride);
	HRESULT (WINAPI *ProcessVertices)(IDirect3DDevice9Ex *This, UINT SrcStartIndex, UINT DestIndex, UINT VertexCount, IDirect3DVertexBuffer9 *pDestBuffer, IDirect3DVertexDeclaration9 *pVertexDecl, DWORD Flags);
	HRESULT (WINAPI *CreateVertexDeclaration)(IDirect3DDevice9Ex *This, const D3DVERTEXELEMENT9 *pVertexElements, IDirect3DVertexDeclaration9 **ppDecl);
	HRESULT (WINAPI *SetVertexDeclaration)(IDirect3DDevice9Ex *This, IDirect3DVertexDeclaration9 *pDecl);
	HRESULT (WINAPI *GetVertexDeclaration)(IDirect3DDevice9Ex *This, IDirect3DVertexDeclaration9 **ppDecl);
	HRESULT (WINAPI *SetFVF)(IDirect3DDevice9Ex *This, DWORD FVF);
	HRESULT (WINAPI *GetFVF)(IDirect3DDevice9Ex *This, DWORD *pFVF);
	HRESULT (WINAPI *CreateVertexShader)(IDirect3DDevice9Ex *This, const DWORD *pFunction, IDirect3DVertexShader9 **ppShader);
	HRESULT (WINAPI *SetVertexShader)(IDirect3DDevice9Ex *This, IDirect3DVertexShader9 *pShader);
	HRESULT (WINAPI *GetVertexShader)(IDirect3DDevice9Ex *This, IDirect3DVertexShader9 **ppShader);
	HRESULT (WINAPI *SetVertexShaderConstantF)(IDirect3DDevice9Ex *This, UINT StartRegister, const float *pConstantData, UINT Vector4fCount);
	HRESULT (WINAPI *GetVertexShaderConstantF)(IDirect3DDevice9Ex *This, UINT StartRegister, float *pConstantData, UINT Vector4fCount);
	HRESULT (WINAPI *SetVertexShaderConstantI)(IDirect3DDevice9Ex *This, UINT StartRegister, const int *pConstantData, UINT Vector4iCount);
	HRESULT (WINAPI *GetVertexShaderConstantI)(IDirect3DDevice9Ex *This, UINT StartRegister, int *pConstantData, UINT Vector4iCount);
	HRESULT (WINAPI *SetVertexShaderConstantB)(IDirect3DDevice9Ex *This, UINT StartRegister, const BOOL *pConstantData, UINT BoolCount);
	HRESULT (WINAPI *GetVertexShaderConstantB)(IDirect3DDevice9Ex *This, UINT StartRegister, BOOL *pConstantData, UINT BoolCount);
	HRESULT (WINAPI *SetStreamSource)(IDirect3DDevice9Ex *This, UINT StreamNumber, IDirect3DVertexBuffer9 *pStreamData, UINT OffsetInBytes, UINT Stride);
	HRESULT (WINAPI *GetStreamSource)(IDirect3DDevice9Ex *This, UINT StreamNumber, IDirect3DVertexBuffer9 **ppStreamData, UINT *pOffsetInBytes, UINT *pStride);
	HRESULT (WINAPI *SetStreamSourceFreq)(IDirect3DDevice9Ex *This, UINT StreamNumber, UINT Setting);
	HRESULT (WINAPI *GetStreamSourceFreq)(IDirect3DDevice9Ex *This, UINT StreamNumber, UINT *pSetting);
	HRESULT (WINAPI *SetIndices)(IDirect3DDevice9Ex *This, IDirect3DIndexBuffer9 *pIndexData);
	HRESULT (WINAPI *GetIndices)(IDirect3DDevice9Ex *This, IDirect3DIndexBuffer9 **ppIndexData);
	HRESULT (WINAPI *CreatePixelShader)(IDirect3DDevice9Ex *This, const DWORD *pFunction, IDirect3DPixelShader9 **ppShader);
	HRESULT (WINAPI *SetPixelShader)(IDirect3DDevice9Ex *This, IDirect3DPixelShader9 *pShader);
	HRESULT (WINAPI *GetPixelShader)(IDirect3DDevice9Ex *This, IDirect3DPixelShader9 **ppShader);
	HRESULT (WINAPI *SetPixelShaderConstantF)(IDirect3DDevice9Ex *This, UINT StartRegister, const float *pConstantData, UINT Vector4fCount);
	HRESULT (WINAPI *GetPixelShaderConstantF)(IDirect3DDevice9Ex *This, UINT StartRegister, float *pConstantData, UINT Vector4fCount);
	HRESULT (WINAPI *SetPixelShaderConstantI)(IDirect3DDevice9Ex *This, UINT StartRegister, const int *pConstantData, UINT Vector4iCount);
	HRESULT (WINAPI *GetPixelShaderConstantI)(IDirect3DDevice9Ex *This, UINT StartRegister, int *pConstantData, UINT Vector4iCount);
	HRESULT (WINAPI *SetPixelShaderConstantB)(IDirect3DDevice9Ex *This, UINT StartRegister, const BOOL *pConstantData, UINT BoolCount);
	HRESULT (WINAPI *GetPixelShaderConstantB)(IDirect3DDevice9Ex *This, UINT StartRegister, BOOL *pConstantData, UINT BoolCount);
	HRESULT (WINAPI *DrawRectPatch)(IDirect3DDevice9Ex *This, UINT Handle, const float *pNumSegs, const D3DRECTPATCH_INFO *pRectPatchInfo);
	HRESULT (WINAPI *DrawTriPatch)(IDirect3DDevice9Ex *This, UINT Handle, const float *pNumSegs, const D3DTRIPATCH_INFO *pTriPatchInfo);
	HRESULT (WINAPI *DeletePatch)(IDirect3DDevice9Ex *This, UINT Handle);
	HRESULT (WINAPI *CreateQuery)(IDirect3DDevice9Ex *This, D3DQUERYTYPE Type, IDirect3DQuery9 **ppQuery);
	/* IDirect3DDevice9Ex */
	HRESULT (WINAPI *SetConvolutionMonoKernel)(IDirect3DDevice9Ex *This, UINT width, UINT height, float *rows, float *columns);
	HRESULT (WINAPI *ComposeRects)(IDirect3DDevice9Ex *This, IDirect3DSurface9 *pSrc, IDirect3DSurface9 *pDst, IDirect3DVertexBuffer9 *pSrcRectDescs, UINT NumRects, IDirect3DVertexBuffer9 *pDstRectDescs, D3DCOMPOSERECTSOP Operation, int Xoffset, int Yoffset);
	HRESULT (WINAPI *PresentEx)(IDirect3DDevice9Ex *This, const RECT *pSourceRect, const RECT *pDestRect, HWND hDestWindowOverride, const RGNDATA *pDirtyRegion, DWORD dwFlags);
	HRESULT (WINAPI *GetGPUThreadPriority)(IDirect3DDevice9Ex *This, INT *pPriority);
	HRESULT (WINAPI *SetGPUThreadPriority)(IDirect3DDevice9Ex *This, INT Priority);
	HRESULT (WINAPI *WaitForVBlank)(IDirect3DDevice9Ex *This, UINT iSwapChain);
	HRESULT (WINAPI *CheckResourceResidency)(IDirect3DDevice9Ex *This, IDirect3DResource9 **pResourceArray, UINT32 NumResources);
	HRESULT (WINAPI *SetMaximumFrameLatency)(IDirect3DDevice9Ex *This, UINT MaxLatency);
	HRESULT (WINAPI *GetMaximumFrameLatency)(IDirect3DDevice9Ex *This, UINT *pMaxLatency);
	HRESULT (WINAPI *CheckDeviceState)(IDirect3DDevice9Ex *This, HWND hDestinationWindow);
	HRESULT (WINAPI *CreateRenderTargetEx)(IDirect3DDevice9Ex *This, UINT Width, UINT Height, D3DFORMAT Format, D3DMULTISAMPLE_TYPE MultiSample, DWORD MultisampleQuality, BOOL Lockable, IDirect3DSurface9 **ppSurface, HANDLE *pSharedHandle, DWORD Usage);
	HRESULT (WINAPI *CreateOffscreenPlainSurfaceEx)(IDirect3DDevice9Ex *This, UINT Width, UINT Height, D3DFORMAT Format, D3DPOOL Pool, IDirect3DSurface9 **ppSurface, HANDLE *pSharedHandle, DWORD Usage);
	HRESULT (WINAPI *CreateDepthStencilSurfaceEx)(IDirect3DDevice9Ex *This, UINT Width, UINT Height, D3DFORMAT Format, D3DMULTISAMPLE_TYPE MultiSample, DWORD MultisampleQuality, BOOL Discard, IDirect3DSurface9 **ppSurface, HANDLE *pSharedHandle, DWORD Usage);
	HRESULT (WINAPI *ResetEx)(IDirect3DDevice9Ex *This, D3DPRESENT_PARAMETERS *pPresentationParameters, D3DDISPLAYMODEEX *pFullscreenDisplayMode);
	HRESULT (WINAPI *GetDisplayModeEx)(IDirect3DDevice9Ex *This, UINT iSwapChain, D3DDISPLAYMODEEX *pMode, D3DDISPLAYROTATION *pRotation);
} IDirect3DDevice9ExVtbl;
struct IDirect3DDevice9Ex
{
	IDirect3DDevice9ExVtbl *lpVtbl;
};

/* IUnknown macros */
#define IDirect3DDevice9Ex_QueryInterface(p,a,b) (p)->lpVtbl->QueryInterface(p,a,b)
#define IDirect3DDevice9Ex_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirect3DDevice9Ex_Release(p) (p)->lpVtbl->Release(p)
/* IDirect3DDevice9 macros */
#define IDirect3DDevice9Ex_TestCooperativeLevel(p) (p)->lpVtbl->TestCooperativeLevel(p)
#define IDirect3DDevice9Ex_GetAvailableTextureMem(p) (p)->lpVtbl->GetAvailableTextureMem(p)
#define IDirect3DDevice9Ex_EvictManagedResources(p) (p)->lpVtbl->EvictManagedResources(p)
#define IDirect3DDevice9Ex_GetDirect3D(p,a) (p)->lpVtbl->GetDirect3D(p,a)
#define IDirect3DDevice9Ex_GetDeviceCaps(p,a) (p)->lpVtbl->GetDeviceCaps(p,a)
#define IDirect3DDevice9Ex_GetDisplayMode(p,a,b) (p)->lpVtbl->GetDisplayMode(p,a,b)
#define IDirect3DDevice9Ex_GetCreationParameters(p,a) (p)->lpVtbl->GetCreationParameters(p,a)
#define IDirect3DDevice9Ex_SetCursorProperties(p,a,b,c) (p)->lpVtbl->SetCursorProperties(p,a,b,c)
#define IDirect3DDevice9Ex_SetCursorPosition(p,a,b,c) (p)->lpVtbl->SetCursorPosition(p,a,b,c)
#define IDirect3DDevice9Ex_ShowCursor(p,a) (p)->lpVtbl->ShowCursor(p,a)
#define IDirect3DDevice9Ex_CreateAdditionalSwapChain(p,a,b) (p)->lpVtbl->CreateAdditionalSwapChain(p,a,b)
#define IDirect3DDevice9Ex_GetSwapChain(p,a,b) (p)->lpVtbl->GetSwapChain(p,a,b)
#define IDirect3DDevice9Ex_GetNumberOfSwapChains(p) (p)->lpVtbl->GetNumberOfSwapChains(p)
#define IDirect3DDevice9Ex_Reset(p,a) (p)->lpVtbl->Reset(p,a)
#define IDirect3DDevice9Ex_Present(p,a,b,c,d) (p)->lpVtbl->Present(p,a,b,c,d)
#define IDirect3DDevice9Ex_GetBackBuffer(p,a,b,c,d) (p)->lpVtbl->GetBackBuffer(p,a,b,c,d)
#define IDirect3DDevice9Ex_GetRasterStatus(p,a,b) (p)->lpVtbl->GetRasterStatus(p,a,b)
#define IDirect3DDevice9Ex_SetDialogBoxMode(p,a) (p)->lpVtbl->SetDialogBoxMode(p,a)
#define IDirect3DDevice9Ex_SetGammaRamp(p,a,b,c) (p)->lpVtbl->SetGammaRamp(p,a,b,c)
#define IDirect3DDevice9Ex_GetGammaRamp(p,a,b) (p)->lpVtbl->GetGammaRamp(p,a,b)
#define IDirect3DDevice9Ex_CreateTexture(p,a,b,c,d,e,f,g,h) (p)->lpVtbl->CreateTexture(p,a,b,c,d,e,f,g,h)
#define IDirect3DDevice9Ex_CreateVolumeTexture(p,a,b,c,d,e,f,g,h,i) (p)->lpVtbl->CreateVolumeTexture(p,a,b,c,d,e,f,g,h,i)
#define IDirect3DDevice9Ex_CreateCubeTexture(p,a,b,c,d,e,f,g) (p)->lpVtbl->CreateCubeTexture(p,a,b,c,d,e,f,g)
#define IDirect3DDevice9Ex_CreateVertexBuffer(p,a,b,c,d,e,f) (p)->lpVtbl->CreateVertexBuffer(p,a,b,c,d,e,f)
#define IDirect3DDevice9Ex_CreateIndexBuffer(p,a,b,c,d,e,f) (p)->lpVtbl->CreateIndexBuffer(p,a,b,c,d,e,f)
#define IDirect3DDevice9Ex_CreateRenderTarget(p,a,b,c,d,e,f,g,h) (p)->lpVtbl->CreateRenderTarget(p,a,b,c,d,e,f,g,h)
#define IDirect3DDevice9Ex_CreateDepthStencilSurface(p,a,b,c,d,e,f,g,h) (p)->lpVtbl->CreateDepthStencilSurface(p,a,b,c,d,e,f,g,h)
#define IDirect3DDevice9Ex_UpdateSurface(p,a,b,c,d) (p)->lpVtbl->UpdateSurface(p,a,b,c,d)
#define IDirect3DDevice9Ex_UpdateTexture(p,a,b) (p)->lpVtbl->UpdateTexture(p,a,b)
#define IDirect3DDevice9Ex_GetRenderTargetData(p,a,b) (p)->lpVtbl->GetRenderTargetData(p,a,b)
#define IDirect3DDevice9Ex_GetFrontBufferData(p,a,b) (p)->lpVtbl->GetFrontBufferData(p,a,b)
#define IDirect3DDevice9Ex_StretchRect(p,a,b,c,d,e) (p)->lpVtbl->StretchRect(p,a,b,c,d,e)
#define IDirect3DDevice9Ex_ColorFill(p,a,b,c) (p)->lpVtbl->ColorFill(p,a,b,c)
#define IDirect3DDevice9Ex_CreateOffscreenPlainSurface(p,a,b,c,d,e,f) (p)->lpVtbl->CreateOffscreenPlainSurface(p,a,b,c,d,e,f)
#define IDirect3DDevice9Ex_SetRenderTarget(p,a,b) (p)->lpVtbl->SetRenderTarget(p,a,b)
#define IDirect3DDevice9Ex_GetRenderTarget(p,a,b) (p)->lpVtbl->GetRenderTarget(p,a,b)
#define IDirect3DDevice9Ex_SetDepthStencilSurface(p,a) (p)->lpVtbl->SetDepthStencilSurface(p,a)
#define IDirect3DDevice9Ex_GetDepthStencilSurface(p,a) (p)->lpVtbl->GetDepthStencilSurface(p,a)
#define IDirect3DDevice9Ex_BeginScene(p) (p)->lpVtbl->BeginScene(p)
#define IDirect3DDevice9Ex_EndScene(p) (p)->lpVtbl->EndScene(p)
#define IDirect3DDevice9Ex_Clear(p,a,b,c,d,e,f) (p)->lpVtbl->Clear(p,a,b,c,d,e,f)
#define IDirect3DDevice9Ex_SetTransform(p,a,b) (p)->lpVtbl->SetTransform(p,a,b)
#define IDirect3DDevice9Ex_GetTransform(p,a,b) (p)->lpVtbl->GetTransform(p,a,b)
#define IDirect3DDevice9Ex_MultiplyTransform(p,a,b) (p)->lpVtbl->MultiplyTransform(p,a,b)
#define IDirect3DDevice9Ex_SetViewport(p,a) (p)->lpVtbl->SetViewport(p,a)
#define IDirect3DDevice9Ex_GetViewport(p,a) (p)->lpVtbl->GetViewport(p,a)
#define IDirect3DDevice9Ex_SetMaterial(p,a) (p)->lpVtbl->SetMaterial(p,a)
#define IDirect3DDevice9Ex_GetMaterial(p,a) (p)->lpVtbl->GetMaterial(p,a)
#define IDirect3DDevice9Ex_SetLight(p,a,b) (p)->lpVtbl->SetLight(p,a,b)
#define IDirect3DDevice9Ex_GetLight(p,a,b) (p)->lpVtbl->GetLight(p,a,b)
#define IDirect3DDevice9Ex_LightEnable(p,a,b) (p)->lpVtbl->LightEnable(p,a,b)
#define IDirect3DDevice9Ex_GetLightEnable(p,a,b) (p)->lpVtbl->GetLightEnable(p,a,b)
#define IDirect3DDevice9Ex_SetClipPlane(p,a,b) (p)->lpVtbl->SetClipPlane(p,a,b)
#define IDirect3DDevice9Ex_GetClipPlane(p,a,b) (p)->lpVtbl->GetClipPlane(p,a,b)
#define IDirect3DDevice9Ex_SetRenderState(p,a,b) (p)->lpVtbl->SetRenderState(p,a,b)
#define IDirect3DDevice9Ex_GetRenderState(p,a,b) (p)->lpVtbl->GetRenderState(p,a,b)
#define IDirect3DDevice9Ex_CreateStateBlock(p,a,b) (p)->lpVtbl->CreateStateBlock(p,a,b)
#define IDirect3DDevice9Ex_BeginStateBlock(p) (p)->lpVtbl->BeginStateBlock(p)
#define IDirect3DDevice9Ex_EndStateBlock(p,a) (p)->lpVtbl->EndStateBlock(p,a)
#define IDirect3DDevice9Ex_SetClipStatus(p,a) (p)->lpVtbl->SetClipStatus(p,a)
#define IDirect3DDevice9Ex_GetClipStatus(p,a) (p)->lpVtbl->GetClipStatus(p,a)
#define IDirect3DDevice9Ex_GetTexture(p,a,b) (p)->lpVtbl->GetTexture(p,a,b)
#define IDirect3DDevice9Ex_SetTexture(p,a,b) (p)->lpVtbl->SetTexture(p,a,b)
#define IDirect3DDevice9Ex_GetTextureStageState(p,a,b,c) (p)->lpVtbl->GetTextureStageState(p,a,b,c)
#define IDirect3DDevice9Ex_SetTextureStageState(p,a,b,c) (p)->lpVtbl->SetTextureStageState(p,a,b,c)
#define IDirect3DDevice9Ex_GetSamplerState(p,a,b,c) (p)->lpVtbl->GetSamplerState(p,a,b,c)
#define IDirect3DDevice9Ex_SetSamplerState(p,a,b,c) (p)->lpVtbl->SetSamplerState(p,a,b,c)
#define IDirect3DDevice9Ex_ValidateDevice(p,a) (p)->lpVtbl->ValidateDevice(p,a)
#define IDirect3DDevice9Ex_SetPaletteEntries(p,a,b) (p)->lpVtbl->SetPaletteEntries(p,a,b)
#define IDirect3DDevice9Ex_GetPaletteEntries(p,a,b) (p)->lpVtbl->GetPaletteEntries(p,a,b)
#define IDirect3DDevice9Ex_SetCurrentTexturePalette(p,a) (p)->lpVtbl->SetCurrentTexturePalette(p,a)
#define IDirect3DDevice9Ex_GetCurrentTexturePalette(p,a) (p)->lpVtbl->GetCurrentTexturePalette(p,a)
#define IDirect3DDevice9Ex_SetScissorRect(p,a) (p)->lpVtbl->SetScissorRect(p,a)
#define IDirect3DDevice9Ex_GetScissorRect(p,a) (p)->lpVtbl->GetScissorRect(p,a)
#define IDirect3DDevice9Ex_SetSoftwareVertexProcessing(p,a) (p)->lpVtbl->SetSoftwareVertexProcessing(p,a)
#define IDirect3DDevice9Ex_GetSoftwareVertexProcessing(p) (p)->lpVtbl->GetSoftwareVertexProcessing(p)
#define IDirect3DDevice9Ex_SetNPatchMode(p,a) (p)->lpVtbl->SetNPatchMode(p,a)
#define IDirect3DDevice9Ex_GetNPatchMode(p) (p)->lpVtbl->GetNPatchMode(p)
#define IDirect3DDevice9Ex_DrawPrimitive(p,a,b,c) (p)->lpVtbl->DrawPrimitive(p,a,b,c)
#define IDirect3DDevice9Ex_DrawIndexedPrimitive(p,a,b,c,d,e,f) (p)->lpVtbl->DrawIndexedPrimitive(p,a,b,c,d,e,f)
#define IDirect3DDevice9Ex_DrawPrimitiveUP(p,a,b,c,d) (p)->lpVtbl->DrawPrimitiveUP(p,a,b,c,d)
#define IDirect3DDevice9Ex_DrawIndexedPrimitiveUP(p,a,b,c,d,e,f,g,h) (p)->lpVtbl->DrawIndexedPrimitiveUP(p,a,b,c,d,e,f,g,h)
#define IDirect3DDevice9Ex_ProcessVertices(p,a,b,c,d,e,f) (p)->lpVtbl->ProcessVertices(p,a,b,c,d,e,f)
#define IDirect3DDevice9Ex_CreateVertexDeclaration(p,a,b) (p)->lpVtbl->CreateVertexDeclaration(p,a,b)
#define IDirect3DDevice9Ex_SetVertexDeclaration(p,a) (p)->lpVtbl->SetVertexDeclaration(p,a)
#define IDirect3DDevice9Ex_GetVertexDeclaration(p,a) (p)->lpVtbl->GetVertexDeclaration(p,a)
#define IDirect3DDevice9Ex_SetFVF(p,a) (p)->lpVtbl->SetFVF(p,a)
#define IDirect3DDevice9Ex_GetFVF(p,a) (p)->lpVtbl->GetFVF(p,a)
#define IDirect3DDevice9Ex_CreateVertexShader(p,a,b) (p)->lpVtbl->CreateVertexShader(p,a,b)
#define IDirect3DDevice9Ex_SetVertexShader(p,a) (p)->lpVtbl->SetVertexShader(p,a)
#define IDirect3DDevice9Ex_GetVertexShader(p,a) (p)->lpVtbl->GetVertexShader(p,a)
#define IDirect3DDevice9Ex_SetVertexShaderConstantF(p,a,b,c) (p)->lpVtbl->SetVertexShaderConstantF(p,a,b,c)
#define IDirect3DDevice9Ex_GetVertexShaderConstantF(p,a,b,c) (p)->lpVtbl->GetVertexShaderConstantF(p,a,b,c)
#define IDirect3DDevice9Ex_SetVertexShaderConstantI(p,a,b,c) (p)->lpVtbl->SetVertexShaderConstantI(p,a,b,c)
#define IDirect3DDevice9Ex_GetVertexShaderConstantI(p,a,b,c) (p)->lpVtbl->GetVertexShaderConstantI(p,a,b,c)
#define IDirect3DDevice9Ex_SetVertexShaderConstantB(p,a,b,c) (p)->lpVtbl->SetVertexShaderConstantB(p,a,b,c)
#define IDirect3DDevice9Ex_GetVertexShaderConstantB(p,a,b,c) (p)->lpVtbl->GetVertexShaderConstantB(p,a,b,c)
#define IDirect3DDevice9Ex_SetStreamSource(p,a,b,c,d) (p)->lpVtbl->SetStreamSource(p,a,b,c,d)
#define IDirect3DDevice9Ex_GetStreamSource(p,a,b,c,d) (p)->lpVtbl->GetStreamSource(p,a,b,c,d)
#define IDirect3DDevice9Ex_SetStreamSourceFreq(p,a,b) (p)->lpVtbl->SetStreamSourceFreq(p,a,b)
#define IDirect3DDevice9Ex_GetStreamSourceFreq(p,a,b) (p)->lpVtbl->GetStreamSourceFreq(p,a,b)
#define IDirect3DDevice9Ex_SetIndices(p,a) (p)->lpVtbl->SetIndices(p,a)
#define IDirect3DDevice9Ex_GetIndices(p,a) (p)->lpVtbl->GetIndices(p,a)
#define IDirect3DDevice9Ex_CreatePixelShader(p,a,b) (p)->lpVtbl->CreatePixelShader(p,a,b)
#define IDirect3DDevice9Ex_SetPixelShader(p,a) (p)->lpVtbl->SetPixelShader(p,a)
#define IDirect3DDevice9Ex_GetPixelShader(p,a) (p)->lpVtbl->GetPixelShader(p,a)
#define IDirect3DDevice9Ex_SetPixelShaderConstantF(p,a,b,c) (p)->lpVtbl->SetPixelShaderConstantF(p,a,b,c)
#define IDirect3DDevice9Ex_GetPixelShaderConstantF(p,a,b,c) (p)->lpVtbl->GetPixelShaderConstantF(p,a,b,c)
#define IDirect3DDevice9Ex_SetPixelShaderConstantI(p,a,b,c) (p)->lpVtbl->SetPixelShaderConstantI(p,a,b,c)
#define IDirect3DDevice9Ex_GetPixelShaderConstantI(p,a,b,c) (p)->lpVtbl->GetPixelShaderConstantI(p,a,b,c)
#define IDirect3DDevice9Ex_SetPixelShaderConstantB(p,a,b,c) (p)->lpVtbl->SetPixelShaderConstantB(p,a,b,c)
#define IDirect3DDevice9Ex_GetPixelShaderConstantB(p,a,b,c) (p)->lpVtbl->GetPixelShaderConstantB(p,a,b,c)
#define IDirect3DDevice9Ex_DrawRectPatch(p,a,b,c) (p)->lpVtbl->DrawRectPatch(p,a,b,c)
#define IDirect3DDevice9Ex_DrawTriPatch(p,a,b,c) (p)->lpVtbl->DrawTriPatch(p,a,b,c)
#define IDirect3DDevice9Ex_DeletePatch(p,a) (p)->lpVtbl->DeletePatch(p,a)
#define IDirect3DDevice9Ex_CreateQuery(p,a,b) (p)->lpVtbl->CreateQuery(p,a,b)
/* IDirect3DDevice9Ex macros */
#define IDirect3DDevice9Ex_SetConvolutionMonoKernel(p,a,b,c,d) (p)->lpVtbl->SetConvolutionMonoKernel(p,a,b,c,d)
#define IDirect3DDevice9Ex_ComposeRects(p,a,b,c,d,e,f,g,h) (p)->lpVtbl->ComposeRects(p,a,b,c,d,e,f,g,h)
#define IDirect3DDevice9Ex_PresentEx(p,a,b,c,d,e) (p)->lpVtbl->PresentEx(p,a,b,c,d,e)
#define IDirect3DDevice9Ex_GetGPUThreadPriority(p,a) (p)->lpVtbl->GetGPUThreadPriority(p,a)
#define IDirect3DDevice9Ex_SetGPUThreadPriority(p,a) (p)->lpVtbl->SetGPUThreadPriority(p,a)
#define IDirect3DDevice9Ex_WaitForVBlank(p,a) (p)->lpVtbl->WaitForVBlank(p,a)
#define IDirect3DDevice9Ex_CheckResourceResidency(p,a,b) (p)->lpVtbl->CheckResourceResidency(p,a,b)
#define IDirect3DDevice9Ex_SetMaximumFrameLatency(p,a) (p)->lpVtbl->SetMaximumFrameLatency(p,a)
#define IDirect3DDevice9Ex_GetMaximumFrameLatency(p,a) (p)->lpVtbl->GetMaximumFrameLatency(p,a)
#define IDirect3DDevice9Ex_CheckDeviceState(p,a) (p)->lpVtbl->CheckDeviceState(p,a)
#define IDirect3DDevice9Ex_CreateRenderTargetEx(p,a,b,c,d,e,f,g,h,i) (p)->lpVtbl->CreateRenderTargetEx(p,a,b,c,d,e,f,g,h,i)
#define IDirect3DDevice9Ex_CreateOffscreenPlainSurfaceEx(p,a,b,c,d,e,f,g) (p)->lpVtbl->CreateOffscreenPlainSurfaceEx(p,a,b,c,d,e,f,g)
#define IDirect3DDevice9Ex_CreateDepthStencilSurfaceEx(p,a,b,c,d,e,f,g,h,i) (p)->lpVtbl->CreateDepthStencilSurfaceEx(p,a,b,c,d,e,f,g,h,i)
#define IDirect3DDevice9Ex_ResetEx(p,a,b) (p)->lpVtbl->ResetEx(p,a,b)
#define IDirect3DDevice9Ex_GetDisplayModeEx(p,a,b,c) (p)->lpVtbl->GetDisplayModeEx(p,a,b,c)

typedef struct IDirect3DDevice9VideoVtbl
{
	/* IUnknown */
	HRESULT (WINAPI *QueryInterface)(IDirect3DDevice9Video *This, REFIID riid, void **ppvObject);
	ULONG (WINAPI *AddRef)(IDirect3DDevice9Video *This);
	ULONG (WINAPI *Release)(IDirect3DDevice9Video *This);
	/* IDirect3DDevice9Video */
	HRESULT (WINAPI *GetContentProtectionCaps)(IDirect3DDevice9Video *This, const GUID *pCryptoType, const GUID *pDecodeProfile, D3DCONTENTPROTECTIONCAPS *pCaps);
	HRESULT (WINAPI *CreateAuthenticatedChannel)(IDirect3DDevice9Video *This, D3DAUTHENTICATEDCHANNELTYPE ChannelType, IDirect3DAuthenticatedChannel9 **ppAuthenticatedChannel, HANDLE *pChannelHandle);
	HRESULT (WINAPI *CreateCryptoSession)(IDirect3DDevice9Video *This, const GUID *pCryptoType, const GUID *pDecodeProfile, IDirect3DCryptoSession9 **ppCryptoSession, HANDLE *pCryptoHandle);
} IDirect3DDevice9VideoVtbl;
struct IDirect3DDevice9Video
{
	IDirect3DDevice9VideoVtbl *lpVtbl;
};

/* IUnknown macros */
#define IDirect3DDevice9Video_QueryInterface(p,a,b) (p)->lpVtbl->QueryInterface(p,a,b)
#define IDirect3DDevice9Video_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirect3DDevice9Video_Release(p) (p)->lpVtbl->Release(p)
/* IDirect3DDevice9Video macros */
#define IDirect3DDevice9Video_GetContentProtectionCaps(p,a,b,c) (p)->lpVtbl->GetContentProtectionCaps(p,a,b,c)
#define IDirect3DDevice9Video_CreateAuthenticatedChannel(p,a,b,c) (p)->lpVtbl->CreateAuthenticatedChannel(p,a,b,c)
#define IDirect3DDevice9Video_CreateCryptoSession(p,a,b,c,d) (p)->lpVtbl->CreateCryptoSession(p,a,b,c,d)

typedef struct IDirect3DIndexBuffer9Vtbl
{
	/* IUnknown */
	HRESULT (WINAPI *QueryInterface)(IDirect3DIndexBuffer9 *This, REFIID riid, void **ppvObject);
	ULONG (WINAPI *AddRef)(IDirect3DIndexBuffer9 *This);
	ULONG (WINAPI *Release)(IDirect3DIndexBuffer9 *This);
	/* IDirect3DResource9 */
	HRESULT (WINAPI *GetDevice)(IDirect3DIndexBuffer9 *This, IDirect3DDevice9 **ppDevice);
	HRESULT (WINAPI *SetPrivateData)(IDirect3DIndexBuffer9 *This, REFGUID refguid, const void *pData, DWORD SizeOfData, DWORD Flags);
	HRESULT (WINAPI *GetPrivateData)(IDirect3DIndexBuffer9 *This, REFGUID refguid, void *pData, DWORD *pSizeOfData);
	HRESULT (WINAPI *FreePrivateData)(IDirect3DIndexBuffer9 *This, REFGUID refguid);
	DWORD (WINAPI *SetPriority)(IDirect3DIndexBuffer9 *This, DWORD PriorityNew);
	DWORD (WINAPI *GetPriority)(IDirect3DIndexBuffer9 *This);
	void (WINAPI *PreLoad)(IDirect3DIndexBuffer9 *This);
	D3DRESOURCETYPE (WINAPI *GetType)(IDirect3DIndexBuffer9 *This);
	/* IDirect3DIndexBuffer9 */
	HRESULT (WINAPI *Lock)(IDirect3DIndexBuffer9 *This, UINT OffsetToLock, UINT SizeToLock, void **ppbData, DWORD Flags);
	HRESULT (WINAPI *Unlock)(IDirect3DIndexBuffer9 *This);
	HRESULT (WINAPI *GetDesc)(IDirect3DIndexBuffer9 *This, D3DINDEXBUFFER_DESC *pDesc);
} IDirect3DIndexBuffer9Vtbl;
struct IDirect3DIndexBuffer9
{
	IDirect3DIndexBuffer9Vtbl *lpVtbl;
};

/* IUnknown macros */
#define IDirect3DIndexBuffer9_QueryInterface(p,a,b) (p)->lpVtbl->QueryInterface(p,a,b)
#define IDirect3DIndexBuffer9_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirect3DIndexBuffer9_Release(p) (p)->lpVtbl->Release(p)
/* IDirect3DResource9 macros */
#define IDirect3DIndexBuffer9_GetDevice(p,a) (p)->lpVtbl->GetDevice(p,a)
#define IDirect3DIndexBuffer9_SetPrivateData(p,a,b,c,d) (p)->lpVtbl->SetPrivateData(p,a,b,c,d)
#define IDirect3DIndexBuffer9_GetPrivateData(p,a,b,c) (p)->lpVtbl->GetPrivateData(p,a,b,c)
#define IDirect3DIndexBuffer9_FreePrivateData(p,a) (p)->lpVtbl->FreePrivateData(p,a)
#define IDirect3DIndexBuffer9_SetPriority(p,a) (p)->lpVtbl->SetPriority(p,a)
#define IDirect3DIndexBuffer9_GetPriority(p) (p)->lpVtbl->GetPriority(p)
#define IDirect3DIndexBuffer9_PreLoad(p) (p)->lpVtbl->PreLoad(p)
#define IDirect3DIndexBuffer9_GetType(p) (p)->lpVtbl->GetType(p)
/* IDirect3DIndexBuffer9 macros */
#define IDirect3DIndexBuffer9_Lock(p,a,b,c,d) (p)->lpVtbl->Lock(p,a,b,c,d)
#define IDirect3DIndexBuffer9_Unlock(p) (p)->lpVtbl->Unlock(p)
#define IDirect3DIndexBuffer9_GetDesc(p,a) (p)->lpVtbl->GetDesc(p,a)

typedef struct IDirect3DPixelShader9Vtbl
{
	/* IUnknown */
	HRESULT (WINAPI *QueryInterface)(IDirect3DPixelShader9 *This, REFIID riid, void **ppvObject);
	ULONG (WINAPI *AddRef)(IDirect3DPixelShader9 *This);
	ULONG (WINAPI *Release)(IDirect3DPixelShader9 *This);
	/* IDirect3DPixelShader9 */
	HRESULT (WINAPI *GetDevice)(IDirect3DPixelShader9 *This, IDirect3DDevice9 **ppDevice);
	HRESULT (WINAPI *GetFunction)(IDirect3DPixelShader9 *This, void *pData, UINT *pSizeOfData);
} IDirect3DPixelShader9Vtbl;
struct IDirect3DPixelShader9
{
	IDirect3DPixelShader9Vtbl *lpVtbl;
};

/* IUnknown macros */
#define IDirect3DPixelShader9_QueryInterface(p,a,b) (p)->lpVtbl->QueryInterface(p,a,b)
#define IDirect3DPixelShader9_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirect3DPixelShader9_Release(p) (p)->lpVtbl->Release(p)
/* IDirect3DPixelShader9 macros */
#define IDirect3DPixelShader9_GetDevice(p,a) (p)->lpVtbl->GetDevice(p,a)
#define IDirect3DPixelShader9_GetFunction(p,a,b) (p)->lpVtbl->GetFunction(p,a,b)

typedef struct IDirect3DQuery9Vtbl
{
	/* IUnknown */
	HRESULT (WINAPI *QueryInterface)(IDirect3DQuery9 *This, REFIID riid, void **ppvObject);
	ULONG (WINAPI *AddRef)(IDirect3DQuery9 *This);
	ULONG (WINAPI *Release)(IDirect3DQuery9 *This);
	/* IDirect3DQuery9 */
	HRESULT (WINAPI *GetDevice)(IDirect3DQuery9 *This, IDirect3DDevice9 **ppDevice);
	D3DQUERYTYPE (WINAPI *GetType)(IDirect3DQuery9 *This);
	DWORD (WINAPI *GetDataSize)(IDirect3DQuery9 *This);
	HRESULT (WINAPI *Issue)(IDirect3DQuery9 *This, DWORD dwIssueFlags);
	HRESULT (WINAPI *GetData)(IDirect3DQuery9 *This, void *pData, DWORD dwSize, DWORD dwGetDataFlags);
} IDirect3DQuery9Vtbl;
struct IDirect3DQuery9
{
	IDirect3DQuery9Vtbl *lpVtbl;
};

/* IUnknown macros */
#define IDirect3DQuery9_QueryInterface(p,a,b) (p)->lpVtbl->QueryInterface(p,a,b)
#define IDirect3DQuery9_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirect3DQuery9_Release(p) (p)->lpVtbl->Release(p)
/* IDirect3DQuery9 macros */
#define IDirect3DQuery9_GetDevice(p,a) (p)->lpVtbl->GetDevice(p,a)
#define IDirect3DQuery9_GetType(p) (p)->lpVtbl->GetType(p)
#define IDirect3DQuery9_GetDataSize(p) (p)->lpVtbl->GetDataSize(p)
#define IDirect3DQuery9_Issue(p,a) (p)->lpVtbl->Issue(p,a)
#define IDirect3DQuery9_GetData(p,a,b,c) (p)->lpVtbl->GetData(p,a,b,c)

typedef struct IDirect3DResource9Vtbl
{
	/* IUnknown */
	HRESULT (WINAPI *QueryInterface)(IDirect3DResource9 *This, REFIID riid, void **ppvObject);
	ULONG (WINAPI *AddRef)(IDirect3DResource9 *This);
	ULONG (WINAPI *Release)(IDirect3DResource9 *This);
	/* IDirect3DResource9 */
	HRESULT (WINAPI *GetDevice)(IDirect3DResource9 *This, IDirect3DDevice9 **ppDevice);
	HRESULT (WINAPI *SetPrivateData)(IDirect3DResource9 *This, REFGUID refguid, const void *pData, DWORD SizeOfData, DWORD Flags);
	HRESULT (WINAPI *GetPrivateData)(IDirect3DResource9 *This, REFGUID refguid, void *pData, DWORD *pSizeOfData);
	HRESULT (WINAPI *FreePrivateData)(IDirect3DResource9 *This, REFGUID refguid);
	DWORD (WINAPI *SetPriority)(IDirect3DResource9 *This, DWORD PriorityNew);
	DWORD (WINAPI *GetPriority)(IDirect3DResource9 *This);
	void (WINAPI *PreLoad)(IDirect3DResource9 *This);
	D3DRESOURCETYPE (WINAPI *GetType)(IDirect3DResource9 *This);
} IDirect3DResource9Vtbl;
struct IDirect3DResource9
{
	IDirect3DResource9Vtbl *lpVtbl;
};

/* IUnknown macros */
#define IDirect3DResource9_QueryInterface(p,a,b) (p)->lpVtbl->QueryInterface(p,a,b)
#define IDirect3DResource9_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirect3DResource9_Release(p) (p)->lpVtbl->Release(p)
/* IDirect3DResource9 macros */
#define IDirect3DResource9_GetDevice(p,a) (p)->lpVtbl->GetDevice(p,a)
#define IDirect3DResource9_SetPrivateData(p,a,b,c,d) (p)->lpVtbl->SetPrivateData(p,a,b,c,d)
#define IDirect3DResource9_GetPrivateData(p,a,b,c) (p)->lpVtbl->GetPrivateData(p,a,b,c)
#define IDirect3DResource9_FreePrivateData(p,a) (p)->lpVtbl->FreePrivateData(p,a)
#define IDirect3DResource9_SetPriority(p,a) (p)->lpVtbl->SetPriority(p,a)
#define IDirect3DResource9_GetPriority(p) (p)->lpVtbl->GetPriority(p)
#define IDirect3DResource9_PreLoad(p) (p)->lpVtbl->PreLoad(p)
#define IDirect3DResource9_GetType(p) (p)->lpVtbl->GetType(p)

typedef struct IDirect3DStateBlock9Vtbl
{
	/* IUnknown */
	HRESULT (WINAPI *QueryInterface)(IDirect3DStateBlock9 *This, REFIID riid, void **ppvObject);
	ULONG (WINAPI *AddRef)(IDirect3DStateBlock9 *This);
	ULONG (WINAPI *Release)(IDirect3DStateBlock9 *This);
	/* IDirect3DStateBlock9 */
	HRESULT (WINAPI *GetDevice)(IDirect3DStateBlock9 *This, IDirect3DDevice9 **ppDevice);
	HRESULT (WINAPI *Capture)(IDirect3DStateBlock9 *This);
	HRESULT (WINAPI *Apply)(IDirect3DStateBlock9 *This);
} IDirect3DStateBlock9Vtbl;
struct IDirect3DStateBlock9
{
	IDirect3DStateBlock9Vtbl *lpVtbl;
};

/* IUnknown macros */
#define IDirect3DStateBlock9_QueryInterface(p,a,b) (p)->lpVtbl->QueryInterface(p,a,b)
#define IDirect3DStateBlock9_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirect3DStateBlock9_Release(p) (p)->lpVtbl->Release(p)
/* IDirect3DStateBlock9 macros */
#define IDirect3DStateBlock9_GetDevice(p,a) (p)->lpVtbl->GetDevice(p,a)
#define IDirect3DStateBlock9_Capture(p) (p)->lpVtbl->Capture(p)
#define IDirect3DStateBlock9_Apply(p) (p)->lpVtbl->Apply(p)

typedef struct IDirect3DSurface9Vtbl
{
	/* IUnknown */
	HRESULT (WINAPI *QueryInterface)(IDirect3DSurface9 *This, REFIID riid, void **ppvObject);
	ULONG (WINAPI *AddRef)(IDirect3DSurface9 *This);
	ULONG (WINAPI *Release)(IDirect3DSurface9 *This);
	/* IDirect3DResource9 */
	HRESULT (WINAPI *GetDevice)(IDirect3DSurface9 *This, IDirect3DDevice9 **ppDevice);
	HRESULT (WINAPI *SetPrivateData)(IDirect3DSurface9 *This, REFGUID refguid, const void *pData, DWORD SizeOfData, DWORD Flags);
	HRESULT (WINAPI *GetPrivateData)(IDirect3DSurface9 *This, REFGUID refguid, void *pData, DWORD *pSizeOfData);
	HRESULT (WINAPI *FreePrivateData)(IDirect3DSurface9 *This, REFGUID refguid);
	DWORD (WINAPI *SetPriority)(IDirect3DSurface9 *This, DWORD PriorityNew);
	DWORD (WINAPI *GetPriority)(IDirect3DSurface9 *This);
	void (WINAPI *PreLoad)(IDirect3DSurface9 *This);
	D3DRESOURCETYPE (WINAPI *GetType)(IDirect3DSurface9 *This);
	/* IDirect3DSurface9 */
	HRESULT (WINAPI *GetContainer)(IDirect3DSurface9 *This, REFIID riid, void **ppContainer);
	HRESULT (WINAPI *GetDesc)(IDirect3DSurface9 *This, D3DSURFACE_DESC *pDesc);
	HRESULT (WINAPI *LockRect)(IDirect3DSurface9 *This, D3DLOCKED_RECT *pLockedRect, const RECT *pRect, DWORD Flags);
	HRESULT (WINAPI *UnlockRect)(IDirect3DSurface9 *This);
	HRESULT (WINAPI *GetDC)(IDirect3DSurface9 *This, HDC *phdc);
	HRESULT (WINAPI *ReleaseDC)(IDirect3DSurface9 *This, HDC hdc);
} IDirect3DSurface9Vtbl;
struct IDirect3DSurface9
{
	IDirect3DSurface9Vtbl *lpVtbl;
};

/* IUnknown macros */
#define IDirect3DSurface9_QueryInterface(p,a,b) (p)->lpVtbl->QueryInterface(p,a,b)
#define IDirect3DSurface9_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirect3DSurface9_Release(p) (p)->lpVtbl->Release(p)
/* IDirect3DResource9 macros */
#define IDirect3DSurface9_GetDevice(p,a) (p)->lpVtbl->GetDevice(p,a)
#define IDirect3DSurface9_SetPrivateData(p,a,b,c,d) (p)->lpVtbl->SetPrivateData(p,a,b,c,d)
#define IDirect3DSurface9_GetPrivateData(p,a,b,c) (p)->lpVtbl->GetPrivateData(p,a,b,c)
#define IDirect3DSurface9_FreePrivateData(p,a) (p)->lpVtbl->FreePrivateData(p,a)
#define IDirect3DSurface9_SetPriority(p,a) (p)->lpVtbl->SetPriority(p,a)
#define IDirect3DSurface9_GetPriority(p) (p)->lpVtbl->GetPriority(p)
#define IDirect3DSurface9_PreLoad(p) (p)->lpVtbl->PreLoad(p)
#define IDirect3DSurface9_GetType(p) (p)->lpVtbl->GetType(p)
/* IDirect3DSurface9 macros */
#define IDirect3DSurface9_GetContainer(p,a,b) (p)->lpVtbl->GetContainer(p,a,b)
#define IDirect3DSurface9_GetDesc(p,a) (p)->lpVtbl->GetDesc(p,a)
#define IDirect3DSurface9_LockRect(p,a,b,c) (p)->lpVtbl->LockRect(p,a,b,c)
#define IDirect3DSurface9_UnlockRect(p) (p)->lpVtbl->UnlockRect(p)
#define IDirect3DSurface9_GetDC(p,a) (p)->lpVtbl->GetDC(p,a)
#define IDirect3DSurface9_ReleaseDC(p,a) (p)->lpVtbl->ReleaseDC(p,a)

typedef struct IDirect3DSwapChain9Vtbl
{
	/* IUnknown */
	HRESULT (WINAPI *QueryInterface)(IDirect3DSwapChain9 *This, REFIID riid, void **ppvObject);
	ULONG (WINAPI *AddRef)(IDirect3DSwapChain9 *This);
	ULONG (WINAPI *Release)(IDirect3DSwapChain9 *This);
	/* IDirect3DSwapChain9 */
	HRESULT (WINAPI *Present)(IDirect3DSwapChain9 *This, const RECT *pSourceRect, const RECT *pDestRect, HWND hDestWindowOverride, const RGNDATA *pDirtyRegion, DWORD dwFlags);
	HRESULT (WINAPI *GetFrontBufferData)(IDirect3DSwapChain9 *This, IDirect3DSurface9 *pDestSurface);
	HRESULT (WINAPI *GetBackBuffer)(IDirect3DSwapChain9 *This, UINT iBackBuffer, D3DBACKBUFFER_TYPE Type, IDirect3DSurface9 **ppBackBuffer);
	HRESULT (WINAPI *GetRasterStatus)(IDirect3DSwapChain9 *This, D3DRASTER_STATUS *pRasterStatus);
	HRESULT (WINAPI *GetDisplayMode)(IDirect3DSwapChain9 *This, D3DDISPLAYMODE *pMode);
	HRESULT (WINAPI *GetDevice)(IDirect3DSwapChain9 *This, IDirect3DDevice9 **ppDevice);
	HRESULT (WINAPI *GetPresentParameters)(IDirect3DSwapChain9 *This, D3DPRESENT_PARAMETERS *pPresentationParameters);
} IDirect3DSwapChain9Vtbl;
struct IDirect3DSwapChain9
{
	IDirect3DSwapChain9Vtbl *lpVtbl;
};

/* IUnknown macros */
#define IDirect3DSwapChain9_QueryInterface(p,a,b) (p)->lpVtbl->QueryInterface(p,a,b)
#define IDirect3DSwapChain9_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirect3DSwapChain9_Release(p) (p)->lpVtbl->Release(p)
/* IDirect3DSwapChain9 macros */
#define IDirect3DSwapChain9_Present(p,a,b,c,d,e) (p)->lpVtbl->Present(p,a,b,c,d,e)
#define IDirect3DSwapChain9_GetFrontBufferData(p,a) (p)->lpVtbl->GetFrontBufferData(p,a)
#define IDirect3DSwapChain9_GetBackBuffer(p,a,b,c) (p)->lpVtbl->GetBackBuffer(p,a,b,c)
#define IDirect3DSwapChain9_GetRasterStatus(p,a) (p)->lpVtbl->GetRasterStatus(p,a)
#define IDirect3DSwapChain9_GetDisplayMode(p,a) (p)->lpVtbl->GetDisplayMode(p,a)
#define IDirect3DSwapChain9_GetDevice(p,a) (p)->lpVtbl->GetDevice(p,a)
#define IDirect3DSwapChain9_GetPresentParameters(p,a) (p)->lpVtbl->GetPresentParameters(p,a)

typedef struct IDirect3DSwapChain9ExVtbl
{
	/* IUnknown */
	HRESULT (WINAPI *QueryInterface)(IDirect3DSwapChain9Ex *This, REFIID riid, void **ppvObject);
	ULONG (WINAPI *AddRef)(IDirect3DSwapChain9Ex *This);
	ULONG (WINAPI *Release)(IDirect3DSwapChain9Ex *This);
	/* IDirect3DSwapChain9 */
	HRESULT (WINAPI *Present)(IDirect3DSwapChain9Ex *This, const RECT *pSourceRect, const RECT *pDestRect, HWND hDestWindowOverride, const RGNDATA *pDirtyRegion, DWORD dwFlags);
	HRESULT (WINAPI *GetFrontBufferData)(IDirect3DSwapChain9Ex *This, IDirect3DSurface9 *pDestSurface);
	HRESULT (WINAPI *GetBackBuffer)(IDirect3DSwapChain9Ex *This, UINT iBackBuffer, D3DBACKBUFFER_TYPE Type, IDirect3DSurface9 **ppBackBuffer);
	HRESULT (WINAPI *GetRasterStatus)(IDirect3DSwapChain9Ex *This, D3DRASTER_STATUS *pRasterStatus);
	HRESULT (WINAPI *GetDisplayMode)(IDirect3DSwapChain9Ex *This, D3DDISPLAYMODE *pMode);
	HRESULT (WINAPI *GetDevice)(IDirect3DSwapChain9Ex *This, IDirect3DDevice9 **ppDevice);
	HRESULT (WINAPI *GetPresentParameters)(IDirect3DSwapChain9Ex *This, D3DPRESENT_PARAMETERS *pPresentationParameters);
	/* IDirect3DSwapChain9Ex */
	HRESULT (WINAPI *GetLastPresentCount)(IDirect3DSwapChain9Ex *This, UINT *pLastPresentCount);
	HRESULT (WINAPI *GetPresentStats)(IDirect3DSwapChain9Ex *This, D3DPRESENTSTATS *pPresentationStatistics);
	HRESULT (WINAPI *GetDisplayModeEx)(IDirect3DSwapChain9Ex *This, D3DDISPLAYMODEEX *pMode, D3DDISPLAYROTATION *pRotation);
} IDirect3DSwapChain9ExVtbl;
struct IDirect3DSwapChain9Ex
{
	IDirect3DSwapChain9ExVtbl *lpVtbl;
};

/* IUnknown macros */
#define IDirect3DSwapChain9Ex_QueryInterface(p,a,b) (p)->lpVtbl->QueryInterface(p,a,b)
#define IDirect3DSwapChain9Ex_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirect3DSwapChain9Ex_Release(p) (p)->lpVtbl->Release(p)
/* IDirect3DSwapChain9 macros */
#define IDirect3DSwapChain9Ex_Present(p,a,b,c,d,e) (p)->lpVtbl->Present(p,a,b,c,d,e)
#define IDirect3DSwapChain9Ex_GetFrontBufferData(p,a) (p)->lpVtbl->GetFrontBufferData(p,a)
#define IDirect3DSwapChain9Ex_GetBackBuffer(p,a,b,c) (p)->lpVtbl->GetBackBuffer(p,a,b,c)
#define IDirect3DSwapChain9Ex_GetRasterStatus(p,a) (p)->lpVtbl->GetRasterStatus(p,a)
#define IDirect3DSwapChain9Ex_GetDisplayMode(p,a) (p)->lpVtbl->GetDisplayMode(p,a)
#define IDirect3DSwapChain9Ex_GetDevice(p,a) (p)->lpVtbl->GetDevice(p,a)
#define IDirect3DSwapChain9Ex_GetPresentParameters(p,a) (p)->lpVtbl->GetPresentParameters(p,a)
/* IDirect3DSwapChain9Ex macros */
#define IDirect3DSwapChain9Ex_GetLastPresentCount(p,a) (p)->lpVtbl->GetLastPresentCount(p,a)
#define IDirect3DSwapChain9Ex_GetPresentStats(p,a) (p)->lpVtbl->GetPresentStats(p,a)
#define IDirect3DSwapChain9Ex_GetDisplayModeEx(p,a,b) (p)->lpVtbl->GetDisplayModeEx(p,a,b)

typedef struct IDirect3DTexture9Vtbl
{
	/* IUnknown */
	HRESULT (WINAPI *QueryInterface)(IDirect3DTexture9 *This, REFIID riid, void **ppvObject);
	ULONG (WINAPI *AddRef)(IDirect3DTexture9 *This);
	ULONG (WINAPI *Release)(IDirect3DTexture9 *This);
	/* IDirect3DResource9 */
	HRESULT (WINAPI *GetDevice)(IDirect3DTexture9 *This, IDirect3DDevice9 **ppDevice);
	HRESULT (WINAPI *SetPrivateData)(IDirect3DTexture9 *This, REFGUID refguid, const void *pData, DWORD SizeOfData, DWORD Flags);
	HRESULT (WINAPI *GetPrivateData)(IDirect3DTexture9 *This, REFGUID refguid, void *pData, DWORD *pSizeOfData);
	HRESULT (WINAPI *FreePrivateData)(IDirect3DTexture9 *This, REFGUID refguid);
	DWORD (WINAPI *SetPriority)(IDirect3DTexture9 *This, DWORD PriorityNew);
	DWORD (WINAPI *GetPriority)(IDirect3DTexture9 *This);
	void (WINAPI *PreLoad)(IDirect3DTexture9 *This);
	D3DRESOURCETYPE (WINAPI *GetType)(IDirect3DTexture9 *This);
	/* IDirect3DBaseTexture9 */
	DWORD (WINAPI *SetLOD)(IDirect3DTexture9 *This, DWORD LODNew);
	DWORD (WINAPI *GetLOD)(IDirect3DTexture9 *This);
	DWORD (WINAPI *GetLevelCount)(IDirect3DTexture9 *This);
	HRESULT (WINAPI *SetAutoGenFilterType)(IDirect3DTexture9 *This, D3DTEXTUREFILTERTYPE FilterType);
	D3DTEXTUREFILTERTYPE (WINAPI *GetAutoGenFilterType)(IDirect3DTexture9 *This);
	void (WINAPI *GenerateMipSubLevels)(IDirect3DTexture9 *This);
	/* IDirect3DTexture9 */
	HRESULT (WINAPI *GetLevelDesc)(IDirect3DTexture9 *This, UINT Level, D3DSURFACE_DESC *pDesc);
	HRESULT (WINAPI *GetSurfaceLevel)(IDirect3DTexture9 *This, UINT Level, IDirect3DSurface9 **ppSurfaceLevel);
	HRESULT (WINAPI *LockRect)(IDirect3DTexture9 *This, UINT Level, D3DLOCKED_RECT *pLockedRect, const RECT *pRect, DWORD Flags);
	HRESULT (WINAPI *UnlockRect)(IDirect3DTexture9 *This, UINT Level);
	HRESULT (WINAPI *AddDirtyRect)(IDirect3DTexture9 *This, const RECT *pDirtyRect);
} IDirect3DTexture9Vtbl;
struct IDirect3DTexture9
{
	IDirect3DTexture9Vtbl *lpVtbl;
};

/* IUnknown macros */
#define IDirect3DTexture9_QueryInterface(p,a,b) (p)->lpVtbl->QueryInterface(p,a,b)
#define IDirect3DTexture9_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirect3DTexture9_Release(p) (p)->lpVtbl->Release(p)
/* IDirect3DResource9 macros */
#define IDirect3DTexture9_GetDevice(p,a) (p)->lpVtbl->GetDevice(p,a)
#define IDirect3DTexture9_SetPrivateData(p,a,b,c,d) (p)->lpVtbl->SetPrivateData(p,a,b,c,d)
#define IDirect3DTexture9_GetPrivateData(p,a,b,c) (p)->lpVtbl->GetPrivateData(p,a,b,c)
#define IDirect3DTexture9_FreePrivateData(p,a) (p)->lpVtbl->FreePrivateData(p,a)
#define IDirect3DTexture9_SetPriority(p,a) (p)->lpVtbl->SetPriority(p,a)
#define IDirect3DTexture9_GetPriority(p) (p)->lpVtbl->GetPriority(p)
#define IDirect3DTexture9_PreLoad(p) (p)->lpVtbl->PreLoad(p)
#define IDirect3DTexture9_GetType(p) (p)->lpVtbl->GetType(p)
/* IDirect3DBaseTexture9 macros */
#define IDirect3DTexture9_SetLOD(p,a) (p)->lpVtbl->SetLOD(p,a)
#define IDirect3DTexture9_GetLOD(p) (p)->lpVtbl->GetLOD(p)
#define IDirect3DTexture9_GetLevelCount(p) (p)->lpVtbl->GetLevelCount(p)
#define IDirect3DTexture9_SetAutoGenFilterType(p,a) (p)->lpVtbl->SetAutoGenFilterType(p,a)
#define IDirect3DTexture9_GetAutoGenFilterType(p) (p)->lpVtbl->GetAutoGenFilterType(p)
#define IDirect3DTexture9_GenerateMipSubLevels(p) (p)->lpVtbl->GenerateMipSubLevels(p)
/* IDirect3DTexture9 macros */
#define IDirect3DTexture9_GetLevelDesc(p,a,b) (p)->lpVtbl->GetLevelDesc(p,a,b)
#define IDirect3DTexture9_GetSurfaceLevel(p,a,b) (p)->lpVtbl->GetSurfaceLevel(p,a,b)
#define IDirect3DTexture9_LockRect(p,a,b,c,d) (p)->lpVtbl->LockRect(p,a,b,c,d)
#define IDirect3DTexture9_UnlockRect(p,a) (p)->lpVtbl->UnlockRect(p,a)
#define IDirect3DTexture9_AddDirtyRect(p,a) (p)->lpVtbl->AddDirtyRect(p,a)

typedef struct IDirect3DVertexBuffer9Vtbl
{
	/* IUnknown */
	HRESULT (WINAPI *QueryInterface)(IDirect3DVertexBuffer9 *This, REFIID riid, void **ppvObject);
	ULONG (WINAPI *AddRef)(IDirect3DVertexBuffer9 *This);
	ULONG (WINAPI *Release)(IDirect3DVertexBuffer9 *This);
	/* IDirect3DResource9 */
	HRESULT (WINAPI *GetDevice)(IDirect3DVertexBuffer9 *This, IDirect3DDevice9 **ppDevice);
	HRESULT (WINAPI *SetPrivateData)(IDirect3DVertexBuffer9 *This, REFGUID refguid, const void *pData, DWORD SizeOfData, DWORD Flags);
	HRESULT (WINAPI *GetPrivateData)(IDirect3DVertexBuffer9 *This, REFGUID refguid, void *pData, DWORD *pSizeOfData);
	HRESULT (WINAPI *FreePrivateData)(IDirect3DVertexBuffer9 *This, REFGUID refguid);
	DWORD (WINAPI *SetPriority)(IDirect3DVertexBuffer9 *This, DWORD PriorityNew);
	DWORD (WINAPI *GetPriority)(IDirect3DVertexBuffer9 *This);
	void (WINAPI *PreLoad)(IDirect3DVertexBuffer9 *This);
	D3DRESOURCETYPE (WINAPI *GetType)(IDirect3DVertexBuffer9 *This);
	/* IDirect3DVertexBuffer9 */
	HRESULT (WINAPI *Lock)(IDirect3DVertexBuffer9 *This, UINT OffsetToLock, UINT SizeToLock, void **ppbData, DWORD Flags);
	HRESULT (WINAPI *Unlock)(IDirect3DVertexBuffer9 *This);
	HRESULT (WINAPI *GetDesc)(IDirect3DVertexBuffer9 *This, D3DVERTEXBUFFER_DESC *pDesc);
} IDirect3DVertexBuffer9Vtbl;
struct IDirect3DVertexBuffer9
{
	IDirect3DVertexBuffer9Vtbl *lpVtbl;
};

/* IUnknown macros */
#define IDirect3DVertexBuffer9_QueryInterface(p,a,b) (p)->lpVtbl->QueryInterface(p,a,b)
#define IDirect3DVertexBuffer9_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirect3DVertexBuffer9_Release(p) (p)->lpVtbl->Release(p)
/* IDirect3DResource9 macros */
#define IDirect3DVertexBuffer9_GetDevice(p,a) (p)->lpVtbl->GetDevice(p,a)
#define IDirect3DVertexBuffer9_SetPrivateData(p,a,b,c,d) (p)->lpVtbl->SetPrivateData(p,a,b,c,d)
#define IDirect3DVertexBuffer9_GetPrivateData(p,a,b,c) (p)->lpVtbl->GetPrivateData(p,a,b,c)
#define IDirect3DVertexBuffer9_FreePrivateData(p,a) (p)->lpVtbl->FreePrivateData(p,a)
#define IDirect3DVertexBuffer9_SetPriority(p,a) (p)->lpVtbl->SetPriority(p,a)
#define IDirect3DVertexBuffer9_GetPriority(p) (p)->lpVtbl->GetPriority(p)
#define IDirect3DVertexBuffer9_PreLoad(p) (p)->lpVtbl->PreLoad(p)
#define IDirect3DVertexBuffer9_GetType(p) (p)->lpVtbl->GetType(p)
/* IDirect3DVertexBuffer9 macros */
#define IDirect3DVertexBuffer9_Lock(p,a,b,c,d) (p)->lpVtbl->Lock(p,a,b,c,d)
#define IDirect3DVertexBuffer9_Unlock(p) (p)->lpVtbl->Unlock(p)
#define IDirect3DVertexBuffer9_GetDesc(p,a) (p)->lpVtbl->GetDesc(p,a)

typedef struct IDirect3DVertexDeclaration9Vtbl
{
	/* IUnknown */
	HRESULT (WINAPI *QueryInterface)(IDirect3DVertexDeclaration9 *This, REFIID riid, void **ppvObject);
	ULONG (WINAPI *AddRef)(IDirect3DVertexDeclaration9 *This);
	ULONG (WINAPI *Release)(IDirect3DVertexDeclaration9 *This);
	/* IDirect3DVertexDeclaration9 */
	HRESULT (WINAPI *GetDevice)(IDirect3DVertexDeclaration9 *This, IDirect3DDevice9 **ppDevice);
	HRESULT (WINAPI *GetDeclaration)(IDirect3DVertexDeclaration9 *This, D3DVERTEXELEMENT9 *pElement, UINT *pNumElements);
} IDirect3DVertexDeclaration9Vtbl;
struct IDirect3DVertexDeclaration9
{
	IDirect3DVertexDeclaration9Vtbl *lpVtbl;
};

/* IUnknown macros */
#define IDirect3DVertexDeclaration9_QueryInterface(p,a,b) (p)->lpVtbl->QueryInterface(p,a,b)
#define IDirect3DVertexDeclaration9_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirect3DVertexDeclaration9_Release(p) (p)->lpVtbl->Release(p)
/* IDirect3DVertexDeclaration9 macros */
#define IDirect3DVertexDeclaration9_GetDevice(p,a) (p)->lpVtbl->GetDevice(p,a)
#define IDirect3DVertexDeclaration9_GetDeclaration(p,a,b) (p)->lpVtbl->GetDeclaration(p,a,b)

typedef struct IDirect3DVertexShader9Vtbl
{
	/* IUnknown */
	HRESULT (WINAPI *QueryInterface)(IDirect3DVertexShader9 *This, REFIID riid, void **ppvObject);
	ULONG (WINAPI *AddRef)(IDirect3DVertexShader9 *This);
	ULONG (WINAPI *Release)(IDirect3DVertexShader9 *This);
	/* IDirect3DVertexShader9 */
	HRESULT (WINAPI *GetDevice)(IDirect3DVertexShader9 *This, IDirect3DDevice9 **ppDevice);
	HRESULT (WINAPI *GetFunction)(IDirect3DVertexShader9 *This, void *pData, UINT *pSizeOfData);
} IDirect3DVertexShader9Vtbl;
struct IDirect3DVertexShader9
{
	IDirect3DVertexShader9Vtbl *lpVtbl;
};

/* IUnknown macros */
#define IDirect3DVertexShader9_QueryInterface(p,a,b) (p)->lpVtbl->QueryInterface(p,a,b)
#define IDirect3DVertexShader9_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirect3DVertexShader9_Release(p) (p)->lpVtbl->Release(p)
/* IDirect3DVertexShader9 macros */
#define IDirect3DVertexShader9_GetDevice(p,a) (p)->lpVtbl->GetDevice(p,a)
#define IDirect3DVertexShader9_GetFunction(p,a,b) (p)->lpVtbl->GetFunction(p,a,b)

typedef struct IDirect3DVolume9Vtbl
{
	/* IUnknown */
	HRESULT (WINAPI *QueryInterface)(IDirect3DVolume9 *This, REFIID riid, void **ppvObject);
	ULONG (WINAPI *AddRef)(IDirect3DVolume9 *This);
	ULONG (WINAPI *Release)(IDirect3DVolume9 *This);
	/* IDirect3DVolume9 */
	HRESULT (WINAPI *GetDevice)(IDirect3DVolume9 *This, IDirect3DDevice9 **ppDevice);
	HRESULT (WINAPI *SetPrivateData)(IDirect3DVolume9 *This, REFGUID refguid, const void *pData, DWORD SizeOfData, DWORD Flags);
	HRESULT (WINAPI *GetPrivateData)(IDirect3DVolume9 *This, REFGUID refguid, void *pData, DWORD *pSizeOfData);
	HRESULT (WINAPI *FreePrivateData)(IDirect3DVolume9 *This, REFGUID refguid);
	HRESULT (WINAPI *GetContainer)(IDirect3DVolume9 *This, REFIID riid, void **ppContainer);
	HRESULT (WINAPI *GetDesc)(IDirect3DVolume9 *This, D3DVOLUME_DESC *pDesc);
	HRESULT (WINAPI *LockBox)(IDirect3DVolume9 *This, D3DLOCKED_BOX *pLockedVolume, const D3DBOX *pBox, DWORD Flags);
	HRESULT (WINAPI *UnlockBox)(IDirect3DVolume9 *This);
} IDirect3DVolume9Vtbl;
struct IDirect3DVolume9
{
	IDirect3DVolume9Vtbl *lpVtbl;
};

/* IUnknown macros */
#define IDirect3DVolume9_QueryInterface(p,a,b) (p)->lpVtbl->QueryInterface(p,a,b)
#define IDirect3DVolume9_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirect3DVolume9_Release(p) (p)->lpVtbl->Release(p)
/* IDirect3DVolume9 macros */
#define IDirect3DVolume9_GetDevice(p,a) (p)->lpVtbl->GetDevice(p,a)
#define IDirect3DVolume9_SetPrivateData(p,a,b,c,d) (p)->lpVtbl->SetPrivateData(p,a,b,c,d)
#define IDirect3DVolume9_GetPrivateData(p,a,b,c) (p)->lpVtbl->GetPrivateData(p,a,b,c)
#define IDirect3DVolume9_FreePrivateData(p,a) (p)->lpVtbl->FreePrivateData(p,a)
#define IDirect3DVolume9_GetContainer(p,a,b) (p)->lpVtbl->GetContainer(p,a,b)
#define IDirect3DVolume9_GetDesc(p,a) (p)->lpVtbl->GetDesc(p,a)
#define IDirect3DVolume9_LockBox(p,a,b,c) (p)->lpVtbl->LockBox(p,a,b,c)
#define IDirect3DVolume9_UnlockBox(p) (p)->lpVtbl->UnlockBox(p)

typedef struct IDirect3DVolumeTexture9Vtbl
{
	/* IUnknown */
	HRESULT (WINAPI *QueryInterface)(IDirect3DVolumeTexture9 *This, REFIID riid, void **ppvObject);
	ULONG (WINAPI *AddRef)(IDirect3DVolumeTexture9 *This);
	ULONG (WINAPI *Release)(IDirect3DVolumeTexture9 *This);
	/* IDirect3DResource9 */
	HRESULT (WINAPI *GetDevice)(IDirect3DVolumeTexture9 *This, IDirect3DDevice9 **ppDevice);
	HRESULT (WINAPI *SetPrivateData)(IDirect3DVolumeTexture9 *This, REFGUID refguid, const void *pData, DWORD SizeOfData, DWORD Flags);
	HRESULT (WINAPI *GetPrivateData)(IDirect3DVolumeTexture9 *This, REFGUID refguid, void *pData, DWORD *pSizeOfData);
	HRESULT (WINAPI *FreePrivateData)(IDirect3DVolumeTexture9 *This, REFGUID refguid);
	DWORD (WINAPI *SetPriority)(IDirect3DVolumeTexture9 *This, DWORD PriorityNew);
	DWORD (WINAPI *GetPriority)(IDirect3DVolumeTexture9 *This);
	void (WINAPI *PreLoad)(IDirect3DVolumeTexture9 *This);
	D3DRESOURCETYPE (WINAPI *GetType)(IDirect3DVolumeTexture9 *This);
	/* IDirect3DBaseTexture9 */
	DWORD (WINAPI *SetLOD)(IDirect3DVolumeTexture9 *This, DWORD LODNew);
	DWORD (WINAPI *GetLOD)(IDirect3DVolumeTexture9 *This);
	DWORD (WINAPI *GetLevelCount)(IDirect3DVolumeTexture9 *This);
	HRESULT (WINAPI *SetAutoGenFilterType)(IDirect3DVolumeTexture9 *This, D3DTEXTUREFILTERTYPE FilterType);
	D3DTEXTUREFILTERTYPE (WINAPI *GetAutoGenFilterType)(IDirect3DVolumeTexture9 *This);
	void (WINAPI *GenerateMipSubLevels)(IDirect3DVolumeTexture9 *This);
	/* IDirect3DVolumeTexture9 */
	HRESULT (WINAPI *GetLevelDesc)(IDirect3DVolumeTexture9 *This, UINT Level, D3DVOLUME_DESC *pDesc);
	HRESULT (WINAPI *GetVolumeLevel)(IDirect3DVolumeTexture9 *This, UINT Level, IDirect3DVolume9 **ppVolumeLevel);
	HRESULT (WINAPI *LockBox)(IDirect3DVolumeTexture9 *This, UINT Level, D3DLOCKED_BOX *pLockedVolume, const D3DBOX *pBox, DWORD Flags);
	HRESULT (WINAPI *UnlockBox)(IDirect3DVolumeTexture9 *This, UINT Level);
	HRESULT (WINAPI *AddDirtyBox)(IDirect3DVolumeTexture9 *This, const D3DBOX *pDirtyBox);
} IDirect3DVolumeTexture9Vtbl;
struct IDirect3DVolumeTexture9
{
	IDirect3DVolumeTexture9Vtbl *lpVtbl;
};

/* IUnknown macros */
#define IDirect3DVolumeTexture9_QueryInterface(p,a,b) (p)->lpVtbl->QueryInterface(p,a,b)
#define IDirect3DVolumeTexture9_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirect3DVolumeTexture9_Release(p) (p)->lpVtbl->Release(p)
/* IDirect3DResource9 macros */
#define IDirect3DVolumeTexture9_GetDevice(p,a) (p)->lpVtbl->GetDevice(p,a)
#define IDirect3DVolumeTexture9_SetPrivateData(p,a,b,c,d) (p)->lpVtbl->SetPrivateData(p,a,b,c,d)
#define IDirect3DVolumeTexture9_GetPrivateData(p,a,b,c) (p)->lpVtbl->GetPrivateData(p,a,b,c)
#define IDirect3DVolumeTexture9_FreePrivateData(p,a) (p)->lpVtbl->FreePrivateData(p,a)
#define IDirect3DVolumeTexture9_SetPriority(p,a) (p)->lpVtbl->SetPriority(p,a)
#define IDirect3DVolumeTexture9_GetPriority(p) (p)->lpVtbl->GetPriority(p)
#define IDirect3DVolumeTexture9_PreLoad(p) (p)->lpVtbl->PreLoad(p)
#define IDirect3DVolumeTexture9_GetType(p) (p)->lpVtbl->GetType(p)
/* IDirect3DBaseTexture9 macros */
#define IDirect3DVolumeTexture9_SetLOD(p,a) (p)->lpVtbl->SetLOD(p,a)
#define IDirect3DVolumeTexture9_GetLOD(p) (p)->lpVtbl->GetLOD(p)
#define IDirect3DVolumeTexture9_GetLevelCount(p) (p)->lpVtbl->GetLevelCount(p)
#define IDirect3DVolumeTexture9_SetAutoGenFilterType(p,a) (p)->lpVtbl->SetAutoGenFilterType(p,a)
#define IDirect3DVolumeTexture9_GetAutoGenFilterType(p) (p)->lpVtbl->GetAutoGenFilterType(p)
#define IDirect3DVolumeTexture9_GenerateMipSubLevels(p) (p)->lpVtbl->GenerateMipSubLevels(p)
/* IDirect3DVolumeTexture9 macros */
#define IDirect3DVolumeTexture9_GetLevelDesc(p,a,b) (p)->lpVtbl->GetLevelDesc(p,a,b)
#define IDirect3DVolumeTexture9_GetVolumeLevel(p,a,b) (p)->lpVtbl->GetVolumeLevel(p,a,b)
#define IDirect3DVolumeTexture9_LockBox(p,a,b,c,d) (p)->lpVtbl->LockBox(p,a,b,c,d)
#define IDirect3DVolumeTexture9_UnlockBox(p,a) (p)->lpVtbl->UnlockBox(p,a)
#define IDirect3DVolumeTexture9_AddDirtyBox(p,a) (p)->lpVtbl->AddDirtyBox(p,a)

#endif /* __cplusplus */

#ifdef _WIN32

IDirect3D9 *WINAPI
Direct3DCreate9( UINT SDKVersion );

HRESULT WINAPI
Direct3DCreate9Ex( UINT SDKVersion,
                   IDirect3D9Ex **ppD3D9 );

void *WINAPI
Direct3DShaderValidatorCreate9( void );

int WINAPI
D3DPERF_BeginEvent( D3DCOLOR color,
                    LPCWSTR name );

int WINAPI
D3DPERF_EndEvent( void );

DWORD WINAPI
D3DPERF_GetStatus( void );

void WINAPI
D3DPERF_SetOptions( DWORD options );

BOOL WINAPI
D3DPERF_QueryRepeatFrame( void );

void WINAPI
D3DPERF_SetMarker( D3DCOLOR color,
                   LPCWSTR name );

void WINAPI
D3DPERF_SetRegion( D3DCOLOR color,
                   LPCWSTR name );

void WINAPI
DebugSetMute( void );

#endif

#endif /* _D3D9_H_ */
