/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.geom;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;

public class Bezier {
    private Bezier() {
    }

    public static void main(String[] stringArray) {
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        arrayList.add(new Point2D.Double(0.0, 0.0));
        arrayList.add(new Point2D.Double(5.0, 1.0));
        arrayList.add(new Point2D.Double(10.0, 0.0));
        arrayList.add(new Point2D.Double(10.0, 10.0));
        arrayList.add(new Point2D.Double(0.0, 10.0));
        arrayList.add(new Point2D.Double(0.0, 0.0));
        ArrayList<ArrayList<Point2D.Double>> arrayList2 = Bezier.splitAtCorners(arrayList, 0.7853981633974483, 2.0);
        for (ArrayList<Point2D.Double> arrayList3 : arrayList2) {
            for (int i = 0; i < 2; ++i) {
                arrayList3 = Bezier.reduceNoise(arrayList3, 0.8);
            }
        }
    }

    public static BezierPath fitBezierPath(Point2D.Double[] doubleArray, double d) {
        return Bezier.fitBezierPath(Arrays.asList(doubleArray), d);
    }

    public static BezierPath fitBezierPath(List<Point2D.Double> list, double d) {
        ArrayList<Object> arrayList = new ArrayList();
        arrayList = Bezier.splitAtCorners(list, 1.3439035240356336, d * d);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            ArrayList<Point2D.Double> arrayList2 = (ArrayList)arrayList.get(i);
            arrayList2 = Bezier.removeClosePoints((List<Point2D.Double>)arrayList2, d * 2.0);
            arrayList2 = Bezier.reduceNoise(arrayList2, 0.8);
            arrayList.set(i, arrayList2);
        }
        BezierPath bezierPath = new BezierPath();
        n = 0;
        for (ArrayList arrayList3 : arrayList) {
            if (!arrayList3.isEmpty()) continue;
            n = 0;
            break;
        }
        if (n == 0) {
            double d2 = d * d;
            block7: for (ArrayList arrayList4 : arrayList) {
                switch (arrayList4.size()) {
                    case 0: {
                        continue block7;
                    }
                    case 1: {
                        bezierPath.add(new BezierPath.Node((Point2D.Double)arrayList4.get(0)));
                        continue block7;
                    }
                    case 2: {
                        if (bezierPath.isEmpty()) {
                            bezierPath.add(new BezierPath.Node((Point2D.Double)arrayList4.get(0)));
                        }
                        bezierPath.lineTo(((Point2D.Double)arrayList4.get((int)1)).x, ((Point2D.Double)arrayList4.get((int)1)).y);
                        continue block7;
                    }
                }
                if (bezierPath.isEmpty()) {
                    bezierPath.add(new BezierPath.Node((Point2D.Double)arrayList4.get(0)));
                }
                Point2D.Double double_ = new Point2D.Double();
                Point2D.Double double_2 = new Point2D.Double();
                double_ = Bezier.computeLeftTangent(arrayList4, 0);
                double_2 = Bezier.computeRightTangent(arrayList4, arrayList4.size() - 1);
                Bezier.fitCubic(arrayList4, 0, arrayList4.size() - 1, double_, double_2, d2, bezierPath);
            }
        }
        return bezierPath;
    }

    public static BezierPath fitBezierPath(BezierPath bezierPath, double d) {
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>(bezierPath.size());
        for (BezierPath.Node node : bezierPath) {
            arrayList.add(new Point2D.Double(node.x[0], node.y[0]));
        }
        return Bezier.fitBezierPath(arrayList, d);
    }

    public static ArrayList<Point2D.Double> removeClosePoints(List<Point2D.Double> list, double d) {
        if (d == 0.0) {
            return Bezier.removeCoincidentPoints(list);
        }
        double d2 = d * d;
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        if (list.size() > 0) {
            Point2D.Double double_ = list.get(0);
            arrayList.add(double_);
            for (Point2D.Double double_2 : list) {
                if (!(Bezier.v2SquaredDistanceBetween2Points(double_, double_2) > d2)) continue;
                arrayList.add(double_2);
                double_ = double_2;
            }
            if (!double_.equals(list.get(list.size() - 1))) {
                arrayList.set(arrayList.size() - 1, list.get(list.size() - 1));
            }
        }
        return arrayList;
    }

    private static ArrayList<Point2D.Double> removeCoincidentPoints(List<Point2D.Double> list) {
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        if (list.size() > 0) {
            Point2D.Double double_ = list.get(0);
            arrayList.add(double_);
            for (Point2D.Double double_2 : list) {
                if (double_.equals(double_2)) continue;
                arrayList.add(double_2);
                double_ = double_2;
            }
        }
        return arrayList;
    }

    public static ArrayList<ArrayList<Point2D.Double>> splitAtCorners(List<Point2D.Double> list, double d, double d2) {
        ArrayList<Integer> arrayList = Bezier.findCorners(list, d, d2);
        ArrayList<ArrayList<Point2D.Double>> arrayList2 = new ArrayList<ArrayList<Point2D.Double>>(arrayList.size() + 1);
        if (arrayList.size() == 0) {
            arrayList2.add(new ArrayList<Point2D.Double>(list));
        } else {
            arrayList2.add(new ArrayList<Point2D.Double>(list.subList(0, arrayList.get(0) + 1)));
            for (int i = 1; i < arrayList.size(); ++i) {
                arrayList2.add(new ArrayList<Point2D.Double>(list.subList(arrayList.get(i - 1), arrayList.get(i) + 1)));
            }
            arrayList2.add(new ArrayList<Point2D.Double>(list.subList(arrayList.get(arrayList.size() - 1), list.size())));
        }
        return arrayList2;
    }

    public static ArrayList<Integer> findCorners(List<Point2D.Double> list, double d, double d2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        double d3 = d2 * d2;
        int n = -1;
        double d4 = 0.0;
        int n2 = list.size();
        for (int i = 1; i < n2 - 1; ++i) {
            double d5;
            double d6;
            double d7;
            Point2D.Double double_ = list.get(i);
            Point2D.Double double_2 = null;
            boolean bl = false;
            for (int j = i - 1; j >= 0; --j) {
                if (j != n && !(Bezier.v2SquaredDistanceBetween2Points(list.get(j), double_) >= d3)) continue;
                double_2 = list.get(j);
                bl = j < n;
                break;
            }
            if (double_2 == null) continue;
            Point2D.Double double_3 = null;
            for (int j = i + 1; j < n2; ++j) {
                if (!(Bezier.v2SquaredDistanceBetween2Points(list.get(j), double_) >= d3)) continue;
                double_3 = list.get(j);
                break;
            }
            if (double_3 == null || !((d7 = Math.abs((d6 = Math.atan2(double_2.y - double_.y, double_2.x - double_.x)) - (d5 = Math.atan2(double_3.y - double_.y, double_3.x - double_.x)))) < Math.PI - d) && !(d7 > Math.PI + d)) continue;
            if (bl) {
                arrayList.set(arrayList.size() - 1, i);
            } else {
                arrayList.add(i);
            }
            n = i;
            d4 = d7;
        }
        return arrayList;
    }

    public static ArrayList<Point2D.Double> reduceNoise(List<Point2D.Double> list, double d) {
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        if (list.size() > 0) {
            Point2D.Double double_ = list.get(0);
            arrayList.add(double_);
            double d2 = (1.0 - d) / 2.0;
            int n = list.size() - 1;
            for (int i = 1; i < n; ++i) {
                Point2D.Double double_2 = list.get(i);
                Point2D.Double double_3 = list.get(i + 1);
                arrayList.add(new Point2D.Double(double_2.x * d + d2 * double_.x + d2 * double_3.x, double_2.y * d + d2 * double_.y + d2 * double_3.y));
                double_ = double_2;
            }
            if (list.size() > 1) {
                arrayList.add(list.get(list.size() - 1));
            }
        }
        return arrayList;
    }

    private static void fitCubic(ArrayList<Point2D.Double> arrayList, int n, int n2, Point2D.Double double_, Point2D.Double double_2, double d, BezierPath bezierPath) {
        int[] nArray = new int[1];
        int n3 = 4;
        Point2D.Double double_3 = new Point2D.Double();
        double_ = (Point2D.Double)double_.clone();
        double_2 = (Point2D.Double)double_2.clone();
        double d2 = d * d;
        int n4 = n2 - n + 1;
        if (n4 == 2) {
            double d3 = Bezier.v2DistanceBetween2Points(arrayList.get(n2), arrayList.get(n)) / 3.0;
            Point2D.Double[] doubleArray = new Point2D.Double[4];
            for (int i = 0; i < doubleArray.length; ++i) {
                doubleArray[i] = new Point2D.Double();
            }
            doubleArray[0] = arrayList.get(n);
            doubleArray[3] = arrayList.get(n2);
            Bezier.v2Add(doubleArray[0], Bezier.v2Scale(double_, d3), doubleArray[1]);
            Bezier.v2Add(doubleArray[3], Bezier.v2Scale(double_2, d3), doubleArray[2]);
            bezierPath.curveTo(doubleArray[1].x, doubleArray[1].y, doubleArray[2].x, doubleArray[2].y, doubleArray[3].x, doubleArray[3].y);
            return;
        }
        double[] dArray = Bezier.chordLengthParameterize(arrayList, n, n2);
        Point2D.Double[] doubleArray = Bezier.generateBezier(arrayList, n, n2, dArray, double_, double_2);
        double d4 = Bezier.computeMaxError(arrayList, n, n2, doubleArray, dArray, nArray);
        if (d4 < d) {
            Bezier.addCurveTo(doubleArray, bezierPath, d, n == 0 && n2 == arrayList.size() - 1);
            return;
        }
        if (d4 < d2) {
            for (int i = 0; i < n3; ++i) {
                double[] dArray2 = Bezier.reparameterize(arrayList, n, n2, dArray, doubleArray);
                d4 = Bezier.computeMaxError(arrayList, n, n2, doubleArray = Bezier.generateBezier(arrayList, n, n2, dArray2, double_, double_2), dArray2, nArray);
                if (d4 < d) {
                    Bezier.addCurveTo(doubleArray, bezierPath, d, n == 0 && n2 == arrayList.size() - 1);
                    return;
                }
                dArray = dArray2;
            }
        }
        double_3 = Bezier.computeCenterTangent(arrayList, nArray[0]);
        if (n < nArray[0]) {
            Bezier.fitCubic(arrayList, n, nArray[0], double_, double_3, d, bezierPath);
        } else {
            bezierPath.lineTo(arrayList.get((int)nArray[0]).x, arrayList.get((int)nArray[0]).y);
        }
        Bezier.v2Negate(double_3);
        if (nArray[0] < n2) {
            Bezier.fitCubic(arrayList, nArray[0], n2, double_3, double_2, d, bezierPath);
        } else {
            bezierPath.lineTo(arrayList.get((int)n2).x, arrayList.get((int)n2).y);
        }
    }

    private static void addCurveTo(Point2D.Double[] doubleArray, BezierPath bezierPath, double d, boolean bl) {
        BezierPath.Node node = (BezierPath.Node)bezierPath.get(bezierPath.size() - 1);
        double d2 = Math.sqrt(d);
        if (bl && Geom.lineContainsPoint(node.x[0], node.y[0], doubleArray[3].x, doubleArray[3].y, doubleArray[1].x, doubleArray[1].y, d2) && Geom.lineContainsPoint(node.x[0], node.y[0], doubleArray[3].x, doubleArray[3].y, doubleArray[2].x, doubleArray[2].y, d2)) {
            bezierPath.lineTo(doubleArray[3].x, doubleArray[3].y);
        } else {
            bezierPath.curveTo(doubleArray[1].x, doubleArray[1].y, doubleArray[2].x, doubleArray[2].y, doubleArray[3].x, doubleArray[3].y);
        }
    }

    private static Point2D.Double computeLeftTangent(ArrayList<Point2D.Double> arrayList, int n) {
        Point2D.Double double_ = new Point2D.Double();
        double_ = Bezier.v2SubII(arrayList.get(n + 1), arrayList.get(n));
        double_ = Bezier.v2Normalize(double_);
        return double_;
    }

    private static Point2D.Double computeRightTangent(ArrayList<Point2D.Double> arrayList, int n) {
        Point2D.Double double_ = new Point2D.Double();
        double_ = Bezier.v2SubII(arrayList.get(n - 1), arrayList.get(n));
        double_ = Bezier.v2Normalize(double_);
        return double_;
    }

    private static Point2D.Double computeCenterTangent(ArrayList<Point2D.Double> arrayList, int n) {
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        Point2D.Double double_3 = new Point2D.Double();
        double_ = Bezier.v2SubII(arrayList.get(n - 1), arrayList.get(n));
        double_2 = Bezier.v2SubII(arrayList.get(n), arrayList.get(n + 1));
        double_3.x = (double_.x + double_2.x) / 2.0;
        double_3.y = (double_.y + double_2.y) / 2.0;
        double_3 = Bezier.v2Normalize(double_3);
        return double_3;
    }

    private static double[] chordLengthParameterize(ArrayList<Point2D.Double> arrayList, int n, int n2) {
        int n3;
        double[] dArray = new double[n2 - n + 1];
        dArray[0] = 0.0;
        for (n3 = n + 1; n3 <= n2; ++n3) {
            dArray[n3 - n] = dArray[n3 - n - 1] + Bezier.v2DistanceBetween2Points(arrayList.get(n3), arrayList.get(n3 - 1));
        }
        for (n3 = n + 1; n3 <= n2; ++n3) {
            dArray[n3 - n] = dArray[n3 - n] / dArray[n2 - n];
        }
        return dArray;
    }

    private static double[] reparameterize(ArrayList<Point2D.Double> arrayList, int n, int n2, double[] dArray, Point2D.Double[] doubleArray) {
        int n3 = n2 - n + 1;
        double[] dArray2 = new double[n3];
        for (int i = n; i <= n2; ++i) {
            dArray2[i - n] = Bezier.newtonRaphsonRootFind(doubleArray, arrayList.get(i), dArray[i - n]);
        }
        return dArray2;
    }

    private static double newtonRaphsonRootFind(Point2D.Double[] doubleArray, Point2D.Double double_, double d) {
        int n;
        Point2D.Double[] doubleArray2 = new Point2D.Double[3];
        Point2D.Double[] doubleArray3 = new Point2D.Double[2];
        Point2D.Double double_2 = new Point2D.Double();
        Point2D.Double double_3 = new Point2D.Double();
        Point2D.Double double_4 = new Point2D.Double();
        double_2 = Bezier.bezierII(3, doubleArray, d);
        for (n = 0; n <= 2; ++n) {
            doubleArray2[n] = new Point2D.Double((doubleArray[n + 1].x - doubleArray[n].x) * 3.0, (doubleArray[n + 1].y - doubleArray[n].y) * 3.0);
        }
        for (n = 0; n <= 1; ++n) {
            doubleArray3[n] = new Point2D.Double((doubleArray2[n + 1].x - doubleArray2[n].x) * 2.0, (doubleArray2[n + 1].y - doubleArray2[n].y) * 2.0);
        }
        double_3 = Bezier.bezierII(2, doubleArray2, d);
        double_4 = Bezier.bezierII(1, doubleArray3, d);
        double d2 = (double_2.x - double_.x) * double_3.x + (double_2.y - double_.y) * double_3.y;
        double d3 = double_3.x * double_3.x + double_3.y * double_3.y + (double_2.x - double_.x) * double_4.x + (double_2.y - double_.y) * double_4.y;
        double d4 = d - d2 / d3;
        return d4;
    }

    private static double computeMaxError(ArrayList<Point2D.Double> arrayList, int n, int n2, Point2D.Double[] doubleArray, double[] dArray, int[] nArray) {
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        nArray[0] = (n2 - n + 1) / 2;
        double d = 0.0;
        for (int i = n + 1; i < n2; ++i) {
            double_ = Bezier.bezierII(3, doubleArray, dArray[i - n]);
            double_2 = Bezier.v2SubII(double_, arrayList.get(i));
            double d2 = Bezier.v2SquaredLength(double_2);
            if (!(d2 >= d)) continue;
            d = d2;
            nArray[0] = i;
        }
        return d;
    }

    private static Point2D.Double[] generateBezier(ArrayList<Point2D.Double> arrayList, int n, int n2, double[] dArray, Point2D.Double double_, Point2D.Double double_2) {
        Point2D.Double[] doubleArray = new Point2D.Double[4];
        for (int i = 0; i < doubleArray.length; ++i) {
            doubleArray[i] = new Point2D.Double();
        }
        double d = Bezier.v2DistanceBetween2Points(arrayList.get(n2), arrayList.get(n)) / 3.0;
        doubleArray[0] = arrayList.get(n);
        doubleArray[3] = arrayList.get(n2);
        Bezier.v2Add(doubleArray[0], Bezier.v2Scale(double_, d), doubleArray[1]);
        Bezier.v2Add(doubleArray[3], Bezier.v2Scale(double_2, d), doubleArray[2]);
        return doubleArray;
    }

    private static Point2D.Double bezierII(int n, Point2D.Double[] doubleArray, double d) {
        int n2;
        Point2D.Double[] doubleArray2 = new Point2D.Double[n + 1];
        for (n2 = 0; n2 <= n; ++n2) {
            doubleArray2[n2] = (Point2D.Double)doubleArray[n2].clone();
        }
        for (n2 = 1; n2 <= n; ++n2) {
            for (int i = 0; i <= n - n2; ++i) {
                doubleArray2[i].x = (1.0 - d) * doubleArray2[i].x + d * doubleArray2[i + 1].x;
                doubleArray2[i].y = (1.0 - d) * doubleArray2[i].y + d * doubleArray2[i + 1].y;
            }
        }
        Point2D.Double double_ = doubleArray2[0];
        return double_;
    }

    private static double v2DistanceBetween2Points(Point2D.Double double_, Point2D.Double double_2) {
        return Math.sqrt(Bezier.v2SquaredDistanceBetween2Points(double_, double_2));
    }

    private static double v2SquaredDistanceBetween2Points(Point2D.Double double_, Point2D.Double double_2) {
        double d = double_.x - double_2.x;
        double d2 = double_.y - double_2.y;
        return d * d + d2 * d2;
    }

    private static Point2D.Double v2Scale(Point2D.Double double_, double d) {
        double d2 = Bezier.v2Length(double_);
        if (d2 != 0.0) {
            double_.x *= d / d2;
            double_.y *= d / d2;
        }
        return double_;
    }

    private static Point2D.Double v2ScaleIII(Point2D.Double double_, double d) {
        Point2D.Double double_2 = new Point2D.Double();
        double_2.x = double_.x * d;
        double_2.y = double_.y * d;
        return double_2;
    }

    private static double v2Length(Point2D.Double double_) {
        return Math.sqrt(Bezier.v2SquaredLength(double_));
    }

    private static double v2SquaredLength(Point2D.Double double_) {
        return double_.x * double_.x + double_.y * double_.y;
    }

    private static Point2D.Double v2Add(Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3) {
        double_3.x = double_.x + double_2.x;
        double_3.y = double_.y + double_2.y;
        return double_3;
    }

    private static Point2D.Double v2AddII(Point2D.Double double_, Point2D.Double double_2) {
        Point2D.Double double_3 = new Point2D.Double();
        double_3.x = double_.x + double_2.x;
        double_3.y = double_.y + double_2.y;
        return double_3;
    }

    private static Point2D.Double v2Negate(Point2D.Double double_) {
        double_.x = -double_.x;
        double_.y = -double_.y;
        return double_;
    }

    private static double v2Dot(Point2D.Double double_, Point2D.Double double_2) {
        return double_.x * double_2.x + double_.y * double_2.y;
    }

    private static Point2D.Double v2Normalize(Point2D.Double double_) {
        double d = Bezier.v2Length(double_);
        if (d != 0.0) {
            double_.x /= d;
            double_.y /= d;
        }
        return double_;
    }

    private static Point2D.Double v2SubII(Point2D.Double double_, Point2D.Double double_2) {
        Point2D.Double double_3 = new Point2D.Double();
        double_3.x = double_.x - double_2.x;
        double_3.y = double_.y - double_2.y;
        return double_3;
    }

    private static double b0(double d) {
        double d2 = 1.0 - d;
        return d2 * d2 * d2;
    }

    private static double b1(double d) {
        double d2 = 1.0 - d;
        return 3.0 * d * (d2 * d2);
    }

    private static double b2(double d) {
        double d2 = 1.0 - d;
        return 3.0 * d * d * d2;
    }

    private static double b3(double d) {
        return d * d * d;
    }
}

