#!/usr/bin/env bash

#*****************************************************************************
# xtnfold version 1.0.2
# 򺹸ѤΥǡåȤκ
# T.Nakahara
# 2002/01/12
# Y.Hamuro
# 2002/01/29 -tɲ, -dΥǥ쥯ȥ꤬Ǹ/ǽäƤɬѤʤ
# 2003/02/03 ߤΥޥɤб(1.0.1)
# 2004/01/21 top /bin/bash -> /usr/bin/env bash ѹ(ĻΤŦ)
# 2004/01/21 إפǥСɽ褦ѹ(1.0.2)
#*****************************************************************************
#顼å
function help {
cat >/dev/stderr <<EOF
------------------------
xtnfold.sh version 1.0.2
------------------------
) 򺹸ѤΥǡåȤ롣
) xtnfold.sh -iե -dϥǥ쥯ȥ -nfold -c饹 -S μ [-t] [-oȥ졼˥󥰥ե̾] [-Oƥȥե̾]
) xtnfold.sh -i dat -d fold -n 5 -c Class -o fold##.train -O fold##.test
EOF
exit 1
}

#ѥ᡼Υå
  rName='fold##.data'
  sName='fold##.test'
  while getopts ":i:d:n:c:S:k:o:O:th" opt; do
    case $opt in
      i  ) input=$OPTARG ;;
      d  ) path=$OPTARG ;;
      n  ) fold=$OPTARG ;;
      c  ) cls=$OPTARG ;;
      S  ) sed=$OPTARG ;;
      o  ) rName=$OPTARG ;;
      O  ) sName=$OPTARG ;;
      t  ) txt=1 ;;
      h  ) help ;;
      \? ) help ;;
    esac
  done
  shift $(($OPTIND -1 ))

  if [ "$input" = "" ]; then
     help; exit 1
  fi
  if [ "$path" = "" ]; then
     help; exit 1
  fi
  if [ "$fold" = "" ]; then
     help; exit 1
  fi
  if [ "$cls" = "" ]; then
     help; exit 1
  fi
  if [ "$sed" = "" ]; then
     sed=-1
  fi
  if [ "$rName" = "" ]; then
     help; exit 1
  fi
  if [ "$sName" = "" ]; then
     help; exit 1
  fi

#ȥ졼˥󥰤ȥƥȤƱ̾å
  if [ "$rName" = "$sName" ]; then
    echo 'file names for training and test must be different'
    exit 1
  fi

#ϥեå
  if [ ! -f $input ]; then
     echo 'file not found : '$input; exit 1
  fi

#-dΤ"/"Ȥ
path=`echo $path | sed 's/\/*$//'`

#եΥץեå
wf=/tmp/xt##$$-xtnfold

#ƥȤξ硢xmlTableѴ
  if [ "$txt" = "1" ]; then
    fldCnt=`head -1 $input | gawk '{print NF}'`
    cnt=2
    fldName=1
    while [ $cnt -le $fldCnt ] ; do
      fldName=$fldName","$cnt
      cnt=$((cnt+1))
    done
    txt2xt -a $fldName -i $input -o $wf-01
    input=$wf-01
  fi

#ϥǥ쥯ȥ꤬¸ߤʤʤ
  if [ ! -d $path ]; then
     mkdir -p $path
  fi

#clsʬ뤿foldˤ碌clsֹդ
  xtrand -a rand -S $sed -i$input |
  xtcal  -k$cls -s rand%n -c 'down(keyLine()/(keyCnt()/'$fold'+0.00001),1)' -a val >$wf-03

#clsֹˤ碌Ƥ줾Υե˽Ϥ
  roop=0
  while [ "$roop" -lt "$fold" ]; do
    xtsel -c'$val -eq '$roop -i$wf-03\
          -u$wf-trn-$(($roop+1)) -o $wf-tst-$(($roop+1))
    roop=$((roop+1)) 
  done;

  roop=1
  while [ $roop -le $fold ] ; do
    trnName=`echo $rName | sed 's/##/'$roop'/'`
    tstName=`echo $sName | sed 's/##/'$roop'/'`
    tprName=$wf-trn-$roop
    tpsName=$wf-tst-$roop

    #ƥȤξ硢textѴ
    if [ "$txt" = "1" ]; then
      xtcut -rfval,rand -i$tprName | xt2txt -o"$path"/$trnName
      xtcut -rfval,rand -i$tpsName | xt2txt -o"$path"/$tstName
    else 
      xtcut -rfval,rand -i$tprName -o"$path"/$trnName
      xtcut -rfval,rand -i$tpsName -o"$path"/$tstName
    fi
    roop=$((roop+1)) 
  done;

  rm $wf-*
  exit 0
