#!/usr/bin/env bash

################################################################################
# xtrfm version 1.0.1
# RFMʬ
# 2003/07/22 Y.Hamuro 
# 2004/01/21 top /bin/bash -> /usr/bin/env bash ѹ(ĻΤŦ)
# 2004/01/21 إפǥСɽ褦ѹ(1.0.1)
################################################################################

#===============================================================================
#إץå( -hͿ줿Ȥɽ )
#-------------------------------------------------------------------------------
# -hͿ줿Ȥɽ롣
# "cat >/dev/stderr <<EOR""EOF"ιԤޤǤΥƥȤΤޤ޲̤ɽ
# ˡˤơάǽʥѥ᡼ϳ("[]")ǳ뤳ȡ
#===============================================================================
function help {
cat >/dev/stderr <<EOF
------------------------
xtrfm.sh version 1.0.1
------------------------
ˡ) xtrfm [-c ܵID̾] [-d չ̾] [-D ] [-m ۹̾]
              [-p] [-R RecencyΥ饹] [-F FrequencyΥ饹]
              [-M MonetaryΥ饹] -iϥե̾ -O ϥǥ쥯ȥ̾
  -c ܵID̾ : ܵID򼨤̾ꤹ(ʣܤλǽ)
                    ά"ܵ"Ȥ̾Ѥ롣
  -d չ̾   : ܵҤˬ򼨤̾ꤹ롣
                    ά""Ȥ̾Ѥ롣
  -D      : Recency׻뤿δYYYYMMDDηǻꤹ롣
                    RecencyϡִաסݡָܵҤκǽˬפǷ׻
                    ˤ롣
                    άդѤ롣
  -m ۹̾   : ܵҤιۤ򼨤̾ꤹ롣
                    ά""Ȥ̾Ѥ롣
  -p          : ꤵ줿֤ǥǡ򤷤ˡRFMʬϤԤ
                    ֤YYYYMMDD_YYYYMMDDηǻꤹ롣
                    άϥեƤΥǡѤRFMʬϤԤ
  -R              : Recency򲿸ĤΥ饹ʬ䤹뤫(ǥեȤ5)
  -F              : Frequency򲿸ĤΥ饹ʬ䤹뤫(ǥեȤ5)
  -M              : Monetary򲿸ĤΥ饹ʬ䤹뤫(ǥեȤ5)
  -i ϥե̾ : 磻ɥɤѤǤ롣
  -O ϥǥ쥯ȥ̾ : ̤Ϥǥ쥯ȥ̾
                          ꤷǥ쥯ȥ꤬¸ߤʤк롣
                          άϡȥǥ쥯ȥ"outfiles"˺

) xtrfm -i dat.xt -O rsl
EOF
exit 1
}

#===============================================================================
#ѥ᡼Υå
# Ȥѥ᡼ϡͤѿ˥åȤȤʤѥ᡼ϡ
# ѿ"1"򥻥åȤ롣
#-------------------------------------------------------------------------------
# getoptsΰˤĤ
#   ǽΥ(:)ϡʥץϻˡoptѿ"?"򥻥åȤ롣
#   ΤȤˤꡢΥʸ"\?)"˰äꡢhelp¹Ԥ뤳Ȥˤʤ롣
#   ꤷѥ᡼"ե٥å+"(ex."i:")ͿȰȤ
#   ѥ᡼ȤưʤξϡΤʤѥ᡼Ȥư
#   ex. "i:a:thv" -> "-i", "-a"ϰȤѥ᡼
#                    "-t", "-h", "-v"ϰȤʤѥ᡼
#   OPTARGѿ˥åȤ롣
#
# while & case νˤĤ
#   while롼(whiledoneޤǤΥ֥å)󤴤Ȥˡ桼Ϥ
#   ѥ᡼ĤŤĥågetoptsΰ(嵭)˴Ť
#   opt,OPTARGѿ򥻥åȤ롣
#   optѿˤϡ桼Ϥѥ᡼ΥɤåȤ졢
#   OPTARGѿˤϡΥɤȤʤ顢ͤåȤ롣
#   桼ʥѥ᡼Ϥϡoptѿ"?"åȤ졢
#   "\? )"ΰʸ¹Ԥ롣
#
# caseʸȤ
#   "case $opt in  case"ϡoptѿƤ x )פxͤƱԤ
#   ޥɤ¹Ԥ롣 x )פθˤʣΥޥɤ򵭽ҲǽǤ뤬
#   ǸΥޥɤθ";;"(ü)Ĥɬפ롣
#===============================================================================
  while getopts ":c:d:D:m:p:R:F:M:i:O:h" opt; do
    case $opt in
      c  ) cFld=$OPTARG ;;
      d  ) dFld=$OPTARG ;;
      D  ) today=$OPTARG ;;
      m  ) mFld=$OPTARG ;;
      p  ) period=$OPTARG ;;
      R  ) bucketR=$OPTARG ;;
      F  ) bucketF=$OPTARG ;;
      M  ) bucketM=$OPTARG ;;
      i  ) inFile=$OPTARG ;;
      O  ) outPath=$OPTARG ;;
      h  ) help ;;
      \? ) echo xxxx; exit 0 ;help ;;
    esac
  done

#-------------------------------------------------------------------------------
# OPTIND򣱸롣->νˤꡢ嵭ѥ᡼$nǻ
# ǽȤʤ롣
#-------------------------------------------------------------------------------
  shift $(($OPTIND -1 ))

#-------------------------------------------------------------------------------
# ѥ᡼Υå
#-------------------------------------------------------------------------------
  if [ "$cFld" = "" ]; then
     cFld="ܵ"
  fi
  if [ "$dFld" = "" ]; then
     dFld=""
  fi
  if [ "$today" = "" ]; then
     today=`date +%Y%m%d`
  fi
  if [ "$mFld" = "" ]; then
     mFld=""
  fi
  if [ "$period" = "" ]; then
     periodFrom="0"
     periodTo="99999999"
  else
     periodFrom=${period%_*}
     periodTo=${period#*_}
  fi
  if [ "$bucketR" = "" ]; then
    bucketR=5
  fi
  if [ "$bucketF" = "" ]; then
    bucketF=5
  fi
  if [ "$bucketM" = "" ]; then
    bucketM=5
  fi
  if [ "$inFile" = "" ]; then
     help; exit 1
  fi
  if [ "$outPath" = "" ]; then
     outPath="./outfiles"
  fi

#-------------------------------------------------------------------------------
# Ƽ
#-------------------------------------------------------------------------------
# եΥץեå
# $$ϥץֹ
wf=/tmp/xt##$$-xtrfm

#ϥǥ쥯ȥ꤬¸ߤʤʤ
  if [ ! -d $outPath ]; then
     mkdir -p $outPath
  fi

#-------------------------------------------------------------------------------
# ᥤ
#-------------------------------------------------------------------------------
# 1. ϥǡʻ礷
# 2. ɬפʹ(ܵ,,)ȴ
# 3. ǡ򤷡
# 4. ̶ܵ۹פ롣
xtcat -i "$inFile" |
xtsel -c "\$$dFld>$periodFrom && \$$dFld<$periodTo" |
xtcut -f $cFld,$dFld,$mFld |
xtagg -k $cFld,$dFld -f $mFld -c sum -o $wf-01

#Ź٥饹
xtcut -f $cFld -i $wf-01 |
xtcount -k $cFld -a Ź |
xtbucket -n $bucketF -f Ź:Fclass -o $wf-F

#ۥ饹
xtcut -f $cFld,$mFld -i $wf-01 |
xtagg -k $cFld -f $mFld -c sum |
xtbucket -n $bucketM -f $mFld:Mclass -o $wf-M

#Recency饹
xtsetchr -v "$today" -a today -i $wf-01 |
xtcut -f $cFld,$dFld,today |
xtagg -k $cFld -f $dFld -c max |
xtcal -c "day($today,\$$dFld)" -a Recency |
xtbucket -n $bucketR -f Recency:Rclass -o $wf-R

#ĤΥե
xtjoin -nN -k $cFld -m $wf-F -f Fclass -i $wf-R |
xtjoin -nN -k $cFld -m $wf-M -f Mclass |
xtcut -f $cFld,Rclass,Fclass,Mclass -o $outPath/dat.xt

#-------------------------------------------------------------------------------
# 
#-------------------------------------------------------------------------------
# եκ
  rm $wf-*

# λ(ơϣ)
  exit 0
