# Web::Persistent::IDgen
# Copyright(c) 2002 MoonWolf <moonwolf@moonwolf.com>
require "digest/md5"

module Web
  class Persistent
    module IDgen
      module Default
        def self.create_id(key)
          md5 = Digest::MD5.new(key)
          
          [md5.digest].pack("m").chop.tr("+/","@-")
        end
        
        def self.unique_id()
          Web::Common::unique_id
        end
      end # Default
    end # IDgen
  end # Persistent
end # Web
