open Printf
open Newt

let () =
  let r =
    init_and_finish (
      fun () ->
	cls ();

	centered_window 20 20 "Checkboxes";

	let cb1 = checkbox 1 1 "Checkbox 1" ' ' None in
	let cb2 = checkbox 1 3 "Checkbox 2" '*' None in
	let cb3 = checkbox 1 5 "Checkbox 3" '+' (Some " -+") in

	let b1 = button 5 10 "  OK  " in

	let form = form None None [] in
	form_add_components form [cb1; cb2; cb3; b1];

	ignore (run_form form);
	pop_window ();

	sprintf "cb1 = <%c>, cb2 = <%c>, cb3 = <%c>"
	  (checkbox_get_value cb1)
	  (checkbox_get_value cb2)
	  (checkbox_get_value cb3)
    ) in

  prerr_endline ("result: " ^ r);

  Gc.compact ()
