(* Demonstration program showing a simple message dialog. *)

open Printf
open Newt

let () =
  init_and_finish (
    fun () ->
      cls ();

      centered_window 40 20 "Message dialog";

      let text = textbox 1 1 35 14 [WRAP; SCROLL] in
      textbox_set_text text "This is a long message. Please read it and do what it says. This is a long message. Please read it and do what it says. This is a long message. Please read it and do what it says. This is a long message. Please read it and do what it says. This is a long message. Please read it and do what it says. This is a long message. Please read it and do what it says. This is a long message. Please read it and do what it says. This is a long message. Please read it and do what it says. This is a long message. Please read it and do what it says. This is a long message. Please read it and do what it says.\n\nEnd of message.";
      let ok = button 28 16 "  OK  " in
      component_takes_focus ok true;
      let form = form None None [] in
      form_add_components form [text; ok];

      ignore (run_form form);
      pop_window ()
  );

  Gc.compact ()
