/****************************************************************************
    Qt-BSch3V schematic capture
    Copyright (C) 2002-2006 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

//#ifdef _WINDOWS
//	#include <windows.h>
//#endif
#include <string.h>




#include <QtGui>

#include <qimage.h>
#include <qpixmap.h>
#include <q3toolbar.h>
#include <qtoolbutton.h>
#include <q3popupmenu.h>
#include <qmenubar.h>
#include <qnamespace.h>
//#include <qmultilineedit.h>
//#include <qfile.h>
//#include <q3filedialog.h>
#include <qstatusbar.h>
#include <qmessagebox.h>
#include <qprinter.h>
#include <qapplication.h>
#include <q3accel.h>
#include <qlabel.h>
#include <qtextstream.h>
#include <qpainter.h>
#include <q3paintdevicemetrics.h>
#include <q3whatsthis.h>
#include <q3scrollview.h>
#include <qtooltip.h>
#include <qfontdialog.h>
#include <qwidget.h>
//Added by qt3to4:
#include <QCloseEvent>
#include <QKeyEvent>
#include <QMenu>
#include <QAction>


#include "xbsch.h"
#include "xbschview.h"
#include "application.h"
#include "xbschglobal.h"
#include "cfgdata.h"



#include "filesave.xpm"
#include "fileopen.xpm"
//#include "fileprint.xpm"
#include "toolbent.xpm"
#include "toolbus.xpm"
#include "toolcmnt.xpm"
#include "toolcomp.xpm"
#include "tooldash.xpm"
#include "tooldrag.xpm"
#include "toolent.xpm"
#include "tooljunc.xpm"
#include "toollabel.xpm"
#include "toolselect.xpm"
#include "tooltag.xpm"
#include "toolwire.xpm"
#include "xbschicon.xpm"
#include "setlibimpl.h"

#include "printOptionDlg.h"
#include "setlayerdlg.h"



//#include <windows.h>
/* What's this Τʸ󡣤򥵥ݡȤʤ
const char * fileOpenText = "<img source=\"fileopen\"> "
"Click this button to open a <em>new file</em>. <br><br>"
"You can also select the <b>Open command</b> from the File menu.";
const char * fileSaveText = "Click this button to save the file you are "
"editing.  You will be prompted for a file name.\n\n"
"You can also select the Save command from the File menu.\n\n"
"Note that implementing this function is left as an exercise for the reader.";
const char * filePrintText = "Click this button to print the file you "
"are editing.\n\n"
"You can also select the Print command from the File menu.";
*/

//Static Сѿ
QWidgetList ApplicationWindow::m_appWindowList;

//󥹥ȥ饯
ApplicationWindow::ApplicationWindow()
    : Q3MainWindow( 0, "XBSch Main Window", Qt::WDestructiveClose )
{
//    int id;
//	m_pscrollview = NULL;	
//	m_pxbschview = NULL;

	printer = NULL;
	//printer = new QPrinter( QPrinter::HighResolution );
	

	QFont tipfont( "helvetica", 10 ) ;
//Qt4	QToolTip::setFont ( tipfont );
	
	setCaption( "Qt-BSch3V" );

	setIcon(QPixmap((const char**)xbschicon ));


	////////////////////////////////////////////////
	//TOOLBARν
	////////////////////////////////////////////////
	QPixmap openIcon, saveIcon, printIcon,
			tSelectIcon,tDragIcon,tCompIcon,
			tBusIcon,tWireIcon,tDashIcon,
			tJuncIcon,tBEntIcon,tEntIcon,
			tTagIcon,tLabelIcon,tCmntIcon;
	
    toolbar = new Q3ToolBar( this);


    openIcon = QPixmap( (const char**)fileopen );
    m_ptbFileOpen = new QToolButton( openIcon, "Open File", QString::null,
			   this, SLOT(load()), toolbar, "open file" );
	
    saveIcon = QPixmap( (const char**)filesave );
    m_ptbFileSave = new QToolButton( saveIcon, "Save File", QString::null,
			   this, SLOT(save()), toolbar, "save file" );

    //printIcon = QPixmap( (const char**)fileprint );
    //m_ptbFilePrint = new QToolButton( printIcon, "Print File", QString::null,
	//		   this, SLOT(print()), toolbar, "print file" );
	m_ptbFilePrint = NULL;	

	toolbar->addSeparator();
	
   	//toolbar = new QToolBar( this);
 	

	tSelectIcon = QPixmap( (const char**) toolselect );
    m_ptbToolSelect = new QToolButton( tSelectIcon, "Select", QString::null,
			   this, SLOT(ToolSelector()), toolbar, "Select" );
	m_ptbToolSelect->setToggleButton (true);


	tDragIcon = QPixmap( (const char**) tooldrag );
    m_ptbToolDrag = new QToolButton( tDragIcon, "Drag", QString::null,
			   this, SLOT(ToolDrag()), toolbar, "Drag" );
	m_ptbToolDrag->setToggleButton (true);

	toolbar->addSeparator();

	tCompIcon = QPixmap( (const char**) toolcomp );
    m_ptbToolComp = new QToolButton( tCompIcon, "Component", QString::null,
			   this, SLOT(ToolComp()), toolbar, "Component" );
	m_ptbToolComp->setToggleButton (true);

	toolbar->addSeparator();

	tBusIcon = QPixmap( (const char**) toolbus );
    m_ptbToolBus = new QToolButton( tBusIcon, "Bus", QString::null,
			   this, SLOT(ToolBus()), toolbar, "Bus" );
	m_ptbToolBus->setToggleButton (true);

	tWireIcon = QPixmap( (const char**) toolwire );
    m_ptbToolWire= new QToolButton( tWireIcon, "Wire", QString::null,
			   this, SLOT(ToolWire()), toolbar, "Wire" );
	m_ptbToolWire->setToggleButton (true);

	tDashIcon = QPixmap( (const char**) tooldash );
    m_ptbToolDash = new QToolButton( tDashIcon, "Dash", QString::null,
			   this, SLOT(ToolDash()), toolbar, "Dash" );
	m_ptbToolDash->setToggleButton (true);

	toolbar->addSeparator();

	tJuncIcon = QPixmap( (const char**) tooljunc );
    m_ptbToolJunc = new QToolButton( tJuncIcon, "Junction", QString::null,
			   this, SLOT(ToolJunction()), toolbar, "Junction" );
	m_ptbToolJunc->setToggleButton (true);

	tBEntIcon = QPixmap( (const char**) toolbent );
    m_ptbToolBEnt = new QToolButton( tBEntIcon, "Bus Entry", QString::null,
			   this, SLOT(ToolBEntry()), toolbar, "Bus Entry" );
	m_ptbToolBEnt->setToggleButton (true);

	tEntIcon = QPixmap( (const char**) toolent );
    m_ptbToolEnt = new QToolButton( tEntIcon, "Entry", QString::null,
			   this, SLOT(ToolEntry()), toolbar, "Entry" );
	m_ptbToolEnt->setToggleButton (true);

	toolbar->addSeparator();

	tTagIcon = QPixmap( (const char**) tooltag );
    m_ptbToolTag = new QToolButton( tTagIcon, "Tag", QString::null,
			   this, SLOT(ToolTag()), toolbar, "Tag" );
	m_ptbToolTag->setToggleButton (true);

	tLabelIcon = QPixmap( (const char**)toollabel);
    m_ptbToolLabel = new QToolButton( tLabelIcon, "Label", QString::null,
			   this, SLOT(ToolLabel()), toolbar, "Label" );
	m_ptbToolLabel->setToggleButton (true);

	tCmntIcon = QPixmap( (const char**) toolcmnt);
    m_ptbToolCmnt = new QToolButton( tCmntIcon, "Comment", QString::null,
			   this, SLOT(ToolCmnt()), toolbar, "Comment" );
	m_ptbToolCmnt->setToggleButton (true);

	//Qt 2.0 Ǥ draggable toolbar ̤Ǥ
#ifdef Q_WS_MACX
	setDockWindowsMovable ( false);
#else
//	setDockEnabled(Qt::Top,true);
//	setDockEnabled(Qt::Left,true);
//	setDockEnabled(Qt::Right,true);
//	setDockEnabled(Qt::Bottom,true);
	setDockWindowsMovable ( false);
#endif

/*  
    (void)QWhatsThis::whatsThisButton( toolbar );

    QWhatsThis::add( fileOpen, fileOpenText );
	//What's this HTMLɽȤˤϲιԤɬ
	QMimeSourceFactory::defaultFactory()->setPixmap( "fileopen", openIcon );
    QWhatsThis::add( fileSave, fileSaveText );
    QWhatsThis::add( filePrint, filePrintText );
*/

	////////////////////////////////////////////////////
	//MENUν
	////////////////////////////////////////////////////
	//FILE˥塼
    QMenu * file = new QMenu("&File", this );
    menuBar()->addMenu(file);

	file->addAction( "&New", this, SLOT(newDoc()), Qt::CTRL+Qt::Key_N );
	file->addAction( "&Open...", this, SLOT(load()), Qt::CTRL+Qt::Key_O );
   	file->addAction( "&Save...", this, SLOT(save()), Qt::CTRL+Qt::Key_S );
 	file->addAction( "Save &as...", this, SLOT(saveAs()) );
	file->addSeparator();
	file->addAction( "&Export image...",this, SLOT(exportImage()) );
	file->addAction( "&Print...",this, SLOT(print()), Qt::CTRL+Qt::Key_P );
	file->addAction( "Print Op&tion...",this, SLOT(printOption()) );	
 	file->addSeparator();
	file->addAction( "&Close", this, SLOT(close()));
	file->addAction( "&Quit", qApp, SLOT( closeAllWindows() ));

	//EDIT˥塼
    QMenu * m_menuEdit = new QMenu("&Edit",this );
	menuBar()->addMenu(m_menuEdit);

    m_nMenuItemEditUndo = m_menuEdit->addAction( "&Undo", this, SLOT(EditUndo()), Qt::CTRL+Qt::Key_Z );
    m_nMenuItemEditCut = m_menuEdit->addAction( "Cu&t", this, SLOT(EditCut()), Qt::CTRL+Qt::Key_X );
    m_nMenuItemEditCopy = m_menuEdit->addAction( "&Copy", this, SLOT(EditCopy()), Qt::CTRL+Qt::Key_C );
    m_nMenuItemEditPaste = m_menuEdit->addAction( "&Paste", this, SLOT(EditPaste()), Qt::CTRL+Qt::Key_V );
#ifdef Q_WS_MACX
    m_nMenuItemEditDelete = m_menuEdit->addAction( "&Delete", this, SLOT(EditDelete()));
#else
    m_nMenuItemEditDelete = m_menuEdit->addAction( "&Delete", this, SLOT(EditDelete()), Qt::Key_Delete);
#endif
    m_menuEdit->insertSeparator();
    m_nMenuItemEditAttr = m_menuEdit->addAction( "&Attribute", this, SLOT(EditAttr()), Qt::CTRL+Qt::Key_A );
    m_nMenuItemEditMirror = m_menuEdit->addAction( "&Mirror", this, SLOT(EditMirror()), Qt::CTRL+Qt::Key_M );
    m_nMenuItemEditRotate = m_menuEdit->addAction( "&Rotate", this, SLOT(EditRotate()), Qt::CTRL+Qt::Key_R );
	//m_nMenuItemEditInvert = edit->insertItem( "&Invert", this, SLOT(EditInvert()), CTRL+Key_I );
    m_menuEdit->insertSeparator();
	
	QMenu* moveto = new QMenu("MoveTo",this );
	m_menuEdit->addMenu(moveto);
	m_nMenuItemEditMoveTo0 = moveto->addAction("Layer 0",this,SLOT(MoveToLayer0()));
	m_nMenuItemEditMoveTo1 = moveto->addAction("Layer 1",this,SLOT(MoveToLayer1()));
	m_nMenuItemEditMoveTo2 = moveto->addAction("Layer 2",this,SLOT(MoveToLayer2()));
	m_nMenuItemEditMoveTo3 = moveto->addAction("Layer 3",this,SLOT(MoveToLayer3()));
	m_nMenuItemEditMoveTo4 = moveto->addAction("Layer 4",this,SLOT(MoveToLayer4()));
	m_nMenuItemEditMoveTo5 = moveto->addAction("Layer 5",this,SLOT(MoveToLayer5()));
	m_nMenuItemEditMoveTo6 = moveto->addAction("Layer 6",this,SLOT(MoveToLayer6()));
	m_nMenuItemEditMoveTo7 = moveto->addAction("Layer 7",this,SLOT(MoveToLayer7()));
	
	m_nMenuItemEditSetupLayer = m_menuEdit->addAction( "Setup Layer...",this,SLOT(SetupLayer()));

	QObject::connect(m_menuEdit,SIGNAL(aboutToShow ()),
			this,SLOT(setupEditMenu()));


	//VIEW˥塼
	QMenu* view=new QMenu( "&View",this);
    menuBar()->addMenu(view);
    view->addAction( "&Refresh", this, SLOT(ViewRefresh()) );
    view->addSeparator();
    m_nMenuItemViewZoomIn = view->addAction( "Zoom  &In", this, SLOT(ViewZoomIn()));//, Key_PageUp );
    m_nMenuItemViewZoomOut = view->addAction( "Zoom  &Out", this, SLOT(ViewZoomOut()));//, Key_PageDown );
    view->addSeparator();
    m_nMenuItemViewGrid = view->addAction( "&Grid", this, SLOT(ViewGridOnOff()));
    m_nMenuItemViewGrid->setCheckable(true);

	//TOOL˥塼
    QMenu * tools = new QMenu( "&Tool", this );
    menuBar()->addMenu(tools);
    m_nMenuItemToolSelect = tools->addAction( "Select", this, SLOT(ToolSelector()),Qt::Key_Escape );
	m_nMenuItemToolSelect->setCheckable(true);

    m_nMenuItemToolDrag = tools->addAction( "D&rag", this, SLOT(ToolDrag()) );
	m_nMenuItemToolDrag->setCheckable(true);

    tools->addSeparator();
    m_nMenuItemToolComp = tools->addAction( "Com&ponent", this, SLOT(ToolComp()) );
	m_nMenuItemToolComp->setCheckable(true);

    tools->addSeparator();
    m_nMenuItemToolBus = tools->addAction( "&Bus", this, SLOT(ToolBus()) );
	m_nMenuItemToolBus->setCheckable(true);

    m_nMenuItemToolWire = tools->addAction( "&Wire", this, SLOT(ToolWire()) );
	m_nMenuItemToolWire->setCheckable(true);

    m_nMenuItemToolDash = tools->addAction( "&Dash", this, SLOT(ToolDash()) );
	m_nMenuItemToolDash->setCheckable(true);

    tools->addSeparator();
    m_nMenuItemToolJunc = tools->addAction( "&Junction", this, SLOT(ToolJunction()) );
	m_nMenuItemToolJunc->setCheckable(true);

    m_nMenuItemToolBEnt = tools->addAction( "Bus e&ntry", this, SLOT(ToolBEntry()) );
	m_nMenuItemToolBEnt->setCheckable(true);

    m_nMenuItemToolEnt = tools->addAction( "&Entry", this, SLOT(ToolEntry()) );
	m_nMenuItemToolEnt->setCheckable(true);

    tools->addSeparator();
    m_nMenuItemToolTag = tools->addAction( "&Tag", this, SLOT(ToolTag()) );
	m_nMenuItemToolTag->setCheckable(true);

    m_nMenuItemToolLabel = tools->addAction( "&Lable", this, SLOT(ToolLabel()) );
	m_nMenuItemToolLabel->setCheckable(true);

    m_nMenuItemToolCmnt = tools->addAction( "&Comment", this, SLOT(ToolCmnt()) );
	m_nMenuItemToolCmnt->setCheckable(true);


	//SET˥塼
    QMenu * setenv = new QMenu(  "&Set", this );
    menuBar()->addMenu(setenv);
    setenv->addAction( "&SheetSize...", this, SLOT(SetSheetSize()) );
    m_nMenuItemSetSnap = setenv->addAction( "Sna&p", this, SLOT(SetSnap()) );
	m_nMenuItemSetSnap->setCheckable(true);

    setenv->addSeparator();
    setenv->addAction( "&Library...", this, SLOT(SetLibrary()) );
    setenv->addAction( "default &Comment font...", this, SLOT(SetFont()) );
    setenv->addAction( "Label &Font...", this, SLOT(SetSmallFont()) );
	
	//WINDOW˥塼
	m_menuWindow = new  QMenu( "&Window", this );
	menuBar()->addMenu( m_menuWindow);
	QObject::connect(m_menuWindow,SIGNAL(aboutToShow ()),
			this,SLOT(setupWindowMenu()));
			
	QObject::connect(m_menuWindow,SIGNAL(triggered ( QAction *)),
			this,SLOT(selectActiveDocument( QAction *)));
	
//	QObject::connect(m_menuWindow,SIGNAL(activated (int)),
//			this,SLOT(selectActiveDocument(int)));
	
	//HELP˥塼
    menuBar()->addSeparator();
    QMenu * help = new QMenu( "&Help", this );
    menuBar()->addMenu( help );

    help->addAction( "&About Qt-BSch3V", this, SLOT(about()));
    help->addAction( "About &Qt", this, SLOT(aboutQt()));

/*  
	help->insertSeparator();
    help->insertItem( "What's &This", this, SLOT(whatsThis()), SHIFT+Key_F1);
*/

    m_pXBSchView = new SXBSchView(this);
    setCentralWidget(m_pXBSchView);

	QObject::connect(m_pXBSchView,SIGNAL(cursorMove(int,int)),
					this,SLOT(cursorMove(int,int)));

	QObject::connect(m_pXBSchView,SIGNAL(toolChange()),
					this,SLOT(toolChange()));


	int nCfg1;
//	int nCfg2;
	//åɽ̵ͭ
	if(!g_cfg.getInt("VIEW","GRID",nCfg1)){
		g_cfg.setInt("VIEW","GRID",1);
		nCfg1=1;
	}
	m_pXBSchView->setDisplayGrid(nCfg1!=0);
	m_nMenuItemViewGrid->setChecked(nCfg1!=0);
	//menuBar()->setItemChecked(m_nMenuItemViewGrid,nCfg1!=0);

	//ʥåפξ֤
	if(!g_cfg.getInt("SET","SNAP",nCfg1)){
		g_cfg.setInt("SET","SNAP",1);
		nCfg1=1;
	}
	m_pXBSchView->setSnapGrid(nCfg1!=0);
	m_nMenuItemSetSnap->setChecked(nCfg1!=0);
	
	//󥢥ƥ֥쥤䡼ɽ֤
	if(!g_cfg.getInt("VIEW","DARKEN_NONACTIVE_LAYER",nCfg1)){
		g_cfg.setInt("VIEW","DARKEN_NONACTIVE_LAYER",1);
		nCfg1=1;
	}
	m_pXBSchView->setDarkenNonActiveLayer(nCfg1!=0);
	
	
	//menuBar()->setItemChecked(m_nMenuItemSetSnap,nCfg1!=0);


	//ġ⡼ɤ
	m_pXBSchView->setToolMode(TOOL_SELECTOR);
	


	SetToolButtonState();


   	//msg = new QLabel( statusBar(), "message" );
    //msg->setAlignment( AlignCenter );
    //QFont boldfont; boldfont.setWeight(QFont::Bold);
    //msg->setFont( boldfont );
    //statusBar()->addWidget( msg, 4 );


	m_plabelX = new QLabel(" X:0000 ",statusBar());
	m_plabelY = new QLabel(" Y:0000 ",statusBar());
	//QFont statusfont( "helvetica", 10 ) ;
	m_plabelX->setFont( tipfont );
	m_plabelY->setFont( tipfont );
	//m_plabelX->setAlignment(AlignCenter);
	//m_plabelY->setAlignment(AlignCenter);
	statusBar()->addWidget(m_plabelX,0,true);
	statusBar()->addWidget(m_plabelY,0,true);

	//statusBar()->setSizeGripEnabled(false); 

    //statusBar()->message( "Ready", 2000 );
    resize( 600, 450 );

	//¾Υ˥塼ξ֤

	m_nMenuItemViewZoomIn->setEnabled(m_pXBSchView->CanZoomIn());
	m_nMenuItemViewZoomOut->setEnabled(m_pXBSchView->CanZoomOut());
	
	//	menuBar()->setItemEnabled(m_nMenuItemViewZoomIn,m_pXBSchView->CanZoomIn());
	//	menuBar()->setItemEnabled(m_nMenuItemViewZoomOut,m_pXBSchView->CanZoomOut());

	m_appWindowList.append(this);
	menuBar()->show();
	//m_filename=("Untitled");
	
	string strname;
	if(g_cfg.getString("SmallFont","Name",strname)){
		QFont font=QFont(QString::fromLocal8Bit(strname.c_str()));
		int n;
		if(g_cfg.getInt("SmallFont","Size",n)) font.setPixelSize(n);
		if(g_cfg.getInt("SmallFont","Bold",n)) font.setBold(n!=0);
		if(g_cfg.getInt("SmallFont","Italic",n)) font.setItalic(n!=0);
		if(g_cfg.getInt("SmallFont","Underline",n)) font.setStrikeOut(n!=0);
		if(g_cfg.getInt("SmallFont","StrikeOut",n)) font.setUnderline(n!=0);
		g_SmallFont.SetFont(font);		
	}
}


ApplicationWindow::~ApplicationWindow()
{
	int windowCount=m_appWindowList.count();
	int n;
	for(n=0;n<windowCount;n++){
		QWidget * w = m_appWindowList.at(n);
		if(w==this){
			m_appWindowList.remove(w);//qt4
			break;
		}
    }
	
    delete printer;
}

QString ApplicationWindow::fileName()
{
	return m_filename;
}


bool ApplicationWindow::isEmptyDocWindow()
{
	return  m_filename.isEmpty() && m_pXBSchView->isEmpty();
}

ApplicationWindow* ApplicationWindow::firstEmptyDocWindow()
{
	int windowCount=m_appWindowList.count();
	int n;
	for(n=0;n<windowCount;n++){
		ApplicationWindow * w = (ApplicationWindow*)m_appWindowList.at(n);
		if(w->isEmptyDocWindow())return w;
	}
	return NULL;
}

void ApplicationWindow::newDoc()
{
    ApplicationWindow *ed = new ApplicationWindow;
    ed->show();
}

void ApplicationWindow::load()
{
/*
	if(m_pXBSchView->isDirty()){
		switch( QMessageBox::information( this, "Open",
				      "The current document has been changed since the last save.",
				      "Save Now", "Leave Anyway", "Cancel",
				      0, 2) ) {
		case 0:
			if(save() != 0)	return;			
			break;
    	case 1:
			break;
    	case 2:
    	default:
			return;
    	}
	}

*/

	QString fn = QFileDialog::getOpenFileName( this,QString::null,QString::null,"*.ce3");
//	QString fn = Q3FileDialog::getOpenFileName( QString::null,"*.ce3",this);
	if ( !fn.isEmpty() ){
		//		if(m_pXBSchView->isDirty()|| !m_pXBSchView->isEmpty()){
		ApplicationWindow * aw =ApplicationWindow::firstEmptyDocWindow();
		if(aw == NULL) aw = new ApplicationWindow();
		aw->show();
		aw->load(fn);
		aw->setActiveWindow();
	    //ApplicationWindow *ed = new ApplicationWindow;
    	//ed->show();
		//ed->load(fn);
//		if(!m_pXBSchView->isDirty()&& m_pXBSchView->isEmpty()){
//			close();
//		}
//		}else{
//			load(fn);
//		}
/*		switch (m_pXBSchView->load(fn)){
		case 0:
			filename = fn;
			setAppCaption();
			break;
		default:
		
		break;
		}
*/
	}else{
		statusBar()->message( "Loading aborted", 2000 );
	}
}

void ApplicationWindow::load(const QString &fn)
//void ApplicationWindow::load( const char *fn)
{
    //QFile f( fn );
	QString msg;
    if(!QFile::exists(fn)) return;
	switch (m_pXBSchView->load(fn)){
	case 0:
		m_filename = fn;
		setAppCaption();
		break;
	case 1:
		msg=fn;
		msg += " read error.";
		QMessageBox::information( this, "Open file",msg,"OK",QString::null,QString::null,0,0);
		break;
	default:
		msg=fn;
		msg += " is not Qt-BSch document.";
		QMessageBox::information( this, "Open file",msg,"OK",QString::null,QString::null,0,0);
		break;
	}
    //QString s;
    //s.sprintf( "Loaded document %s", fileName );
    //statusBar()->message( s, 2000 );
}

//¸0֤
int ApplicationWindow::save()
{
	if ( m_filename.isEmpty() ) {
		return saveAs();
	}else{
		return m_pXBSchView->save(m_filename);
	}
}


//¸0֤
int ApplicationWindow::saveAs()
{
	QString fn = QFileDialog::getSaveFileName( this,QString::null,QString::null,"*.ce3");
//	QString fn = Q3FileDialog::getSaveFileName( QString::null,"*.ce3",this );
	if ( !fn.isEmpty() ) {
		//ĥҤ̵϶Ū.ce3Ȥ롣
		QFileInfo finfo(fn);
		if(finfo.extension(false).isEmpty()){	//xxxx.פȡxxxxפξĥҤʤȽꤷƤޤ
			if(fn.right(1)!=".") fn+=".";		// Ǹʸ.פǤʤС.פɲá
			fn+="ce3";							// ĥҤɲá
		}
		if(QFile::exists (fn)){
			QString msg=fn;
			msg += " already exists.Overwrite?";
			switch( QMessageBox::information( this, "Save as",msg,
				      "Overwrite", "Cancel",QString::null,0, 1) ) {
			case 0:
				if(m_pXBSchView->save(fn) == 0){
					m_filename = fn;
					setAppCaption();
					return 0;
				}else{
					return 1;
				}			
   			case 1:
			default:
				return 1;
   			}

		}else{
			if(m_pXBSchView->save(fn) == 0){
				m_filename = fn;
				setAppCaption();
				return 0;
			}else{
				return 1;
			}			
		}
	}else{
		return 1;
	}
}

void ApplicationWindow::exportImage()
{
	//qDebug("ApplicationWindow::exportImage()");
	QString imagefilename = m_filename;
	if ( imagefilename.isEmpty() ) {
		imagefilename="untitled";
	}
	QFileInfo finfo(imagefilename);
	QString path=finfo.dirPath(true);
	QString baseName = finfo.baseName(); 
	QString filter;
	//qDebug("dir:%s",path.latin1());
	//qDebug("baseName:%s",baseName.latin1());
	if(!path.isEmpty()) path+='/';
	path+=baseName;

//#ifdef _WINDOWS
//	path+=".bmp";
//	filter="*.bmp";
//#else
	path+=".png";
	filter="*.png";
//#endif
	QString fn = QFileDialog::getSaveFileName( this,QString::null,path,filter);
//	QString fn = Q3FileDialog::getSaveFileName(path,filter,this );
	if(!fn.isEmpty()){
//#ifndef _WINDOWS
		//ĥҤ̵϶Ū.pngȤ롣
		QFileInfo finfo(fn);
		if(finfo.extension(false).isEmpty()){	//xxxx.פȡxxxxפξĥҤʤȽꤷƤޤ
			if(fn.right(1)!=".") fn+=".";		// Ǹʸ.פǤʤС.פɲá
			fn+="png";							// ĥҤɲá
		}
//#endif
		m_pXBSchView->exportImage(fn);
	}
}

void ApplicationWindow::printOption()
{
	printOptionDlg *dlg = new printOptionDlg(this);
	int mgn_left, mgn_right, mgn_top, mgn_bottom, n;
	
	mgn_left=mgn_right=mgn_top=mgn_bottom=15;
	
	if(!dlg)return;	
		
	if(g_cfg.getInt("PrintMargin","Top",n)) mgn_top=n;
	if(g_cfg.getInt("PrintMargin","Bottom",n)) mgn_bottom=n;
	if(g_cfg.getInt("PrintMargin","Left",n)) mgn_left=n;
	if(g_cfg.getInt("PrintMargin","Right",n)) mgn_right=n;
	
	
	dlg->m_top = mgn_top;
	dlg->m_bottom = mgn_bottom;
	dlg->m_left = mgn_left;
	dlg->m_right = mgn_right;

/*	bool ok;
	font=QFontDialog::getFont(&ok,font,this);
	if(ok){
		g_cfg.setString("Font","Name",string(font.family().local8Bit()));
		QFontInfo fontInfo(font);
		g_cfg.setInt("Font","Size",fontInfo.pixelSize());
		g_cfg.setInt("Font","Bold",font.bold()?1:0);

	*/
	
	if(dlg->exec()){
		g_cfg.setInt("PrintMargin","Top", dlg->m_top);
		g_cfg.setInt("PrintMargin","Bottom",dlg->m_bottom);
		g_cfg.setInt("PrintMargin","Left",dlg->m_left);
		g_cfg.setInt("PrintMargin","Right",dlg->m_right);
	}
	delete dlg;
}


void ApplicationWindow::print()
{
	printer = new QPrinter( QPrinter::HighResolution );
	if ( printer->setup( this ) ) {
		m_pXBSchView->print( printer );
		
//		QPainter paint;
//		if(paint.begin(printer ) ){
//			int dpi=printer->resolution();
//        	m_pXBSchView->print( &paint,dpi );
//    		paint.end();
//    	}
//
    }
	delete printer;
    printer=NULL;
    
#ifdef Q_WS_MACX
//	delete printer;
//	printer = new QPrinter( QPrinter::HighResolution );
#endif
}

void ApplicationWindow::keyPressEvent ( QKeyEvent * e )
{

	switch(e->key()){
	case Qt::Key_Q:
	case Qt::Key_PageUp:
		ZoomIn(false);
		break;
	case Qt::Key_A:
	case Qt::Key_PageDown:
		ZoomOut(false);
		break;
	case Qt::Key_S:
		ToolSelector();
		break;
	case Qt::Key_R:
		ToolDrag();
		break;
	case Qt::Key_P:
		ToolComp();
		break;
	case Qt::Key_B:
		ToolBus();
		break;
	case Qt::Key_W:
		ToolWire();
		break;
	case Qt::Key_D:
		ToolDash();
		break;
	case Qt::Key_J:
		ToolJunction();
		break;
	case Qt::Key_N:
		ToolBEntry();
		break;
	case Qt::Key_E:
		ToolEntry();
		break;
	case Qt::Key_T:
		ToolTag();
		break;
	case Qt::Key_L:
		ToolLabel();
		break;
	case Qt::Key_C:
		ToolCmnt();
		break;
	}

}


void ApplicationWindow::closeEvent( QCloseEvent* ce )
{
	if(m_pXBSchView->isDirty()){
		switch( QMessageBox::information( this, "Close Qt-BSch3V document",
				      "The current document has been changed since the last save.",
				      "Save Now", "Leave Anyway", "Cancel",
				      0, 2) ) {
		case 0:
			if(save() == 0){
				ce->accept();
			}else{
				ce->ignore();
			}			
			break;
    	case 1:
			ce->accept();
			break;
    	case 2:
    	default:
			ce->ignore();
			break;
    	}
	}else{
		ce->accept();
	}	
}


void ApplicationWindow::about()
{
	QPixmap icon( (const char**)xbschicon );

	QMessageBox mb(this);

	mb.setMinimumWidth(400);
	mb.setCaption("About  Qt-BSch3V");
	mb.setTextFormat(Qt::RichText);
	mb.setText(	
			"<center><b>Qt-BSch3V  Version 0.47</b><br><br>"
			"Copyright(C) 2002-2006 H.Okada(Suigyodo)<br>"
			"Qt-BSch3V comes with absolutely no warranty.<br>"
			"URL  http://www.suigyodo.com/online<br>"
			"E-Mail  hitoshi@suigyodo.com</center>"
		);
	mb.setIconPixmap(icon);
	//mb.adjustSize();
	mb.exec();
}


void ApplicationWindow::aboutQt()
{
    QMessageBox::aboutQt( this, "About Qt" );
}

//EDIT
void ApplicationWindow::EditUndo()
{
	m_pXBSchView->undo();

//	qDebug("void ApplicationWindow::EditUndo()\n");
}
void ApplicationWindow::EditCut()
{
	m_pXBSchView->cut();
}
void ApplicationWindow::EditCopy()
{
	//printf("EditCopy()\n");
	m_pXBSchView->copy();
}
void ApplicationWindow::EditPaste()
{
	m_pXBSchView->paste();
}
void ApplicationWindow::EditDelete()
{
	m_pXBSchView->del();
}
void ApplicationWindow::EditAttr()
{
	m_pXBSchView->attribute();
}

void ApplicationWindow::EditMirror()
{
	m_pXBSchView->mirror();
}
void ApplicationWindow::EditRotate()
{
	m_pXBSchView->rotate();
}
void ApplicationWindow::EditInvert()
{
}
//VIEW
void ApplicationWindow::ViewRefresh()
{
	m_pXBSchView->RefreshView();
}

void ApplicationWindow::ZoomIn(bool menucommand)
{
	m_pXBSchView->ZoomIn(menucommand);
	m_nMenuItemViewZoomIn->setEnabled(m_pXBSchView->CanZoomIn());
	m_nMenuItemViewZoomOut->setEnabled(m_pXBSchView->CanZoomOut());


//	menuBar()->setItemEnabled(m_nMenuItemViewZoomOut,m_pXBSchView->CanZoomOut());
//	menuBar()->setItemEnabled(m_nMenuItemViewZoomIn,m_pXBSchView->CanZoomIn());
}
void ApplicationWindow::ZoomOut(bool menucommand)
{
	m_pXBSchView->ZoomOut(menucommand);
	m_nMenuItemViewZoomIn->setEnabled(m_pXBSchView->CanZoomIn());
	m_nMenuItemViewZoomOut->setEnabled(m_pXBSchView->CanZoomOut());

//	menuBar()->setItemEnabled(m_nMenuItemViewZoomOut,m_pXBSchView->CanZoomOut());
//	menuBar()->setItemEnabled(m_nMenuItemViewZoomIn,m_pXBSchView->CanZoomIn());
}


void ApplicationWindow::ViewZoomIn()
{
	ZoomIn(true);
}
void ApplicationWindow::ViewZoomOut()
{
	ZoomOut(true);
}

void ApplicationWindow::ViewGridOnOff()
{
	bool bGridOn =!m_pXBSchView->displayGrid();
//	bool bGridOn =!(menuBar()->isItemChecked(m_nMenuItemViewGrid));
	m_nMenuItemViewGrid->setChecked(bGridOn);
//	menuBar()->setItemChecked(m_nMenuItemViewGrid,bGridOn);
	m_pXBSchView->setDisplayGrid(bGridOn);
	g_cfg.setInt("VIEW","GRID",bGridOn);
}

//TOOL
void ApplicationWindow::ToolSelector()
{
	//qDebug("void ApplicationWindow::ToolSelector()");
	m_pXBSchView->setToolMode(TOOL_SELECTOR);
	SetToolButtonState();
}

void ApplicationWindow::ToolDrag()
{
	m_pXBSchView->setToolMode(TOOL_DRAG);
	SetToolButtonState();
}
void ApplicationWindow::ToolComp()
{
	m_pXBSchView->setToolMode(TOOL_COMPONENT);
	SetToolButtonState();
}
void ApplicationWindow::ToolBus()
{
	m_pXBSchView->setToolMode(TOOL_BUS);
	SetToolButtonState();
}
void ApplicationWindow::ToolWire()
{
	m_pXBSchView->setToolMode(TOOL_WIRE);
	SetToolButtonState();
}
void ApplicationWindow::ToolDash()
{
	m_pXBSchView->setToolMode(TOOL_DASH);
	SetToolButtonState();
}
void ApplicationWindow::ToolJunction()
{
	m_pXBSchView->setToolMode(TOOL_JUNCTION);
	SetToolButtonState();
}
void ApplicationWindow::ToolBEntry()
{
	m_pXBSchView->setToolMode(TOOL_BENTRY);
	SetToolButtonState();
}
void ApplicationWindow::ToolEntry()
{
	m_pXBSchView->setToolMode(TOOL_ENTRY);
	SetToolButtonState();
}
void ApplicationWindow::ToolTag()
{
	m_pXBSchView->setToolMode(TOOL_TAG);
	SetToolButtonState();
}
void ApplicationWindow::ToolLabel()
{
	m_pXBSchView->setToolMode(TOOL_LABEL);
	SetToolButtonState();
}
void ApplicationWindow::ToolCmnt()
{
	m_pXBSchView->setToolMode(TOOL_COMMENT);
	SetToolButtonState();
}

//SET
void ApplicationWindow::SetSheetSize()
{
	m_pXBSchView->resize();
}


//ӥ塼ǤΥ֤ΰư
void ApplicationWindow::cursorMove(int x,int y)
{
	char buff[16];
	sprintf(buff," X:%04d ",x);
	m_plabelX->setText(buff);
	sprintf(buff," Y:%04d ",y);
	m_plabelY->setText(buff);
}

//ӥ塼ǤΥġζѹξ
void ApplicationWindow::toolChange()
{
	//printf("ApplicationWindow::toolChange()\n");
	SetToolButtonState();
}

void ApplicationWindow::redrawAll()
{
	int windowCount=m_appWindowList.count();
	int n;
	for(n=0;n<windowCount;n++){
		ApplicationWindow * w = (ApplicationWindow*)m_appWindowList.at(n);
		w->m_pXBSchView->RefreshView();
		//w->m_pXBSchView->erase();
		//qDebug("redrawAll()\n");
	}
}	

//Edit˥塼Υߥ󥰤
void ApplicationWindow::setupEditMenu()
{
	m_nMenuItemEditUndo->setEnabled(m_pXBSchView->canUndo());
	m_nMenuItemEditCut->setEnabled(m_pXBSchView->canCut());
	m_nMenuItemEditCopy->setEnabled(m_pXBSchView->canCopy());
	m_nMenuItemEditPaste->setEnabled(m_pXBSchView->canPaste());
	m_nMenuItemEditDelete->setEnabled(m_pXBSchView->canDel());
	m_nMenuItemEditAttr->setEnabled(m_pXBSchView->canAttribute());
	m_nMenuItemEditMirror->setEnabled(m_pXBSchView->canMirror());
	m_nMenuItemEditRotate->setEnabled(m_pXBSchView->canRotate());
	m_nMenuItemEditMoveTo0->setEnabled(m_pXBSchView->canMoveToLayer(0));
	m_nMenuItemEditMoveTo1->setEnabled(m_pXBSchView->canMoveToLayer(1));
	m_nMenuItemEditMoveTo2->setEnabled(m_pXBSchView->canMoveToLayer(2));
	m_nMenuItemEditMoveTo3->setEnabled(m_pXBSchView->canMoveToLayer(3));
	m_nMenuItemEditMoveTo4->setEnabled(m_pXBSchView->canMoveToLayer(4));
	m_nMenuItemEditMoveTo5->setEnabled(m_pXBSchView->canMoveToLayer(5));
	m_nMenuItemEditMoveTo6->setEnabled(m_pXBSchView->canMoveToLayer(6));
	m_nMenuItemEditMoveTo7->setEnabled(m_pXBSchView->canMoveToLayer(7));
}


//Window˥塼Υߥ󥰤
void ApplicationWindow::setupWindowMenu()
{
	//printf("setupWindowMenu \n");
	QString fn;
	m_menuWindow->clear();
	int windowCount=m_appWindowList.count();
	int n;
	for(n=0;n<windowCount;n++){
		ApplicationWindow * w = (ApplicationWindow*)m_appWindowList.at(n);
		fn=w->fileName();
		if(fn.isEmpty()) fn="Untitled";
		QAction* action = m_menuWindow->addAction(fn);
		action->setData(QVariant::QVariant(n));
		action->setCheckable(true);
		if(w==this){
			action->setChecked(true);
		}
//		m_menuWindow->insertItem(fn,n);
//		if(w==this){
//			m_menuWindow->setItemChecked(n,true);
//		}
    }
	

}

//Window˥塼Υƥब򤵤줿ȤSLOT
void ApplicationWindow::selectActiveDocument(QAction* action)
{
	int id=action->data().toInt();
	int windowCount=m_appWindowList.count();
	if(id<0 || windowCount<=id)return;
	ApplicationWindow * w = (ApplicationWindow*)m_appWindowList.at(id);
	w->setActiveWindow();
	w->raise();		//2005/06/11
}
//void ApplicationWindow::selectActiveDocument(int id)
//{
//	int windowCount=m_appWindowList.count();
//	if(id<0 || windowCount<=id)return;
//	ApplicationWindow * w = (ApplicationWindow*)m_appWindowList.at(id);
//	w->setActiveWindow();
//	w->raise();		//2005/06/11
//}

void ApplicationWindow::SetSnap()
{
	bool bCheck =!m_pXBSchView->snapGrid();
//	bool bCheck =!(menuBar()->isItemChecked(m_nMenuItemSetSnap));
	m_nMenuItemSetSnap->setChecked(bCheck);
//	menuBar()->setItemChecked(m_nMenuItemSetSnap,bCheck);
	m_pXBSchView->setSnapGrid(bCheck);
	g_cfg.setInt("SET","SNAP",bCheck);
}

//饤֥Ԥ
void ApplicationWindow::SetLibrary()
{
	QStringList list;
	int n;
	char szKey[32];
	string filename;
	for(n=0;n<MAX_LIB;n++){
		sprintf(szKey,"LIB%d",n);
		if(g_cfg.getString("Library",szKey,filename)){
			list.append(QString::fromLocal8Bit(filename.c_str()));
		}else{
			break;
		}
	}
	SetLib* dlg=new SetLib(this,0,true);
	dlg->setFiles(list);
	if(dlg->exec()){
		//qDebug("void ApplicationWindow::SetLibrary() OK\n");
		list.clear();
		list=dlg->selectedFiles();
		QStringList::Iterator it = list.begin();
		for(n=0;n<MAX_LIB;n++){
			sprintf(szKey,"LIB%d",n);
			if(it != list.end()){
				if(!(*it).isEmpty()){
					string strData = string((*it).local8Bit());
					g_cfg.setString("Library",szKey,strData);
				}else{
					g_cfg.setString("Library",szKey,"");
				}
				it++;
			}else{
				g_cfg.setString("Library",szKey,"");
			}
		}
		delete dlg;
		g_FreeLibrary();
		g_ReadLibrary();

//		QMessageBox::information( this, "Set Library",
//								"You must restart Qt BSch before\nthe new settings will take effect.",
//								"OK",QString::null,QString::null,0,0);
	}else{
		delete dlg;
	}
}

void ApplicationWindow::SetFont()
{
	QFont font;
	int dpi,point,pixel;
	QDesktopWidget *desktop = QApplication::desktop();
	dpi=desktop->logicalDpiX();

	string strname;
	if(g_cfg.getString("Font","Name",strname)){
		font=QFont(QString::fromLocal8Bit(strname.c_str()));
		int n;
		if(g_cfg.getInt("Font","Size",pixel)){
			point=(pixel*72+dpi-1)/dpi;			
			font.setPointSize(point);
		}
		if(g_cfg.getInt("Font","Bold",n)) font.setBold(n!=0);
		if(g_cfg.getInt("Font","Italic",n)) font.setItalic(n!=0);
		if(g_cfg.getInt("Font","Underline",n)) font.setStrikeOut(n!=0);
		if(g_cfg.getInt("Font","StrikeOut",n)) font.setUnderline(n!=0);
	}		

	bool ok;
	font=QFontDialog::getFont(&ok,font,this);
	if(ok){
		g_cfg.setString("Font","Name",string(font.family().local8Bit()));
		//QFontInfo fontInfo(font);
	
		point=font.pointSize();
		pixel=point*dpi/72;
		//int m,n,n2,n3;
		//n3=desktop->logicalDpiX();
		//m=fontInfo.pixelSize();
		//n=font.pixelSize();
		//n2=font.pointSize();
		//printf(" ApplicationWindow::SetFont() output %d,%d,%d,%d\n",m,n,n2,n3);
		//g_cfg.setInt("Font","Size",fontInfo.pixelSize());
		g_cfg.setInt("Font","Size",pixel);
		g_cfg.setInt("Font","Bold",font.bold()?1:0);
		g_cfg.setInt("Font","Italic",font.italic()?1:0);
		g_cfg.setInt("Font","Underline",font.underline()?1:0);
		g_cfg.setInt("Font","StrikeOut",font.strikeOut()?1:0);
		m_pXBSchView->setDefaultFont();
	}
}

void ApplicationWindow::SetSmallFont()
{
	QFont font;
	int dpi,point,pixel;
	QDesktopWidget *desktop = QApplication::desktop();
	dpi=desktop->logicalDpiX();
	string strname;
	if(g_cfg.getString("SmallFont","Name",strname)){
		font=QFont(QString::fromLocal8Bit(strname.c_str()));
		int n;
		if(g_cfg.getInt("SmallFont","Size",pixel)){
			point=(pixel*72+dpi-1)/dpi;			
			font.setPointSize(point);
		}
		if(g_cfg.getInt("SmallFont","Bold",n)) font.setBold(n!=0);
		if(g_cfg.getInt("SmallFont","Italic",n)) font.setItalic(n!=0);
		if(g_cfg.getInt("SmallFont","Underline",n)) font.setStrikeOut(n!=0);
		if(g_cfg.getInt("SmallFont","StrikeOut",n)) font.setUnderline(n!=0);
	}		

	bool ok;
	font=QFontDialog::getFont(&ok,font,this);
	if(ok){
		g_cfg.setString("SmallFont","Name",string(font.family().local8Bit()));
		//QFontInfo fontInfo(font);
		point=font.pointSize();
		pixel=point*dpi/72;
		font.setPixelSize(pixel);
		g_cfg.setInt("SmallFont","Size",pixel);
		g_cfg.setInt("SmallFont","Bold",font.bold()?1:0);
		g_cfg.setInt("SmallFont","Italic",font.italic()?1:0);
		g_cfg.setInt("SmallFont","Underline",font.underline()?1:0);
		g_cfg.setInt("SmallFont","StrikeOut",font.strikeOut()?1:0);
		g_SmallFont.SetFont(font);
		redrawAll();
		//m_pXBSchView->setSmallFont();
	}
}


//ġΥܥξ֤ȥ˥塼Υå֤ꤹ
void ApplicationWindow::SetToolButtonState()
{
	BSCH_TOOL_MODE toolmode = m_pXBSchView->toolMode();
	//˥塼Υå
	m_nMenuItemToolSelect->setChecked(toolmode == TOOL_SELECTOR);
    m_nMenuItemToolDrag->setChecked(toolmode == TOOL_DRAG);
    m_nMenuItemToolComp->setChecked(toolmode == TOOL_COMPONENT);
    m_nMenuItemToolBus->setChecked(toolmode == TOOL_BUS);
    m_nMenuItemToolWire->setChecked(toolmode == TOOL_WIRE);
    m_nMenuItemToolDash->setChecked(toolmode == TOOL_DASH);
    m_nMenuItemToolJunc->setChecked(toolmode == TOOL_JUNCTION);
    m_nMenuItemToolBEnt->setChecked(toolmode == TOOL_BENTRY);
	m_nMenuItemToolEnt->setChecked(toolmode == TOOL_ENTRY);
	m_nMenuItemToolTag->setChecked(toolmode == TOOL_TAG);
	m_nMenuItemToolLabel->setChecked(toolmode == TOOL_LABEL);
	m_nMenuItemToolCmnt->setChecked(toolmode == TOOL_COMMENT);
	//ġСΥܥξ
	m_ptbToolSelect->setOn(toolmode == TOOL_SELECTOR);
    m_ptbToolDrag->setOn(toolmode == TOOL_DRAG);
    m_ptbToolComp->setOn(toolmode == TOOL_COMPONENT);
    m_ptbToolBus->setOn(toolmode == TOOL_BUS);
    m_ptbToolWire->setOn(toolmode == TOOL_WIRE);
    m_ptbToolDash->setOn(toolmode == TOOL_DASH);
    m_ptbToolJunc->setOn(toolmode == TOOL_JUNCTION);
    m_ptbToolBEnt->setOn(toolmode == TOOL_BENTRY);
	m_ptbToolEnt->setOn(toolmode == TOOL_ENTRY);
	m_ptbToolTag->setOn(toolmode == TOOL_TAG);
	m_ptbToolLabel->setOn(toolmode == TOOL_LABEL);
	m_ptbToolCmnt->setOn(toolmode == TOOL_COMMENT);
}

//ץꥱΥץ
void ApplicationWindow::setAppCaption()
{
	QFileInfo finfo(m_filename);

	QString caption = "Qt-BSch3V - ";
	caption += finfo.fileName();
	setCaption( caption );
}

void ApplicationWindow::MoveToLayer0()
{
	m_pXBSchView->moveToLayer(0);
}
void ApplicationWindow::MoveToLayer1()
{
	m_pXBSchView->moveToLayer(1);
}
void ApplicationWindow::MoveToLayer2()
{
	m_pXBSchView->moveToLayer(2);
}
void ApplicationWindow::MoveToLayer3()
{
	m_pXBSchView->moveToLayer(3);
}
void ApplicationWindow::MoveToLayer4()
{
	m_pXBSchView->moveToLayer(4);
}
void ApplicationWindow::MoveToLayer5()
{
	m_pXBSchView->moveToLayer(5);
}
void ApplicationWindow::MoveToLayer6()
{
	m_pXBSchView->moveToLayer(6);
}
void ApplicationWindow::MoveToLayer7()
{
	m_pXBSchView->moveToLayer(7);
}

void ApplicationWindow::SetupLayer()
{
	setlayerdlg dlg(this);
	dlg.setVisibleLayer(m_pXBSchView->visibleLayer());
	dlg.setActiveLayer(m_pXBSchView->activeLayer());
	dlg.setDarkenNonActive(m_pXBSchView->darkenNonActiveLayer());
	if(dlg.exec()){
		m_pXBSchView->setVisibleLayer(dlg.visibleLayer());
		m_pXBSchView->setActiveLayer(dlg.activeLayer());
		bool darken = dlg.darkenNonActive();
		m_pXBSchView->setDarkenNonActiveLayer(darken);
		g_cfg.setInt("VIEW","DARKEN_NONACTIVE_LAYER",(darken ? 1 : 0));
		m_pXBSchView->RefreshView();
	}
}	
