/****************************************************************************
    Qt-BSch3V schematic capture
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/



#include <qapplication.h>
#include <qwindowsstyle.h>
#include <qdir.h>
#include <stdio.h>
#ifdef Q_WS_MACX
	#include <Carbon/Carbon.h>
#endif
#include "application.h"
#include "xbschglobal.h"


class SCmdlineOption{
public:
	SCmdlineOption();
	string openFileName;
	string configFileName;
	void setupOption(QApplication& a);
};

SCmdlineOption::SCmdlineOption()
{
	openFileName	="";
	configFileName	="";
}

void SCmdlineOption::setupOption(QApplication& a)
{
	int i;
	string var="";
	string val="";
	for(i=1;i<a.argc();i++){
		val=string(a.argv()[i]);
		if(val[0]=='-'){
			var=val;
		}else{
			if(var.length()==0){
				openFileName = val;
			}else if(var=="-conf"){
				configFileName = val;
			}
			var = "";
		}
	}
}

#ifdef Q_WS_MACX
OSStatus openDocumentsHandler(const AppleEvent* appleEvt,AppleEvent* reply,SInt32 refcon)
{
	//printf("openDocumentsHandler\n");

	AEDesc fileList ={typeNull,NULL};
	OSErr err;
	SInt32 itemsInList;

	
	err = AEGetParamDesc(appleEvt,keyDirectObject, typeAEList,&fileList);
	if(err == noErr){
		err = AECountItems(&fileList,&itemsInList);
		if(err == noErr && itemsInList >0){
			OSType keyword;
			OSType returnedType;
			Size actualSize;
			FSRef fileToOpen;
			char qstr_buf[1024];
			QString strFilename;
			int i;
			for(i=1;err==noErr && i<=itemsInList;i++){
				err = AESizeOfNthItem(&fileList, i, &returnedType, &actualSize);
				if(err == noErr){
					err = AEGetNthPtr(&fileList,i,typeFSRef,&keyword,
							&returnedType,&fileToOpen,
							sizeof(FSRef),&actualSize);
					if (err == noErr) {
						FSRefMakePath(&fileToOpen, (UInt8*)qstr_buf, 1024);
						strFilename=QString::fromUtf8(qstr_buf);
						ApplicationWindow * mw =ApplicationWindow::firstEmptyDocWindow();
						if(mw == NULL) mw = new ApplicationWindow();
						mw->show();
						mw->load(strFilename);
						mw->setActiveWindow();
					}
				}
			}
		}
		AEDisposeDesc(&fileList);
	}
	return err;
}

#endif

int main( int argc, char ** argv )
{

	//QApplication::setColorSpec(QApplication::ManyColor);
	QApplication a( argc, argv );

#ifdef Q_WS_X11
	QApplication::setStyle("windows");
#endif
	
#ifdef Q_WS_MACX
	QApplication::setStyle("plastique");	// Qt4.1.0ΥǥեȥΥġС礭뤿
#endif

	SCmdlineOption cmdoption;
	cmdoption.setupOption(a);

	g_strCfgFileName = cmdoption.configFileName;
	
	if(g_strCfgFileName.length()==0){
		//ޥɥ饤Ǥλ̵꤬äΥե졼ե̾
//#ifdef _WINDOWS
#ifdef Q_WS_WIN
		//WindowsǤǤϡȥǥ쥯ȥ qbsch.cfg
		g_strCfgFileName = string(QDir::currentDirPath().local8Bit());
		g_strCfgFileName = g_strCfgFileName + "/qbsch.cfg";
#else
		//LINUXǤǤϡۡǥ쥯ȥ .qbschrc
		g_strCfgFileName = string(QDir::homeDirPath().local8Bit());
		g_strCfgFileName = g_strCfgFileName + "/.qbschrc"; 
#endif
	}

	
	
	g_cfg.load(g_strCfgFileName.c_str());
	g_ReadLibrary();

#ifdef Q_WS_MACX
	AEInstallEventHandler(kCoreEventClass, kAEOpenDocuments,
			NewAEEventHandlerUPP((AEEventHandlerProcPtr)openDocumentsHandler),NULL,false);
	QTextCodec::setCodecForLocale(QTextCodec::codecForName("UTF-8"));
#endif

	ApplicationWindow * mw = new ApplicationWindow();

	mw->show();

	if(cmdoption.openFileName.length()>0){
		mw->load(QString::fromLocal8Bit(cmdoption.openFileName.c_str()));
	}
	
	a.connect( &a, SIGNAL(lastWindowClosed()), &a, SLOT(quit()) );
	
	int result = a.exec();
//	g_cfg.dump();
	g_cfg.save(g_strCfgFileName.c_str());

	g_FreeLibrary();

	

	return result;
}
