/****************************************************************************
    Qt-BSch3V schematic capture
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#include "setlib.h"

#include <q3listbox.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <q3whatsthis.h>
//Added by qt3to4:
#include <QGridLayout>

/* 
 *  Constructs a SetLibBase which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
SetLibBase::SetLibBase( QWidget* parent,  const char* name, bool modal, Qt::WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    if ( !name )
	setName( "SetLibBase" );
    resize( 348, 191 ); 
    setProperty( "windowTitle", tr( "Qt-BSch Set Library" ) );
 //   setProperty( "caption", tr( "Qt-BSch Set Library" ) );
    setProperty( "sizeGripEnabled", QVariant( FALSE, 0 ) );
    SetLibBaseLayout = new QGridLayout( this ); 
    SetLibBaseLayout->setSpacing( 6 );
    SetLibBaseLayout->setMargin( 11 );

    buttonOk = new QPushButton( this, "buttonOk" );
    //buttonOk->setProperty( "caption", tr( "" ) );
    buttonOk->setProperty( "text", tr( "&OK" ) );
    buttonOk->setProperty( "autoDefault", QVariant( TRUE, 0 ) );
    buttonOk->setProperty( "default", QVariant( TRUE, 0 ) );

    SetLibBaseLayout->addWidget( buttonOk, 0, 1 );

    buttonCancel = new QPushButton( this, "buttonCancel" );
    buttonCancel->setProperty( "text", tr( "&Cancel" ) );
    buttonCancel->setProperty( "autoDefault", QVariant( TRUE, 0 ) );

    SetLibBaseLayout->addWidget( buttonCancel, 1, 1 );

    buttonUp = new QPushButton( this, "buttonUp" );
    buttonUp->setProperty( "text", tr( "&Up" ) );

    SetLibBaseLayout->addWidget( buttonUp, 2, 1 );

    buttonDown = new QPushButton( this, "buttonDown" );
    buttonDown->setProperty( "text", tr( "&Down" ) );

    SetLibBaseLayout->addWidget( buttonDown, 3, 1 );

    buttonAdd = new QPushButton( this, "buttonAdd" );
    buttonAdd->setProperty( "text", tr( "&Add" ) );

    SetLibBaseLayout->addWidget( buttonAdd, 4, 1 );

    buttonRemove = new QPushButton( this, "buttonRemove" );
    buttonRemove->setProperty( "text", tr( "&Remove" ) );

    SetLibBaseLayout->addWidget( buttonRemove, 5, 1 );

    ListBox1 = new Q3ListBox( this, "ListBox1" );
    ListBox1->insertItem( tr( "New Item" ) );

    SetLibBaseLayout->addMultiCellWidget( ListBox1, 0, 5, 0, 0 );

    // signals and slots connections
    connect( buttonOk, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( buttonCancel, SIGNAL( clicked() ), this, SLOT( reject() ) );
    connect( buttonUp, SIGNAL( clicked() ), this, SLOT( OnUpButton() ) );
    connect( buttonDown, SIGNAL( clicked() ), this, SLOT( OnDownButton() ) );
    connect( buttonAdd, SIGNAL( clicked() ), this, SLOT( OnAddButton() ) );
    connect( buttonRemove, SIGNAL( clicked() ), this, SLOT( OnRemoveButton() ) );
    connect( ListBox1, SIGNAL( selectionChanged() ), this, SLOT( itemChanged() ) );
}

/*  
 *  Destroys the object and frees any allocated resources
 */
SetLibBase::~SetLibBase()
{
    // no need to delete child widgets, Qt does it all for us
}

void SetLibBase::OnAddButton()
{
    qWarning( "SetLibBase::OnAddButton(): Not implemented yet!" );
}

void SetLibBase::OnDownButton()
{
    qWarning( "SetLibBase::OnDownButton(): Not implemented yet!" );
}

void SetLibBase::OnUpButton()
{
    qWarning( "SetLibBase::OnUpButton(): Not implemented yet!" );
}

void SetLibBase::itemChanged()
{
    qWarning( "SetLibBase::itemChanged(): Not implemented yet!" );
}

void SetLibBase::OnRemoveButton()
{
    qWarning( "SetLibBase::OnRemoveButton(): Not implemented yet!" );
}

