/****************************************************************************
    Qt-BSch3V schematic capture
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#ifndef SETLIB_H
#define SETLIB_H
#include "setlib.h"

class QStringList;

class SetLib : public SetLibBase
{ 
    Q_OBJECT

protected:
	QStringList m_files;

public:
    SetLib( QWidget* parent = 0, const char* name = 0, bool modal = FALSE, Qt::WFlags fl = 0 );
    ~SetLib();
	int exec();
	void setFiles(const QStringList& files);
	QStringList selectedFiles();

public:
    void OnAddButton();
    void OnDownButton();
    void OnUpButton();
    void itemChanged();
    void OnRemoveButton();
	void setButtonEnable();
protected  slots:
	void accept();

};

#endif // SETLIB_H
