/****************************************************************************
    BSch3V and Utility common file.
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

/****************************************************************************
** XBSchǥ饹
****************************************************************************/
#ifndef XBSCHTAG_H
#define XBSCHTAG_H

#include "xbsch.h"
#include "xbschobj.h"

class SXBSchTag:public SXBSchObj
{

public:

	enum BSCHTAG_TYPE{
		TAG_SQ =0,
		TAG_LU =1,
		TAG_RD =2,
		TAG_BI =3
	};

	//󥹥ȥ饯
	SXBSchTag();
	//ǥȥ饯
	virtual ~SXBSchTag(){};

	bool readCe3(SReadCE3&,const SPoint* ,SXBSchDoc*);
	bool writeCe3(SWriteCE3& ,const SPoint* );
	

	//IDμ
	unsigned id(){return ID_TAG;}
protected:
	string m_strText;
	bool m_bHoriz;
	int m_nType;
public:
	int width();
	void setp2();
	// m_p1ޤϲˤʤ褦Ĵ
	void normalize();
	//ʣԤ
	SXBSchObj* duplicate();
	//ɸ  m_p2ؤ̵ˤƤ
	void setX2(int){}
	void setY2(int){}
	void setP2(const SPoint&){}
	//XɸꤷƺȿžԤ
	void mirrorH(int x);
	//XY濴ɸꤷơžԤ
	void rotate(const SPoint& p);
	//žԤ
	void rotate();
	//ꤷ٤֤
	int qSelectWeight(const SPoint& p);
	//ϰϤꤷԤ
	unsigned testSelection(const SRect& rc);
	//ϰϤ򤷤ƥɥåԤ
	unsigned testSelectionForDrag(const SRect& rc);
	//褬ɬפɤ֤
	bool qRedraw(const SRect& rc);
	//ͭϰϤ֤
	SRect area();
	SRect rotateRect();
	//ԥ֤
	int pinCount()const {return 2;}
	//nܤΥԥΰ֤롣
	SPoint pinPosition(int n) const;

public:
	bool canAttribute(){return true;}
	//ͭʥ֥Ȥʤtrue֤
	bool qValid(){return true;}

	bool horizontal(){ return m_bHoriz; }
	void setHorizontal(bool horizFlag){m_bHoriz = horizFlag;}
	int	 tagType(){ return m_nType; }
	void setTagType(int nType){ assert(nType>=0 && nType<=3); m_nType = nType ; }
	void setText(const char* psz);
	const char* text(){return m_strText.c_str();}

};

#endif
