dnl AM_PATH_RUBY([MAJOR], [MINOR], [TEENY])
dnl Adds support for Ruby
AC_DEFUN([AM_PATH_RUBY],
[
  required_ruby_version="$1.$2.$3"

  AC_ARG_WITH(ruby,
  AC_HELP_STRING([--with-ruby=PATH],[path to ruby]),
  [
    AC_MSG_RESULT([using $withval for ruby])
    RUBY="$withval"
  ], [
    AC_PATH_PROG(RUBY, ruby, no)
  ])
  HAVE_RUBY="no"
  if test "$RUBY" != "no"; then
    AC_MSG_CHECKING(Ruby version)
    RUBY_VERSION=`$RUBY -e 'print RUBY_VERSION'`
    AC_MSG_RESULT([$RUBY_VERSION])
    if $RUBY -e "exit(RUBY_VERSION < \"$required_ruby_version\" ? 0 : 1)"; then
      AC_MSG_WARN([$required_ruby_version is required])
    else
      if ! $RUBY -r mkmf -e 0 2> /dev/null; then
        AC_MSG_WARN([mkmf.rb not found])
      else
        ruby_site_install="yes"
        AC_ARG_ENABLE(ruby-site-install,
        AC_HELP_STRING([--disable-ruby-site-install],
                       [do not install ruby libraries to site_ruby]),
        [
          ruby_site_install="$enableval"
        ])

        changequote(<<, >>)dnl
        if test "x$ruby_site_install" = "xyes"; then
          rubylibdir=`$RUBY -r rbconfig -e 'print Config::CONFIG["sitelibdir"]'`
          rubyarchdir=`$RUBY -r rbconfig -e 'print Config::CONFIG["sitearchdir"]'`
        else
          rubylibdir=`$RUBY -r rbconfig -e 'print Config::CONFIG["rubylibdir"]'`
          rubyarchdir=`$RUBY -r rbconfig -e 'print Config::CONFIG["archdir"]'`
        fi
        changequote([, ])dnl

        AC_ARG_WITH(rubylibdir,
        AC_HELP_STRING([--with-rubylibdir=DIR],
                       [path to directory for ruby libraries]),
        [
          AC_MSG_RESULT([using $withval for rubylibdir])
          rubylibdir="$withval"
        ])

        AC_ARG_WITH(rubyarchdir,
        AC_HELP_STRING([--with-rubyarchdir=DIR],
                       [path to directory for ruby extension libraries]),
        [
          AC_MSG_RESULT([using $withval for rubyarchdir])
          rubyarchdir="$withval"
        ])

        changequote(<<, >>)dnl
        HAVE_RUBY="yes"
        RUBY_CC=`$RUBY -r rbconfig -e 'print Config::CONFIG["CC"]'`
        RUBY_CFLAGS=`$RUBY -r rbconfig -e 'print Config::CONFIG["CFLAGS"]'`
        RUBY_INCLUDES=`$RUBY -r rbconfig -e 'print " -I" + Config::CONFIG["archdir"]'`
        RUBY_LDSHARED=`$RUBY -r rbconfig -e 'print Config::CONFIG["LDSHARED"]'`
        RUBY_DLDFLAGS=`$RUBY -r rbconfig -e 'print Config::CONFIG["DLDFLAGS"]'`
        RUBY_OBJEXT=`$RUBY -r rbconfig -e 'print Config::CONFIG["OBJEXT"]'`
        RUBY_DLEXT=`$RUBY -r rbconfig -e 'print Config::CONFIG["DLEXT"]'`
        RUBY_SHARED=`$RUBY -r rbconfig -e 'print Config::CONFIG["ENABLE_SHARED"]'`
        if test "$RUBY_SHARED" = "yes"; then
          RUBY_LIBS=`$RUBY -r rbconfig -e 'print Config::CONFIG["LIBRUBYARG"].gsub(/-L\./, "-L" + Config::CONFIG["libdir"]) + " " + Config::CONFIG["LIBS"]'`
          RUBY_EXT_LIBS="$RUBY_LIBS"
        else
          RUBY_LIBS=`$RUBY -r rbconfig -e 'print Config::CONFIG["archdir"] + "/" + Config::CONFIG["LIBRUBYARG"] + " " + Config::CONFIG["LIBS"]'`
          RUBY_EXT_LIBS=`$RUBY -r rbconfig -e 'Config::CONFIG["LIBS"]'`
        fi
        changequote([, ])dnl
      fi
    fi
  fi
  AC_SUBST(HAVE_RUBY)
  AC_SUBST(RUBY_VERSION)
  AC_SUBST(RUBY_CC)
  AC_SUBST(RUBY_CFLAGS)
  AC_SUBST(RUBY_INCLUDES)
  AC_SUBST(RUBY_LDSHARED)
  AC_SUBST(RUBY_DLDFLAGS)
  AC_SUBST(RUBY_OBJEXT)
  AC_SUBST(RUBY_DLEXT)
  AC_SUBST(RUBY_SHARED)
  AC_SUBST(RUBY_LIBS)
  AC_SUBST(RUBY_EXT_LIBS)
  AC_SUBST(rubylibdir)
  AC_SUBST(rubyarchdir)
])
