# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

require "open3"

module MSOfficeProperty
  def extract_property(filter, mime_type, path)
    db_encoding = filter.db_encoding

    encoding_map = {"932" => "CP932"}
    input_encoding = nil
    Open3.popen3("wvSummary #{path}") do |stdin, stdout, stderr|
      db_properties = {}
      s = stdout.read
      if (match_data = /^Codepage is .*\((.*)\)$/.match(s))
        input_encoding = encoding_map[match_data[1]]
      else
        input_encoding = db_encoding
      end

      ["title", "author"].each do |name|
        if (match_data = /^The #{name} is (.*)$/i.match(s))
          db_properties[name] = match_data[1]
        end
      end
      db_properties.each do |key, value|
        property = Rast::EncodingConverter.convert_encoding(input_encoding,
                                                            db_encoding, value)
        filter.set_property(key, property)
      end
    end
  end
end
