# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

require "test/unit"
require "tempfile"

require "rast_test"

module Rast
  class FileBucketTest < Test::Unit::TestCase
    def setup
      @tempfile = Tempfile.new("file_bucket")
      @tempfile.close(false)
      @file = File.open(@tempfile.path, "w+")
    end

    def teardown
      @tempfile.close(true)
    end

    def test_s_new
      assert_instance_of(FileBucket, FileBucket.new(@file))
    end

    def test_file_p
      bucket = FileBucket.new(@file)
      assert_equal(false, bucket.eos?)
      assert_equal(true, bucket.file?)
      assert_equal(false, bucket.transient?)
    end

    def test_read
      @file.write("ŷʤ")
      @file.flush
      @file.rewind
      bucket = FileBucket.new(@file)
      assert_equal("ŷʤ", bucket.read)
    end
  end
end
