# Copyright (C) 2005  Network Applied Communication Laboratory Co., Ltd.
#
# This file is part of Rast.
# See the file COPYING for redistribution information.
#

require "test/unit"

require "rast_test"
require "rast/filter"

module Rast
  module Filter
    load_mime_filter("rfc822.rb")

    class MessageRfc822Test < Test::Unit::TestCase
      def test_invoke
        invoke_test_simple
      end

      def invoke_test_simple
        filter = SpoofFilter.new("UTF-8")
        brigade = Brigade.new
        filename = File.join(MakeVariable::TOP_SRCDIR, "tests", "data",
                             "filter", "ja", "single-part.mail")
        File.open(filename) do |f|
          bucket = FileBucket.new(f)
          brigade.insert_tail(bucket)
          brigade.insert_tail(EOSBucket.new)
          filter_module = MessageRfc822.new
          filter_module.invoke(filter, brigade, "message/rfc822")
        end

        buf = ""
        filter.passed[0].brigade.each do |bucket|
          buf.concat(bucket.read)
        end
        assert_equal("これはメールです\n", NKF.nkf("-Jw", buf))
        assert_equal("text/plain", filter.passed[0].mime_type)
        assert_equal(1, filter.passed.length)
        assert_equal("from-test@example.com", filter.properties["from"])
        assert_equal("to-test@example.com", filter.properties["to"])
        assert_equal("メールテスト", filter.properties["subject"])
        assert_equal("from-test@example.com", filter.properties["author"])
        assert_equal("メールテスト", filter.properties["title"])
        assert_equal(5, filter.properties.length)
      end
    end
  end
end
