/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

public class TestSuite
implements Test {
    private Vector fTests = new Vector(10);
    private String fName;
    static /* synthetic */ Class class$junit$framework$Test;
    static /* synthetic */ Class class$java$lang$String;

    public TestSuite() {
    }

    public TestSuite(Class theClass) {
        this.fName = theClass.getName();
        Constructor constructor = this.getConstructor(theClass);
        if (!Modifier.isPublic(theClass.getModifiers())) {
            this.addTest(this.warning("Class " + theClass.getName() + " is not public"));
            return;
        }
        if (constructor == null) {
            this.addTest(this.warning("Class " + theClass.getName() + " has no public constructor TestCase(String name)"));
            return;
        }
        Class superClass = theClass;
        Vector names = new Vector();
        while ((class$junit$framework$Test != null ? class$junit$framework$Test : TestSuite.class$("junit.framework.Test")).isAssignableFrom(superClass)) {
            Method[] methods = superClass.getDeclaredMethods();
            int i = 0;
            while (i < methods.length) {
                this.addTestMethod(methods[i], names, constructor);
                ++i;
            }
            superClass = superClass.getSuperclass();
        }
        if (this.fTests.size() == 0) {
            this.addTest(this.warning("No tests found in " + theClass.getName()));
        }
    }

    public TestSuite(String name) {
        this.fName = name;
    }

    public void addTest(Test test) {
        this.fTests.addElement(test);
    }

    private void addTestMethod(Method m, Vector names, Constructor constructor) {
        String name = m.getName();
        if (names.contains(name)) {
            return;
        }
        if (this.isPublicTestMethod(m)) {
            names.addElement(name);
            Object[] args = new Object[]{name};
            try {
                this.addTest((Test)constructor.newInstance(args));
            }
            catch (Exception exception) {
                this.addTest(this.warning("Cannot instantiate test case: " + name));
            }
        } else if (this.isTestMethod(m)) {
            this.addTest(this.warning("Test method isn't public: " + m.getName()));
        }
    }

    public void addTestSuite(Class testClass) {
        this.addTest(new TestSuite(testClass));
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public int countTestCases() {
        int count = 0;
        Enumeration e = this.tests();
        while (e.hasMoreElements()) {
            Test test = (Test)e.nextElement();
            count += test.countTestCases();
        }
        return count;
    }

    private Constructor getConstructor(Class theClass) {
        Class[] args = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = TestSuite.class$("java.lang.String"))};
        Constructor c = null;
        try {
            c = theClass.getConstructor(args);
        }
        catch (Exception exception) {}
        return c;
    }

    private boolean isPublicTestMethod(Method m) {
        return this.isTestMethod(m) && Modifier.isPublic(m.getModifiers());
    }

    private boolean isTestMethod(Method m) {
        String name = m.getName();
        Class<?>[] parameters = m.getParameterTypes();
        Class<?> returnType = m.getReturnType();
        return parameters.length == 0 && name.startsWith("test") && returnType.equals(Void.TYPE);
    }

    public void run(TestResult result) {
        Enumeration e = this.tests();
        while (e.hasMoreElements()) {
            if (result.shouldStop()) break;
            Test test = (Test)e.nextElement();
            this.runTest(test, result);
        }
    }

    public void runTest(Test test, TestResult result) {
        test.run(result);
    }

    public Test testAt(int index) {
        return (Test)this.fTests.elementAt(index);
    }

    public int testCount() {
        return this.fTests.size();
    }

    public Enumeration tests() {
        return this.fTests.elements();
    }

    public String toString() {
        if (this.fName != null) {
            return this.fName;
        }
        return super.toString();
    }

    private Test warning(final String message) {
        return new TestCase("warning"){

            protected void runTest() {
                Assert.fail(message);
            }
        };
    }
}

