/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.stree;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.stree.DocImpl;
import org.apache.xalan.stree.DocumentFragmentImpl;
import org.apache.xalan.stree.DocumentImpl;
import org.apache.xalan.stree.DocumentTypeImpl;
import org.apache.xalan.stree.EntityImpl;
import org.apache.xalan.stree.Parent;
import org.apache.xalan.stree.StreeDOMBuilder;
import org.apache.xalan.stree.StreeDOMHelper;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.DOMBuilder;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xpath.SourceTreeManager;
import org.apache.xpath.XPathContext;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SourceTreeHandler
extends DefaultHandler
implements TransformerHandler,
DeclHandler,
DTDHandler {
    TransformerImpl m_transformer;
    private DOMBuilder m_sourceTreeHandler;
    private DocImpl m_root;
    private DocumentFragment m_docFrag;
    private boolean m_initedRoot;
    boolean m_shouldCheckWhitespace = false;
    boolean m_shouldTransformAtEnd = true;
    private Source m_inputSource;
    private boolean m_useMultiThreading = false;
    private int m_entryCount = 0;
    private static final boolean DEBUG = false;
    private boolean indexedLookup = false;
    private int m_eventsCount = 0;
    private int m_maxEventsToNotify = 18;
    private boolean m_isCData = false;
    private boolean m_inDTD = false;
    private boolean m_shouldStripWS = false;
    private BoolStack m_shouldStripWhitespaceStack = new BoolStack();

    public SourceTreeHandler() {
        this.m_root = new DocumentImpl(this);
        this.m_initedRoot = false;
    }

    public SourceTreeHandler(TransformerImpl transformerImpl) {
        this(transformerImpl, false);
    }

    public SourceTreeHandler(TransformerImpl transformerImpl, boolean bl) {
        this.m_transformer = transformerImpl;
        XPathContext xPathContext = transformerImpl.getXPathContext();
        xPathContext.setDOMHelper(new StreeDOMHelper());
        if (bl) {
            this.m_root = new DocumentFragmentImpl(1024);
            this.m_docFrag = (DocumentFragmentImpl)this.m_root;
        } else {
            this.m_root = new DocumentImpl(this);
        }
        this.m_initedRoot = false;
        this.m_shouldCheckWhitespace = transformerImpl.getStylesheet().shouldCheckWhitespace();
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_inDTD) {
            return;
        }
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_sourceTreeHandler.characters(cArray, n, n2);
        }
        this.notifyWaiters();
    }

    public void charactersRaw(char[] cArray, int n, int n2) throws SAXException {
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_sourceTreeHandler.charactersRaw(cArray, n, n2);
        }
        this.notifyWaiters();
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_inDTD) {
            return;
        }
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_sourceTreeHandler.comment(cArray, n, n2);
        }
        this.notifyWaiters();
    }

    public void elementDecl(String string, String string2) throws SAXException {
    }

    public void endCDATA() throws SAXException {
        this.m_isCData = false;
    }

    public void endDTD() throws SAXException {
        this.m_inDTD = false;
    }

    public void endDocument() throws SAXException {
        DocImpl docImpl;
        this.m_eventsCount = this.m_maxEventsToNotify;
        DocImpl docImpl2 = docImpl = this.m_root;
        synchronized (docImpl2) {
            this.m_sourceTreeHandler.endDocument();
            this.m_root.setComplete(true);
            this.popShouldStripWhitespace();
            if (!this.m_useMultiThreading && this.m_transformer != null && this.m_shouldTransformAtEnd) {
                try {
                    this.m_transformer.transformNode(this.m_root);
                }
                catch (TransformerException transformerException) {
                    throw new SAXException(transformerException);
                }
            }
        }
        this.m_eventsCount = this.m_maxEventsToNotify;
        this.notifyWaiters();
        if (this.m_useMultiThreading && this.m_transformer != null) {
            this.m_transformer.waitTransformThread();
        }
        --this.m_entryCount;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            Parent parent = (Parent)this.m_sourceTreeHandler.getCurrentNode();
            this.m_sourceTreeHandler.endElement(string, string2, string3);
            parent.setComplete(true);
            this.m_shouldStripWS = this.m_shouldStripWhitespaceStack.popAndTop();
        }
        this.notifyWaiters();
    }

    public void endEntity(String string) throws SAXException {
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_sourceTreeHandler.endEntity(string);
        }
        this.notifyWaiters();
    }

    public void endPrefixMapping(String string) throws SAXException {
        this.m_sourceTreeHandler.endPrefixMapping(string);
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
    }

    public Source getInputSource() {
        return this.m_inputSource;
    }

    public Node getRoot() {
        return this.m_root;
    }

    boolean getShouldStripWhitespace() {
        return this.m_shouldStripWS;
    }

    public String getSystemId() {
        return this.m_transformer.getBaseURLOfSource();
    }

    public Transformer getTransformer() {
        return this.m_transformer;
    }

    TransformerImpl getTransformerImpl() {
        return this.m_transformer;
    }

    public boolean getUseMultiThreading() {
        return this.m_useMultiThreading;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_inDTD) {
            return;
        }
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            if (this.m_shouldStripWS) {
                Object var5_5 = null;
                return;
            }
            this.m_sourceTreeHandler.characters(cArray, n, n2);
        }
        this.notifyWaiters();
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
    }

    public void notationDecl(String string, String string2, String string3) throws SAXException {
    }

    private void notifyWaiters() {
        if (this.m_useMultiThreading && this.m_eventsCount >= this.m_maxEventsToNotify) {
            DocImpl docImpl;
            DocImpl docImpl2 = docImpl = this.m_root;
            synchronized (docImpl2) {
                docImpl.notify();
            }
            this.m_eventsCount = 0;
        } else {
            ++this.m_eventsCount;
        }
    }

    void popShouldStripWhitespace() {
        this.m_shouldStripWS = this.m_shouldStripWhitespaceStack.popAndTop();
    }

    private void printTree(Node node) {
        System.out.println("node: " + node.getNodeName());
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            this.printTree(node2);
            node2 = node2.getNextSibling();
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_sourceTreeHandler.processingInstruction(string, string2);
        }
        this.notifyWaiters();
    }

    void pushShouldStripWhitespace(boolean bl) {
        this.m_shouldStripWS = bl;
        this.m_shouldStripWhitespaceStack.push(bl);
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void setExceptionThrown(Exception exception) {
        this.m_root.m_exceptionThrown = exception;
    }

    public void setInputSource(Source source) {
        this.m_inputSource = source;
    }

    public void setResult(Result result) throws IllegalArgumentException {
        if (result == null) {
            throw new IllegalArgumentException("result should not be null");
        }
        try {
            ContentHandler contentHandler = this.m_transformer.createResultContentHandler(result);
            this.m_transformer.setContentHandler(contentHandler);
        }
        catch (TransformerException transformerException) {
            throw new IllegalArgumentException("result could not be set");
        }
    }

    public void setRoot(DocImpl docImpl) {
        this.m_root = docImpl;
    }

    void setShouldStripWhitespace(boolean bl) {
        this.m_shouldStripWS = bl;
        this.m_shouldStripWhitespaceStack.setTop(bl);
    }

    public void setShouldTransformAtEnd(boolean bl) {
        this.m_shouldTransformAtEnd = bl;
    }

    public void setSystemId(String string) {
        this.m_transformer.setBaseURLOfSource(string);
        XPathContext xPathContext = this.m_transformer.getXPathContext();
        SourceTreeManager sourceTreeManager = xPathContext.getSourceTreeManager();
        this.m_inputSource = new StreamSource(string);
        sourceTreeManager.putDocumentInCache(this.m_root, this.m_inputSource);
    }

    public void setUseMultiThreading(boolean bl) {
        this.m_useMultiThreading = bl;
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.m_isCData = true;
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.m_inDTD = true;
        if (this.m_root instanceof DocumentImpl) {
            DocumentImpl documentImpl = (DocumentImpl)this.m_root;
            DocumentTypeImpl documentTypeImpl = new DocumentTypeImpl(documentImpl, string, string2, string3);
            ((DocumentImpl)this.m_root).setDoctype(documentTypeImpl);
        }
    }

    public void startDocument() throws SAXException {
        if (this.m_entryCount != 0) {
            throw new SAXException("startDocument can not be called while within startDocument/endDocument! Threading problem?");
        }
        ++this.m_entryCount;
        Object object = this.m_root;
        synchronized (object) {
            this.m_inDTD = false;
            this.m_root.setSourceTreeHandler(this);
            this.m_root.setUid(1);
            this.m_root.setLevel(new Integer(1).shortValue());
            this.m_root.setUseMultiThreading(this.getUseMultiThreading());
            this.m_sourceTreeHandler = this.m_docFrag != null ? new StreeDOMBuilder((Document)this.m_root, this.m_docFrag) : (this.m_root.getNodeType() == 11 ? new StreeDOMBuilder(this.m_root.getOwnerDocument(), (DocumentFragment)((Object)this.m_root)) : new StreeDOMBuilder(this.m_root));
            this.pushShouldStripWhitespace(false);
            this.m_sourceTreeHandler.startDocument();
        }
        if (this.m_useMultiThreading && this.m_transformer != null && this.m_transformer.isParserEventsOnMain()) {
            object = this.m_transformer.getContentHandler();
            if (object != null && object instanceof SourceTreeHandler) {
                Properties properties = this.m_transformer.getOutputProperties();
                SourceTreeHandler sourceTreeHandler = (SourceTreeHandler)object;
                Transformer transformer = sourceTreeHandler.getTransformer();
                Properties properties2 = transformer.getOutputProperties();
                Enumeration enumeration = ((Hashtable)properties).keys();
                while (enumeration.hasMoreElements()) {
                    Object k = enumeration.nextElement();
                    if (((Hashtable)properties2).get(k) != null) continue;
                    ((Hashtable)properties2).put(k, ((Hashtable)properties).get(k));
                }
                transformer.setOutputProperties(properties2);
            }
            if (this.m_docFrag != null) {
                this.m_transformer.setSourceTreeDocForThread(this.m_docFrag);
            } else {
                this.m_transformer.setSourceTreeDocForThread(this.m_root);
            }
            int n = Thread.currentThread().getPriority();
            this.m_transformer.runTransformThread(n);
        }
        this.notifyWaiters();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_shouldStripWhitespaceStack.push(this.m_shouldStripWS);
            this.m_sourceTreeHandler.startElement(string, string2, string3, attributes);
        }
        this.notifyWaiters();
    }

    public void startEntity(String string) throws SAXException {
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_sourceTreeHandler.startEntity(string);
        }
        this.notifyWaiters();
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_sourceTreeHandler.startPrefixMapping(string, string2);
        }
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        try {
            if (this.m_inputSource != null) {
                string3 = SystemIDResolver.getAbsoluteURI(string3, this.m_inputSource.getSystemId());
            }
        }
        catch (Exception exception) {
            throw new SAXException(exception);
        }
        EntityImpl entityImpl = new EntityImpl(string, string4, string2, string3);
        this.m_root.getDoctype().getEntities().setNamedItem(entityImpl);
    }
}

