/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.clearcase;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.clearcase.ClearCase;
import org.apache.tools.ant.types.Commandline;

public class CCCheckin
extends ClearCase {
    private String m_Comment = null;
    private String m_Cfile = null;
    private boolean m_Nwarn = false;
    private boolean m_Ptime = false;
    private boolean m_Keep = false;
    private boolean m_Identical = true;
    public static final String FLAG_COMMENT = "-c";
    public static final String FLAG_COMMENTFILE = "-cfile";
    public static final String FLAG_NOCOMMENT = "-nc";
    public static final String FLAG_NOWARN = "-nwarn";
    public static final String FLAG_PRESERVETIME = "-ptime";
    public static final String FLAG_KEEPCOPY = "-keep";
    public static final String FLAG_IDENTICAL = "-identical";

    public void execute() throws BuildException {
        Commandline commandline = new Commandline();
        Project project = this.getProject();
        int n = 0;
        if (this.getViewPath() == null) {
            this.setViewPath(project.getBaseDir().getPath());
        }
        commandline.setExecutable(this.getClearToolCommand());
        commandline.createArgument().setValue("checkin");
        this.checkOptions(commandline);
        n = this.run(commandline);
        if (n != 0) {
            String string = "Failed executing: " + commandline.toString();
            throw new BuildException(string, this.location);
        }
    }

    private void checkOptions(Commandline commandline) {
        if (this.getComment() != null) {
            this.getCommentCommand(commandline);
        } else if (this.getCommentFile() != null) {
            this.getCommentFileCommand(commandline);
        } else {
            commandline.createArgument().setValue(FLAG_NOCOMMENT);
        }
        if (this.getNoWarn()) {
            commandline.createArgument().setValue(FLAG_NOWARN);
        }
        if (this.getPreserveTime()) {
            commandline.createArgument().setValue(FLAG_PRESERVETIME);
        }
        if (this.getKeepCopy()) {
            commandline.createArgument().setValue(FLAG_KEEPCOPY);
        }
        if (this.getIdentical()) {
            commandline.createArgument().setValue(FLAG_IDENTICAL);
        }
        commandline.createArgument().setValue(this.getViewPath());
    }

    public void setComment(String string) {
        this.m_Comment = string;
    }

    public String getComment() {
        return this.m_Comment;
    }

    public void setCommentFile(String string) {
        this.m_Cfile = string;
    }

    public String getCommentFile() {
        return this.m_Cfile;
    }

    public void setNoWarn(boolean bl) {
        this.m_Nwarn = bl;
    }

    public boolean getNoWarn() {
        return this.m_Nwarn;
    }

    public void setPreserveTime(boolean bl) {
        this.m_Ptime = bl;
    }

    public boolean getPreserveTime() {
        return this.m_Ptime;
    }

    public void setKeepCopy(boolean bl) {
        this.m_Keep = bl;
    }

    public boolean getKeepCopy() {
        return this.m_Keep;
    }

    public void setIdentical(boolean bl) {
        this.m_Identical = bl;
    }

    public boolean getIdentical() {
        return this.m_Identical;
    }

    private void getCommentCommand(Commandline commandline) {
        if (this.getComment() != null) {
            commandline.createArgument().setValue(FLAG_COMMENT);
            commandline.createArgument().setValue(this.getComment());
        }
    }

    private void getCommentFileCommand(Commandline commandline) {
        if (this.getCommentFile() != null) {
            commandline.createArgument().setValue(FLAG_COMMENTFILE);
            commandline.createArgument().setValue(this.getCommentFile());
        }
    }
}

