// The original version of this code (revision 2 of the Subversion
// archive) was released subject to the following license:

//   Copyright (c) 2006, Sun Microsystems, Inc.  All rights reserved.
//   Redistribution and use in source and binary forms, with or
//   without modification, are permitted provided that the following
//   conditions are met:

//   * Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above
//     copyright notice, this list of conditions and the following
//     disclaimer in the documentation and/or other materials provided
//     with the distribution.
//   * Neither the name of Sun Microsystems or the names of
//     contributors may be used to endorse or promote products derived
//     from this software without specific prior written permission.
 
//   THIS SOFTWARE IS PROVIDED BY SUN AND ITS LICENSORS ``AS IS'' AND
//   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
//   THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//   PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SUN OR ITS
//   LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
//   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
//   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
//   USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
//   AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
//   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
//   ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
//   POSSIBILITY OF SUCH DAMAGE.

// Subsequent additions and modifications are Copyright (c) 2006 David
// Carlton, and may be used subject to the same conditions.


#ifndef UNITTEST_REGISTRY_H
#define UNITTEST_REGISTRY_H

#include <iosfwd>
#include "UnitTest.hpp"

namespace UnitTest {

  // A test registry.  Your test program's main() function should
  // first call add() a bunch of times, with arguments a test and a
  // name for the test; then call run(argc,argv); and finally return
  // run's value.
  class Registry {
  public:
    Registry();
    ~Registry();

    // Add a test to the registry, calling it NAME.
    void add(TestPtr test, const char *name);

    // Run the tests.  If arguments are provided, only run the tests
    // with those names; otherwise, run all of the tests.  Also, if
    // "-debug" is the first argument, print out the name of each test
    // as you set it up, run it, and tear it down.  If "-list" is the
    // first argument, list the names of the tests, instead of running
    // them.  Returns 0 if everything passed, 1 if at least one test
    // failed.
    int run(int argc, char **argv);

    // Print output messages (dots, assertion failure messages,
    // numbers of passes/failures, etc.) to STREAM instead of
    // std::cout.  This is only here to help write unit tests for
    // UnitTest and friends; don't use it yourself unless you know
    // what you're doing.
    void stream(std::ostream &stream);

  private:
    bool pruneArgs(int &argc, char **&argv);
    void addTests(int argc, char **argv, Suite &suite);
    TestPtr test(const std::string &name);
    bool run(bool debug, Suite &suite);

    typedef std::pair<TestPtr, const char *> Registration;

    std::list<Registration> tests_;
    std::ostream *stream_;
  };

}

#endif // UNITTEST_REGISTRY_H
