// The original version of this code (revision 2 of the Subversion
// archive) was released subject to the following license:

//   Copyright (c) 2006, Sun Microsystems, Inc.  All rights reserved.
//   Redistribution and use in source and binary forms, with or
//   without modification, are permitted provided that the following
//   conditions are met:

//   * Redistributions of source code must retain the above copyright
//     notice, this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above
//     copyright notice, this list of conditions and the following
//     disclaimer in the documentation and/or other materials provided
//     with the distribution.
//   * Neither the name of Sun Microsystems or the names of
//     contributors may be used to endorse or promote products derived
//     from this software without specific prior written permission.
 
//   THIS SOFTWARE IS PROVIDED BY SUN AND ITS LICENSORS ``AS IS'' AND
//   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
//   THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
//   PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL SUN OR ITS
//   LICENSORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
//   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
//   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
//   USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
//   AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
//   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
//   ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
//   POSSIBILITY OF SUCH DAMAGE.

// Subsequent additions and modifications are Copyright (c) 2006 David
// Carlton, and may be used subject to the same conditions.

// A helper class for the UnitTest test suite: it can pass or fail as
// desired, and give feedback as to when setup/run/teardown were
// called.

#include "Helper.hpp"

Helper::Helper()
  : name_(0), status_(0), shouldFail_(false),
    passes_(0), failures_(0) {
}

void Helper::shouldFail(bool fail) {
  shouldFail_ = fail;
}

void Helper::statusString(std::string *status, const char *name) {
  name_ = name;
  status_ = status;
}

int Helper::passes() const {
  return passes_;
}

int Helper::failures() const {
  return failures_;
}

void Helper::passes(int count) {
  passes_ = count;
}

void Helper::failures(int count) {
  failures_ = count;
}

void Helper::setUp() {
  event("setup");
}

void Helper::run() {
  event("run");
  if (shouldFail_)
    ASSERT(false);
}

void Helper::tearDown() {
  event("teardown");
}

void Helper::event(const char *body) {
  appendStatus(name_);
  appendStatus(":");
  appendStatus(body);
  appendStatus(";");
}

void Helper::appendStatus(const char *text) {
  if (status_ != 0)
    *status_ = *status_ + text;
}
