/***************************************************************************
@author:    Fabian Wuertz <xadras@sidux.com>
@copyright: Fabian Wuertz <xadras@sidux.com>
@license:   GPL2, GPL3

@project:   Waheela
@file:      metadata.h    
***************************************************************************/

#ifndef DATETIME_H
#define DATETIME_H

#include <QWidget>
#include <KPushButton>
#include <KConfig>
#include <QLabel>

#include "ui_dateTimeSettings.h"

class DateTime : public QWidget
{
	Q_OBJECT

	public:
		DateTime(QWidget* parent = 0, Qt::WFlags flags = 0);
		void setup(KConfigGroup, KConfigGroup, QString);
		void hideControlElements();
		void showControlElements();
		void show2();
		void hide2();
		
	private:
		QString theme, dateFormat, timeFormat;
		Ui::dateTimePage dateTimeUi;
		QWidget *settingsWidget;
		KPushButton *colorButton, *configButton;
		QLabel *dateLabel, *timeLabel;

	public slots:
		virtual void updateClock();
		virtual void apply();
		virtual void showSettingsDialog();
		virtual void showColorDialog();
		virtual void changeBackgroundColor(const QColor &);

};
#endif