/////////////////////////////////////////////////////////////////////////////
// Name:        screenshots.h
// Purpose:     Screenshots of all controls at a glance
// Author:      Vadim Zeitlin <vadim@wxwidgets.org>
// Licence:     wxWindows licence
/////////////////////////////////////////////////////////////////////////////

/**

@page page_screenshots Screenshots of Different Controls

This page contains the screenshots of various controls under the three major
platforms: wxMSW in the first column, wxGTK in the second one and wxOSX in the
third one.

@section page_screenshots_standard Standard Controls

Some common controls:

@appearance_brief{wxButton,button}
@appearance_brief{wxBitmapButton,bitmapbutton}
@appearance_brief{wxCheckBox,checkbox}
@appearance_brief{wxChoice,choice}
@appearance_brief{wxCheckListBox,checklistbox}
@appearance_brief{wxComboBox,combobox}
@appearance_brief{wxGauge,gauge}
@appearance_brief{wxListBox,listbox}
@appearance_brief{wxRadioBox,radiobox}
@appearance_brief{wxRadioButton,radiobutton}
@appearance_brief{wxScrollBar,scrollbar}
@appearance_brief{wxSlider,slider}
@appearance_brief{wxSpinButton,spinbutton}
@appearance_brief{wxSpinCtrl,spinctrl}
@appearance_brief{wxSpinCtrlDouble,spinctrldouble}


@section page_screenshots_picker Picker Controls

These controls provide the user with the possibility to choose something (file
or directory, font or colour, ...) directly from the window containing them:

@appearance_brief{wxColourPickerCtrl,colourpickerctrl}
@appearance_brief{wxDatePickerCtrl,datepickerctrl}
@appearance_brief{wxFilePickerCtrl,filepickerctrl}
@appearance_brief{wxDirPickerCtrl,dirpickerctrl}
@appearance_brief{wxFontPickerCtrl,fontpickerctrl}


@section page_screenshots_adv Advanced Controls

These controls are considered to be less common and are defined in
@ref page_libs_wxadv "adv" library:

@appearance_brief{wxActivityIndicator,activityindicator}
@appearance_brief{wxAnimationCtrl,animationctrl}
@genericAppearance_brief{wxBannerWindow,bannerwindow}
@appearance_brief{wxBitmapComboBox,bitmapcombobox}
@appearance_brief{wxCalendarCtrl,calendarctrl}
@appearance_brief{wxComboCtrl,comboctrl}
@appearance_brief{wxCommandLinkButton,commandlinkbutton}
@appearance_brief{wxHyperlinkCtrl,hyperlinkctrl}
@appearance_brief{wxOwnerDrawnComboBox,ownerdrawncombobox}


@section page_screenshots_book Book Controls

Book controls contain several pages (also called tabs in wxNotebook case) and
allow the user to switch between them:

@appearance_brief{wxChoicebook,choicebook}
@appearance_brief{wxListbook,listbook}
@appearance_brief{wxNotebook,notebook}


@section page_screenshots_treelist Tree and List Controls

Several controls can be used to display items organized in a tree or (multi
column) list:

@appearance_brief{wxDataViewCtrl,dataviewctrl}
@appearance_brief{wxDataViewTreeCtrl,dataviewtreectrl}
@appearance_brief{wxListCtrl,listctrl}
@appearance_brief{wxPropertyGrid,propertygrid}
@genericAppearance_brief{wxSimpleHtmlListBox,simplehtmllistbox}


@section page_screenshots_misc Miscellaneous Other Controls

@appearance_brief{wxCollapsiblePane,collapsiblepane}
@appearance_brief{wxDirCtrl,genericdirctrl}
@appearance_brief{wxFileCtrl,filectrl}
@appearance_brief{wxRichTextCtrl,richtextctrl}
@appearance_brief{wxRichToolTip,richtooltip}

 */
