/* dbbrowser.c generated by valac 0.14.0, the Vala compiler
 * generated from dbbrowser.vala, do not modify */

/*
 *  Copyright (c) 2009-2010 Mike Massonnet <mmassonnet@xfce.org>
 *  Copyright (c) 2009-2010 Vincent Legout <vincent@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <mpdclient.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>


#define XFMPC_TYPE_DBBROWSER (xfmpc_dbbrowser_get_type ())
#define XFMPC_DBBROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_DBBROWSER, XfmpcDbbrowser))
#define XFMPC_DBBROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_DBBROWSER, XfmpcDbbrowserClass))
#define XFMPC_IS_DBBROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_DBBROWSER))
#define XFMPC_IS_DBBROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_DBBROWSER))
#define XFMPC_DBBROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_DBBROWSER, XfmpcDbbrowserClass))

typedef struct _XfmpcDbbrowser XfmpcDbbrowser;
typedef struct _XfmpcDbbrowserClass XfmpcDbbrowserClass;
typedef struct _XfmpcDbbrowserPrivate XfmpcDbbrowserPrivate;

#define XFMPC_TYPE_PREFERENCES (xfmpc_preferences_get_type ())
#define XFMPC_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_PREFERENCES, XfmpcPreferences))
#define XFMPC_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_PREFERENCES, XfmpcPreferencesClass))
#define XFMPC_IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_PREFERENCES))
#define XFMPC_IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_PREFERENCES))
#define XFMPC_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_PREFERENCES, XfmpcPreferencesClass))

typedef struct _XfmpcPreferences XfmpcPreferences;
typedef struct _XfmpcPreferencesClass XfmpcPreferencesClass;

#define XFMPC_DBBROWSER_TYPE_COLUMNS (xfmpc_dbbrowser_columns_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define XFMPC_TYPE_PLAYLIST (xfmpc_playlist_get_type ())
#define XFMPC_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_PLAYLIST, XfmpcPlaylist))
#define XFMPC_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_PLAYLIST, XfmpcPlaylistClass))
#define XFMPC_IS_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_PLAYLIST))
#define XFMPC_IS_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_PLAYLIST))
#define XFMPC_PLAYLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_PLAYLIST, XfmpcPlaylistClass))

typedef struct _XfmpcPlaylist XfmpcPlaylist;
typedef struct _XfmpcPlaylistClass XfmpcPlaylistClass;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))

struct _XfmpcDbbrowser {
	GtkVBox parent_instance;
	XfmpcDbbrowserPrivate * priv;
};

struct _XfmpcDbbrowserClass {
	GtkVBoxClass parent_class;
};

struct _XfmpcDbbrowserPrivate {
	XfmpcMpdclient* mpdclient;
	XfmpcPreferences* preferences;
	GtkListStore* store;
	GtkTreeView* treeview;
	GtkMenu* menu;
	GtkEntry* search_entry;
	GtkImageMenuItem* mi_browse;
	gchar* wdir;
	gchar* last_wdir;
	gboolean is_searching;
	guint search_timeout;
};

typedef enum  {
	XFMPC_DBBROWSER_COLUMNS_COLUMN_ID,
	XFMPC_DBBROWSER_COLUMNS_COLUMN_PIXBUF,
	XFMPC_DBBROWSER_COLUMNS_COLUMN_FILENAME,
	XFMPC_DBBROWSER_COLUMNS_COLUMN_BASENAME,
	XFMPC_DBBROWSER_COLUMNS_COLUMN_IS_DIR,
	XFMPC_DBBROWSER_COLUMNS_COLUMN_WEIGHT,
	XFMPC_DBBROWSER_COLUMNS_N_COLUMNS
} XfmpcDbbrowserColumns;


static gpointer xfmpc_dbbrowser_parent_class = NULL;

GType xfmpc_dbbrowser_get_type (void) G_GNUC_CONST;
GType xfmpc_preferences_get_type (void) G_GNUC_CONST;
#define XFMPC_DBBROWSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), XFMPC_TYPE_DBBROWSER, XfmpcDbbrowserPrivate))
enum  {
	XFMPC_DBBROWSER_DUMMY_PROPERTY
};
static GType xfmpc_dbbrowser_columns_get_type (void) G_GNUC_UNUSED;
void xfmpc_dbbrowser_reload (XfmpcDbbrowser* self);
GType xfmpc_playlist_get_type (void) G_GNUC_CONST;
static void xfmpc_dbbrowser_clear (XfmpcDbbrowser* self);
gboolean xfmpc_dbbrowser_wdir_is_root (XfmpcDbbrowser* self);
gchar* xfmpc_dbbrowser_get_parent_wdir (XfmpcDbbrowser* self);
void xfmpc_dbbrowser_append (XfmpcDbbrowser* self, const gchar* filename, const gchar* basename, gboolean is_dir, gboolean is_bold);
gboolean xfmpc_playlist_has_filename (XfmpcPlaylist* self, const gchar* filename, gboolean is_dir);
void xfmpc_dbbrowser_set_wdir (XfmpcDbbrowser* self, const gchar* dir);
void xfmpc_dbbrowser_add_selected_rows (XfmpcDbbrowser* self);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
void xfmpc_dbbrowser_search (XfmpcDbbrowser* self, const gchar* query);
static void xfmpc_dbbrowser_menu_popup (XfmpcDbbrowser* self);
static void xfmpc_dbbrowser_cb_playlist_changed (XfmpcDbbrowser* self);
static gboolean xfmpc_dbbrowser_cb_popup_menu (XfmpcDbbrowser* self);
static gboolean xfmpc_dbbrowser_cb_key_pressed (XfmpcDbbrowser* self, GdkEventKey* event);
static gboolean xfmpc_dbbrowser_cb_button_released (XfmpcDbbrowser* self, GdkEventButton* event);
static void xfmpc_dbbrowser_cb_row_activated (XfmpcDbbrowser* self, GtkTreePath* path, GtkTreeViewColumn* column);
static void xfmpc_dbbrowser_cb_replace_with_selected_rows (XfmpcDbbrowser* self);
static void xfmpc_dbbrowser_cb_browse (XfmpcDbbrowser* self);
static void xfmpc_dbbrowser_cb_search_entry_activated (XfmpcDbbrowser* self);
static gboolean xfmpc_dbbrowser_cb_search_entry_key_released (XfmpcDbbrowser* self, GdkEventKey* event);
static void xfmpc_dbbrowser_cb_search_entry_changed (XfmpcDbbrowser* self);
static gboolean xfmpc_dbbrowser_timeout_search (XfmpcDbbrowser* self);
static gboolean _xfmpc_dbbrowser_timeout_search_gsource_func (gpointer self);
static void xfmpc_dbbrowser_cb_search_entry_icon_activated (XfmpcDbbrowser* self, GtkEntryIconPosition icon_pos, GdkEvent* event);
XfmpcDbbrowser* xfmpc_dbbrowser_new (void);
XfmpcDbbrowser* xfmpc_dbbrowser_construct (GType object_type);
static GObject * xfmpc_dbbrowser_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
XfmpcPreferences* xfmpc_preferences_get_default (void);
static void _xfmpc_dbbrowser_add_selected_rows_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xfmpc_dbbrowser_cb_replace_with_selected_rows_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xfmpc_dbbrowser_cb_browse_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xfmpc_dbbrowser_reload_xfmpc_mpdclient_connected (XfmpcMpdclient* _sender, gpointer self);
static void _xfmpc_dbbrowser_reload_xfmpc_mpdclient_database_changed (XfmpcMpdclient* _sender, gpointer self);
static void _xfmpc_dbbrowser_cb_playlist_changed_xfmpc_mpdclient_playlist_changed (XfmpcMpdclient* _sender, gpointer self);
static void _xfmpc_dbbrowser_cb_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static gboolean _xfmpc_dbbrowser_cb_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static gboolean _xfmpc_dbbrowser_cb_button_released_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _xfmpc_dbbrowser_cb_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender, gpointer self);
static void _xfmpc_dbbrowser_cb_search_entry_activated_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static gboolean _xfmpc_dbbrowser_cb_search_entry_key_released_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void _xfmpc_dbbrowser_cb_search_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void _xfmpc_dbbrowser_cb_search_entry_icon_activated_gtk_entry_icon_release (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static void _xfmpc_dbbrowser_reload_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void xfmpc_dbbrowser_finalize (GObject* obj);


static GType xfmpc_dbbrowser_columns_get_type (void) {
	static volatile gsize xfmpc_dbbrowser_columns_type_id__volatile = 0;
	if (g_once_init_enter (&xfmpc_dbbrowser_columns_type_id__volatile)) {
		static const GEnumValue values[] = {{XFMPC_DBBROWSER_COLUMNS_COLUMN_ID, "XFMPC_DBBROWSER_COLUMNS_COLUMN_ID", "column-id"}, {XFMPC_DBBROWSER_COLUMNS_COLUMN_PIXBUF, "XFMPC_DBBROWSER_COLUMNS_COLUMN_PIXBUF", "column-pixbuf"}, {XFMPC_DBBROWSER_COLUMNS_COLUMN_FILENAME, "XFMPC_DBBROWSER_COLUMNS_COLUMN_FILENAME", "column-filename"}, {XFMPC_DBBROWSER_COLUMNS_COLUMN_BASENAME, "XFMPC_DBBROWSER_COLUMNS_COLUMN_BASENAME", "column-basename"}, {XFMPC_DBBROWSER_COLUMNS_COLUMN_IS_DIR, "XFMPC_DBBROWSER_COLUMNS_COLUMN_IS_DIR", "column-is-dir"}, {XFMPC_DBBROWSER_COLUMNS_COLUMN_WEIGHT, "XFMPC_DBBROWSER_COLUMNS_COLUMN_WEIGHT", "column-weight"}, {XFMPC_DBBROWSER_COLUMNS_N_COLUMNS, "XFMPC_DBBROWSER_COLUMNS_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType xfmpc_dbbrowser_columns_type_id;
		xfmpc_dbbrowser_columns_type_id = g_enum_register_static ("XfmpcDbbrowserColumns", values);
		g_once_init_leave (&xfmpc_dbbrowser_columns_type_id__volatile, xfmpc_dbbrowser_columns_type_id);
	}
	return xfmpc_dbbrowser_columns_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void xfmpc_dbbrowser_reload (XfmpcDbbrowser* self) {
	gchar* filename;
	gchar* basename;
	gboolean is_dir;
	gboolean is_bold;
	gint i;
	gconstpointer _tmp0_ = NULL;
	XfmpcPlaylist* _tmp1_;
	XfmpcPlaylist* playlist;
	gboolean _tmp2_;
	XfmpcMpdclient* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	filename = NULL;
	basename = NULL;
	is_dir = FALSE;
	is_bold = FALSE;
	i = 0;
	_tmp0_ = g_object_get_data ((GObject*) self, "XfmpcPlaylist");
	_tmp1_ = _g_object_ref0 ((XfmpcPlaylist*) _tmp0_);
	playlist = _tmp1_;
	_tmp2_ = self->priv->is_searching;
	if (_tmp2_) {
		_g_object_unref0 (playlist);
		_g_free0 (basename);
		_g_free0 (filename);
		return;
	}
	xfmpc_dbbrowser_clear (self);
	_tmp3_ = self->priv->mpdclient;
	_tmp4_ = xfmpc_mpdclient_is_connected (_tmp3_);
	if (!_tmp4_) {
		_g_object_unref0 (playlist);
		_g_free0 (basename);
		_g_free0 (filename);
		return;
	}
	_tmp5_ = xfmpc_dbbrowser_wdir_is_root (self);
	if (!_tmp5_) {
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_;
		gint _tmp8_;
		_tmp6_ = xfmpc_dbbrowser_get_parent_wdir (self);
		_g_free0 (filename);
		filename = _tmp6_;
		_tmp7_ = filename;
		xfmpc_dbbrowser_append (self, _tmp7_, "..", TRUE, FALSE);
		_tmp8_ = i;
		i = _tmp8_ + 1;
	}
	while (TRUE) {
		XfmpcMpdclient* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		XfmpcPlaylist* _tmp15_;
		const gchar* _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_ = FALSE;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gint _tmp25_ = 0;
		_tmp9_ = self->priv->mpdclient;
		_tmp10_ = self->priv->wdir;
		_tmp14_ = xfmpc_mpdclient_database_read (_tmp9_, _tmp10_, &_tmp11_, &_tmp12_, &_tmp13_);
		_g_free0 (filename);
		filename = _tmp11_;
		_g_free0 (basename);
		basename = _tmp12_;
		is_dir = _tmp13_;
		if (!_tmp14_) {
			break;
		}
		_tmp15_ = playlist;
		_tmp16_ = filename;
		_tmp17_ = is_dir;
		_tmp18_ = xfmpc_playlist_has_filename (_tmp15_, _tmp16_, _tmp17_);
		is_bold = _tmp18_;
		_tmp19_ = filename;
		_tmp20_ = basename;
		_tmp21_ = is_dir;
		_tmp22_ = is_bold;
		xfmpc_dbbrowser_append (self, _tmp19_, _tmp20_, _tmp21_, _tmp22_);
		_tmp23_ = filename;
		_tmp24_ = self->priv->last_wdir;
		_tmp25_ = g_utf8_collate (_tmp23_, _tmp24_);
		if (_tmp25_ == 0) {
			gint _tmp26_;
			GtkTreePath* _tmp27_;
			GtkTreePath* path;
			GtkTreeView* _tmp28_;
			GtkTreePath* _tmp29_;
			GtkTreeView* _tmp30_;
			GtkTreePath* _tmp31_;
			_tmp26_ = i;
			_tmp27_ = gtk_tree_path_new_from_indices (_tmp26_, -1, -1);
			path = _tmp27_;
			_tmp28_ = self->priv->treeview;
			_tmp29_ = path;
			gtk_tree_view_set_cursor (_tmp28_, _tmp29_, NULL, FALSE);
			_tmp30_ = self->priv->treeview;
			_tmp31_ = path;
			gtk_tree_view_scroll_to_cell (_tmp30_, _tmp31_, NULL, TRUE, (gfloat) 0.10, (gfloat) 0);
			i = -1;
			_gtk_tree_path_free0 (path);
		} else {
			gint _tmp32_;
			_tmp32_ = i;
			i = _tmp32_ + 1;
		}
	}
	_g_object_unref0 (playlist);
	_g_free0 (basename);
	_g_free0 (filename);
}


gboolean xfmpc_dbbrowser_wdir_is_root (XfmpcDbbrowser* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->wdir;
	result = g_strcmp0 (_tmp0_, "") == 0;
	return result;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


gchar* xfmpc_dbbrowser_get_parent_wdir (XfmpcDbbrowser* self) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->wdir;
	_tmp1_ = string_index_of (_tmp0_, "/", 0);
	if (_tmp1_ == (-1)) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		result = _tmp2_;
		return result;
	} else {
		const gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp3_ = self->priv->wdir;
		_tmp4_ = g_path_get_dirname (_tmp3_);
		result = _tmp4_;
		return result;
	}
}


void xfmpc_dbbrowser_append (XfmpcDbbrowser* self, const gchar* filename, const gchar* basename, gboolean is_dir, gboolean is_bold) {
	GtkTreeIter iter = {0};
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	GtkTreeView* _tmp2_;
	const gchar* _tmp3_;
	GdkPixbuf* _tmp4_ = NULL;
	GdkPixbuf* pixbuf;
	GtkListStore* _tmp5_;
	GtkTreeIter _tmp6_ = {0};
	PangoWeight _tmp7_ = 0;
	gboolean _tmp8_;
	GtkListStore* _tmp9_;
	GtkTreeIter _tmp10_;
	GdkPixbuf* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gboolean _tmp14_;
	PangoWeight _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (basename != NULL);
	_tmp1_ = is_dir;
	if (_tmp1_) {
		_tmp0_ = GTK_STOCK_DIRECTORY;
	} else {
		_tmp0_ = GTK_STOCK_FILE;
	}
	_tmp2_ = self->priv->treeview;
	_tmp3_ = _tmp0_;
	_tmp4_ = gtk_widget_render_icon ((GtkWidget*) _tmp2_, _tmp3_, GTK_ICON_SIZE_MENU, NULL);
	pixbuf = _tmp4_;
	_tmp5_ = self->priv->store;
	gtk_list_store_append (_tmp5_, &_tmp6_);
	iter = _tmp6_;
	_tmp8_ = is_bold;
	if (_tmp8_) {
		_tmp7_ = PANGO_WEIGHT_BOLD;
	} else {
		_tmp7_ = PANGO_WEIGHT_NORMAL;
	}
	_tmp9_ = self->priv->store;
	_tmp10_ = iter;
	_tmp11_ = pixbuf;
	_tmp12_ = filename;
	_tmp13_ = basename;
	_tmp14_ = is_dir;
	_tmp15_ = _tmp7_;
	gtk_list_store_set (_tmp9_, &_tmp10_, XFMPC_DBBROWSER_COLUMNS_COLUMN_PIXBUF, _tmp11_, XFMPC_DBBROWSER_COLUMNS_COLUMN_FILENAME, _tmp12_, XFMPC_DBBROWSER_COLUMNS_COLUMN_BASENAME, _tmp13_, XFMPC_DBBROWSER_COLUMNS_COLUMN_IS_DIR, _tmp14_, XFMPC_DBBROWSER_COLUMNS_COLUMN_WEIGHT, _tmp15_, -1, -1);
	_g_object_unref0 (pixbuf);
}


void xfmpc_dbbrowser_set_wdir (XfmpcDbbrowser* self, const gchar* dir) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	_tmp0_ = self->priv->wdir;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->last_wdir);
	self->priv->last_wdir = _tmp1_;
	_tmp2_ = dir;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->wdir);
	self->priv->wdir = _tmp3_;
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


void xfmpc_dbbrowser_add_selected_rows (XfmpcDbbrowser* self) {
	GtkListStore* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	gchar* _tmp2_;
	gchar* filename;
	GtkTreeView* _tmp3_;
	GtkTreeSelection* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GList* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_;
	GList* list;
	GList* _tmp8_;
	XfmpcMpdclient* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->store;
	_tmp1_ = _g_object_ref0 ((GtkTreeModel*) _tmp0_);
	model = _tmp1_;
	_tmp2_ = g_strdup ("");
	filename = _tmp2_;
	_tmp3_ = self->priv->treeview;
	_tmp4_ = gtk_tree_view_get_selection (_tmp3_);
	_tmp6_ = gtk_tree_selection_get_selected_rows (_tmp4_, &_tmp5_);
	_g_object_unref0 (model);
	_tmp7_ = _g_object_ref0 (_tmp5_);
	model = _tmp7_;
	list = _tmp6_;
	_tmp8_ = list;
	{
		GList* path_collection = NULL;
		GList* path_it = NULL;
		path_collection = _tmp8_;
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
			GtkTreePath* _tmp9_;
			GtkTreePath* path = NULL;
			_tmp9_ = _gtk_tree_path_copy0 ((GtkTreePath*) path_it->data);
			path = _tmp9_;
			{
				GtkTreeModel* _tmp10_;
				GtkTreePath* _tmp11_;
				GtkTreeIter _tmp12_ = {0};
				gboolean _tmp13_ = FALSE;
				_tmp10_ = model;
				_tmp11_ = path;
				_tmp13_ = gtk_tree_model_get_iter (_tmp10_, &_tmp12_, _tmp11_);
				iter = _tmp12_;
				if (_tmp13_) {
					GtkTreeModel* _tmp14_;
					GtkTreeIter _tmp15_;
					XfmpcMpdclient* _tmp16_;
					const gchar* _tmp17_;
					_tmp14_ = model;
					_tmp15_ = iter;
					gtk_tree_model_get (_tmp14_, &_tmp15_, XFMPC_DBBROWSER_COLUMNS_COLUMN_FILENAME, &filename, -1, -1);
					_tmp16_ = self->priv->mpdclient;
					_tmp17_ = filename;
					xfmpc_mpdclient_queue_add (_tmp16_, _tmp17_);
				}
				_gtk_tree_path_free0 (path);
			}
		}
	}
	_tmp18_ = self->priv->mpdclient;
	xfmpc_mpdclient_queue_commit (_tmp18_);
	__g_list_free__gtk_tree_path_free0_0 (list);
	_g_free0 (filename);
	_g_object_unref0 (model);
}


void xfmpc_dbbrowser_search (XfmpcDbbrowser* self, const gchar* query) {
	gchar* filename;
	gchar* basename;
	gboolean is_bold = FALSE;
	gint i;
	gconstpointer _tmp0_ = NULL;
	XfmpcPlaylist* _tmp1_;
	XfmpcPlaylist* playlist;
	XfmpcMpdclient* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean no_result_buf;
	gboolean no_result;
	GdkColor color = {0};
	GdkColor _tmp16_ = {0};
	gint _tmp17_;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp23_;
	gint _tmp35_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query != NULL);
	filename = NULL;
	basename = NULL;
	i = 0;
	_tmp0_ = g_object_get_data ((GObject*) self, "XfmpcPlaylist");
	_tmp1_ = _g_object_ref0 ((XfmpcPlaylist*) _tmp0_);
	playlist = _tmp1_;
	_tmp2_ = self->priv->mpdclient;
	_tmp3_ = xfmpc_mpdclient_is_connected (_tmp2_);
	if (!_tmp3_) {
		_g_object_unref0 (playlist);
		_g_free0 (basename);
		_g_free0 (filename);
		return;
	}
	self->priv->is_searching = TRUE;
	xfmpc_dbbrowser_clear (self);
	while (TRUE) {
		XfmpcMpdclient* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		XfmpcPlaylist* _tmp9_;
		const gchar* _tmp10_;
		gboolean _tmp11_ = FALSE;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gboolean _tmp14_;
		gint _tmp15_;
		_tmp4_ = self->priv->mpdclient;
		_tmp5_ = query;
		_tmp8_ = xfmpc_mpdclient_database_search (_tmp4_, _tmp5_, &_tmp6_, &_tmp7_);
		_g_free0 (filename);
		filename = _tmp6_;
		_g_free0 (basename);
		basename = _tmp7_;
		if (!_tmp8_) {
			break;
		}
		_tmp9_ = playlist;
		_tmp10_ = filename;
		_tmp11_ = xfmpc_playlist_has_filename (_tmp9_, _tmp10_, FALSE);
		is_bold = _tmp11_;
		_tmp12_ = filename;
		_tmp13_ = basename;
		_tmp14_ = is_bold;
		xfmpc_dbbrowser_append (self, _tmp12_, _tmp13_, FALSE, _tmp14_);
		_tmp15_ = i;
		i = _tmp15_ + 1;
	}
	no_result_buf = FALSE;
	no_result = FALSE;
	gdk_color_parse ("white", &_tmp16_);
	color = _tmp16_;
	color.red = (guint16) 0xFFFF;
	color.green = (guint16) 0x6666;
	color.blue = (guint16) 0x6666;
	_tmp17_ = i;
	if (_tmp17_ == 0) {
		no_result = TRUE;
	} else {
		gboolean _tmp18_;
		_tmp18_ = no_result;
		if (_tmp18_) {
			no_result = FALSE;
		}
	}
	_tmp20_ = no_result;
	_tmp21_ = no_result_buf;
	if (_tmp20_ == _tmp21_) {
		gboolean _tmp22_;
		_tmp22_ = no_result;
		_tmp19_ = _tmp22_;
	} else {
		_tmp19_ = FALSE;
	}
	_tmp23_ = _tmp19_;
	if (_tmp23_) {
		GtkEntry* _tmp24_;
		GdkColor _tmp25_;
		GtkEntry* _tmp26_;
		GdkColor _tmp27_;
		_tmp24_ = self->priv->search_entry;
		_tmp25_ = color;
		gtk_widget_modify_bg ((GtkWidget*) _tmp24_, GTK_STATE_NORMAL, &_tmp25_);
		_tmp26_ = self->priv->search_entry;
		_tmp27_ = color;
		gtk_widget_modify_bg ((GtkWidget*) _tmp26_, GTK_STATE_SELECTED, &_tmp27_);
	} else {
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_;
		gboolean _tmp30_;
		gboolean _tmp32_;
		_tmp29_ = no_result;
		_tmp30_ = no_result_buf;
		if (_tmp29_ == _tmp30_) {
			gboolean _tmp31_;
			_tmp31_ = no_result;
			_tmp28_ = !_tmp31_;
		} else {
			_tmp28_ = FALSE;
		}
		_tmp32_ = _tmp28_;
		if (_tmp32_) {
			GtkEntry* _tmp33_;
			GtkEntry* _tmp34_;
			_tmp33_ = self->priv->search_entry;
			gtk_widget_modify_bg ((GtkWidget*) _tmp33_, GTK_STATE_NORMAL, NULL);
			_tmp34_ = self->priv->search_entry;
			gtk_widget_modify_bg ((GtkWidget*) _tmp34_, GTK_STATE_SELECTED, NULL);
		}
	}
	_tmp35_ = i;
	if (_tmp35_ == 0) {
		GtkEntry* _tmp36_;
		GdkColor _tmp37_;
		GtkEntry* _tmp38_;
		GdkColor _tmp39_;
		_tmp36_ = self->priv->search_entry;
		_tmp37_ = color;
		gtk_widget_modify_bg ((GtkWidget*) _tmp36_, GTK_STATE_NORMAL, &_tmp37_);
		_tmp38_ = self->priv->search_entry;
		_tmp39_ = color;
		gtk_widget_modify_bg ((GtkWidget*) _tmp38_, GTK_STATE_SELECTED, &_tmp39_);
	} else {
		gboolean _tmp40_;
		_tmp40_ = no_result;
		if (_tmp40_) {
			GtkEntry* _tmp41_;
			GtkEntry* _tmp42_;
			_tmp41_ = self->priv->search_entry;
			gtk_widget_modify_bg ((GtkWidget*) _tmp41_, GTK_STATE_NORMAL, NULL);
			_tmp42_ = self->priv->search_entry;
			gtk_widget_modify_bg ((GtkWidget*) _tmp42_, GTK_STATE_SELECTED, NULL);
		}
	}
	_g_object_unref0 (playlist);
	_g_free0 (basename);
	_g_free0 (filename);
}


static void xfmpc_dbbrowser_clear (XfmpcDbbrowser* self) {
	GtkListStore* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->store;
	gtk_list_store_clear (_tmp0_);
}


static void xfmpc_dbbrowser_menu_popup (XfmpcDbbrowser* self) {
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* selection;
	GtkTreeSelection* _tmp3_;
	gint _tmp4_ = 0;
	gint count;
	gboolean _tmp5_;
	GtkMenu* _tmp12_;
	guint32 _tmp13_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->treeview;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	_tmp4_ = gtk_tree_selection_count_selected_rows (_tmp3_);
	count = _tmp4_;
	_tmp5_ = self->priv->is_searching;
	if (_tmp5_) {
		GtkImageMenuItem* _tmp6_;
		gboolean _tmp7_ = FALSE;
		gint _tmp8_;
		GtkImageMenuItem* _tmp9_;
		gboolean _tmp10_;
		_tmp6_ = self->priv->mi_browse;
		gtk_widget_show ((GtkWidget*) _tmp6_);
		_tmp8_ = count;
		if (_tmp8_ == 1) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp9_ = self->priv->mi_browse;
		_tmp10_ = _tmp7_;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp9_, _tmp10_);
	} else {
		GtkImageMenuItem* _tmp11_;
		_tmp11_ = self->priv->mi_browse;
		gtk_widget_hide ((GtkWidget*) _tmp11_);
	}
	_tmp12_ = self->priv->menu;
	_tmp13_ = gtk_get_current_event_time ();
	gtk_menu_popup (_tmp12_, NULL, NULL, NULL, NULL, (guint) 0, _tmp13_);
	_g_object_unref0 (selection);
}


static void xfmpc_dbbrowser_cb_playlist_changed (XfmpcDbbrowser* self) {
	GtkListStore* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	gchar* _tmp2_;
	gchar* filename;
	gboolean is_bold;
	gboolean is_dir;
	gconstpointer _tmp3_ = NULL;
	XfmpcPlaylist* _tmp4_;
	XfmpcPlaylist* playlist;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->store;
	_tmp1_ = _g_object_ref0 ((GtkTreeModel*) _tmp0_);
	model = _tmp1_;
	_tmp2_ = g_strdup ("");
	filename = _tmp2_;
	is_bold = FALSE;
	is_dir = FALSE;
	_tmp3_ = g_object_get_data ((GObject*) self, "XfmpcPlaylist");
	_tmp4_ = _g_object_ref0 ((XfmpcPlaylist*) _tmp3_);
	playlist = _tmp4_;
	_tmp5_ = model;
	_tmp7_ = gtk_tree_model_get_iter_first (_tmp5_, &_tmp6_);
	iter = _tmp6_;
	if (!_tmp7_) {
		_g_object_unref0 (playlist);
		_g_free0 (filename);
		_g_object_unref0 (model);
		return;
	}
	{
		gboolean _tmp8_;
		_tmp8_ = TRUE;
		while (TRUE) {
			gboolean _tmp9_;
			GtkTreeModel* _tmp12_;
			GtkTreeIter _tmp13_;
			XfmpcPlaylist* _tmp14_;
			const gchar* _tmp15_;
			gboolean _tmp16_;
			gboolean _tmp17_ = FALSE;
			PangoWeight _tmp18_ = 0;
			gboolean _tmp19_;
			GtkListStore* _tmp20_;
			GtkTreeIter _tmp21_;
			PangoWeight _tmp22_;
			_tmp9_ = _tmp8_;
			if (!_tmp9_) {
				GtkTreeModel* _tmp10_;
				gboolean _tmp11_ = FALSE;
				_tmp10_ = model;
				_tmp11_ = gtk_tree_model_iter_next (_tmp10_, &iter);
				if (!_tmp11_) {
					break;
				}
			}
			_tmp8_ = FALSE;
			_tmp12_ = model;
			_tmp13_ = iter;
			gtk_tree_model_get (_tmp12_, &_tmp13_, XFMPC_DBBROWSER_COLUMNS_COLUMN_FILENAME, &filename, XFMPC_DBBROWSER_COLUMNS_COLUMN_IS_DIR, &is_dir, -1, -1);
			_tmp14_ = playlist;
			_tmp15_ = filename;
			_tmp16_ = is_dir;
			_tmp17_ = xfmpc_playlist_has_filename (_tmp14_, _tmp15_, _tmp16_);
			is_bold = _tmp17_;
			_tmp19_ = is_bold;
			if (_tmp19_) {
				_tmp18_ = PANGO_WEIGHT_BOLD;
			} else {
				_tmp18_ = PANGO_WEIGHT_NORMAL;
			}
			_tmp20_ = self->priv->store;
			_tmp21_ = iter;
			_tmp22_ = _tmp18_;
			gtk_list_store_set (_tmp20_, &_tmp21_, XFMPC_DBBROWSER_COLUMNS_COLUMN_WEIGHT, _tmp22_, -1, -1);
		}
	}
	_g_object_unref0 (playlist);
	_g_free0 (filename);
	_g_object_unref0 (model);
}


static gboolean xfmpc_dbbrowser_cb_popup_menu (XfmpcDbbrowser* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	xfmpc_dbbrowser_menu_popup (self);
	result = TRUE;
	return result;
}


static gboolean xfmpc_dbbrowser_cb_key_pressed (XfmpcDbbrowser* self, GdkEventKey* event) {
	gboolean result = FALSE;
	GdkEventKey _tmp0_;
	GdkEventType _tmp1_;
	GdkEventKey _tmp2_;
	guint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.type;
	if (_tmp1_ != GDK_KEY_PRESS) {
		result = FALSE;
		return result;
	}
	_tmp2_ = *event;
	_tmp3_ = _tmp2_.keyval;
	switch (_tmp3_) {
		case 0xff0d:
		{
			GtkTreeView* _tmp4_;
			GtkTreeSelection* _tmp5_ = NULL;
			GtkTreeSelection* _tmp6_;
			GtkTreeSelection* selection;
			GtkTreeSelection* _tmp7_;
			gint _tmp8_ = 0;
			_tmp4_ = self->priv->treeview;
			_tmp5_ = gtk_tree_view_get_selection (_tmp4_);
			_tmp6_ = _g_object_ref0 (_tmp5_);
			selection = _tmp6_;
			_tmp7_ = selection;
			_tmp8_ = gtk_tree_selection_count_selected_rows (_tmp7_);
			if (_tmp8_ > 1) {
				xfmpc_dbbrowser_add_selected_rows (self);
			} else {
				result = FALSE;
				_g_object_unref0 (selection);
				return result;
			}
			_g_object_unref0 (selection);
			break;
		}
		case 0xff08:
		{
			gchar* _tmp9_ = NULL;
			gchar* filename;
			const gchar* _tmp10_;
			_tmp9_ = xfmpc_dbbrowser_get_parent_wdir (self);
			filename = _tmp9_;
			_tmp10_ = filename;
			xfmpc_dbbrowser_set_wdir (self, _tmp10_);
			xfmpc_dbbrowser_reload (self);
			_g_free0 (filename);
			break;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


static gboolean xfmpc_dbbrowser_cb_button_released (XfmpcDbbrowser* self, GdkEventButton* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton _tmp1_;
	GdkEventType _tmp2_;
	gboolean _tmp5_;
	GtkTreePath* path = NULL;
	GtkTreeView* _tmp6_;
	GtkTreeSelection* _tmp7_ = NULL;
	GtkTreeSelection* _tmp8_;
	GtkTreeSelection* selection;
	GtkTreeView* _tmp9_;
	GdkEventButton _tmp10_;
	gdouble _tmp11_;
	GdkEventButton _tmp12_;
	gdouble _tmp13_;
	GtkTreePath* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	GtkTreeSelection* _tmp22_;
	gint _tmp23_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.type;
	if (_tmp2_ != GDK_BUTTON_PRESS) {
		_tmp0_ = TRUE;
	} else {
		GdkEventButton _tmp3_;
		guint _tmp4_;
		_tmp3_ = *event;
		_tmp4_ = _tmp3_.button;
		_tmp0_ = _tmp4_ != ((guint) 3);
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		result = FALSE;
		return result;
	}
	_tmp6_ = self->priv->treeview;
	_tmp7_ = gtk_tree_view_get_selection (_tmp6_);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	selection = _tmp8_;
	_tmp9_ = self->priv->treeview;
	_tmp10_ = *event;
	_tmp11_ = _tmp10_.x;
	_tmp12_ = *event;
	_tmp13_ = _tmp12_.y;
	_tmp15_ = gtk_tree_view_get_path_at_pos (_tmp9_, (gint) _tmp11_, (gint) _tmp13_, &_tmp14_, NULL, NULL, NULL);
	_gtk_tree_path_free0 (path);
	path = _tmp14_;
	if (_tmp15_) {
		GtkTreeSelection* _tmp16_;
		GtkTreePath* _tmp17_;
		gboolean _tmp18_ = FALSE;
		_tmp16_ = selection;
		_tmp17_ = path;
		_tmp18_ = gtk_tree_selection_path_is_selected (_tmp16_, _tmp17_);
		if (!_tmp18_) {
			GtkTreeSelection* _tmp19_;
			GtkTreeSelection* _tmp20_;
			GtkTreePath* _tmp21_;
			_tmp19_ = selection;
			gtk_tree_selection_unselect_all (_tmp19_);
			_tmp20_ = selection;
			_tmp21_ = path;
			gtk_tree_selection_select_path (_tmp20_, _tmp21_);
		}
	}
	_tmp22_ = selection;
	_tmp23_ = gtk_tree_selection_count_selected_rows (_tmp22_);
	if (_tmp23_ < 1) {
		result = TRUE;
		_g_object_unref0 (selection);
		_gtk_tree_path_free0 (path);
		return result;
	}
	xfmpc_dbbrowser_menu_popup (self);
	result = TRUE;
	_g_object_unref0 (selection);
	_gtk_tree_path_free0 (path);
	return result;
}


static void xfmpc_dbbrowser_cb_row_activated (XfmpcDbbrowser* self, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkTreePath* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* ppath;
	GtkListStore* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	gchar* _tmp4_;
	gchar* filename;
	gboolean is_dir;
	GtkTreeModel* _tmp5_;
	GtkTreePath* _tmp6_;
	GtkTreeIter _tmp7_ = {0};
	gboolean _tmp8_ = FALSE;
	GtkTreeModel* _tmp9_;
	GtkTreeIter _tmp10_;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = path;
	_tmp1_ = _gtk_tree_path_copy0 (_tmp0_);
	ppath = _tmp1_;
	_tmp2_ = self->priv->store;
	_tmp3_ = _g_object_ref0 ((GtkTreeModel*) _tmp2_);
	model = _tmp3_;
	_tmp4_ = g_strdup ("");
	filename = _tmp4_;
	is_dir = FALSE;
	_tmp5_ = model;
	_tmp6_ = ppath;
	_tmp8_ = gtk_tree_model_get_iter (_tmp5_, &_tmp7_, _tmp6_);
	iter = _tmp7_;
	if (!_tmp8_) {
		_g_free0 (filename);
		_g_object_unref0 (model);
		_gtk_tree_path_free0 (ppath);
		return;
	}
	_tmp9_ = model;
	_tmp10_ = iter;
	gtk_tree_model_get (_tmp9_, &_tmp10_, XFMPC_DBBROWSER_COLUMNS_COLUMN_FILENAME, &filename, XFMPC_DBBROWSER_COLUMNS_COLUMN_IS_DIR, &is_dir, -1, -1);
	_tmp11_ = is_dir;
	if (_tmp11_) {
		const gchar* _tmp12_;
		_tmp12_ = filename;
		xfmpc_dbbrowser_set_wdir (self, _tmp12_);
		xfmpc_dbbrowser_reload (self);
	} else {
		XfmpcMpdclient* _tmp13_;
		const gchar* _tmp14_;
		XfmpcMpdclient* _tmp15_;
		_tmp13_ = self->priv->mpdclient;
		_tmp14_ = filename;
		xfmpc_mpdclient_queue_add (_tmp13_, _tmp14_);
		_tmp15_ = self->priv->mpdclient;
		xfmpc_mpdclient_queue_commit (_tmp15_);
	}
	_g_free0 (filename);
	_g_object_unref0 (model);
	_gtk_tree_path_free0 (ppath);
}


static void xfmpc_dbbrowser_cb_replace_with_selected_rows (XfmpcDbbrowser* self) {
	XfmpcMpdclient* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mpdclient;
	xfmpc_mpdclient_queue_clear (_tmp0_);
	xfmpc_dbbrowser_add_selected_rows (self);
}


static void xfmpc_dbbrowser_cb_browse (XfmpcDbbrowser* self) {
	GtkListStore* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	GtkTreeView* _tmp2_;
	GtkTreeSelection* _tmp3_ = NULL;
	GtkTreeSelection* _tmp4_;
	GtkTreeSelection* selection;
	GtkTreeSelection* _tmp5_;
	gint _tmp6_ = 0;
	GtkTreeSelection* _tmp7_;
	GtkTreeModel* _tmp8_ = NULL;
	GList* _tmp9_ = NULL;
	GtkTreeModel* _tmp10_;
	GList* list;
	GList* _tmp11_;
	gconstpointer _tmp12_ = NULL;
	GtkTreePath* _tmp13_;
	GtkTreePath* path;
	GtkTreeModel* _tmp14_;
	GtkTreePath* _tmp15_;
	GtkTreeIter _tmp16_ = {0};
	gboolean _tmp17_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->store;
	_tmp1_ = _g_object_ref0 ((GtkTreeModel*) _tmp0_);
	model = _tmp1_;
	_tmp2_ = self->priv->treeview;
	_tmp3_ = gtk_tree_view_get_selection (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	selection = _tmp4_;
	_tmp5_ = selection;
	_tmp6_ = gtk_tree_selection_count_selected_rows (_tmp5_);
	if (_tmp6_ > 1) {
		_g_object_unref0 (selection);
		_g_object_unref0 (model);
		return;
	}
	_tmp7_ = selection;
	_tmp9_ = gtk_tree_selection_get_selected_rows (_tmp7_, &_tmp8_);
	_g_object_unref0 (model);
	_tmp10_ = _g_object_ref0 (_tmp8_);
	model = _tmp10_;
	list = _tmp9_;
	_tmp11_ = list;
	_tmp12_ = g_list_nth_data (_tmp11_, (guint) 0);
	_tmp13_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp12_);
	path = _tmp13_;
	_tmp14_ = model;
	_tmp15_ = path;
	_tmp17_ = gtk_tree_model_get_iter (_tmp14_, &_tmp16_, _tmp15_);
	iter = _tmp16_;
	if (_tmp17_) {
		gchar* filename = NULL;
		GtkTreeModel* _tmp18_;
		GtkTreeIter _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* dir;
		const gchar* _tmp22_;
		_tmp18_ = model;
		_tmp19_ = iter;
		gtk_tree_model_get (_tmp18_, &_tmp19_, XFMPC_DBBROWSER_COLUMNS_COLUMN_FILENAME, &filename, -1, -1);
		_tmp20_ = filename;
		_tmp21_ = g_path_get_dirname (_tmp20_);
		dir = _tmp21_;
		_tmp22_ = dir;
		xfmpc_dbbrowser_set_wdir (self, _tmp22_);
		xfmpc_dbbrowser_reload (self);
		_g_free0 (dir);
		_g_free0 (filename);
	}
	_gtk_tree_path_free0 (path);
	__g_list_free__gtk_tree_path_free0_0 (list);
	_g_object_unref0 (selection);
	_g_object_unref0 (model);
}


static void xfmpc_dbbrowser_cb_search_entry_activated (XfmpcDbbrowser* self) {
	GtkEntry* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* entry_text;
	const gchar* _tmp3_;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	entry_text = _tmp2_;
	_tmp3_ = entry_text;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		GtkEntry* _tmp4_;
		GtkEntry* _tmp5_;
		self->priv->is_searching = FALSE;
		xfmpc_dbbrowser_reload (self);
		_tmp4_ = self->priv->search_entry;
		gtk_widget_modify_bg ((GtkWidget*) _tmp4_, GTK_STATE_NORMAL, NULL);
		_tmp5_ = self->priv->search_entry;
		gtk_widget_modify_bg ((GtkWidget*) _tmp5_, GTK_STATE_SELECTED, NULL);
		_g_free0 (entry_text);
		return;
	}
	_tmp6_ = entry_text;
	xfmpc_dbbrowser_search (self, _tmp6_);
	_g_free0 (entry_text);
}


static gboolean xfmpc_dbbrowser_cb_search_entry_key_released (XfmpcDbbrowser* self, GdkEventKey* event) {
	gboolean result = FALSE;
	GdkEventKey _tmp0_;
	GdkEventType _tmp1_;
	GdkEventKey _tmp2_;
	guint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.type;
	if (_tmp1_ != GDK_KEY_RELEASE) {
		result = FALSE;
		return result;
	}
	_tmp2_ = *event;
	_tmp3_ = _tmp2_.keyval;
	if (_tmp3_ == ((guint) 0xff1b)) {
		GtkEntry* _tmp4_;
		_tmp4_ = self->priv->search_entry;
		gtk_entry_set_text (_tmp4_, "");
	}
	result = TRUE;
	return result;
}


static gboolean _xfmpc_dbbrowser_timeout_search_gsource_func (gpointer self) {
	gboolean result;
	result = xfmpc_dbbrowser_timeout_search (self);
	return result;
}


static void xfmpc_dbbrowser_cb_search_entry_changed (XfmpcDbbrowser* self) {
	GtkEntry* _tmp0_;
	const gchar* _tmp1_ = NULL;
	guint _tmp4_;
	guint _tmp6_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->search_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	if (g_strcmp0 (_tmp1_, "") != 0) {
		GtkEntry* _tmp2_;
		_tmp2_ = self->priv->search_entry;
		gtk_entry_set_icon_from_stock (_tmp2_, GTK_ENTRY_ICON_SECONDARY, GTK_STOCK_CLEAR);
	} else {
		GtkEntry* _tmp3_;
		_tmp3_ = self->priv->search_entry;
		gtk_entry_set_icon_from_stock (_tmp3_, GTK_ENTRY_ICON_SECONDARY, NULL);
	}
	_tmp4_ = self->priv->search_timeout;
	if (_tmp4_ > ((guint) 0)) {
		guint _tmp5_;
		_tmp5_ = self->priv->search_timeout;
		g_source_remove (_tmp5_);
	}
	_tmp6_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 642, _xfmpc_dbbrowser_timeout_search_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->search_timeout = _tmp6_;
}


static gboolean xfmpc_dbbrowser_timeout_search (XfmpcDbbrowser* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	xfmpc_dbbrowser_cb_search_entry_activated (self);
	result = FALSE;
	return result;
}


static void xfmpc_dbbrowser_cb_search_entry_icon_activated (XfmpcDbbrowser* self, GtkEntryIconPosition icon_pos, GdkEvent* event) {
	GtkEntryIconPosition _tmp0_;
	GtkEntry* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = icon_pos;
	if (_tmp0_ != GTK_ENTRY_ICON_SECONDARY) {
		return;
	}
	_tmp1_ = self->priv->search_entry;
	gtk_entry_set_text (_tmp1_, "");
}


XfmpcDbbrowser* xfmpc_dbbrowser_construct (GType object_type) {
	XfmpcDbbrowser * self = NULL;
	self = (XfmpcDbbrowser*) g_object_new (object_type, NULL);
	return self;
}


XfmpcDbbrowser* xfmpc_dbbrowser_new (void) {
	return xfmpc_dbbrowser_construct (XFMPC_TYPE_DBBROWSER);
}


static void _xfmpc_dbbrowser_add_selected_rows_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xfmpc_dbbrowser_add_selected_rows (self);
}


static void _xfmpc_dbbrowser_cb_replace_with_selected_rows_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xfmpc_dbbrowser_cb_replace_with_selected_rows (self);
}


static void _xfmpc_dbbrowser_cb_browse_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xfmpc_dbbrowser_cb_browse (self);
}


static void _xfmpc_dbbrowser_reload_xfmpc_mpdclient_connected (XfmpcMpdclient* _sender, gpointer self) {
	xfmpc_dbbrowser_reload (self);
}


static void _xfmpc_dbbrowser_reload_xfmpc_mpdclient_database_changed (XfmpcMpdclient* _sender, gpointer self) {
	xfmpc_dbbrowser_reload (self);
}


static void _xfmpc_dbbrowser_cb_playlist_changed_xfmpc_mpdclient_playlist_changed (XfmpcMpdclient* _sender, gpointer self) {
	xfmpc_dbbrowser_cb_playlist_changed (self);
}


static void _xfmpc_dbbrowser_cb_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	xfmpc_dbbrowser_cb_row_activated (self, path, column);
}


static gboolean _xfmpc_dbbrowser_cb_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = xfmpc_dbbrowser_cb_key_pressed (self, event);
	return result;
}


static gboolean _xfmpc_dbbrowser_cb_button_released_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = xfmpc_dbbrowser_cb_button_released (self, event);
	return result;
}


static gboolean _xfmpc_dbbrowser_cb_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender, gpointer self) {
	gboolean result;
	result = xfmpc_dbbrowser_cb_popup_menu (self);
	return result;
}


static void _xfmpc_dbbrowser_cb_search_entry_activated_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	xfmpc_dbbrowser_cb_search_entry_activated (self);
}


static gboolean _xfmpc_dbbrowser_cb_search_entry_key_released_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = xfmpc_dbbrowser_cb_search_entry_key_released (self, event);
	return result;
}


static void _xfmpc_dbbrowser_cb_search_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	xfmpc_dbbrowser_cb_search_entry_changed (self);
}


static void _xfmpc_dbbrowser_cb_search_entry_icon_activated_gtk_entry_icon_release (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	xfmpc_dbbrowser_cb_search_entry_icon_activated (self, p0, p1);
}


static void _xfmpc_dbbrowser_reload_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	xfmpc_dbbrowser_reload (self);
}


static GObject * xfmpc_dbbrowser_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	XfmpcDbbrowser * self;
	XfmpcMpdclient* _tmp0_ = NULL;
	XfmpcPreferences* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkListStore* _tmp4_;
	GtkTreeView* _tmp5_;
	GtkTreeView* _tmp6_;
	GtkTreeView* _tmp7_;
	GtkTreeSelection* _tmp8_ = NULL;
	GtkTreeView* _tmp9_;
	GtkTreeView* _tmp10_;
	GtkTreeView* _tmp11_;
	GtkTreeView* _tmp12_;
	GtkTreeView* _tmp13_;
	GtkTreeView* _tmp14_;
	GtkListStore* _tmp15_;
	GtkCellRendererPixbuf* _tmp16_;
	GtkCellRendererPixbuf* _tmp17_;
	GtkCellRendererPixbuf* cell_pixbuf;
	GtkTreeView* _tmp18_;
	GtkCellRendererPixbuf* _tmp19_;
	GtkCellRendererText* _tmp20_;
	GtkCellRendererText* _tmp21_;
	GtkCellRendererText* cell_text;
	GtkCellRendererText* _tmp22_;
	GtkTreeView* _tmp23_;
	GtkCellRendererText* _tmp24_;
	GtkScrolledWindow* _tmp25_;
	GtkScrolledWindow* _tmp26_;
	GtkScrolledWindow* scrolled;
	GtkScrolledWindow* _tmp27_;
	GtkMenu* _tmp28_;
	GtkMenu* _tmp29_;
	GtkImageMenuItem* _tmp30_;
	GtkImageMenuItem* _tmp31_;
	GtkImageMenuItem* mi;
	GtkMenu* _tmp32_;
	GtkImageMenuItem* _tmp33_;
	GtkImageMenuItem* _tmp34_;
	const gchar* _tmp35_ = NULL;
	GtkImageMenuItem* _tmp36_;
	GtkImageMenuItem* _tmp37_;
	GtkImage* _tmp38_;
	GtkImage* _tmp39_;
	GtkImage* image;
	GtkImageMenuItem* _tmp40_;
	GtkImage* _tmp41_;
	GtkMenu* _tmp42_;
	GtkImageMenuItem* _tmp43_;
	GtkImageMenuItem* _tmp44_;
	const gchar* _tmp45_ = NULL;
	GtkImageMenuItem* _tmp46_;
	GtkImageMenuItem* _tmp47_;
	GtkImage* _tmp48_;
	GtkImage* _tmp49_;
	GtkImageMenuItem* _tmp50_;
	GtkImage* _tmp51_;
	GtkMenu* _tmp52_;
	GtkImageMenuItem* _tmp53_;
	GtkImageMenuItem* _tmp54_;
	GtkMenu* _tmp55_;
	GtkEntry* _tmp56_;
	GtkEntry* _tmp57_;
	GtkEntry* _tmp58_;
	GtkEntry* _tmp59_;
	GtkEntry* _tmp60_;
	GtkScrolledWindow* _tmp61_;
	GtkTreeView* _tmp62_;
	GtkScrolledWindow* _tmp63_;
	GtkEntry* _tmp64_;
	XfmpcMpdclient* _tmp65_;
	XfmpcMpdclient* _tmp66_;
	XfmpcMpdclient* _tmp67_;
	GtkTreeView* _tmp68_;
	GtkTreeView* _tmp69_;
	GtkTreeView* _tmp70_;
	GtkTreeView* _tmp71_;
	GtkEntry* _tmp72_;
	GtkEntry* _tmp73_;
	GtkEntry* _tmp74_;
	GtkEntry* _tmp75_;
	XfmpcPreferences* _tmp76_;
	XfmpcPreferences* _tmp77_;
	parent_class = G_OBJECT_CLASS (xfmpc_dbbrowser_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = XFMPC_DBBROWSER (obj);
	_tmp0_ = xfmpc_mpdclient_get_default ();
	self->priv->mpdclient = _tmp0_;
	_tmp1_ = xfmpc_preferences_get_default ();
	self->priv->preferences = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->wdir);
	self->priv->wdir = _tmp2_;
	_tmp3_ = g_strdup ("");
	_g_free0 (self->priv->last_wdir);
	self->priv->last_wdir = _tmp3_;
	_tmp4_ = gtk_list_store_new ((gint) XFMPC_DBBROWSER_COLUMNS_N_COLUMNS, G_TYPE_INT, GDK_TYPE_PIXBUF, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_INT);
	_g_object_unref0 (self->priv->store);
	self->priv->store = _tmp4_;
	_tmp5_ = (GtkTreeView*) gtk_tree_view_new ();
	_tmp6_ = g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->treeview);
	self->priv->treeview = _tmp6_;
	_tmp7_ = self->priv->treeview;
	_tmp8_ = gtk_tree_view_get_selection (_tmp7_);
	gtk_tree_selection_set_mode (_tmp8_, GTK_SELECTION_MULTIPLE);
	_tmp9_ = self->priv->treeview;
	gtk_tree_view_set_rubber_banding (_tmp9_, TRUE);
	_tmp10_ = self->priv->treeview;
	gtk_tree_view_set_enable_search (_tmp10_, TRUE);
	_tmp11_ = self->priv->treeview;
	gtk_tree_view_set_search_column (_tmp11_, (gint) XFMPC_DBBROWSER_COLUMNS_COLUMN_BASENAME);
	_tmp12_ = self->priv->treeview;
	gtk_tree_view_set_headers_visible (_tmp12_, FALSE);
	_tmp13_ = self->priv->treeview;
	gtk_tree_view_set_rules_hint (_tmp13_, TRUE);
	_tmp14_ = self->priv->treeview;
	_tmp15_ = self->priv->store;
	gtk_tree_view_set_model (_tmp14_, (GtkTreeModel*) _tmp15_);
	_tmp16_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	_tmp17_ = g_object_ref_sink (_tmp16_);
	cell_pixbuf = _tmp17_;
	_tmp18_ = self->priv->treeview;
	_tmp19_ = cell_pixbuf;
	gtk_tree_view_insert_column_with_attributes (_tmp18_, -1, "", (GtkCellRenderer*) _tmp19_, "pixbuf", XFMPC_DBBROWSER_COLUMNS_COLUMN_PIXBUF, NULL, NULL);
	_tmp20_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp21_ = g_object_ref_sink (_tmp20_);
	cell_text = _tmp21_;
	_tmp22_ = cell_text;
	g_object_set (_tmp22_, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	_tmp23_ = self->priv->treeview;
	_tmp24_ = cell_text;
	gtk_tree_view_insert_column_with_attributes (_tmp23_, -1, "Filename", (GtkCellRenderer*) _tmp24_, "text", XFMPC_DBBROWSER_COLUMNS_COLUMN_BASENAME, "weight", XFMPC_DBBROWSER_COLUMNS_COLUMN_WEIGHT, NULL, NULL);
	_tmp25_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	_tmp26_ = g_object_ref_sink (_tmp25_);
	scrolled = _tmp26_;
	_tmp27_ = scrolled;
	gtk_scrolled_window_set_policy (_tmp27_, GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	_tmp28_ = (GtkMenu*) gtk_menu_new ();
	_tmp29_ = g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->menu);
	self->priv->menu = _tmp29_;
	_tmp30_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_ADD, NULL);
	_tmp31_ = g_object_ref_sink (_tmp30_);
	mi = _tmp31_;
	_tmp32_ = self->priv->menu;
	_tmp33_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp32_, (GtkWidget*) ((GtkMenuItem*) _tmp33_));
	_tmp34_ = mi;
	g_signal_connect_object ((GtkMenuItem*) _tmp34_, "activate", (GCallback) _xfmpc_dbbrowser_add_selected_rows_gtk_menu_item_activate, self, 0);
	_tmp35_ = _ ("Replace");
	_tmp36_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_tmp35_);
	_tmp37_ = g_object_ref_sink (_tmp36_);
	_g_object_unref0 (mi);
	mi = _tmp37_;
	_tmp38_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_CUT, GTK_ICON_SIZE_MENU);
	_tmp39_ = g_object_ref_sink (_tmp38_);
	image = _tmp39_;
	_tmp40_ = mi;
	_tmp41_ = image;
	gtk_image_menu_item_set_image (_tmp40_, (GtkWidget*) _tmp41_);
	_tmp42_ = self->priv->menu;
	_tmp43_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp42_, (GtkWidget*) ((GtkMenuItem*) _tmp43_));
	_tmp44_ = mi;
	g_signal_connect_object ((GtkMenuItem*) _tmp44_, "activate", (GCallback) _xfmpc_dbbrowser_cb_replace_with_selected_rows_gtk_menu_item_activate, self, 0);
	_tmp45_ = _ ("Browse");
	_tmp46_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_tmp45_);
	_tmp47_ = g_object_ref_sink (_tmp46_);
	_g_object_unref0 (self->priv->mi_browse);
	self->priv->mi_browse = _tmp47_;
	_tmp48_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_OPEN, GTK_ICON_SIZE_MENU);
	_tmp49_ = g_object_ref_sink (_tmp48_);
	_g_object_unref0 (image);
	image = _tmp49_;
	_tmp50_ = self->priv->mi_browse;
	_tmp51_ = image;
	gtk_image_menu_item_set_image (_tmp50_, (GtkWidget*) _tmp51_);
	_tmp52_ = self->priv->menu;
	_tmp53_ = self->priv->mi_browse;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp52_, (GtkWidget*) ((GtkMenuItem*) _tmp53_));
	_tmp54_ = self->priv->mi_browse;
	g_signal_connect_object ((GtkMenuItem*) _tmp54_, "activate", (GCallback) _xfmpc_dbbrowser_cb_browse_gtk_menu_item_activate, self, 0);
	_tmp55_ = self->priv->menu;
	gtk_widget_show_all ((GtkWidget*) _tmp55_);
	_tmp56_ = (GtkEntry*) gtk_entry_new ();
	_tmp57_ = g_object_ref_sink (_tmp56_);
	_g_object_unref0 (self->priv->search_entry);
	self->priv->search_entry = _tmp57_;
	_tmp58_ = self->priv->search_entry;
	gtk_entry_set_icon_from_stock (_tmp58_, GTK_ENTRY_ICON_PRIMARY, GTK_STOCK_FIND);
	_tmp59_ = self->priv->search_entry;
	gtk_entry_set_icon_activatable (_tmp59_, GTK_ENTRY_ICON_PRIMARY, FALSE);
	_tmp60_ = self->priv->search_entry;
	gtk_entry_set_icon_activatable (_tmp60_, GTK_ENTRY_ICON_SECONDARY, TRUE);
	_tmp61_ = scrolled;
	_tmp62_ = self->priv->treeview;
	gtk_container_add ((GtkContainer*) _tmp61_, (GtkWidget*) _tmp62_);
	_tmp63_ = scrolled;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp63_, TRUE, TRUE, (guint) 0);
	_tmp64_ = self->priv->search_entry;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp64_, FALSE, FALSE, (guint) 0);
	_tmp65_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp65_, "connected", (GCallback) _xfmpc_dbbrowser_reload_xfmpc_mpdclient_connected, self, 0);
	_tmp66_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp66_, "database-changed", (GCallback) _xfmpc_dbbrowser_reload_xfmpc_mpdclient_database_changed, self, 0);
	_tmp67_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp67_, "playlist-changed", (GCallback) _xfmpc_dbbrowser_cb_playlist_changed_xfmpc_mpdclient_playlist_changed, self, 0);
	_tmp68_ = self->priv->treeview;
	g_signal_connect_object (_tmp68_, "row-activated", (GCallback) _xfmpc_dbbrowser_cb_row_activated_gtk_tree_view_row_activated, self, 0);
	_tmp69_ = self->priv->treeview;
	g_signal_connect_object ((GtkWidget*) _tmp69_, "key-press-event", (GCallback) _xfmpc_dbbrowser_cb_key_pressed_gtk_widget_key_press_event, self, 0);
	_tmp70_ = self->priv->treeview;
	g_signal_connect_object ((GtkWidget*) _tmp70_, "button-press-event", (GCallback) _xfmpc_dbbrowser_cb_button_released_gtk_widget_button_press_event, self, 0);
	_tmp71_ = self->priv->treeview;
	g_signal_connect_object ((GtkWidget*) _tmp71_, "popup-menu", (GCallback) _xfmpc_dbbrowser_cb_popup_menu_gtk_widget_popup_menu, self, 0);
	_tmp72_ = self->priv->search_entry;
	g_signal_connect_object (_tmp72_, "activate", (GCallback) _xfmpc_dbbrowser_cb_search_entry_activated_gtk_entry_activate, self, 0);
	_tmp73_ = self->priv->search_entry;
	g_signal_connect_object ((GtkWidget*) _tmp73_, "key-release-event", (GCallback) _xfmpc_dbbrowser_cb_search_entry_key_released_gtk_widget_key_release_event, self, 0);
	_tmp74_ = self->priv->search_entry;
	g_signal_connect_object ((GtkEditable*) _tmp74_, "changed", (GCallback) _xfmpc_dbbrowser_cb_search_entry_changed_gtk_editable_changed, self, 0);
	_tmp75_ = self->priv->search_entry;
	g_signal_connect_object (_tmp75_, "icon-release", (GCallback) _xfmpc_dbbrowser_cb_search_entry_icon_activated_gtk_entry_icon_release, self, 0);
	_tmp76_ = self->priv->preferences;
	g_signal_connect_object ((GObject*) _tmp76_, "notify::song-format", (GCallback) _xfmpc_dbbrowser_reload_g_object_notify, self, 0);
	_tmp77_ = self->priv->preferences;
	g_signal_connect_object ((GObject*) _tmp77_, "notify::song-format-custom", (GCallback) _xfmpc_dbbrowser_reload_g_object_notify, self, 0);
	_g_object_unref0 (image);
	_g_object_unref0 (mi);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (cell_text);
	_g_object_unref0 (cell_pixbuf);
	return obj;
}


static void xfmpc_dbbrowser_class_init (XfmpcDbbrowserClass * klass) {
	xfmpc_dbbrowser_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (XfmpcDbbrowserPrivate));
	G_OBJECT_CLASS (klass)->constructor = xfmpc_dbbrowser_constructor;
	G_OBJECT_CLASS (klass)->finalize = xfmpc_dbbrowser_finalize;
}


static void xfmpc_dbbrowser_instance_init (XfmpcDbbrowser * self) {
	self->priv = XFMPC_DBBROWSER_GET_PRIVATE (self);
}


static void xfmpc_dbbrowser_finalize (GObject* obj) {
	XfmpcDbbrowser * self;
	self = XFMPC_DBBROWSER (obj);
	_g_object_unref0 (self->priv->store);
	_g_object_unref0 (self->priv->treeview);
	_g_object_unref0 (self->priv->menu);
	_g_object_unref0 (self->priv->search_entry);
	_g_object_unref0 (self->priv->mi_browse);
	_g_free0 (self->priv->wdir);
	_g_free0 (self->priv->last_wdir);
	G_OBJECT_CLASS (xfmpc_dbbrowser_parent_class)->finalize (obj);
}


GType xfmpc_dbbrowser_get_type (void) {
	static volatile gsize xfmpc_dbbrowser_type_id__volatile = 0;
	if (g_once_init_enter (&xfmpc_dbbrowser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XfmpcDbbrowserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xfmpc_dbbrowser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XfmpcDbbrowser), 0, (GInstanceInitFunc) xfmpc_dbbrowser_instance_init, NULL };
		GType xfmpc_dbbrowser_type_id;
		xfmpc_dbbrowser_type_id = g_type_register_static (GTK_TYPE_VBOX, "XfmpcDbbrowser", &g_define_type_info, 0);
		g_once_init_leave (&xfmpc_dbbrowser_type_id__volatile, xfmpc_dbbrowser_type_id);
	}
	return xfmpc_dbbrowser_type_id__volatile;
}



