/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Set;
import org.apache.regexp.CharacterIterator;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.apache.regexp.StreamCharacterIterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class CheckLinks
extends MatchingTask {
    private File basedir;
    private boolean checkexternal = true;
    static RE hrefOrAnchor;

    public void setCheckexternal(boolean bl) {
        this.checkexternal = bl;
    }

    public void setBasedir(File file) {
        this.basedir = file;
    }

    public void execute() throws BuildException {
        if (this.basedir == null) {
            throw new BuildException("Must specify the basedir attribute");
        }
        DirectoryScanner directoryScanner = this.getDirectoryScanner(this.basedir);
        directoryScanner.scan();
        String string = "Scanning for broken links in " + this.basedir + " ...";
        if (!this.checkexternal) {
            string = string + " (external URLs will be skipped)";
        }
        this.log(string);
        String[] stringArray = directoryScanner.getIncludedFiles();
        HashSet hashSet = new HashSet(1000);
        HashSet hashSet2 = new HashSet(100);
        HashSet hashSet3 = new HashSet(100);
        int n = 0;
        while (n < stringArray.length) {
            URL uRL;
            File file = new File(this.basedir, stringArray[n]);
            try {
                uRL = file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new BuildException((Throwable)malformedURLException, this.location);
            }
            this.log("Scanning " + file, 3);
            try {
                CheckLinks.scan((Task)this, file.getAbsolutePath(), uRL, hashSet, hashSet2, hashSet3, this.checkexternal, 1);
            }
            catch (IOException iOException) {
                throw new BuildException("Could not scan " + file, (Throwable)iOException, this.location);
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void scan(Task task, String string, URL uRL, Set set, Set set2, Set set3, boolean bl, int n) throws IOException {
        Object object;
        Object object2;
        block19: {
            InputStream inputStream;
            block18: {
                String string2;
                if (set.contains(uRL) && n == 0) {
                    return;
                }
                String string3 = uRL.toString();
                int n2 = string3.lastIndexOf(35);
                if (n2 != -1) {
                    string3 = string3.substring(0, n2);
                }
                URL uRL2 = new URL(string3);
                String string4 = uRL.getRef();
                if (set2.contains(uRL) || set2.contains(uRL2)) {
                    task.log(string + ": broken link (already reported): " + uRL, 1);
                    return;
                }
                if (!bl && !"file".equals(uRL.getProtocol())) {
                    task.log("Skipping external link: " + uRL2, 3);
                    set3.add(uRL2);
                    set.add(uRL2);
                    set.add(uRL);
                    return;
                }
                task.log("Checking " + uRL + " (recursion level " + n + ")", 3);
                try {
                    object2 = uRL2.openConnection();
                    ((URLConnection)object2).connect();
                    string2 = ((URLConnection)object2).getContentType();
                    inputStream = ((URLConnection)object2).getInputStream();
                }
                catch (IOException iOException) {
                    task.log(string + ": broken link: " + uRL2, 1);
                    set2.add(uRL2);
                    set2.add(uRL);
                    return;
                }
                set.add(uRL2);
                object2 = null;
                if (n > 0 && set3.add(uRL2)) {
                    object2 = new HashSet(100);
                }
                try {
                    if (n == 0 && string4 == null) {
                        Object var23_16 = null;
                        break block18;
                    }
                    if ("text/html".equals(string2)) {
                        task.log("Parsing " + uRL2, 3);
                        object = new StreamCharacterIterator(inputStream);
                        int n3 = 0;
                        HashSet<String> hashSet = new HashSet<String>(100);
                        while (hrefOrAnchor.match((CharacterIterator)object, n3)) {
                            String string5;
                            n3 = hrefOrAnchor.getParenEnd(0);
                            String string6 = hrefOrAnchor.getParen(2);
                            if (string6.equalsIgnoreCase("name")) {
                                string5 = hrefOrAnchor.getParen(3);
                                if (hashSet.add(string5)) {
                                    set.add(new URL(uRL2, "#" + string5));
                                    continue;
                                }
                                if (n != 1) continue;
                                task.log(string + ": duplicate anchor name: " + string5, 1);
                                continue;
                            }
                            if (object2 == null) continue;
                            string5 = hrefOrAnchor.getParen(3);
                            String string7 = hrefOrAnchor.getParen(4);
                            if (string5.startsWith("mailto:")) continue;
                            URL uRL3 = new URL(uRL2, string7 == null ? string5 : string5 + string7);
                            object2.add(uRL3);
                        }
                    } else {
                        task.log("Not checking contents of " + uRL2, 3);
                    }
                    Object var23_17 = null;
                    inputStream.close();
                    break block19;
                }
                catch (Throwable throwable) {
                    Object var23_18 = null;
                    inputStream.close();
                    throw throwable;
                }
            }
            inputStream.close();
            return;
        }
        if (!set.contains(uRL)) {
            task.log(string + ": broken link: " + uRL, 1);
        }
        if (object2 != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                URL uRL4 = (URL)object.next();
                CheckLinks.scan(task, uRL.getPath(), uRL4, set, set2, set3, bl, n == 1 ? 0 : 2);
            }
        }
    }

    static {
        try {
            hrefOrAnchor = new RE("<(a|img)\\s+(href|name|src)=\"([^\"#]*)(#[^\"]+)?\">");
        }
        catch (RESyntaxException rESyntaxException) {
            throw new Error(rESyntaxException.toString());
        }
        hrefOrAnchor.setMatchFlags(1);
    }
}

