/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSourceDropEvent;
import java.util.Arrays;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.ExplorerDragSupport;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.TreeViewCellEditor;
import org.openide.nodes.Node;

final class TreeViewDragSupport
extends ExplorerDragSupport {
    boolean active = false;
    DragGestureRecognizer defaultGesture;
    TreePath[] curSelection;
    TreePath[] oldSelection;
    protected TreeView view;
    private JTree tree;
    static /* synthetic */ Class class$org$openide$explorer$ExplorerPanel;

    public TreeViewDragSupport(TreeView treeView, JTree jTree) {
        this.view = treeView;
        this.comp = jTree;
        this.tree = jTree;
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        TreeCellEditor treeCellEditor;
        super.dragGestureRecognized(dragGestureEvent);
        if (this.exDnD.isDnDActive() && (treeCellEditor = this.tree.getCellEditor()) instanceof TreeViewCellEditor) {
            ((TreeViewCellEditor)treeCellEditor).setDnDActive(true);
        }
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        Object object;
        Node[] nodeArray = this.exDnD.getDraggedNodes();
        super.dragDropEnd(dragSourceDropEvent);
        try {
            if (nodeArray != null && (object = (ExplorerPanel)SwingUtilities.getAncestorOfClass(class$org$openide$explorer$ExplorerPanel == null ? (class$org$openide$explorer$ExplorerPanel = TreeViewDragSupport.class$("org.openide.explorer.ExplorerPanel")) : class$org$openide$explorer$ExplorerPanel, this.view)) != null) {
                ((ExplorerPanel)object).getExplorerManager().setSelectedNodes(nodeArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.exDnD.setDnDActive(false);
        object = this.tree.getCellEditor();
        if (object instanceof TreeViewCellEditor) {
            ((TreeViewCellEditor)object).setDnDActive(false);
        }
    }

    Node[] obtainNodes(DragGestureEvent dragGestureEvent) {
        Point point = dragGestureEvent.getDragOrigin();
        TreePath treePath = this.tree.getPathForLocation(point.x, point.y);
        if (treePath == null) {
            return null;
        }
        Node node = DragDropUtilities.secureFindNode(treePath.getLastPathComponent());
        if (node == null) {
            return null;
        }
        if (this.oldSelection != null && this.wasSelected(node)) {
            this.tree.setSelectionPaths(this.oldSelection);
            this.curSelection = null;
        }
        Node[] nodeArray = null;
        if (this.tree.isPathSelected(treePath)) {
            TreePath[] treePathArray = this.tree.getSelectionPaths();
            nodeArray = new Node[treePathArray.length];
            int n = 0;
            while (n < treePathArray.length) {
                nodeArray[n] = DragDropUtilities.secureFindNode(treePathArray[n].getLastPathComponent());
                if (nodeArray[n] == null) {
                    return null;
                }
                ++n;
            }
        } else {
            nodeArray = new Node[]{node};
        }
        return nodeArray;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object[] objectArray = this.tree.getSelectionPaths();
        if (objectArray != null && !Arrays.equals(this.curSelection, objectArray)) {
            this.oldSelection = this.curSelection == null ? objectArray : this.curSelection;
            this.curSelection = objectArray;
        }
    }

    boolean wasSelected(Object object) {
        if (this.oldSelection == null) {
            return false;
        }
        int n = 0;
        while (n < this.oldSelection.length) {
            if (object.equals(this.oldSelection[n].getLastPathComponent())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

