/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.Day;
import com.jrefinery.data.TimePeriod;
import com.jrefinery.data.TimePeriodFormatException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Year
extends TimePeriod {
    private int year;

    public Year() {
        this(new Date());
    }

    public Year(int n) {
        if (n < 1900 || n > 9999) {
            throw new IllegalArgumentException("Year constructor: year (" + n + ") outside valid range.");
        }
        this.year = n;
    }

    public Year(Date date) {
        this(date, TimePeriod.DEFAULT_TIME_ZONE);
    }

    public Year(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        this.year = calendar.get(1);
    }

    public int getYear() {
        return this.year;
    }

    public TimePeriod previous() {
        if (this.year > 1900) {
            return new Year(this.year - 1);
        }
        return null;
    }

    public TimePeriod next() {
        if (this.year < 9999) {
            return new Year(this.year + 1);
        }
        return null;
    }

    public long getSerialIndex() {
        return this.year;
    }

    public long getStart(Calendar calendar) {
        Day day = new Day(1, 1, this.year);
        return day.getStart(calendar);
    }

    public long getEnd(Calendar calendar) {
        Day day = new Day(31, 12, this.year);
        return day.getEnd(calendar);
    }

    public boolean equals(Object object) {
        if (object != null) {
            if (object instanceof Year) {
                Year year = (Year)object;
                return this.year == year.getYear();
            }
            return false;
        }
        return false;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Year) {
            Year year = (Year)object;
            n = this.year - year.getYear();
        } else {
            n = object instanceof TimePeriod ? 0 : 1;
        }
        return n;
    }

    public String toString() {
        return Integer.toString(this.year);
    }

    public static Year parseYear(String string) throws TimePeriodFormatException {
        int n;
        try {
            n = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimePeriodFormatException("Year.parseYear(string): cannot parse string.");
        }
        Year year = null;
        try {
            year = new Year(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new TimePeriodFormatException("Year.parseYear(string): year outside valid range.");
        }
        return year;
    }
}

