/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.sax.CommentHandler;
import com.jclark.xsl.sax.Destination;
import com.jclark.xsl.sax.OutputDocumentHandler;
import com.jclark.xsl.sax.RawCharactersHandler;
import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class HTMLOutputHandler
implements OutputDocumentHandler,
CommentHandler,
RawCharactersHandler {
    private Writer writer;
    private static final int DEFAULT_BUF_LENGTH = 4096;
    private char[] buf = new char[4096];
    private int bufUsed = 0;
    private boolean inCdata = false;
    private boolean inPcdataChunk = true;
    private boolean inBlock = false;
    private final String lineSeparator = System.getProperty("line.separator");
    private boolean indent = true;
    private char maxRepresentableChar = (char)65535;
    private boolean keepOpen;
    private String encoding;
    private String doctypeSystem;
    private String doctypePublic;
    private static final int NORMAL_CONTENT = 0;
    private static final int EMPTY_CONTENT = 1;
    private static final int CDATA_CONTENT = 2;
    private static final int CONTENT_TYPE = 3;
    private static final int BLOCK_ELEMENT = 4;
    private static final int HEAD_ELEMENT = 8;
    private static final int PCDATA_ELEMENT = 16;
    private static final String[] emptyElements;
    private static final String[] cdataElements;
    private static final String[] blockElements;
    private static final String[] pcdataElements;
    private static final String[] booleanAttributes;
    private static final String[] charEntities;
    private static String[][] charMap;
    private static Hashtable elementTypeTable;
    private static Hashtable booleanAttributesTable;

    static {
        int n;
        emptyElements = new String[]{"area", "base", "basefont", "br", "col", "frame", "hr", "img", "input", "isindex", "link", "meta", "param"};
        cdataElements = new String[]{"script", "style"};
        blockElements = new String[]{"address", "area", "base", "blockquote", "body", "br", "caption", "center", "col", "colgroup", "dd", "dir", "div", "dl", "dt", "fieldset", "form", "frame", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", "hr", "html", "isindex", "li", "link", "map", "menu", "meta", "noframes", "noscript", "ol", "p", "pre", "style", "table", "tbody", "tfoot", "thead", "title", "tr", "ul"};
        pcdataElements = new String[]{"applet", "img", "object"};
        booleanAttributes = new String[]{"checked", "compact", "declare", "defer", "disabled", "ismap", "multiple", "nohref", "noresize", "noshade", "nowrap", "readonly", "selected"};
        charEntities = new String[]{"\u00a0nbsp", "\u00a1iexcl", "\u00a2cent", "\u00a3pound", "\u00a4curren", "\u00a5yen", "\u00a6brvbar", "\u00a7sect", "\u00a8uml", "\u00a9copy", "\u00aaordf", "\u00ablaquo", "\u00acnot", "\u00adshy", "\u00aereg", "\u00afmacr", "\u00b0deg", "\u00b1plusmn", "\u00b2sup2", "\u00b3sup3", "\u00b4acute", "\u00b5micro", "\u00b6para", "\u00b7middot", "\u00b8cedil", "\u00b9sup1", "\u00baordm", "\u00bbraquo", "\u00bcfrac14", "\u00bdfrac12", "\u00befrac34", "\u00bfiquest", "\u00c0Agrave", "\u00c1Aacute", "\u00c2Acirc", "\u00c3Atilde", "\u00c4Auml", "\u00c5Aring", "\u00c6AElig", "\u00c7Ccedil", "\u00c8Egrave", "\u00c9Eacute", "\u00caEcirc", "\u00cbEuml", "\u00ccIgrave", "\u00cdIacute", "\u00ceIcirc", "\u00cfIuml", "\u00d0ETH", "\u00d1Ntilde", "\u00d2Ograve", "\u00d3Oacute", "\u00d4Ocirc", "\u00d5Otilde", "\u00d6Ouml", "\u00d7times", "\u00d8Oslash", "\u00d9Ugrave", "\u00daUacute", "\u00dbUcirc", "\u00dcUuml", "\u00ddYacute", "\u00deTHORN", "\u00dfszlig", "\u00e0agrave", "\u00e1aacute", "\u00e2acirc", "\u00e3atilde", "\u00e4auml", "\u00e5aring", "\u00e6aelig", "\u00e7ccedil", "\u00e8egrave", "\u00e9eacute", "\u00eaecirc", "\u00ebeuml", "\u00ecigrave", "\u00ediacute", "\u00eeicirc", "\u00efiuml", "\u00f0eth", "\u00f1ntilde", "\u00f2ograve", "\u00f3oacute", "\u00f4ocirc", "\u00f5otilde", "\u00f6ouml", "\u00f7divide", "\u00f8oslash", "\u00f9ugrave", "\u00fauacute", "\u00fbucirc", "\u00fcuuml", "\u00fdyacute", "\u00fethorn", "\u00ffyuml", "\u0152OElig", "\u0153oelig", "\u0160Scaron", "\u0161scaron", "\u0178Yuml", "\u0192fnof", "\u02c6circ", "\u02dctilde", "\u0391Alpha", "\u0392Beta", "\u0393Gamma", "\u0394Delta", "\u0395Epsilon", "\u0396Zeta", "\u0397Eta", "\u0398Theta", "\u0399Iota", "\u039aKappa", "\u039bLambda", "\u039cMu", "\u039dNu", "\u039eXi", "\u039fOmicron", "\u03a0Pi", "\u03a1Rho", "\u03a3Sigma", "\u03a4Tau", "\u03a5Upsilon", "\u03a6Phi", "\u03a7Chi", "\u03a8Psi", "\u03a9Omega", "\u03b1alpha", "\u03b2beta", "\u03b3gamma", "\u03b4delta", "\u03b5epsilon", "\u03b6zeta", "\u03b7eta", "\u03b8theta", "\u03b9iota", "\u03bakappa", "\u03bblambda", "\u03bcmu", "\u03bdnu", "\u03bexi", "\u03bfomicron", "\u03c0pi", "\u03c1rho", "\u03c2sigmaf", "\u03c3sigma", "\u03c4tau", "\u03c5upsilon", "\u03c6phi", "\u03c7chi", "\u03c8psi", "\u03c9omega", "\u03d1thetasym", "\u03d2upsih", "\u03d6piv", "\u2002ensp", "\u2003emsp", "\u2009thinsp", "\u200czwnj", "\u200dzwj", "\u200elrm", "\u200frlm", "\u2013ndash", "\u2014mdash", "\u2018lsquo", "\u2019rsquo", "\u201asbquo", "\u201cldquo", "\u201drdquo", "\u201ebdquo", "\u2020dagger", "\u2021Dagger", "\u2022bull", "\u2026hellip", "\u2030permil", "\u2032prime", "\u2033Prime", "\u2039lsaquo", "\u203arsaquo", "\u203eoline", "\u2044frasl", "\u20aceuro", "\u2111image", "\u2118weierp", "\u211creal", "\u2122trade", "\u2135alefsym", "\u2190larr", "\u2191uarr", "\u2192rarr", "\u2193darr", "\u2194harr", "\u21b5crarr", "\u21d0lArr", "\u21d1uArr", "\u21d2rArr", "\u21d3dArr", "\u21d4hArr", "\u2200forall", "\u2202part", "\u2203exist", "\u2205empty", "\u2207nabla", "\u2208isin", "\u2209notin", "\u220bni", "\u220fprod", "\u2211sum", "\u2212minus", "\u2217lowast", "\u221aradic", "\u221dprop", "\u221einfin", "\u2220ang", "\u2227and", "\u2228or", "\u2229cap", "\u222acup", "\u222bint", "\u2234there4", "\u223csim", "\u2245cong", "\u2248asymp", "\u2260ne", "\u2261equiv", "\u2264le", "\u2265ge", "\u2282sub", "\u2283sup", "\u2284nsub", "\u2286sube", "\u2287supe", "\u2295oplus", "\u2297otimes", "\u22a5perp", "\u22c5sdot", "\u2308lceil", "\u2309rceil", "\u230alfloor", "\u230brfloor", "\u2329lang", "\u232arang", "\u25caloz", "\u2660spades", "\u2663clubs", "\u2665hearts", "\u2666diams"};
        charMap = new String[256][];
        elementTypeTable = new Hashtable();
        booleanAttributesTable = new Hashtable();
        int n2 = 0;
        while (n2 < charEntities.length) {
            char c = charEntities[n2].charAt(0);
            n = c & 0xFF;
            int n3 = c >> 8;
            if (charMap[n3] == null) {
                HTMLOutputHandler.charMap[n3] = new String[256];
            }
            HTMLOutputHandler.charMap[n3][n] = "&" + charEntities[n2].substring(1) + ";";
            ++n2;
        }
        char[] cArray = new char[1];
        n = 0;
        while (n < 128) {
            if (charMap[0][n] == null) {
                cArray[0] = (char)n;
                HTMLOutputHandler.charMap[0][n] = new String(cArray);
            }
            ++n;
        }
        Integer n4 = new Integer(4);
        int n5 = 0;
        while (n5 < blockElements.length) {
            elementTypeTable.put(blockElements[n5], n4);
            ++n5;
        }
        Integer n6 = new Integer(5);
        Integer n7 = new Integer(1);
        int n8 = 0;
        while (n8 < emptyElements.length) {
            n4 = elementTypeTable.get(emptyElements[n8]) == null ? n7 : n6;
            elementTypeTable.put(emptyElements[n8], n4);
            ++n8;
        }
        n6 = new Integer(6);
        n7 = new Integer(2);
        int n9 = 0;
        while (n9 < cdataElements.length) {
            n4 = elementTypeTable.get(cdataElements[n9]) == null ? n7 : n6;
            elementTypeTable.put(cdataElements[n9], n4);
            ++n9;
        }
        int n10 = 0;
        while (n10 < pcdataElements.length) {
            n4 = (Integer)elementTypeTable.get(pcdataElements[n10]);
            n4 = n4 == null ? new Integer(16) : new Integer(0x10 | n4);
            elementTypeTable.put(pcdataElements[n10], n4);
            ++n10;
        }
        int n11 = 0;
        while (n11 < booleanAttributes.length) {
            booleanAttributesTable.put(booleanAttributes[n11], booleanAttributes[n11]);
            ++n11;
        }
        elementTypeTable.put("head", new Integer(12));
    }

    public HTMLOutputHandler() {
    }

    public HTMLOutputHandler(Writer writer) {
        this.writer = writer;
    }

    private void attribute(String string, String string2) throws SAXException {
        this.write(' ');
        this.write(string);
        if (!HTMLOutputHandler.isBooleanAttribute(string, string2)) {
            this.write('=');
            this.write('\"');
            int n = string2.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string2.charAt(n2);
                switch (c) {
                    case '\n': {
                        this.write(this.lineSeparator);
                        break;
                    }
                    case '&': {
                        if (n2 + 1 < n && string2.charAt(n2 + 1) == '{') {
                            this.write(c);
                            break;
                        }
                        this.write("&amp;");
                        break;
                    }
                    case '\"': {
                        this.write("&quot;");
                        break;
                    }
                    case '\u00a0': {
                        this.write("&nbsp;");
                        break;
                    }
                    default: {
                        if (c <= this.maxRepresentableChar) {
                            this.write(c);
                            break;
                        }
                        this.write(HTMLOutputHandler.getCharString(c));
                        break;
                    }
                }
                ++n2;
            }
            this.write('\"');
        }
    }

    /*
     * Unable to fully structure code
     */
    public void characters(char[] var1_1, int var2_2, int var3_3) throws SAXException {
        block10: {
            if (var3_3 == 0) {
                return;
            }
            this.inPcdataChunk = true;
            if (!this.inCdata) ** GOTO lbl32
            this.writeUnquoted(new String(var1_1, var2_2, var3_3));
            break block10;
lbl-1000:
            // 1 sources

            {
                var4_4 = var1_1[var2_2];
                switch (var4_4) {
                    case '\n': {
                        this.write(this.lineSeparator);
                        break;
                    }
                    case '&': {
                        this.write("&amp;");
                        break;
                    }
                    case '<': {
                        this.write("&lt;");
                        break;
                    }
                    case '>': {
                        this.write("&gt;");
                        break;
                    }
                    case '\u00a0': {
                        this.write("&nbsp;");
                        break;
                    }
                    default: {
                        if (var4_4 <= this.maxRepresentableChar) {
                            this.write(var4_4);
                            break;
                        }
                        this.write(HTMLOutputHandler.getCharString(var4_4));
                        break;
                    }
                }
                --var3_3;
                ++var2_2;
lbl32:
                // 2 sources

                ** while (var3_3 > 0)
            }
        }
    }

    public void comment(String string) throws SAXException {
        this.write("<!--");
        this.writeUnquoted(string);
        this.write("-->");
    }

    public void endDocument() throws SAXException {
        this.write(this.lineSeparator);
        if (this.bufUsed != 0) {
            this.flushBuf();
        }
        try {
            if (this.keepOpen) {
                this.writer.flush();
            } else {
                this.writer.close();
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        this.writer = null;
        this.buf = null;
    }

    public void endElement(String string) throws SAXException {
        boolean bl;
        int n = HTMLOutputHandler.getElementTypeFlags(string);
        int n2 = n & 3;
        boolean bl2 = bl = (n & 4) != 0;
        if (n2 != 1) {
            if (this.inPcdataChunk) {
                this.inPcdataChunk = false;
            } else if (this.indent && (!this.inBlock || bl)) {
                this.write(this.lineSeparator);
            }
            this.inBlock = bl ^ true;
            this.write('<');
            this.write('/');
            this.write(string);
            this.write('>');
        }
        if ((n & 0x10) != 0) {
            this.inPcdataChunk = true;
        }
        this.inCdata = false;
    }

    private final void flushBuf() throws SAXException {
        try {
            this.writer.write(this.buf, 0, this.bufUsed);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        this.bufUsed = 0;
    }

    private static String getCharString(char c) {
        String string;
        String[] stringArray = charMap[c >> 8];
        if (stringArray == null) {
            stringArray = new String[256];
            HTMLOutputHandler.charMap[c >> 8] = stringArray;
        }
        if ((string = stringArray[c & 0xFF]) == null) {
            stringArray[c & 0xFF] = string = "&#" + Integer.toString(c) + ";";
        }
        return string;
    }

    private static int getElementTypeFlags(String string) {
        Integer n = (Integer)elementTypeTable.get(string.toLowerCase());
        if (n == null) {
            return 0;
        }
        return n;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    public DocumentHandler init(Destination destination, AttributeList attributeList) throws IOException {
        String string = attributeList.getValue("media-type");
        if (string == null) {
            string = "text/html";
        }
        this.encoding = attributeList.getValue("encoding");
        if (this.encoding == null) {
            this.writer = destination.getWriter(string, "iso-8859-1");
            this.maxRepresentableChar = (char)127;
        } else {
            this.writer = destination.getWriter(string, this.encoding);
            this.encoding = destination.getEncoding();
            if (this.encoding.equalsIgnoreCase("iso-8859-1")) {
                this.maxRepresentableChar = (char)255;
            } else if (this.encoding.equalsIgnoreCase("us-ascii")) {
                this.maxRepresentableChar = (char)127;
            }
        }
        this.doctypeSystem = attributeList.getValue("doctype-system");
        this.doctypePublic = attributeList.getValue("doctype-public");
        this.keepOpen = destination.keepOpen();
        if ("no".equals(attributeList.getValue("indent"))) {
            this.indent = false;
        }
        return this;
    }

    private static boolean isBooleanAttribute(String string, String string2) {
        if (!string.equalsIgnoreCase(string2)) {
            return false;
        }
        return booleanAttributesTable.get(string.toLowerCase()) != null;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (string == null) {
            this.comment(string2);
            return;
        }
        this.write("<?");
        this.write(string);
        if (string2.length() != 0) {
            this.write(' ');
            this.writeUnquoted(string2);
        }
        this.write('>');
    }

    public void rawCharacters(String string) throws SAXException {
        if (string.length() != 0) {
            this.writeUnquoted(string);
            this.inPcdataChunk = true;
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        boolean bl;
        if (this.inCdata) {
            return;
        }
        if (this.doctypeSystem != null || this.doctypePublic != null) {
            this.write("<!DOCTYPE ");
            this.write(string.equals("HTML") ? "HTML" : "html");
            if (this.doctypePublic != null) {
                this.write(" PUBLIC ");
                char c = this.doctypePublic.indexOf(34) >= 0 ? (char)'\'' : '\"';
                this.write(c);
                this.write(this.doctypePublic);
                this.write(c);
            } else {
                this.write(" SYSTEM");
            }
            if (this.doctypeSystem != null) {
                char c = this.doctypeSystem.indexOf(34) >= 0 ? (char)'\'' : '\"';
                this.write(' ');
                this.write(c);
                this.write(this.doctypeSystem);
                this.write(c);
            }
            this.write('>');
            this.doctypeSystem = null;
            this.doctypePublic = null;
            this.write(this.lineSeparator);
        }
        int n = HTMLOutputHandler.getElementTypeFlags(string);
        int n2 = n & 3;
        boolean bl2 = bl = (n & 4) != 0;
        if (this.inPcdataChunk) {
            this.inPcdataChunk = false;
        } else if (this.indent && (!this.inBlock || bl)) {
            this.write(this.lineSeparator);
        }
        this.inBlock = bl ^ true;
        this.write('<');
        this.write(string);
        int n3 = attributeList.getLength();
        int n4 = 0;
        while (n4 < n3) {
            this.attribute(attributeList.getName(n4), attributeList.getValue(n4));
            ++n4;
        }
        if (n2 == 2) {
            this.inCdata = true;
        }
        this.write('>');
        if (this.encoding != null && (n & 8) != 0) {
            this.write(String.valueOf(this.lineSeparator) + "<META http-equiv=\"Content-Type\" content=\"text/html; charset=" + this.encoding + "\">");
        }
    }

    private final void write(char c) throws SAXException {
        if (this.bufUsed == this.buf.length) {
            this.flushBuf();
        }
        this.buf[this.bufUsed++] = c;
    }

    private final void write(String string) throws SAXException {
        int n = 0;
        int n2 = string.length();
        int n3 = this.buf.length - this.bufUsed;
        while (n3 < n2) {
            string.getChars(n, n + n3, this.buf, this.bufUsed);
            this.bufUsed = this.buf.length;
            this.flushBuf();
            n += n3;
            n2 -= n3;
            n3 = this.buf.length;
        }
        string.getChars(n, n + n2, this.buf, this.bufUsed);
        this.bufUsed += n2;
    }

    private void writeUnquoted(String string) throws SAXException {
        int n;
        int n2 = 0;
        while ((n = string.indexOf(10, n2)) >= 0) {
            if (n > n2) {
                this.write(string.substring(n2, n));
            }
            this.write(this.lineSeparator);
            n2 = n + 1;
        }
        this.write(n2 == 0 ? string : string.substring(n2));
    }
}

