/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: QueryStatement.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 17:01:16 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.xmlsearch.xml.qe;

import java.io.*;

public final class QueryStatement implements Externalizable {
    private static final int DefaultNumberOfHits = 20;
  
    private String _terms;
    private String _scope;

    private int _nHits;
  
    public void readExternal(ObjectInput in)
	throws ClassNotFoundException, IOException {
	_terms   = (String) in.readObject();
	_scope   = (String) in.readObject();
	_nHits   = in.readInt();
    }
  
    public void writeExternal(ObjectOutput out) throws IOException {
	out.writeObject(_terms);
	out.writeObject(_scope);
	out.writeInt(_nHits);
    }

    public QueryStatement() { /* for Externalizable */ }

    public QueryStatement(String terms, String scope, int nHits) {
	_terms = terms;
	_scope = scope;
	_nHits = nHits;
    }

    public QueryStatement makeClone() {
	return new QueryStatement(_terms, _scope, _nHits);
    }

    public QueryStatement(String terms, String scope) {
	this(terms, scope, DefaultNumberOfHits);
    }

    public QueryStatement(String terms) {
	this(terms, null);
    }

    public QueryStatement(String terms, int nHits) {
	this(terms, null, nHits);
    }

    public void defaultSearchUnit(String tagName) {
	// !!! need to differenciate requested NONE from not requested
	if (_scope == null || _scope.length() == 0)
	    _scope = tagName;
    }

    public String getTerms() {
	return _terms;
    }
  
    public String getScope() {
	return _scope;
    }

    public int getRequestedNumberOfHits() {
	return _nHits;
    }

    public String toString() {
	return "search for |" + _terms + (_scope != null ? "| in " + _scope : "|");
    }
}
