/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: DrawModelWrapper.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:22:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _CHART2_DRAWMODELWRAPPER_HXX
#define _CHART2_DRAWMODELWRAPPER_HXX

#ifndef _COM_SUN_STAR_UNO_XCOMPONENTCONTEXT_HPP_
#include <com/sun/star/uno/XComponentContext.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XMODEL_HPP_
#include <com/sun/star/frame/XModel.hpp>
#endif

//----
#ifndef _SVDMODEL_HXX
#include <svx/svdmodel.hxx>
#endif

//.............................................................................
namespace chart
{
//.............................................................................

class DrawModelWrapper : private SdrModel
{
private:
	::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiComponentFactory > m_xMCF;
    SfxItemPool* m_pSchItemPool;

	//no default constructor
	DrawModelWrapper();

public:
    //takes ownership of parameter pSchItemPool
	DrawModelWrapper(::com::sun::star::uno::Reference<
			   ::com::sun::star::uno::XComponentContext > const & xContext
               , SfxItemPool* pSchItemPool=NULL );
	virtual ~DrawModelWrapper();

    SfxItemPool&            GetItemPool();
    const SfxItemPool&      GetItemPool() const;

    virtual ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >
		createUnoModel();
	::com::sun::star::uno::Reference< ::com::sun::star::frame::XModel >
		getUnoModel();
    //should only be used for DrawViewWrapper initialization!
    SdrModel& getSdrModel();

    XColorTable*    GetColorTable() const;
    XDashList*      GetDashList() const;
    XLineEndList*   GetLineEndList() const;
    XGradientList*  GetGradientList() const;
    XHatchList*     GetHatchList() const;
    XBitmapList*    GetBitmapList() const;
};
//.............................................................................
} //namespace chart
//.............................................................................
#endif
