/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: DiscreteScaleGroup.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:26:16 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "DiscreteScaleGroup.hxx"
#include "macros.hxx"
#include "algohelper.hxx"

#include <algorithm>

#ifndef _COM_SUN_STAR_CHART2_XDATASERIES_HPP_
#include <com/sun/star/chart2/XDataSeries.hpp>
#endif

using namespace ::com::sun::star;
using ::osl::MutexGuard;

namespace chart
{

DiscreteScaleGroup::DiscreteScaleGroup(
    const uno::Reference< uno::XComponentContext > & xContext )
        : m_xContext( xContext )
{
    if( m_xContext.is())
    {
        m_xContext->getValueByName( C2U( "CoordinateSystem" ) ) >>= m_xCoordSys;

        if( ! ( m_xContext->getValueByName( C2U( "RepresentedDimension" ) ) >>= m_nDimension ))
            m_nDimension = 0;
    }
}

DiscreteScaleGroup::~DiscreteScaleGroup()
{}

// ____ XScaleGroup ____
uno::Reference< chart2::XBoundedCoordinateSystem > SAL_CALL DiscreteScaleGroup::getCoordinateSystem()
    throw (uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    return m_xCoordSys;
    // \--
}

sal_Int32 SAL_CALL DiscreteScaleGroup::getRepresentedDimension()
    throw (uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    return m_nDimension;
    // \--
}

// ____ XDataSeriesTreeParent ____
uno::Sequence< uno::Reference< chart2::XDataSeriesTreeNode > >
        SAL_CALL DiscreteScaleGroup::getChildren()
    throw (uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    return helper::VectorToSequence( m_aChildren );
    // \--
}

void SAL_CALL DiscreteScaleGroup::addChild(
        const uno::Reference< chart2::XDataSeriesTreeNode >& aNode )
        throw (lang::IllegalArgumentException,
               uno::RuntimeException)
{
    if( aNode.is() &&
        aNode->queryInterface(
            ::getCppuType( (uno::Reference< chart2::XDataSeries >* )(0))).hasValue() ||
        aNode->queryInterface(
            ::getCppuType( (uno::Reference< chart2::XScaleGroup >* )(0))).hasValue() )
    {
        // /--
        MutexGuard aGuard( m_aMutex );
        m_aChildren.push_back( aNode );
        // \--
    }
    else
    {
        throw lang::IllegalArgumentException();
    }
}

void SAL_CALL DiscreteScaleGroup::removeChild(
        const uno::Reference< chart2::XDataSeriesTreeNode >& aNode )
        throw (container::NoSuchElementException,
               uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    m_tChildType::iterator aIt( ::std::find(
        m_aChildren.begin(),
        m_aChildren.end(),
        aNode ));

    if( aIt == m_aChildren.end())
    {
        throw container::NoSuchElementException();
    }
    else
    {
        m_aChildren.erase( aIt );
    }
    // \--
}

// helper for lang::XServiceInfo
uno::Sequence< ::rtl::OUString > DiscreteScaleGroup::getSupportedServiceNames_Static()
{
    uno::Sequence< ::rtl::OUString > aServices( 1 );
    aServices[ 0 ] = C2U( "com.sun.star.chart2.DiscreteScaleGroup" );
    return aServices;
}

// implement XServiceInfo methods basing upon getSupportedServiceNames_Static
APPHELPER_XSERVICEINFO_IMPL( DiscreteScaleGroup,
                             C2U( "com.sun.star.comp.chart2.DiscreteScaleGroup" ));


// ========================================


DiscreteStackableScaleGroup::DiscreteStackableScaleGroup(
    const uno::Reference< uno::XComponentContext > & xContext ) :
        m_aStackMode( chart2::StackMode_NONE ),
        m_xContext( xContext )
{
    if( m_xContext.is())
    {
        m_xContext->getValueByName( C2U( "CoordinateSystem" ) ) >>= m_xCoordSys;

        if( ! ( m_xContext->getValueByName( C2U( "RepresentedDimension" ) ) >>= m_nDimension ))
            m_nDimension = 0;
    }
}

DiscreteStackableScaleGroup::~DiscreteStackableScaleGroup()
{}

// ____ XStackableScaleGroup ____
chart2::StackMode SAL_CALL DiscreteStackableScaleGroup::getStackMode()
    throw (uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    return m_aStackMode;
    // \--
}

void SAL_CALL DiscreteStackableScaleGroup::setStackMode( chart2::StackMode aMode )
    throw (lang::IllegalArgumentException,
           uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    m_aStackMode = aMode;
    // \--
}

// ____ XScaleGroup ____
uno::Reference< chart2::XBoundedCoordinateSystem > SAL_CALL DiscreteStackableScaleGroup::getCoordinateSystem()
    throw (uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    return m_xCoordSys;
    // \--
}

sal_Int32 SAL_CALL DiscreteStackableScaleGroup::getRepresentedDimension()
    throw (uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    return m_nDimension;
    // \--
}

// ____ XDataSeriesTreeParent ____
uno::Sequence< uno::Reference< chart2::XDataSeriesTreeNode > >
        SAL_CALL DiscreteStackableScaleGroup::getChildren()
    throw (uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    return helper::VectorToSequence( m_aChildren );
    // \--
}

void SAL_CALL DiscreteStackableScaleGroup::addChild(
        const uno::Reference< chart2::XDataSeriesTreeNode >& aNode )
        throw (lang::IllegalArgumentException,
               uno::RuntimeException)
{
    if( aNode.is() &&
        aNode->queryInterface(
            ::getCppuType( (uno::Reference< chart2::XDataSeries >* )(0))).hasValue() ||
        aNode->queryInterface(
            ::getCppuType( (uno::Reference< chart2::XScaleGroup >* )(0))).hasValue() )
    {
        // /--
        MutexGuard aGuard( m_aMutex );
        m_aChildren.push_back( aNode );
        // \--
    }
    else
    {
        throw lang::IllegalArgumentException();
    }
}

void SAL_CALL DiscreteStackableScaleGroup::removeChild(
        const uno::Reference< chart2::XDataSeriesTreeNode >& aNode )
        throw (container::NoSuchElementException,
               uno::RuntimeException)
{
    // /--
    MutexGuard aGuard( m_aMutex );
    m_tChildType::iterator aIt( ::std::find(
        m_aChildren.begin(),
        m_aChildren.end(),
        aNode ));

    if( aIt == m_aChildren.end())
    {
        throw container::NoSuchElementException();
    }
    else
    {
        m_aChildren.erase( aIt );
    }
    // \--
}

// helper for lang::XServiceInfo
uno::Sequence< ::rtl::OUString > DiscreteStackableScaleGroup::getSupportedServiceNames_Static()
{
    uno::Sequence< ::rtl::OUString > aServices( 1 );
    aServices[ 0 ] = C2U( "com.sun.star.chart2.DiscreteStackableScaleGroup" );
    return aServices;
}

// implement XServiceInfo methods basing upon getSupportedServiceNames_Static
APPHELPER_XSERVICEINFO_IMPL( DiscreteStackableScaleGroup,
                             C2U( "com.sun.star.comp.chart2.DiscreteStackableScaleGroup" ));


} //  namespace chart
