/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: undgrlin.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:29:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#define _SDR_NOITEMS
#define _SDR_NOTOUCH
#define _SDR_NOTRANSFORM
#define _SDR_NOVIEWMARKER
#define _SDR_NODRAGMETHODS
#define _SDR_NOUNDO
#define _SDR_NOXOUTDEV


#pragma hdrstop

#include "schdll.hxx"
#include "app.hrc"
#include "chtmodel.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "undgrlin.hxx"

TYPEINIT1(SchUndoDiagramLine, SchUndoAttr);


/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchUndoDiagramLine::Undo()
{
	switch (nMyID)
	{
		case SID_DIAGRAM_STOCK_LINE:
			rDoc.ChangeAttr(*pOldAttr,CHOBJID_DIAGRAM_STOCKLINE_GROUP);
			break;

		case SID_DIAGRAM_ERROR :
			rDoc.ChangeErrorAttr(*pOldAttr, nMyRow);
			break;

		case SID_DIAGRAM_AVERAGEVALUE :
			rDoc.ChangeAverageAttr(*pOldAttr, nMyRow);
			break;

		case SID_DIAGRAM_REGRESSION :
			rDoc.ChangeRegressAttr(*pOldAttr, nMyRow);
			break;
	}
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchUndoDiagramLine::Redo()
{
	switch (nMyID)
	{
		case SID_DIAGRAM_STOCK_LINE:
			rDoc.ChangeAttr(*pOldAttr,CHOBJID_DIAGRAM_STOCKLINE_GROUP);
			break;

		case SID_DIAGRAM_ERROR :
			rDoc.ChangeErrorAttr(*pNewAttr, nMyRow);
			break;

		case SID_DIAGRAM_AVERAGEVALUE :
			rDoc.ChangeAverageAttr(*pNewAttr, nMyRow);
			break;

		case SID_DIAGRAM_REGRESSION :
			rDoc.ChangeRegressAttr(*pNewAttr, nMyRow);
			break;
	}
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

BOOL SchUndoDiagramLine::CanRepeat(SfxRepeatTarget& rView) const
{
	return FALSE;
}



