/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svuidlg.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:45:40 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "svuidlg.hrc"
#include "svuidlg.hxx"

// class MdPasteObject ---------------------------------------------------

MdPasteObject::MdPasteObject( Window * pParent, const ResId & rResId, BOOL bFreeRes )
    : ModalDialog( pParent, rResId ),
    aFtSource( this, ResId( FT_SOURCE ) ),
    aFtObjectSource( this, ResId( FT_OBJECT_SOURCE ) ),
    aRbPaste( this, ResId( RB_PASTE ) ),
    aRbPasteLink( this, ResId( RB_PASTE_LINK ) ),
    aLbInsertList( this, ResId( LB_INSERT_LIST ) ),
    aCbDisplayAsIcon( this, ResId( CB_DISPLAY_AS_ICON ) ),
    aPbChangeIcon( this, ResId( PB_CHANGE_ICON ) ),
    aFlChoice( this, ResId( FL_CHOICE ) ),
    aOKButton1( this, ResId( 1 ) ),
    aCancelButton1( this, ResId( 1 ) ),
    aHelpButton1( this, ResId( 1 ) ),
    aSObject( ResId( S_OBJECT ) )
{
    if( bFreeRes ) FreeResource();
}

// class MdUpdateBaselinks -----------------------------------------------

MdUpdateBaselinks::MdUpdateBaselinks( Window * pParent, const ResId & rResId, BOOL bFreeRes )
    : ModalDialog( pParent, rResId ),
    aFtFiles( this, ResId( FT_FILES ) ),
    aFtLinks( this, ResId( FT_LINKS ) ),
    aFtType( this, ResId( FT_TYPE ) ),
    aFtStatus( this, ResId( FT_STATUS ) ),
    aCancelButton1( this, ResId( 1 ) ),
    aHelpButton1( this, ResId( 1 ) ),
    aPbUpdateNow( this, ResId( PB_UPDATE_NOW ) ),
    aPbOpenSource( this, ResId( PB_OPEN_SOURCE ) ),
    aPbChangeSource( this, ResId( PB_CHANGE_SOURCE ) ),
    aPbBreakLink( this, ResId( PB_BREAK_LINK ) ),
    aFtFiles2( this, ResId( FT_FILES2 ) ),
    aFtSource2( this, ResId( FT_SOURCE2 ) ),
    aFtType2( this, ResId( FT_TYPE2 ) ),
    aFtUpdate( this, ResId( FT_UPDATE ) ),
    aRbAutomatic( this, ResId( RB_AUTOMATIC ) ),
    aRbManual( this, ResId( RB_MANUAL ) ),
    aFtFullFileName( this, ResId( FT_FULL_FILE_NAME ) ),
    aFtFullSourceName( this, ResId( FT_FULL_SOURCE_NAME ) ),
    aFtFullTypeName( this, ResId( FT_FULL_TYPE_NAME ) ),
    aStrAutolink( ResId( STR_AUTOLINK ) ),
    aStrManuallink( ResId( STR_MANUALLINK ) ),
    aStrBrokenlink( ResId( STR_BROKENLINK ) ),
    aStrGraphiclink( ResId( STR_GRAPHICLINK ) ),
    aStrButtonclose( ResId( STR_BUTTONCLOSE ) ),
    aStrCloselinkmsg( ResId( STR_CLOSELINKMSG ) ),
    aStrCloselinkmsgMulti( ResId( STR_CLOSELINKMSG_MULTI ) ),
    aStrWaitinglink( ResId( STR_WAITINGLINK ) )
{
    if( bFreeRes ) FreeResource();
}

// class MdInsertObjectPlugin --------------------------------------------

MdInsertObjectPlugin::MdInsertObjectPlugin( Window * pParent, const ResId & rResId, BOOL bFreeRes )
    : ModalDialog( pParent, rResId ),
    aEdFileurl( this, ResId( ED_FILEURL ) ),
    aBtnFileurl( this, ResId( BTN_FILEURL ) ),
    aGbFileurl( this, ResId( GB_FILEURL ) ),
    aEdPluginsOptions( this, ResId( ED_PLUGINS_OPTIONS ) ),
    aGbPluginsOptions( this, ResId( GB_PLUGINS_OPTIONS ) ),
    aOKButton1( this, ResId( 1 ) ),
    aCancelButton1( this, ResId( 1 ) ),
    aHelpButton1( this, ResId( 1 ) )
{
    if( bFreeRes ) FreeResource();
}

// class MdDdeLinkedit ---------------------------------------------------

MdDdeLinkedit::MdDdeLinkedit( Window * pParent, const ResId & rResId, BOOL bFreeRes )
    : ModalDialog( pParent, rResId ),
    aFtDdeApp( this, ResId( FT_DDE_APP ) ),
    aEdDdeApp( this, ResId( ED_DDE_APP ) ),
    aFtDdeTopic( this, ResId( FT_DDE_TOPIC ) ),
    aEdDdeTopic( this, ResId( ED_DDE_TOPIC ) ),
    aFtDdeItem( this, ResId( FT_DDE_ITEM ) ),
    aEdDdeItem( this, ResId( ED_DDE_ITEM ) ),
    aGroupDdeChg( this, ResId( GROUP_DDE_CHG ) ),
    aOKButton1( this, ResId( 1 ) ),
    aCancelButton1( this, ResId( 1 ) )
{
    if( bFreeRes ) FreeResource();
}

// class MdInsertObjectApplet --------------------------------------------

MdInsertObjectApplet::MdInsertObjectApplet( Window * pParent, const ResId & rResId, BOOL bFreeRes )
    : ModalDialog( pParent, rResId ),
    aFtClassfile( this, ResId( FT_CLASSFILE ) ),
    aEdClassfile( this, ResId( ED_CLASSFILE ) ),
    aFtClasslocation( this, ResId( FT_CLASSLOCATION ) ),
    aEdClasslocation( this, ResId( ED_CLASSLOCATION ) ),
    aBtnClass( this, ResId( BTN_CLASS ) ),
    aGbClass( this, ResId( GB_CLASS ) ),
    aEdAppletOptions( this, ResId( ED_APPLET_OPTIONS ) ),
    aGbAppletOptions( this, ResId( GB_APPLET_OPTIONS ) ),
    aOKButton1( this, ResId( 1 ) ),
    aCancelButton1( this, ResId( 1 ) ),
    aHelpButton1( this, ResId( 1 ) )
{
    if( bFreeRes ) FreeResource();
}

// class MdInsertOleobject -----------------------------------------------

MdInsertOleobject::MdInsertOleobject( Window * pParent, const ResId & rResId, BOOL bFreeRes )
    : ModalDialog( pParent, rResId ),
    aRbNewObject( this, ResId( RB_NEW_OBJECT ) ),
    aRbObjectFromfile( this, ResId( RB_OBJECT_FROMFILE ) ),
    aLbObjecttype( this, ResId( LB_OBJECTTYPE ) ),
    aEdFilepath( this, ResId( ED_FILEPATH ) ),
    aBtnFilepath( this, ResId( BTN_FILEPATH ) ),
    aCbFilelink( this, ResId( CB_FILELINK ) ),
    aGbObject( this, ResId( GB_OBJECT ) ),
    aOKButton1( this, ResId( 1 ) ),
    aCancelButton1( this, ResId( 1 ) ),
    aHelpButton1( this, ResId( 1 ) ),
    aStrFile( ResId( STR_FILE ) )
{
    if( bFreeRes ) FreeResource();
}


